/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.BondType;
import ur_rna.StructureEditor.models.HistoryState;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaSceneState;
import ur_rna.StructureEditor.models.Strand;
import ur_rna.StructureEditor.models.StrandList;
import ur_rna.StructureEditor.services.History;
import ur_rna.StructureEditor.services.SceneColorizer;
import ur_rna.StructureEditor.services.SceneDrawMode;

public class RnaScene
implements Cloneable {
    public String title;
    public SceneDrawMode drawMode = SceneDrawMode.Standard;
    public boolean drawFlipped;
    private List<Nuc> nucs = new ArrayList<Nuc>();
    public StrandList strands = new StrandList(this, this.nucs);
    public History<HistoryState> history = new History();

    public Nuc getNuc(int n) {
        return this.nucs.get(n);
    }

    public List<Nuc> allNucs() {
        return this.strands.allNucs();
    }

    public Strand getStrand(int n) {
        return this.strands.get(n);
    }

    public Strand getStrand(int n, boolean bl) {
        if (bl) {
            while (this.strands.size() <= n) {
                this.strands.add();
            }
        }
        return this.strands.get(n);
    }

    public List<Motif.Helix> getHelices() {
        return Motif.Helix.findAll(this);
    }

    public List<Motif.Loop> getLoops() {
        return Motif.Loop.findAll(this);
    }

    public List<Motif.MultiLoop> getMultiLoops(int n, boolean bl) {
        return Motif.MultiLoop.findAll(this, n, bl);
    }

    public Motif.Helix getHelix(Nuc nuc) {
        return Motif.Helix.getHelix(nuc);
    }

    public Motif.Loop getLoop(Nuc nuc) {
        return Motif.Loop.getLoop(nuc);
    }

    public Motif.Domain getDomain(Nuc nuc) {
        return Motif.Domain.getDomain(nuc);
    }

    public Motif.Branch getBranch(Nuc nuc) {
        return Motif.Branch.getBranch(nuc);
    }

    public int getNucCount() {
        return this.nucs.size();
    }

    public Strand addStrand() {
        return this.strands.add();
    }

    public List<Bond> getBonds() {
        return this.getBonds(this.nucs, true);
    }

    public List<Bond> getBonds(boolean bl) {
        return this.getBonds(this.nucs, bl);
    }

    public List<Bond> getBonds(Iterable<Nuc> iterable, boolean bl) {
        ArrayList<Bond> arrayList = new ArrayList<Bond>();
        boolean[] blArray = new boolean[this.nucs.size()];
        for (Nuc nuc : iterable) {
            if (nuc.pair == null || blArray[nuc.pair.n5.indexInScene] || !bl && !nuc.pair.isTruePair()) continue;
            arrayList.add(nuc.pair);
            blArray[nuc.pair.n5.indexInScene] = true;
        }
        return arrayList;
    }

    public Nuc nucAtSceneIndex(int n) {
        return this.nucs.get(n);
    }

    public Bond addBond(Bond.BondInfo bondInfo) {
        return this.addBond(bondInfo.n1, bondInfo.n2, bondInfo.type);
    }

    public Bond addBond(Nuc nuc, Nuc nuc2) {
        return this.addBond(nuc, nuc2, BondType.Default);
    }

    public Bond addBond(Nuc nuc, Nuc nuc2, BondType bondType) {
        return this.addBond(new Bond(nuc, nuc2, bondType));
    }

    public Bond addBond(int n, int n2, BondType bondType) {
        return this.addBond(new Bond(this.nucs.get(n), this.nucs.get(n2), bondType));
    }

    private Bond addBond(Bond bond) {
        if (bond.n5 == null || bond.n3 == null) {
            throw new IllegalStateException("The bond does not list valid nucleotides.");
        }
        if (bond.n5.pair != null || bond.n3.pair != null) {
            throw new IllegalStateException("A nucleotide referenced by a bond is already paired.");
        }
        bond.n5.pair = bond;
        bond.n3.pair = bond;
        return bond;
    }

    public void breakBonds(int ... nArray) {
        for (int n : nArray) {
            Nuc nuc = this.nucAtSceneIndex(n);
            if (!nuc.isPaired()) continue;
            this.breakBond(nuc.pair);
        }
    }

    public void breakBond(Bond bond) {
        bond.n5.pair = null;
        bond.n3.pair = null;
    }

    public int[] buildStrandIndex(int n, int n2) {
        int[] nArray = new int[this.strands.size()];
        nArray[0] = n;
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] + this.strands.get(i - 1).size() + n2;
        }
        return nArray;
    }

    public void divideStrand(Nuc nuc) {
        this.strands.divideStrand(nuc.strand, nuc.indexInStrand());
    }

    public void joinStrands(Strand strand, Strand strand2) {
        this.strands.joinStrands(strand, strand2);
    }

    public RnaSceneState getState() {
        Object object;
        RnaSceneState rnaSceneState = new RnaSceneState();
        rnaSceneState.strands = new RnaSceneState.NucState[this.strands.size()][];
        for (int i = 0; i < this.strands.size; ++i) {
            Strand strand = this.strands.get(i);
            rnaSceneState.strands[i] = new RnaSceneState.NucState[strand.size()];
            object = rnaSceneState.strands[i];
            for (int j = 0; j < strand.size; ++j) {
                Nuc nuc = strand.get(j);
                RnaSceneState.NucState nucState = object[j] = new RnaSceneState.NucState();
                nucState.number = nuc.number;
                nucState.style = nuc.style == null ? null : nuc.style.clone();
                nucState.symbol = nuc.symbol;
                nucState.X = nuc.location.x;
                nucState.Y = nuc.location.y;
            }
        }
        List<Bond> list = this.getBonds();
        rnaSceneState.bonds = new Bond.BondInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            rnaSceneState.bonds[i] = new Bond.BondInfo(object.n5.indexInScene, object.n3.indexInScene, object.type);
        }
        return rnaSceneState;
    }

    public void loadState(RnaSceneState rnaSceneState) {
        int n;
        int n2 = 0;
        for (n = 0; n < rnaSceneState.strands.length; ++n) {
            n2 += rnaSceneState.strands[n].length;
        }
        this.nucs = new ArrayList<Nuc>(n2);
        this.strands = new StrandList(this, this.nucs);
        this.strands.suspendUpdate();
        for (n = 0; n < rnaSceneState.strands.length; ++n) {
            RnaSceneState.NucState[] nucStateArray = rnaSceneState.strands[n];
            Strand strand = this.getStrand(n, true);
            for (int i = 0; i < nucStateArray.length; ++i) {
                RnaSceneState.NucState nucState = nucStateArray[i];
                Nuc nuc = strand.add(nucState.symbol);
                nuc.number = nucState.number;
                nuc.style = nucState.style == null ? null : nucState.style.clone();
                nuc.location.x = nucState.X;
                nuc.location.y = nucState.Y;
            }
        }
        this.strands.resumeUpdate(true);
        for (Bond.BondInfo bondInfo : rnaSceneState.bonds) {
            this.addBond(bondInfo);
        }
    }

    public void clearBonds() {
        for (Nuc nuc : this.nucs) {
            nuc.pair = null;
        }
    }

    public boolean hasBonds() {
        for (Nuc nuc : this.nucs) {
            if (nuc.pair == null) continue;
            return true;
        }
        return false;
    }

    public Strand firstStrand() {
        return this.strands.get(0);
    }

    public Strand secondStrand() {
        return this.strands.size > 1 ? this.strands.get(1) : null;
    }

    public void removeNucs(Nuc[] nucArray) {
        Arrays.sort(nucArray);
        for (int i = nucArray.length - 1; i >= 0; --i) {
            if (nucArray[i].isPaired()) {
                this.breakBond(nucArray[i].pair);
            }
            nucArray[i].getStrand().remove(nucArray[i]);
        }
    }

    public void colorize(SceneColorizer sceneColorizer) {
        sceneColorizer.color(this.allNucs());
    }

    public void copyBonds(RnaScene rnaScene) {
        for (Bond bond : rnaScene.getBonds()) {
            this.addBond(bond.getNuc5().indexInScene, bond.getNuc3().indexInScene, bond.type);
        }
    }

    public void identifyPseudoknots() {
        HashSet<Bond> hashSet = new HashSet<Bond>();
        List<Bond> list = this.getBonds(false);
        Motif.findNonCrossingBonds(list, hashSet);
        for (Bond bond : list) {
            if (!hashSet.contains(bond)) continue;
            bond.type = BondType.Pseudo;
        }
    }
}

