/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Set;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.INucGroup;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.NucStyle;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.Strand;
import ur_rna.Utilities.annotation.NotNull;

public class Nuc
implements Cloneable,
INucGroup,
Comparable<Nuc> {
    transient Strand strand;
    transient int indexInScene;
    Bond pair;
    public String symbol;
    public Point2D.Float location;
    public int number = -1;
    public NucStyle style;

    public Nuc() {
        this(null, 0.0f, 0.0f);
    }

    public Nuc(String string) {
        this(string, 0.0f, 0.0f);
    }

    public Nuc(String string, float f, float f2) {
        this.symbol = string;
        this.location = new Point2D.Float(f, f2);
    }

    public RnaScene getScene() {
        return this.strand == null ? null : this.strand.getScene();
    }

    public Strand getStrand() {
        return this.strand;
    }

    public int getStrandIndex() {
        return this.strand == null ? -1 : this.strand.getIndex();
    }

    public Bond getPairBond() {
        return this.pair;
    }

    public Nuc getPaired() {
        return this.pair == null ? null : this.getPairBond().getOther(this);
    }

    public Nuc getPaired(boolean bl) {
        return this.pair != null && (bl || this.pair.isTruePair()) ? this.getPairBond().getOther(this) : null;
    }

    public boolean isPaired() {
        return this.pair != null;
    }

    public boolean isPaired(boolean bl) {
        return this.pair != null && (bl || this.pair.isTruePair());
    }

    @NotNull
    public NucStyle style() {
        if (this.style == null) {
            this.style = new NucStyle();
        }
        return this.style;
    }

    public Nuc getNext() {
        return this.strand.getNext(this);
    }

    public Nuc getNext(int n) {
        return this.strand.getNext(this, n);
    }

    public Nuc getPrev() {
        return this.strand.getNext(this, -1);
    }

    @Override
    public int compareTo(Nuc nuc) {
        return this.indexInScene - nuc.indexInScene;
    }

    public static int compare(Nuc nuc, Nuc nuc2) {
        return nuc.indexInScene - nuc2.indexInScene;
    }

    public Nuc clone() {
        try {
            return (Nuc)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void translate(float f, float f2) {
        this.location.x += f;
        this.location.y += f2;
    }

    public String toString() {
        return "S" + (String)(this.strand == null ? "?" : "" + (this.getStrandIndex() + 1)) + "." + (this.symbol == null ? "N" : this.symbol) + (this.indexInStrand() + 1);
    }

    public Motif.Helix getHelix() {
        return Motif.Helix.getHelix(this);
    }

    public Motif.Loop getLoop() {
        return Motif.Loop.getLoop(this);
    }

    public Motif.MultiLoop getMultiLoop(int n, boolean bl) {
        return Motif.MultiLoop.getFor(this, n, bl);
    }

    public Motif.Domain getDomain() {
        return Motif.Domain.getDomain(this);
    }

    public Motif.Branch getBranch() {
        return Motif.Branch.getBranch(this);
    }

    public int indexInScene(int[] nArray) {
        return nArray[this.strand.getIndex()] + this.indexInStrand();
    }

    public Set<Nuc> getBases() {
        return Collections.singleton(this);
    }

    @Override
    public void transformAll(AffineTransform affineTransform) {
        this.transform(affineTransform);
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.location, this.location);
    }

    public int indexInStrand() {
        return this.strand == null ? -1 : this.strand.sceneToStrandIndex(this.indexInScene);
    }

    public int indexInScene() {
        return this.indexInScene;
    }

    public String toString(String string) {
        return string.replace("$s", this.symbol).replace("$N", Integer.toString(this.indexInScene + 1)).replace("$n", Integer.toString(this.indexInScene)).replace("$S", Integer.toString(this.getStrandIndex() + 1)).replace("$s", Integer.toString(this.getStrandIndex())).replace("$i", Integer.toString(this.indexInStrand())).replace("$I", Integer.toString(this.indexInStrand() + 1));
    }

    public Nuc nextInScene() {
        return this.nextInScene(1, false);
    }

    public Nuc nextInScene(int n, boolean bl) {
        return this.strand.getNextInScene(this, n, bl);
    }
}

