/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.NucStyle;
import ur_rna.Utilities.Colors;

public final class DrawSettings
implements Cloneable {
    public Color sceneBgColor = Color.WHITE;
    public float nucSpacing = 1.6f;
    public float nucRadius = 8.0f;
    public float loopSpacing = 4.0f;
    public double circularStartAngle = 1.5707963267948966;
    public Color nucFillColor = Colors.LightGray;
    public Color nucTextColor = Colors.Black;
    public Color nucOutlineColor = Colors.Black;
    public Font nucFont = new Font("Arial", 1, 12);
    private transient NucStyle defaultStyle;
    public float nucOutlineWidth = 1.0f;
    public Color bondColor = Color.BLUE;
    public Color bondColorPseudo = Color.PINK;
    public float bondWidth = 2.0f;
    public float pseudoBondWidth = 2.5f;
    public boolean drawBondsInHelix = true;
    public transient float bondLength;
    public Color backboneColor = Color.GRAY;
    public float backboneWidth = 1.0f;
    public boolean drawBackboneInLoops = true;
    public boolean drawBackboneInHelix = true;
    public boolean drawBackboneCurved = true;
    public Color nucSelColor = Color.BLUE;
    public Color nucFocusColor = Color.GREEN;
    public Color nucHitColor = new Color(16711758);
    public Color selBandLineColor = new Color(2987519);
    public Color selBandFillColor = new Color(858625535, true);
    public Color hint = new Color(2339839);
    public Color hintEmphasis = new Color(2642333);
    public transient Stroke nucOutlineSelStroke = new BasicStroke(2.0f);
    public transient Stroke editBondStroke = new BasicStroke(3.0f, 1, 1, 10.0f, new float[]{4.0f}, 0.0f);
    public transient Stroke selBandOutline = new BasicStroke(2.0f);
    public Font numberFont = new Font("Arial", 1, 14);
    public Color numberLineColor = Color.BLACK;
    public float numberLineMargin = 2.0f;
    public float numberDistance = 30.0f;
    public float numberLineWidth = 1.0f;
    public boolean drawNumbers = true;
    public int drawNumbersInterval = 10;
    public boolean drawNumbersAtHelix = false;
    public transient Stroke bondStroke;
    public transient Stroke bondStrokePseudo;
    public transient Stroke backboneStroke;
    public transient Stroke nucOutlineStroke;
    public transient Stroke numberLineStroke;

    public DrawSettings() {
        this.onSettingsChanged();
    }

    public NucStyle getStyle(Nuc nuc) {
        NucStyle nucStyle = new NucStyle();
        this.fillStyle(nuc, nucStyle);
        return nucStyle;
    }

    public void fillStyle(Nuc nuc, NucStyle nucStyle) {
        NucStyle nucStyle2;
        NucStyle nucStyle3 = nucStyle2 = nuc == null ? null : nuc.style;
        if (nucStyle2 == null) {
            this.defaultStyle.copyTo(nucStyle);
        } else {
            nucStyle.outlineColor = nucStyle2.outlineColor == null ? this.defaultStyle.outlineColor : nucStyle2.outlineColor;
            nucStyle.fillColor = nucStyle2.fillColor == null ? this.defaultStyle.fillColor : nucStyle2.fillColor;
            nucStyle.textColor = nucStyle2.textColor == null ? this.defaultStyle.textColor : nucStyle2.textColor;
            nucStyle.bondColor = nucStyle2.bondColor == null ? this.defaultStyle.bondColor : nucStyle2.bondColor;
            nucStyle.font = nucStyle2.font == null ? this.defaultStyle.font : nucStyle2.font;
        }
    }

    public void onSettingsChanged() {
        this.bondLength = this.calcBondLength();
        this.bondStroke = new BasicStroke(this.bondWidth);
        this.bondStrokePseudo = new BasicStroke(this.pseudoBondWidth);
        this.backboneStroke = new BasicStroke(this.backboneWidth);
        this.nucOutlineStroke = new BasicStroke(this.nucOutlineWidth);
        this.numberLineStroke = new BasicStroke(this.numberLineWidth);
        this.defaultStyle = new NucStyle(this.nucFillColor, this.nucTextColor, this.nucOutlineColor, this.bondColor, this.nucFont, Float.NaN);
    }

    public float nucDiameter() {
        return 2.0f * this.nucRadius;
    }

    public float calcBondLength() {
        return 1.8f * this.nucRadius;
    }

    public float calcOptimalNuc2NucDistance(Nuc nuc, Nuc nuc2) {
        return this.calcOptimalNuc2NucDistance(Math.abs(nuc2.indexInScene - nuc.indexInScene) + 1);
    }

    public float calcOptimalNuc2NucDistance(int n) {
        return (float)(n - 1) * (2.0f * this.nucRadius + this.nucSpacing);
    }

    public float calcOptimalOuterDistance(Nuc nuc, Nuc nuc2, int n) {
        return this.calcOptimalOuterDistance(Math.abs(nuc2.indexInScene - nuc.indexInScene) + 1, n);
    }

    public float calcOptimalOuterDistance(int n, int n2) {
        return (float)(n * 2) * this.nucRadius + (float)(n + n2 - 1) * this.nucSpacing;
    }

    public float calcOptimalLoopDistance(Nuc nuc, Nuc nuc2, int n) {
        return this.calcOptimalLoopDistance(Math.abs(nuc2.indexInScene - nuc.indexInScene) + 1, n);
    }

    public float calcOptimalLoopDistance(int n, int n2) {
        return (float)(n * 2) * this.nucRadius + (float)(n + n2 - 1) * this.loopSpacing;
    }

    public float nucleotideRadius(Nuc nuc) {
        return this.nucRadius;
    }

    public DrawSettings copy() {
        try {
            DrawSettings drawSettings = (DrawSettings)super.clone();
            drawSettings.onSettingsChanged();
            return drawSettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }
}

