/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.awt.geom.Point2D;
import java.util.NoSuchElementException;
import ur_rna.StructureEditor.models.BondType;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.annotation.Nullable;
import ur_rna.Utilities.geom.Vec2D;

public class Bond
implements Comparable<Bond>,
Cloneable {
    public BondType type;
    public Nuc n5;
    public Nuc n3;

    public RnaScene getScene() {
        return this.n5.getScene();
    }

    public Nuc getNuc5() {
        return this.n5;
    }

    public Nuc getNuc3() {
        return this.n3;
    }

    public Bond clone() {
        try {
            return (Bond)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Nullable
    public Nuc getOther(Nuc nuc) {
        if (nuc == this.n5) {
            return this.n3;
        }
        if (nuc == this.n3) {
            return this.n5;
        }
        throw new NoSuchElementException("The specified nucleotide is not associated with this bond.");
    }

    public Motif.Helix getHelix() {
        return this.n5.getHelix();
    }

    public boolean isHybrid() {
        return this.n5.strand != this.n3.strand;
    }

    public Bond(Nuc nuc, Nuc nuc2) {
        this(nuc, nuc2, BondType.Default);
    }

    public Bond(Nuc nuc, Nuc nuc2, BondType bondType) {
        this.n5 = nuc;
        this.n3 = nuc2;
        this.type = bondType;
        this.makeOrdered();
    }

    @NotNull
    public BondType getType() {
        if (this.type == null) {
            this.type = BondType.Default;
        }
        return this.type;
    }

    public void unpair() {
        this.getScene().breakBond(this);
    }

    public Nuc right(Nuc nuc) {
        switch (this.getMultiLoopRole(nuc)) {
            case Entrance: {
                return this.n5;
            }
            case Exit: {
                return this.n3;
            }
        }
        return null;
    }

    public Nuc left(Nuc nuc) {
        switch (this.getMultiLoopRole(nuc)) {
            case Entrance: {
                return this.n3;
            }
            case Exit: {
                return this.n5;
            }
        }
        return null;
    }

    public MultiLoopRole getMultiLoopRole(@Nullable Nuc nuc) {
        boolean bl = this.isFirst();
        boolean bl2 = this.isLast();
        if (!bl && !bl2) {
            return MultiLoopRole.None;
        }
        if (!bl) {
            return MultiLoopRole.Entrance;
        }
        if (!bl2) {
            return MultiLoopRole.Exit;
        }
        if (nuc == null) {
            return MultiLoopRole.Unknown;
        }
        if (nuc.indexInScene == this.n5.indexInScene || nuc.indexInScene == this.n3.indexInScene) {
            throw new IllegalArgumentException("The reference nucleotide cannot be one of the bases in this pair.");
        }
        return nuc.indexInScene > this.n5.indexInScene && nuc.indexInScene < this.n3.indexInScene ? MultiLoopRole.Entrance : MultiLoopRole.Exit;
    }

    public Bond nextInHelix() {
        return this.nextInHelix(1);
    }

    public Bond prevInHelix() {
        return this.nextInHelix(-1);
    }

    public Bond nextInHelix(int n) {
        Nuc nuc = this.n5.nextInScene(n, false);
        return null != nuc && null != (nuc = nuc.getPaired(false)) && nuc == this.n3.nextInScene(-n, false) ? nuc.getPairBond() : null;
    }

    public boolean isFirst() {
        return this.prevInHelix() == null;
    }

    public boolean isLast() {
        return this.nextInHelix() == null;
    }

    public Point2D midpoint(@Nullable Point2D point2D) {
        if (point2D == null) {
            return this.midpoint();
        }
        point2D.setLocation((this.n5.location.x + this.n3.location.x) / 2.0f, (this.n5.location.y + this.n3.location.y) / 2.0f);
        return point2D;
    }

    public Vec2D midpoint() {
        return Vec2D.getMidpoint(this.n5.location, this.n3.location);
    }

    public Vec2D normal(@Nullable Vec2D vec2D) {
        if (vec2D == null) {
            vec2D = new Vec2D(this.n5.location, this.n3.location);
        } else {
            vec2D.setLocation(this.n3.location.x - this.n5.location.x, this.n3.location.y - this.n5.location.y);
        }
        return vec2D.rotate90();
    }

    public Vec2D normal() {
        return this.normal(null);
    }

    public boolean isTruePair() {
        switch (this.type) {
            case Prohibited: 
            case Pseudo: {
                return false;
            }
        }
        return true;
    }

    public boolean contains(Nuc nuc) {
        return this.n5 == nuc || this.n3 == nuc;
    }

    public void makeOrdered() {
        if (!this.isOrdered()) {
            this.swap();
        }
    }

    private void swap() {
        Nuc nuc = this.n3;
        this.n3 = this.n5;
        this.n5 = nuc;
    }

    public boolean isOrdered() {
        return this.getNuc5().compareTo(this.getNuc3()) <= 0;
    }

    @Override
    public int compareTo(Bond bond) {
        int n = this.getNuc5().compareTo(bond.getNuc5());
        if (n == 0) {
            return this.getNuc3().compareTo(bond.getNuc3());
        }
        return n;
    }

    public static int compare(Bond bond, Bond bond2) {
        return bond.compareTo(bond2);
    }

    public String toString() {
        return "Bond " + this.n5 + ":" + this.n3 + (String)(this.type == null || this.type == BondType.Default ? "" : " (" + this.type + ")");
    }

    public static class BondInfo {
        public int n1;
        public int n2;
        public BondType type;

        public BondInfo(int n, int n2, BondType bondType) {
            this.n1 = n;
            this.n2 = n2;
            this.type = bondType;
        }
    }

    public static enum MultiLoopRole {
        None,
        Entrance,
        Exit,
        Unknown;

    }
}

