/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import ur_rna.StructureEditor.AppActions;
import ur_rna.StructureEditor.FileType;
import ur_rna.StructureEditor.MainFrame;
import ur_rna.StructureEditor.Settings;
import ur_rna.StructureEditor.services.UserPrefs;
import ur_rna.Utilities.AppInfo;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.JniLoader;
import ur_rna.Utilities.OSInfo;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.Version;
import ur_rna.Utilities.annotation.Nullable;
import ur_rna.Utilities.swing.Dialogs;
import ur_rna.Utilities.swing.ImageUtil;

public class Program
implements AppInfo.AppInfoProvider {
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 0;
    public static final String TITLE = "Structure Editor";
    public static final String APPNAME = "RNAeditor";
    public static final String RESOURCES = "/ur_rna/StructureEditor/resources/";
    public static final Version VERSION = new Version(1, 0);
    public static final String C_YEAR = "2016 - 2017";
    public static String DrawingFileExtension = "nsd";
    public static final AppLog log = AppLog.getDefault();
    private static final Program instance = new Program();
    private UserPrefs userPrefs = new UserPrefs("RNAeditor");
    private Settings settings = new Settings();
    private MainFrame mainFrame;
    static Pattern pattern = Pattern.compile("\\bres://([^\\s\"']+)");

    public static Program getInstance() {
        return instance;
    }

    public static String getVersion() {
        return "1.0";
    }

    public UserPrefs prefs() {
        return this.userPrefs;
    }

    public Settings settings() {
        return this.settings;
    }

    public static void main(String[] stringArray) {
        Program.instance.settings.load(Program.instance.userPrefs.user().node("settings"));
        StartupArgs startupArgs = Program.parseCommandArgs(stringArray);
        log.readSystemProperties();
        OSInfo.applyNativeLookAndFeel();
        OSInfo.useNativeMenus();
        MainFrame mainFrame = Program.instance.mainFrame = new MainFrame();
        mainFrame.setVisible(true);
        if (!Program.loadNativeLib()) {
            System.exit(2);
            return;
        }
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Program.instance.settings.save(Program.instance.userPrefs.user().node("settings"));
                super.windowClosing(windowEvent);
            }
        });
        instance.doInitialStartup();
        mainFrame.showDashboard(false);
        for (String string : startupArgs.files) {
            AppActions.openFile(string, FileType.AnyOpenable);
        }
    }

    public Preferences mruPaths() {
        return this.prefs().user().node("MRUPaths");
    }

    private static StartupArgs parseCommandArgs(String[] stringArray) {
        StartupArgs startupArgs = new StartupArgs();
        try {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.startsWith("-") && !bl) {
                    switch (string.toLowerCase()) {
                        case "-d": {
                            System.setProperty("debug", "true");
                            break;
                        }
                        case "-v": {
                            System.setProperty("verbose", stringArray[++i]);
                            break;
                        }
                        case "-sfc": {
                            System.setProperty("simple-file-chooser", "true");
                            break;
                        }
                        case "--": {
                            bl = true;
                            break;
                        }
                        default: {
                            log.error("Unknown command-line option: \"%s\".", stringArray[i]);
                            break;
                        }
                    }
                    continue;
                }
                startupArgs.files.add(string);
            }
        }
        catch (Throwable throwable) {
            log.error("error parsing command line.", throwable);
        }
        return startupArgs;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    @Override
    public Version getAppVersion() {
        return VERSION;
    }

    @Override
    public String getAppTitle() {
        return TITLE;
    }

    @Override
    public String getAppName() {
        return APPNAME;
    }

    public AppInfo.AppInfoProvider getAppInfo() {
        return instance;
    }

    public static boolean loadNativeLib() {
        try {
            JniLoader jniLoader = new JniLoader("RNAstructure", "RNAstructure_GUI" + JniLoader.getJvmBits(), "RNAstructure_GUI");
            jniLoader.load();
            AppLog.getDefault().info("Loaded Native DLL: " + jniLoader.getLoadedLib());
            return true;
        }
        catch (JniLoader.NativeLibLoadError nativeLibLoadError) {
            Dialogs.showWarning(nativeLibLoadError.getMessage());
            return false;
        }
    }

    private void doInitialStartup() {
    }

    public static BufferedImage getImage(String object) {
        if (((String)object).indexOf(46) == -1) {
            object = (String)object + ".png";
        }
        try {
            URL uRL = Program.getResource("images/" + (String)object);
            if (uRL != null) {
                return ImageUtil.toBufferedImage(ImageIO.read(uRL), true);
            }
            log.error("Error loading image resource: \"" + (String)object + "\". Resource not found.");
        }
        catch (Exception exception) {
            log.error("Error loading image resource: \"" + (String)object + "\"", exception);
        }
        return null;
    }

    @Nullable
    public static ImageIcon getIcon(String string) {
        BufferedImage bufferedImage = Program.getImage(string);
        return bufferedImage == null ? null : new ImageIcon(bufferedImage, string);
    }

    @Nullable
    public static URL getResource(String string) {
        return Program.class.getResource(RESOURCES + string);
    }

    @Nullable
    public static File getResourceFile(String string) {
        URL uRL = Program.getResource(string);
        return uRL == null ? null : new File(uRL.toString());
    }

    public static InputStream getResourceStream(String string) {
        return Program.class.getResourceAsStream(RESOURCES + string);
    }

    public static List<String> getImageResources() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            File file = Program.getResourceFile("images");
            if (file == null) {
                return Collections.emptyList();
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return Collections.emptyList();
            }
            for (File file2 : fileArray) {
                if (!file2.getName().endsWith(".png")) continue;
                arrayList.add(file2.getName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static String getResourceText(String string) {
        return Program.getResourceText(string, null);
    }

    public static String getResourceText(String string, String string2) {
        String string3 = null;
        String[] stringArray = new String[]{".txt", ".htm", ".html", ""};
        for (String object2 : stringArray) {
            if (Program.getResource("messages/" + string + object2) == null) continue;
            string3 = "messages/" + string + object2;
            break;
        }
        if (string3 != null) {
            String string4;
            block11: {
                InputStream inputStream = Program.getResourceStream(string3);
                try {
                    Object object = Strings.readAll(inputStream, StandardCharsets.UTF_8);
                    if (string2 != null && !string2.isEmpty()) {
                        Pattern pattern = Pattern.compile("^<section +" + string2 + " *>(?:\\r?\\n)?(.*?)(?:\\r?\\n)?^</section>", 40);
                        Matcher matcher = pattern.matcher((CharSequence)object);
                        object = matcher.find() ? Program.replaceResUrls(matcher.group(1)) : "<Failed to find section " + string2 + ">";
                    }
                    string4 = object;
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                inputStream.close();
            }
            return string4;
        }
        return "<Failed to open message " + string + ">";
    }

    public static String replaceResUrls(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            URL uRL = Program.getResource(matcher.group(1));
            matcher.appendReplacement(stringBuffer, uRL == null ? matcher.group() : uRL.toString());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static class StartupArgs {
        public List<String> files = new ArrayList<String>();

        private StartupArgs() {
        }
    }
}

