/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.swing.Components;

public interface IMergeItem
extends Cloneable {
    public static final int MergePosDefault = 0;
    public static final int MergePosMin = -2147483632;
    public static final int MergePosMax = Integer.MAX_VALUE;
    public static final int MergePosInvalid = -2147483647;
    public static final int MergePosInitial = -2147483647;

    public int getMergePos();

    public IMergeItem setMergePos(int var1);

    public Component getComponent();

    default public String getMergeName() {
        return Components.getNameOrText(this.getComponent());
    }

    default public void mergeStart() {
    }

    default public void mergeEnd() {
    }

    @NotNull
    public static String getMergeName(Component component) {
        String string;
        if (component instanceof IMergeItem && !Strings.isEmpty(string = ((IMergeItem)((Object)component)).getMergeName())) {
            return string;
        }
        return Components.getNameOrText(component);
    }

    public static int getValidMergePos(Component component) {
        return IMergeItem.fixInvalid(IMergeItem.getMergePos(component));
    }

    public static int getMergePos(Component component) {
        return component instanceof IMergeItem ? ((IMergeItem)((Object)component)).getMergePos() : 0;
    }

    public static int compareByMergePos(Component component, Component component2) {
        return IMergeItem.getValidMergePos(component) - IMergeItem.getValidMergePos(component2);
    }

    public static int compareByMergePos(IMergeItem iMergeItem, IMergeItem iMergeItem2) {
        return IMergeItem.fixInvalid(iMergeItem.getMergePos()) - IMergeItem.fixInvalid(iMergeItem2.getMergePos());
    }

    public static int fixInvalid(int n) {
        return n == -2147483647 ? 0 : n;
    }

    public static int setMergePos(IMergeItem iMergeItem, int n) {
        if (n != -2147483647) {
            iMergeItem.setMergePos(n);
        }
        return iMergeItem.getMergePos();
    }

    public static int setInitialMergePos(IMergeItem iMergeItem, int n) {
        if (iMergeItem.getMergePos() == -2147483647) {
            iMergeItem.setMergePos(n);
        }
        return iMergeItem.getMergePos();
    }

    public static IMergeItem asMergeItem(final Component component) {
        if (component instanceof IMergeItem) {
            return (IMergeItem)((Object)component);
        }
        return new IMergeItem(){

            @Override
            public int getMergePos() {
                return 0;
            }

            @Override
            public IMergeItem setMergePos(int n) {
                throw new UnsupportedOperationException("The merge position of a proxy IMergeItem cannot be changed.");
            }

            @Override
            public Component getComponent() {
                return component;
            }
        };
    }

    public static List<IMergeItem> asMergeItems(Collection<? extends Component> collection) {
        ArrayList<IMergeItem> arrayList = new ArrayList<IMergeItem>(collection.size());
        for (Component component : collection) {
            arrayList.add(IMergeItem.asMergeItem(component));
        }
        return arrayList;
    }

    public static class Proxy
    implements IMergeItem {
        private final Component component;
        private int mergePos;

        public Proxy(Component component) {
            this(component, -2147483647);
        }

        public Proxy(Component component, int n) {
            this.component = component;
            this.mergePos = n;
        }

        @Override
        public int getMergePos() {
            return this.mergePos;
        }

        @Override
        public Proxy setMergePos(int n) {
            this.mergePos = n;
            return this;
        }

        @Override
        public Component getComponent() {
            return this.component;
        }
    }
}

