/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.annotation.Nullable;

public class ResourceLoader {
    protected ClassLoader loader;
    protected String baseDir;
    protected List<String> searchDirs = new ArrayList<String>();
    protected static final char pathSep = '/';
    private List<String> allSearchDirs;

    public ResourceLoader() {
        this("resources/");
    }

    public ResourceLoader(String string) {
        this.setBaseDir(string);
        this.setLoader(null);
    }

    public ResourceLoader(String string, ClassLoader classLoader) {
        this(string);
        this.setLoader(classLoader);
    }

    public ResourceLoader(Class clazz, String string) {
        this(ResourceLoader.getDirFromPackage(clazz, string));
    }

    public void setLoader(@Nullable ClassLoader classLoader) {
        this.loader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
        if (this.baseDir == null) {
            this.baseDir = "";
        } else {
            this.baseDir = PathTools.getCanonicalPath(string, true, false, true, true);
            if (this.baseDir.equals("/")) {
                this.baseDir = "";
            }
        }
    }

    public void setBaseDir(@NotNull Class<?> clazz, String string) {
        this.setBaseDir(ResourceLoader.getDirFromPackage(clazz, string));
    }

    public static String getDirFromPackage(@NotNull Class<?> clazz, String string) {
        return ResourceLoader.getDirFromPackage(clazz.getPackage(), string);
    }

    public static String getDirFromPackage(@NotNull Package package_, String string) {
        Object object = package_.getName().replace('.', '/');
        if (string != null && string.length() != 0) {
            object = (String)object + "/" + string;
        }
        return object;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void addSearchDir(String string) {
        this.searchDirs.add(PathTools.getCanonicalPath(string, true, false, false, true));
    }

    public void addSearchDirs(String ... stringArray) {
        for (String string : stringArray) {
            this.addSearchDir(string);
        }
    }

    public List<String> getSearchDirs() {
        return this.searchDirs;
    }

    public InputStream tryGetStream(String string) {
        String string2 = this.getResourceLocation(string);
        if (string2 == null) {
            return null;
        }
        return this.loader.getResourceAsStream(string2);
    }

    public InputStream getStream(String string) throws IOException {
        return this.getStream(string, false);
    }

    public InputStream getStream(String string, boolean bl) throws IOException {
        InputStream inputStream = this.tryGetStream(string);
        if (inputStream == null) {
            if (bl) {
                return null;
            }
            throw ResourceLoader.createNotFoundException(string);
        }
        return inputStream;
    }

    public String getResourceLocation(String string) {
        String string2 = this.baseDir + string;
        if (this.loader.getResource(string2) != null) {
            return string2;
        }
        for (String string3 : this.searchDirs) {
            string2 = string3.startsWith("/") ? string3 + string : this.baseDir + string3 + string;
            if (this.loader.getResource(string2) == null) continue;
            return string2;
        }
        return null;
    }

    private static IOException createNotFoundException(String string) {
        return new IOException(String.format("Resource not found: %s.", string));
    }

    public List<String> getAllSearchDirs() {
        URL[] uRLArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URL uRL : uRLArray = ((URLClassLoader)this.loader).getURLs()) {
            Object object = uRL.toString();
            if (((String)object).endsWith(".jar")) {
                object = (String)object + "!";
            } else if (!((String)object).endsWith("/") && !((String)object).endsWith(".jar!")) {
                object = (String)object + "/";
            }
            arrayList.add((String)object + this.baseDir);
            for (String string : this.searchDirs) {
                if (string.startsWith("/")) {
                    arrayList.add((String)object + string);
                    continue;
                }
                arrayList.add((String)object + this.baseDir + string);
            }
        }
        return arrayList;
    }

    public boolean hasResource(String string) {
        return this.getResourceLocation(string) != null;
    }
}

