/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import ur_rna.Utilities.ClassLoaderInfo;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Version;

public class JniLoader {
    private String libraryTitle;
    private String minVersion;
    private List<String> allowedNames = new ArrayList<String>();
    private Supplier<String> versionCheck;

    public JniLoader(String string) {
        this(string, (Supplier<String>)null, (String)null, (String[])null);
    }

    public JniLoader(String string, String ... stringArray) {
        this(string, (Supplier<String>)null, (String)null, stringArray);
    }

    public JniLoader(String string, Supplier<String> supplier, String string2, String ... stringArray) {
        this.libraryTitle = string;
        this.minVersion = string2;
        if (stringArray != null) {
            Collections.addAll(this.allowedNames, stringArray);
        }
        this.versionCheck = supplier;
    }

    public List<String> getAllowedLibNames() {
        return this.allowedNames;
    }

    public void addLibName(String string) {
        this.allowedNames.add(string);
    }

    public static String getJvmBits(String string, String string2) {
        String string3 = System.getProperty("sun.arch.data.model");
        if (string3.equals("64")) {
            return string2;
        }
        if (string3.equals("32")) {
            return string;
        }
        return "";
    }

    public static String getJvmBits() {
        return JniLoader.getJvmBits("_32", "_64");
    }

    public void load() throws NativeLibLoadError {
        String[] stringArray = this.getLibNames();
        Throwable[] throwableArray = new Throwable[stringArray.length];
        String[] stringArray2 = new String[stringArray.length];
        if (this.tryLoadLibrary(stringArray, throwableArray)) {
            return;
        }
        Throwable throwable = null;
        for (int i = 0; i < throwableArray.length; ++i) {
            String string = stringArray2[i] = throwableArray[i] == null ? "Unknown Error" : throwableArray[i].getMessage();
            if (stringArray2[i].equals("no " + stringArray[i] + " in java.library.path")) {
                stringArray2[i] = "Not found.";
                continue;
            }
            if (throwable != null) continue;
            throwable = throwableArray[i];
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (throwable == null) {
            stringBuilder.append("The required " + this.libraryTitle + " library is missing.\nIt should be in the same directory as the application, and it should be named:\n    ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append("  or  ");
                }
                stringBuilder.append(System.mapLibraryName(stringArray[i]));
            }
            stringBuilder.append("\n\nFor troubleshooting purposes, note that the following locations were searched:\n  ").append(System.getProperty("java.library.path").replace(File.pathSeparator, "\n  "));
            stringBuilder.append("\n  (Current directory: ").append(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString()).append(")\n");
        } else {
            stringBuilder.append("Unable to load the " + this.libraryTitle + " library!\n").append(throwable.getMessage()).append("\n\n-------- Error Details (For all attempted paths): --------\n");
            for (int i = 0; i < throwableArray.length; ++i) {
                stringBuilder.append(i + 1).append(")  Attempted to load ").append(System.mapLibraryName(stringArray[i])).append("\n      Result: ").append(stringArray2[i]).append("\n");
            }
            stringBuilder.append("\nAttempted Paths:\n").append(System.getProperty("java.library.path").replace(File.pathSeparator, ", "));
        }
        throw new NativeLibLoadError(stringBuilder.toString());
    }

    public String getLoadedLib() {
        String[] stringArray = ClassLoaderInfo.getMyLoadedLibraries();
        for (String string : this.getLibNames()) {
            String string2 = string.toLowerCase();
            for (String string3 : stringArray) {
                if (!string3.toLowerCase().contains(string2)) continue;
                return string3;
            }
        }
        return null;
    }

    private boolean tryLoadLibrary(String[] stringArray, Throwable[] throwableArray) {
        this.setLibPath(System.getProperty("java.library.path") + File.pathSeparator + PathTools.findLocalPath(".") + "/");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                System.loadLibrary(stringArray[i]);
                if (this.versionCheck != null) {
                    try {
                        String string = this.versionCheck.get();
                        if (!Version.isVersionCompatible(this.minVersion, string)) {
                            throw new UnsatisfiedLinkError(String.format("The library version is %s, but a version compatible with %s is required.", string, this.minVersion));
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        throw new UnsatisfiedLinkError("The " + stringArray[i] + " library is corrupt or has the wrong version or binary format.");
                    }
                }
                return true;
            }
            catch (Throwable throwable) {
                throwableArray[i] = throwable;
                continue;
            }
        }
        return false;
    }

    private void setLibPath(String string) {
        System.setProperty("java.library.path", string);
        try {
            Field field = ClassLoader.class.getDeclaredField("sys_paths");
            field.setAccessible(true);
            field.set(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] getLibNames() {
        if (this.allowedNames.size() == 0) {
            return new String[]{this.libraryTitle, this.libraryTitle + JniLoader.getJvmBits()};
        }
        return this.allowedNames.toArray(new String[this.allowedNames.size()]);
    }

    public static class NativeLibLoadError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NativeLibLoadError() {
        }

        public NativeLibLoadError(String string) {
            super(string);
        }

        public NativeLibLoadError(Throwable throwable) {
            super(throwable);
        }

        public NativeLibLoadError(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

