/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import ur_rna.Utilities.ActionHandler;
import ur_rna.Utilities.EventArgs;

public abstract class ActionHandlers {
    public static ActionHandler fromRunnable(final Runnable runnable) {
        return new ActionHandler(){

            public void handle(Object object, EventArgs eventArgs) {
                runnable.run();
            }
        };
    }

    public static ActionHandler fromCallable(final Callable callable) {
        return new ActionHandler(){

            public void handle(Object object, EventArgs eventArgs) {
                try {
                    callable.call();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
    }

    public static ActionHandler fromConsumer(final Consumer<EventArgs> consumer) {
        return new ActionHandler(){

            public void handle(Object object, EventArgs eventArgs) {
                consumer.accept(eventArgs);
            }
        };
    }

    public static <T> ActionHandler<EventArgs.ObjEventArgs<T>> fromConsumerT(final Consumer<T> consumer) {
        return new ActionHandler<EventArgs.ObjEventArgs<T>>(){

            @Override
            public void handle(Object object, EventArgs.ObjEventArgs<T> objEventArgs) {
                consumer.accept(objEventArgs.value);
            }
        };
    }

    public static ActionHandler<EventArgs.ActionEventArgs> fromEventListner(final ActionListener actionListener) {
        return new ActionHandler<EventArgs.ActionEventArgs>(){

            @Override
            public void handle(Object object, EventArgs.ActionEventArgs actionEventArgs) {
                actionListener.actionPerformed(actionEventArgs.event);
            }
        };
    }
}

