/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ur_rna.RNAstructure.backend.RNA;
import ur_rna.RNAstructure.backend.RNABackend;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.utilities.FileType;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.RNAstructureUI.windows.PredictWindowBase;
import ur_rna.RNAstructureUI.windows.PredictionResultsWindow;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.swing.FormValidationException;

public class PredictSingleStructureWindow
extends PredictWindowBase {
    private static final long serialVersionUID = 20160122L;
    private JPanel contentPanel;
    private JTextField txtSeqFile;
    private JRadioButton optSeqFile;
    private JButton btnBrowseSeq;
    private JTextArea txtSequence;
    private JTextField txtSeqTitle;
    private JRadioButton optRNA;
    private JSpinner spnTemperature;
    private JTabbedPane tabControls;
    private JSpinner spnMaxLoopSize;
    private JSpinner spnMaxEnergyDiff;
    private JSpinner spnMinHelixLen;
    private JSpinner spnIterations;
    private JSpinner spnGamma;
    private JSpinner spnWindowSize;
    private JSpinner spnMaxStructs;
    private JRadioButton optDNA;
    private JRadioButton optEnterSeq;
    private JTextField txtConFile;
    private JButton btnBrowseCon;
    private JTextField txtShapeFile;
    private JButton btnBrowseShape;
    private JSpinner spnShapeIntercept;
    private JSpinner spnShapeSlope;
    private JButton btnStartCalc;
    private JTextField txtOutputFile;
    private JButton btnBrowseOutput;
    private JButton btnRecentSeq;
    private JButton btnRecentOutput;
    private JButton btnRecentCon;
    private JButton btnRecentShape;
    private JButton btnResetOptions;
    private JLabel lblOptionWarning;
    private JScrollPane scrlSequence;
    private JButton btnCancelTask;
    private JProgressBar prgTaskProgress;
    private JLabel lblTaskStatus;
    private JPanel pnlTaskStatus;
    private JCheckBox chkShowDescription;
    private JLabel lblToolDescription;
    private JPanel pnlOutput;
    private JLabel lblProgressPercent;
    private HashMap<JComponent, Object> defaultOptionValues = new HashMap();
    private ArrayList<JComponent> optionsControls = new ArrayList();
    private ArrayList<JComponent> settingsControls = new ArrayList();
    private final String settingsNodeName = "PredictSingle";
    private String lastSeqFile = "";
    private String lastOutFile = "";

    public PredictSingleStructureWindow() {
        this.$$$setupUI$$$();
        this.autoSetFieldNames();
        this.setCaption("Predict a Secondary Structure");
        this.listenForActions(this.contentPanel, JButton.class, this);
        this.addFileField("seq", this.txtSeqFile, FileFilters.Sequence, false, "select-seqfile");
        this.addFileField("con", this.txtConFile, FileFilters.Constraints, false);
        this.addFileField("shape", this.txtShapeFile, FileFilters.SHAPE, false);
        this.addFileField("output", this.txtOutputFile, FileFilters.CT, true);
        this.pnlTaskStatus.setVisible(false);
        this.setContent(this.contentPanel);
        this.setPreferredSize(new Dimension(700, 600));
        this.optionsControls.addAll(Arrays.asList(this.spnTemperature, this.spnMaxLoopSize, this.spnMaxEnergyDiff, this.spnMaxStructs, this.spnWindowSize, this.spnGamma, this.spnIterations, this.spnMinHelixLen, this.spnShapeIntercept, this.spnShapeSlope));
        this.settingsControls.addAll(this.optionsControls);
        this.settingsControls.addAll(Arrays.asList(this.optDNA, this.optRNA, this.optEnterSeq, this.optSeqFile, this.chkShowDescription));
        this.loadSettingsDefaults();
        for (JComponent jComponent : this.optionsControls) {
            this.defaultOptionValues.put(jComponent, this.getControlValue(jComponent));
        }
        this.handleSettings(false);
        this.btnResetOptions.setEnabled(false);
        this.lblOptionWarning.setVisible(false);
        this.updateFormUI();
        this.startUiTimer();
    }

    @Override
    public void showWindow() {
        super.showWindow();
        SwingUtilities.invokeLater(this::pack);
    }

    private void loadSettingsDefaults() {
        this.setSpin(this.spnTemperature, 310.15, 0.0, 600.0, 1.0);
        this.setSpin(this.spnMaxLoopSize, 30, 3, 100);
        this.setSpin(this.spnMaxEnergyDiff, 10, 1, 200);
        this.setSpin(this.spnMaxStructs, 20, 1, 1000);
        this.setSpin(this.spnWindowSize, 3, 1, 100);
        this.setSpin(this.spnGamma, 1.0);
        this.setSpin(this.spnIterations, 1, 0, 1000);
        this.setSpin(this.spnMinHelixLen, 3, 1, 20);
        this.setSpin(this.spnShapeIntercept, -0.6);
        this.setSpin(this.spnShapeSlope, 1.8);
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        switch (commandInfo.getCommand()) {
            case "select-seqfile": {
                this.optSeqFile.setSelected(true);
                break;
            }
            case "reset-options": {
                for (JComponent jComponent : this.optionsControls) {
                    this.setControlValue(jComponent, this.defaultOptionValues.get(jComponent));
                }
                break;
            }
            case "start": {
                if (!this.verifyInput()) break;
                this.runCalc();
                break;
            }
            case "cancel-task": {
                PredictWindowBase.BackgroundTask backgroundTask = this.getRunningTask();
                if (backgroundTask == null) break;
                backgroundTask.cancel();
                break;
            }
            default: {
                super.processCommand(commandInfo);
            }
        }
    }

    @Override
    protected void updateFormUI() {
        int n;
        Object object;
        PredictSingleStructureTask predictSingleStructureTask = (PredictSingleStructureTask)this.getRunningTask();
        if (predictSingleStructureTask != null) {
            this.setTaskStatus(predictSingleStructureTask.getProgress(), predictSingleStructureTask.getStatus());
            this.btnCancelTask.setEnabled(predictSingleStructureTask.canCancel);
            return;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = this.optionsControls.iterator();
        while (object2.hasNext()) {
            JComponent jComponent = object2.next();
            object = this.getControlValue(jComponent);
            if (Objects.equals(object, this.defaultOptionValues.get(jComponent))) continue;
            stringBuilder.append(this.getControlDescription(jComponent)).append(": ").append(this.formatValue(object)).append("    ");
            bl = true;
        }
        if (bl && !((String)(object = ((String)(object2 = this.lblOptionWarning.getText())).substring(0, (n = ((String)object2).indexOf("<br>")) + 4) + stringBuilder)).equals(object2)) {
            this.lblOptionWarning.setText((String)object);
        }
        this.lblOptionWarning.setVisible(bl);
        boolean bl2 = this.optSeqFile.isSelected();
        this.txtSeqFile.setEnabled(bl2);
        this.txtSequence.setEnabled(!bl2);
        this.txtSeqTitle.setEnabled(!bl2);
        this.scrlSequence.setEnabled(!bl2);
        this.btnResetOptions.setEnabled(bl);
        if (bl2 && !this.lastSeqFile.equals(this.txtSeqFile.getText())) {
            this.lastSeqFile = this.txtSeqFile.getText();
            if (this.txtOutputFile.getText().isEmpty() || this.lastOutFile.equals(this.txtOutputFile.getText())) {
                this.lastOutFile = ModuleWindow.getOutputFile(this.txtSeqFile.getText(), "ct");
                this.txtOutputFile.setText(this.lastOutFile);
            }
        }
        if (this.lblToolDescription.isVisible() != this.chkShowDescription.isSelected()) {
            this.lblToolDescription.setVisible(this.chkShowDescription.isSelected());
            if (this.isVisible()) {
                this.pack();
            }
        }
    }

    private void runCalc() {
        this.saveRecentFiles(this.txtShapeFile, this.txtConFile, this.txtSeqFile, this.txtOutputFile);
        this.handleSettings(true);
        this.btnStartCalc.setVisible(false);
        this.pnlTaskStatus.setVisible(true);
        this.enableDescendants(this.tabControls, false, new Component[0]);
        this.enableDescendants(this.pnlOutput, false, new Component[0]);
        this.setTaskStatus(0, "Starting calculation...");
        PredictSingleStructureTask predictSingleStructureTask = new PredictSingleStructureTask();
        if (this.optEnterSeq.isSelected()) {
            predictSingleStructureTask.sequence = this.txtSequence.getText();
            predictSingleStructureTask.sequenceTitle = this.txtSeqTitle.getText();
            predictSingleStructureTask.seqType = RNABackend.SEQUENCE_STRING;
        } else {
            predictSingleStructureTask.sequence = this.txtSeqFile.getText();
            predictSingleStructureTask.seqType = RNABackend.FILE_SEQ;
        }
        predictSingleStructureTask.alphabet = this.optDNA.isSelected() ? "dna" : "rna";
        predictSingleStructureTask.baseOutputName = PathTools.changeExtension(this.txtOutputFile.getText().trim(), "");
        predictSingleStructureTask.temperature = (Double)this.spnTemperature.getValue();
        predictSingleStructureTask.maxLoopSize = (Integer)this.spnMaxLoopSize.getValue();
        predictSingleStructureTask.maxEnergyDiff = (Integer)this.spnMaxEnergyDiff.getValue();
        predictSingleStructureTask.maxStructures = (Integer)this.spnMaxStructs.getValue();
        predictSingleStructureTask.windowSize = (Integer)this.spnWindowSize.getValue();
        predictSingleStructureTask.gamma = (Double)this.spnGamma.getValue();
        predictSingleStructureTask.iterations = (Integer)this.spnIterations.getValue();
        predictSingleStructureTask.minHelixLen = (Integer)this.spnMinHelixLen.getValue();
        predictSingleStructureTask.shapeSlope = (Double)this.spnShapeSlope.getValue();
        predictSingleStructureTask.shapeIntercept = (Double)this.spnShapeIntercept.getValue();
        predictSingleStructureTask.shapeFile = this.txtShapeFile.getText();
        predictSingleStructureTask.conFile = this.txtConFile.getText();
        this.runInBackground(predictSingleStructureTask, this::calcComplete);
    }

    private void calcComplete(PredictSingleStructureTask predictSingleStructureTask) {
        this.btnStartCalc.setVisible(true);
        this.pnlTaskStatus.setVisible(false);
        this.enableDescendants(this.tabControls, true, new Component[0]);
        this.enableDescendants(this.pnlOutput, true, new Component[0]);
        if (predictSingleStructureTask.isCanceled) {
            return;
        }
        if (predictSingleStructureTask.onComplete()) {
            this.dispose();
        }
    }

    private void $$$setupUI$$$() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setAutoscrolls(true);
        this.contentPanel.setName("contentPanel");
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 14));
        jLabel.setOpaque(false);
        jLabel.setText("Predict a Secondary Structure");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.contentPanel.add((Component)jLabel, gridBagConstraints);
        this.tabControls = new JTabbedPane();
        this.tabControls.setName("tabbedPane1");
        this.tabControls.setPreferredSize(new Dimension(512, 260));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.contentPanel.add((Component)this.tabControls, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.tabControls.addTab("Sequence", jPanel);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Nucleic Acid Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.optRNA = new JRadioButton();
        this.optRNA.setName("optRNA");
        this.optRNA.setSelected(true);
        this.optRNA.setText("RNA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.optRNA, gridBagConstraints);
        this.txtSeqFile = new JTextField();
        this.txtSeqFile.setName("txtSeqFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.txtSeqFile, gridBagConstraints);
        this.btnBrowseSeq = new JButton();
        this.btnBrowseSeq.setActionCommand("browse-seq");
        this.btnBrowseSeq.setName("btnBrowseSeq");
        this.btnBrowseSeq.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.btnBrowseSeq, gridBagConstraints);
        this.txtSeqTitle = new JTextField();
        this.txtSeqTitle.setName("txtSeqTitle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.txtSeqTitle, gridBagConstraints);
        this.scrlSequence = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        jPanel.add((Component)this.scrlSequence, gridBagConstraints);
        this.txtSequence = new JTextArea();
        this.txtSequence.setName("txtSequence");
        this.txtSequence.setText("(Enter Sequence)");
        this.scrlSequence.setViewportView(this.txtSequence);
        this.btnRecentSeq = new JButton();
        this.btnRecentSeq.setActionCommand("recent-seq");
        this.btnRecentSeq.setName("btnRecentSeq");
        this.btnRecentSeq.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.btnRecentSeq, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Sequence Source");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.optSeqFile = new JRadioButton();
        this.optSeqFile.setName("optSeqFile");
        this.optSeqFile.setSelected(true);
        this.optSeqFile.setText("Load from File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.optSeqFile, gridBagConstraints);
        this.optEnterSeq = new JRadioButton();
        this.optEnterSeq.setName("optEnterSeq");
        this.optEnterSeq.setText("Enter Sequence Below");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.optEnterSeq, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Sequence File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Sequence Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        this.optDNA = new JRadioButton();
        this.optDNA.setName("optDNA");
        this.optDNA.setText("DNA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.optDNA, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.tabControls.addTab("Options", jPanel2);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Temperature");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        this.spnTemperature = new JSpinner();
        this.spnTemperature.setName("spnTemperature");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.spnTemperature, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("K");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel2.add((Component)jLabel7, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("(all)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel8, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("(used for)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel9, gridBagConstraints);
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Maximum Loop Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel10, gridBagConstraints);
        this.spnMaxLoopSize = new JSpinner();
        this.spnMaxLoopSize.setName("spnMaxLoopSize");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.spnMaxLoopSize, gridBagConstraints);
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("bases");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel2.add((Component)jLabel11, gridBagConstraints);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Maximum % Energy Difference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel12, gridBagConstraints);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Maximum Number of Structures");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel13, gridBagConstraints);
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Window Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel14, gridBagConstraints);
        this.spnMaxEnergyDiff = new JSpinner();
        this.spnMaxEnergyDiff.setName("spnMaxEnergyDiff");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.spnMaxEnergyDiff, gridBagConstraints);
        this.spnMaxStructs = new JSpinner();
        this.spnMaxStructs.setName("spnMaxStructs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.spnMaxStructs, gridBagConstraints);
        this.spnWindowSize = new JSpinner();
        this.spnWindowSize.setName("spnWindowSize");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.spnWindowSize, gridBagConstraints);
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("(all)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel15, gridBagConstraints);
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("(MFE, MEA)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel16, gridBagConstraints);
        JLabel jLabel17 = new JLabel();
        jLabel17.setText("(MFE, MEA)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel17, gridBagConstraints);
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("(MFE, MEA)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel18, gridBagConstraints);
        this.spnGamma = new JSpinner();
        this.spnGamma.setName("spnGamma");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.spnGamma, gridBagConstraints);
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("Gamma");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel19, gridBagConstraints);
        JLabel jLabel20 = new JLabel();
        jLabel20.setText("(MEA)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel20, gridBagConstraints);
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("Iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel21, gridBagConstraints);
        JLabel jLabel22 = new JLabel();
        jLabel22.setText("Minimum Helix Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel22, gridBagConstraints);
        this.spnIterations = new JSpinner();
        this.spnIterations.setName("spnIterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.spnIterations, gridBagConstraints);
        this.spnMinHelixLen = new JSpinner();
        this.spnMinHelixLen.setName("spnMinHelixLen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.spnMinHelixLen, gridBagConstraints);
        JLabel jLabel23 = new JLabel();
        jLabel23.setText("(Pseudoknot Prediction)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel23, gridBagConstraints);
        JLabel jLabel24 = new JLabel();
        jLabel24.setText("(Pseudoknot Prediction)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel24, gridBagConstraints);
        JLabel jLabel25 = new JLabel();
        jLabel25.setText("bases");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel2.add((Component)jLabel25, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this.btnResetOptions = new JButton();
        this.btnResetOptions.setActionCommand("reset-options");
        this.btnResetOptions.setText("Reset All to Defaults");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.btnResetOptions, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.tabControls.addTab("Constraints", jPanel4);
        JLabel jLabel26 = new JLabel();
        jLabel26.setText("Folding Constraints File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel4.add((Component)jLabel26, gridBagConstraints);
        this.txtConFile = new JTextField();
        this.txtConFile.setName("txtConFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel4.add((Component)this.txtConFile, gridBagConstraints);
        this.btnBrowseCon = new JButton();
        this.btnBrowseCon.setActionCommand("browse-con");
        this.btnBrowseCon.setName("btnBrowseCon");
        this.btnBrowseCon.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.btnBrowseCon, gridBagConstraints);
        JLabel jLabel27 = new JLabel();
        jLabel27.setText("SHAPE File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel4.add((Component)jLabel27, gridBagConstraints);
        this.txtShapeFile = new JTextField();
        this.txtShapeFile.setName("txtShapeFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel4.add((Component)this.txtShapeFile, gridBagConstraints);
        this.btnBrowseShape = new JButton();
        this.btnBrowseShape.setActionCommand("browse-shape");
        this.btnBrowseShape.setName("btnBrowseShape");
        this.btnBrowseShape.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.btnBrowseShape, gridBagConstraints);
        JLabel jLabel28 = new JLabel();
        jLabel28.setText("SHAPE Intercept");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel4.add((Component)jLabel28, gridBagConstraints);
        JLabel jLabel29 = new JLabel();
        jLabel29.setText("SHAPE Slope");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        jPanel4.add((Component)jLabel29, gridBagConstraints);
        this.spnShapeIntercept = new JSpinner();
        this.spnShapeIntercept.setName("spnShapeIntercept");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.spnShapeIntercept, gridBagConstraints);
        this.spnShapeSlope = new JSpinner();
        this.spnShapeSlope.setName("spnShapeSlope");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.spnShapeSlope, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel4.add((Component)jPanel6, gridBagConstraints);
        this.btnRecentCon = new JButton();
        this.btnRecentCon.setActionCommand("recent-con");
        this.btnRecentCon.setName("btnRecentCon");
        this.btnRecentCon.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.btnRecentCon, gridBagConstraints);
        this.btnRecentShape = new JButton();
        this.btnRecentShape.setActionCommand("recent-shape");
        this.btnRecentShape.setName("btnRecentShape");
        this.btnRecentShape.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.btnRecentShape, gridBagConstraints);
        JLabel jLabel30 = new JLabel();
        jLabel30.setText("<html>This calculation will produce multiple files in the same directory as the output file you choose below.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.contentPanel.add((Component)jLabel30, gridBagConstraints);
        this.pnlOutput = new JPanel();
        this.pnlOutput.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)this.pnlOutput, gridBagConstraints);
        JLabel jLabel31 = new JLabel();
        jLabel31.setText("Output File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlOutput.add((Component)jLabel31, gridBagConstraints);
        this.txtOutputFile = new JTextField();
        this.txtOutputFile.setName("txtOutputFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlOutput.add((Component)this.txtOutputFile, gridBagConstraints);
        this.btnBrowseOutput = new JButton();
        this.btnBrowseOutput.setActionCommand("browse-output");
        this.btnBrowseOutput.setName("btnBrowseOutput");
        this.btnBrowseOutput.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOutput.add((Component)this.btnBrowseOutput, gridBagConstraints);
        this.btnRecentOutput = new JButton();
        this.btnRecentOutput.setActionCommand("recent-output");
        this.btnRecentOutput.setName("btnRecentOutput");
        this.btnRecentOutput.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOutput.add((Component)this.btnRecentOutput, gridBagConstraints);
        this.lblOptionWarning = new JLabel();
        this.lblOptionWarning.setBackground(new Color(-2171392));
        this.lblOptionWarning.setForeground(new Color(-16777216));
        this.lblOptionWarning.setHorizontalAlignment(0);
        this.lblOptionWarning.setHorizontalTextPosition(0);
        this.lblOptionWarning.setOpaque(true);
        this.lblOptionWarning.setText("<html><center>Warning: Some options have been set to non-default values.<br>---List---");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlOutput.add((Component)this.lblOptionWarning, gridBagConstraints);
        this.btnStartCalc = new JButton();
        this.btnStartCalc.setActionCommand("start");
        this.btnStartCalc.setHorizontalTextPosition(0);
        this.btnStartCalc.setMinimumSize(new Dimension(54, 40));
        this.btnStartCalc.setName("btnStartCalc");
        this.btnStartCalc.setOpaque(false);
        this.btnStartCalc.setPreferredSize(new Dimension(54, 40));
        this.btnStartCalc.setText("Start");
        this.btnStartCalc.setMnemonic('S');
        this.btnStartCalc.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.pnlOutput.add((Component)this.btnStartCalc, gridBagConstraints);
        this.pnlTaskStatus = new JPanel();
        this.pnlTaskStatus.setLayout(new GridBagLayout());
        this.pnlTaskStatus.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)this.pnlTaskStatus, gridBagConstraints);
        this.btnCancelTask = new JButton();
        this.btnCancelTask.setActionCommand("cancel-task");
        this.btnCancelTask.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.pnlTaskStatus.add((Component)this.btnCancelTask, gridBagConstraints);
        this.prgTaskProgress = new JProgressBar();
        this.prgTaskProgress.setMinimumSize(new Dimension(10, 40));
        this.prgTaskProgress.setPreferredSize(new Dimension(146, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlTaskStatus.add((Component)this.prgTaskProgress, gridBagConstraints);
        this.lblTaskStatus = new JLabel();
        this.lblTaskStatus.setText("Status of background Task");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.pnlTaskStatus.add((Component)this.lblTaskStatus, gridBagConstraints);
        this.lblProgressPercent = new JLabel();
        this.lblProgressPercent.setHorizontalAlignment(0);
        this.lblProgressPercent.setPreferredSize(new Dimension(40, 16));
        this.lblProgressPercent.setText("0%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.pnlTaskStatus.add((Component)this.lblProgressPercent, gridBagConstraints);
        this.chkShowDescription = new JCheckBox();
        this.chkShowDescription.setActionCommand("");
        this.chkShowDescription.setSelected(true);
        this.chkShowDescription.setText("Show Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.contentPanel.add((Component)this.chkShowDescription, gridBagConstraints);
        this.lblToolDescription = new JLabel();
        this.lblToolDescription.setName("lblToolDescription");
        this.lblToolDescription.setText("<html>This tool combines four separate prediction and analysis routines: <ol><li>Calculate a partition function (<b>PF</b>).</li><li>Predict a maximum free energy (<b>MFE</b>) structure.</li><li>Find structures with maximum expected accuracy (<b>MEA</b>).</li><li>Predict pseudoknots (<b>PK</b>).</li></ol>This generates a highly probable, probability-annotated list of secondary structures, starting with the lowest free energy structure and including others with high probabilities of correctness. SHAPE constraints may be specified and are applied to the probability-annotated structures.<br>If SHAPE contraints are specified, a second group of SHAPE constrained, SHAPE annotated structures are be generated. This SHAPE structure group is distinct from the probability-annotated structure group, and is not probability-annotated itself. </html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.contentPanel.add((Component)this.lblToolDescription, gridBagConstraints);
        jLabel4.setLabelFor(this.txtSeqFile);
        jLabel5.setLabelFor(this.txtSeqTitle);
        jLabel6.setLabelFor(this.spnTemperature);
        jLabel10.setLabelFor(this.spnMaxLoopSize);
        jLabel12.setLabelFor(this.spnMaxEnergyDiff);
        jLabel13.setLabelFor(this.spnMaxStructs);
        jLabel14.setLabelFor(this.spnWindowSize);
        jLabel19.setLabelFor(this.spnGamma);
        jLabel21.setLabelFor(this.spnIterations);
        jLabel22.setLabelFor(this.spnMinHelixLen);
        jLabel26.setLabelFor(this.txtConFile);
        jLabel27.setLabelFor(this.txtShapeFile);
        jLabel28.setLabelFor(this.spnShapeIntercept);
        jLabel29.setLabelFor(this.spnShapeSlope);
        jLabel31.setLabelFor(this.txtOutputFile);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.optRNA);
        buttonGroup.add(this.optDNA);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.optSeqFile);
        buttonGroup.add(this.optEnterSeq);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }

    private void setTaskStatus(int n, String string) {
        int n2;
        this.lblTaskStatus.setText(string);
        this.prgTaskProgress.setIndeterminate(n < 0);
        this.lblProgressPercent.setVisible(n >= 0);
        int n3 = n2 = n > 100 ? 100 : n;
        if (n >= 0) {
            this.lblProgressPercent.setText(n2 + "%");
            this.prgTaskProgress.setValue(n2);
        }
    }

    private boolean verifyInput() {
        try {
            this.validateFileField(this.txtOutputFile, false, true);
            if (this.optSeqFile.isSelected()) {
                this.validateFileField(this.txtSeqFile, false);
            } else {
                this.validateRequiredField(this.txtSeqTitle);
                this.validateRequiredField(this.txtSequence);
            }
            this.validateFileField(this.txtConFile, true);
            this.validateFileField(this.txtShapeFile, true);
        }
        catch (FormValidationException formValidationException) {
            Dialogs.showError(formValidationException.getMessage(), "Error in User Input");
            this.focusField(formValidationException.getControl());
            return false;
        }
        return true;
    }

    @Override
    protected void handleSettings(boolean bl) {
        this.handleRecentControlValues(bl, "PredictSingle", this.settingsControls);
    }

    private class PredictSingleStructureTask
    extends PredictWindowBase.PredictTaskBase {
        public String sequence;
        public int seqType;
        public String alphabet;
        public String baseOutputName;
        public double temperature;
        public int maxLoopSize;
        public int maxEnergyDiff;
        public int maxStructures;
        public int windowSize;
        public double gamma;
        public int iterations;
        public int minHelixLen;
        public double shapeSlope;
        public double shapeIntercept;
        public String shapeFile;
        public String conFile;
        public String sequenceTitle;
        public String outFoldCt;
        public String outMaxExpectCt;
        public String outPfs;
        public String outPkCt;
        public String outSav;

        private PredictSingleStructureTask() {
        }

        @Override
        protected void runCalc() {
            this.nextStep("Loading sequence...", true, 2);
            RNA rNA = new RNA(this.sequence, this.seqType, this.alphabet, false, false);
            if (!Strings.isEmpty(this.sequenceTitle)) {
                rNA.GetStructure().SetSequenceLabel(this.sequenceTitle);
            }
            if (this.temperature != 310.15) {
                rNA.SetTemperature(this.temperature);
            }
            if (this.checkError(rNA) || this.isCanceled) {
                return;
            }
            if (!Strings.isWhiteSpace(this.conFile)) {
                rNA.ReadConstraints(this.conFile);
            }
            if (this.checkError(rNA) || this.isCanceled) {
                return;
            }
            if (!Strings.isWhiteSpace(this.shapeFile)) {
                rNA.ReadSHAPE(this.shapeFile, this.shapeSlope, this.shapeIntercept);
            }
            if (this.checkError(rNA) || this.isCanceled) {
                return;
            }
            rNA.SetProgress(this.stepProgress);
            this.nextStep("Running partition...", true, 50);
            this.outPfs = this.baseOutputName + ".pfs";
            rNA.PartitionFunction((String)this.outPfs, this.temperature);
            if (this.checkError(rNA) || this.isCanceled) {
                return;
            }
            this.nextStep("Running MaxExpect...", true, 5);
            rNA.MaximizeExpectedAccuracy(this.maxEnergyDiff, this.maxStructures, this.windowSize, this.gamma);
            this.outMaxExpectCt = this.baseOutputName + "_MaxExpect.ct";
            rNA.WriteCt((String)this.outMaxExpectCt);
            if (this.checkError(rNA) || this.isCanceled) {
                return;
            }
            rNA.GetStructure().RemoveAllStructures();
            this.nextStep("Running ProbKnot...", false, 3);
            rNA.ProbKnot(this.iterations, this.minHelixLen);
            this.outPkCt = this.baseOutputName + "_ProbKnot.ct";
            rNA.WriteCt((String)this.outPkCt);
            if (this.checkError(rNA) || this.isCanceled) {
                return;
            }
            rNA.GetStructure().RemoveAllStructures();
            this.nextStep("Running Fold...", true, 40);
            this.outSav = this.baseOutputName + ".sav";
            rNA.FoldSingleStrand(this.maxEnergyDiff, this.maxStructures, this.windowSize, (String)this.outSav, this.maxLoopSize);
            this.outFoldCt = this.baseOutputName + "_Fold.ct";
            rNA.WriteCt((String)this.outFoldCt);
            if (this.checkError(rNA) || this.isCanceled) {
                return;
            }
            rNA.GetStructure().RemoveAllStructures();
            this.nextStep("Done.", false, 0);
        }

        @Override
        protected boolean showResults() {
            PredictionResultsWindow predictionResultsWindow = new PredictionResultsWindow("Results of Single Structure Prediction");
            if (PathTools.isFile(this.outFoldCt)) {
                predictionResultsWindow.addFile(this.outFoldCt, "MFE (Fold) Structure Prediction");
            }
            if (PathTools.isFile(this.outMaxExpectCt)) {
                predictionResultsWindow.addFile(this.outMaxExpectCt, "MEA (MaxExpect) Structure Prediction");
            }
            if (PathTools.isFile(this.outPkCt)) {
                predictionResultsWindow.addFile(this.outPkCt, "ProbKnot Pseudoknot Structure Prediction");
            }
            if (PathTools.isFile(this.outPfs)) {
                predictionResultsWindow.addFile(this.outPfs, "Partition Function File (Base-pair Probabilities)");
            }
            if (PathTools.isFile(this.outPfs)) {
                predictionResultsWindow.addPlotHeader("Base-pairing Probabilities (from Partition Function)", 1);
                if (PathTools.isFile(this.outPfs)) {
                    predictionResultsWindow.addPlot("Basepair Dot Plot", "Pairwise base-pairing probabilities in dot-plot form.", () -> PredictWindowBase.launchDrawing(this.outPfs, FileType.PFS, null, null, 1));
                }
            }
            predictionResultsWindow.addPlotHeader("Predicted Structures (with no color annotations).", 3);
            if (PathTools.isFile(this.outFoldCt)) {
                predictionResultsWindow.addPlot("MFE Structure", "Minimum Free Energy structure drawing (Without color annotation).", () -> PredictWindowBase.launchDrawing(this.outFoldCt, FileType.CT, null, null, 1));
            }
            if (PathTools.isFile(this.outMaxExpectCt)) {
                predictionResultsWindow.addPlot("MEA Structure", "Maximum Expected Accuracy structure drawing (Without color annotation).", () -> PredictWindowBase.launchDrawing(this.outMaxExpectCt, FileType.CT, null, null, 1));
            }
            if (PathTools.isFile(this.outPkCt)) {
                predictionResultsWindow.addPlot("Pseudoknot Structure", "Structure drawing with possible pseudoknots (Without color annotation).", () -> PredictWindowBase.launchDrawing(this.outPkCt, FileType.CT, null, null, 1));
            }
            predictionResultsWindow.addPlotHeader("Predicted Structures color-annotated with base-pairing probabilities.", 3);
            if (PathTools.isFile(this.outFoldCt)) {
                predictionResultsWindow.addPlot("MFE Structure + Probabilities", "Minimum Free Energy structure drawing color-annotated with base-pairing probabilities.", () -> PredictWindowBase.launchDrawing(this.outFoldCt, FileType.CT, this.outPfs, FileType.PFS, 1));
            }
            if (PathTools.isFile(this.outMaxExpectCt)) {
                predictionResultsWindow.addPlot("MEA Structure + Probabilities", "Maximum Expected Accuracy structure drawing color-annotated with base-pairing probabilities.", () -> PredictWindowBase.launchDrawing(this.outMaxExpectCt, FileType.CT, this.outPfs, FileType.PFS, 1));
            }
            if (PathTools.isFile(this.outPkCt)) {
                predictionResultsWindow.addPlot("Pseudoknot Structure + Probabilities", "Structure drawing with possible pseudoknots color-annotated with base-pairing probabilities.", () -> PredictWindowBase.launchDrawing(this.outPkCt, FileType.CT, this.outPfs, FileType.PFS, 1));
            }
            if (PathTools.isFile(this.shapeFile)) {
                predictionResultsWindow.addPlotHeader("Predicted Structures color-annotated by SHAPE reactivity.", 3);
                if (PathTools.isFile(this.outFoldCt)) {
                    predictionResultsWindow.addPlot("MFE Structure + SHAPE", "Minimum Free Energy structure drawing color-annotated by SHAPE reactivity.", () -> PredictWindowBase.launchDrawing(this.outFoldCt, FileType.CT, this.shapeFile, FileType.SHAPE, 1));
                }
                if (PathTools.isFile(this.outMaxExpectCt)) {
                    predictionResultsWindow.addPlot("MEA Structure + SHAPE", "Maximum Expected Accuracy structure drawing color-annotated by SHAPE reactivity.", () -> PredictWindowBase.launchDrawing(this.outMaxExpectCt, FileType.CT, this.shapeFile, FileType.SHAPE, 1));
                }
                if (PathTools.isFile(this.outPkCt)) {
                    predictionResultsWindow.addPlot("Pseudoknot Structure + SHAPE", "Structure drawing with possible pseudoknots color-annotated by SHAPE reactivity.", () -> PredictWindowBase.launchDrawing(this.outPkCt, FileType.CT, this.shapeFile, FileType.SHAPE, 1));
                }
            }
            predictionResultsWindow.showWindow();
            return true;
        }
    }
}

