/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;
import ur_rna.RNAstructure.backend.RNA;
import ur_rna.RNAstructure.backend.RNABackend;
import ur_rna.RNAstructureUI.RNAstructureBackendCalculator;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.utilities.FileType;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.RNAstructureUI.windows.PredictWindowBase;
import ur_rna.RNAstructureUI.windows.PredictionResultsWindow;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.swing.FormValidationException;
import ur_rna.Utilities.swing.SimpleDocumentListener;

public class PredictMultiStructureWindow
extends PredictWindowBase {
    private static final long serialVersionUID = 20160122L;
    private JPanel contentPanel;
    private JTabbedPane tabControls;
    private JSpinner spnTemperature;
    private JButton btnStartCalc;
    private JTextField txtOutputFile;
    private JButton btnResetOptions;
    private JLabel lblOptionWarning;
    private JButton btnCancelTask;
    private JProgressBar prgTaskProgress;
    private JLabel lblTaskStatus;
    private JPanel pnlTaskStatus;
    private JCheckBox chkShowDescription;
    private JLabel lblToolDescription;
    private JComboBox cmbTurboMode;
    private JPanel pnlOutput;
    private JPanel pnlSequences;
    private JPanel pnlOptions;
    private JPanel pnlTurboOptions;
    private JButton btnResetAll;
    private JButton btnResetTurboOptions;
    private JList<SequenceItem> lstSeqs;
    private JSpinner spnTurboGamma;
    private JSpinner spnTurboIterations;
    private JSpinner spnTurboMaxEnergyDiff;
    private JSpinner spnTurboWindowSize;
    private JSpinner spnTurboMEAGamma;
    private JSpinner spnTurboThreshold;
    private JSpinner spnTurboMinHelix;
    private JSpinner spnTurboPKIterations;
    private JSpinner spnMultiIterations;
    private JSpinner spnMultiDsvChange;
    private JSpinner spnMultiGapPenalty;
    private JSpinner spnMultiAlnSize;
    private JSpinner spnMultiWindowSize;
    private JSpinner spnMultiMaxStructures;
    private JSpinner spnMultiMaxEnergyDiff;
    private JCheckBox chkAllowBaseInserts;
    private JPanel pnlMultiOptions;
    private JButton btnMoveUp;
    private JButton btnMoveDn;
    private JButton btnRemove;
    private JButton btnClearList;
    private JSpinner spnTurboMaxStructures;
    private JLabel lblBaseInserts;
    private JButton btnResetMultiOptions;
    private JPanel pnlSeqInfo;
    private JSpinner spnMultiMaxPairs;
    private JLabel lblProgressPercent;
    private JTextField txtSeqFile = new JTextField();
    private JTextField txtMSeqFile = new JTextField();
    private HashMap<JComponent, Object> defaultOptionValues = new HashMap();
    private ArrayList<JComponent> optionsControls = new ArrayList();
    private ArrayList<JComponent> settingsControls = new ArrayList();
    private final String settingsNodeName = "PredictMulti";
    private boolean _seqInfoUpdating;
    private ArrayList<SequenceItem> seqList = new ArrayList();

    public PredictMultiStructureWindow() {
        this.$$$setupUI$$$();
        this.autoSetFieldNames();
        this.setCaption("Predict a Structure Common to Multiple Sequences");
        this.lblBaseInserts.setLabelFor(this.chkAllowBaseInserts);
        this.listenForActions(this.contentPanel, JButton.class, this);
        this.addFileField("seq", this.txtSeqFile, FileFilters.Sequence, false, "add-seq");
        this.addFileField("mseq", this.txtMSeqFile, FileFilters.MultiSequence, false, "add-mseq");
        this.addFileField("out", this.txtOutputFile, FileFilters.CT, true, "set-output");
        this.pnlTaskStatus.setVisible(false);
        this.setContent(this.contentPanel);
        this.setPreferredSize(new Dimension(700, 600));
        this.lstSeqs.addListSelectionListener(this::onSequenceSelected);
        SimpleDocumentListener.listen(this.txtOutputFile, documentEvent -> this.updateSequenceInfoFromUI());
        this.addOptionControls(this.pnlMultiOptions);
        this.addOptionControls(this.pnlOptions);
        this.addOptionControls(this.pnlTurboOptions);
        this.settingsControls.addAll(this.optionsControls);
        this.settingsControls.addAll(Arrays.asList(this.chkShowDescription));
        this.loadSettingsDefaults();
        for (JComponent jComponent : this.optionsControls) {
            this.defaultOptionValues.put(jComponent, this.getControlValue(jComponent));
        }
        this.handleSettings(false);
        this.btnResetOptions.setEnabled(false);
        this.btnResetTurboOptions.setEnabled(false);
        this.btnResetMultiOptions.setEnabled(false);
        this.lblOptionWarning.setVisible(false);
        this.btnResetAll.setVisible(false);
        this.updateFormUI();
        this.startUiTimer();
    }

    private void onSequenceSelected(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.loadSequenceInfo(this.lstSeqs.getSelectedValue());
        }
    }

    private void loadSequenceInfo(SequenceItem sequenceItem) {
        try {
            this._seqInfoUpdating = true;
            if (sequenceItem == null) {
                this.txtOutputFile.setText("");
            } else {
                this.txtOutputFile.setText(sequenceItem.outCtFile);
            }
            this.pnlSeqInfo.setEnabled(sequenceItem != null);
        }
        finally {
            this._seqInfoUpdating = false;
        }
    }

    private void updateSequenceInfoFromUI() {
        if (this._seqInfoUpdating) {
            return;
        }
        SequenceItem sequenceItem = this.getSelectedSequence();
        if (sequenceItem == null) {
            return;
        }
        sequenceItem.outCtFile = this.txtOutputFile.getText();
    }

    void addOptionControls(JComponent jComponent) {
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            if (component instanceof JCheckBox || component instanceof JTextComponent || component instanceof JSpinner || component instanceof JComboBox || component instanceof JRadioButton) {
                this.optionsControls.add((JComponent)component);
            }
            if (((JComponent)component).getComponentCount() == 0) continue;
            this.addOptionControls((JComponent)component);
        }
    }

    @Override
    public void showWindow() {
        super.showWindow();
        SwingUtilities.invokeLater(this::pack);
    }

    private void createUIComponents() {
        this.lstSeqs = new JList();
    }

    private void loadSettingsDefaults() {
        this.setSpin(this.spnTemperature, 310.15, 0.0, 600.0);
        this.setSpin(this.spnMultiIterations, 2, 1, 100);
        this.setSpin(this.spnMultiDsvChange, 1, 1, 1000);
        this.setSpin(this.spnMultiMaxEnergyDiff, 20, 1, 200);
        this.setSpin(this.spnMultiMaxStructures, 20, 1, 200);
        this.setSpin(this.spnMultiMaxPairs, -1);
        this.setSpin(this.spnMultiWindowSize, 3, 1, 200);
        this.setSpin(this.spnMultiAlnSize, 1, 1, 200);
        this.setSpin(this.spnMultiGapPenalty, 0.4, 0.0, 100.0);
        this.setSpin(this.spnTurboGamma, 0.3, 0.0, 100.0);
        this.setSpin(this.spnTurboMaxEnergyDiff, 50, 1, 500);
        this.setSpin(this.spnTurboWindowSize, 5, 1, 500);
        this.setSpin(this.spnTurboMaxStructures, 1000, 1, 5000);
        this.setSpin(this.spnTurboMEAGamma, 1.0, 0.0, 100.0);
        this.setSpin(this.spnTurboIterations, 3, 1, 100);
        this.setSpin(this.spnTurboPKIterations, 1, 0, 100);
        this.setSpin(this.spnTurboMinHelix, 3, 2, 100);
        this.setSpin(this.spnTurboThreshold, 0.0, 0.0, 100.0);
        this.chkAllowBaseInserts.setSelected(true);
        this.cmbTurboMode.setSelectedIndex(0);
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        switch (commandInfo.getCommand()) {
            case "reset-options-all": {
                this.resetOptionsInPanel(this.contentPanel);
                break;
            }
            case "reset-options-turbo": {
                this.resetOptionsInPanel(this.pnlTurboOptions);
                break;
            }
            case "reset-options-multi": {
                this.resetOptionsInPanel(this.pnlMultiOptions);
                break;
            }
            case "reset-options-general": {
                this.resetOptionsInPanel(this.pnlOptions);
                break;
            }
            case "start": {
                if (!this.verifyInput()) break;
                this.runCalc();
                break;
            }
            case "cancel-task": {
                PredictWindowBase.BackgroundTask backgroundTask = this.getRunningTask();
                if (backgroundTask == null) break;
                backgroundTask.cancel();
                break;
            }
            case "add-seq": {
                this.addSequenceFile(this.txtSeqFile.getText().trim(), false);
                this.txtSeqFile.setText("");
                break;
            }
            case "add-mseq": {
                this.txtMSeqFile.setText("");
                break;
            }
            case "set-output": {
                break;
            }
            case "list-moveup": {
                this.moveSequence(this.getSelectedSequence(), -1);
                break;
            }
            case "list-movedn": {
                this.moveSequence(this.getSelectedSequence(), 1);
                break;
            }
            case "list-remove": {
                this.deleteSequence(this.getSelectedSequence());
                break;
            }
            case "list-clear": {
                this.seqList.clear();
                this.refreshSeqList();
                break;
            }
            default: {
                super.processCommand(commandInfo);
            }
        }
    }

    private void refreshSeqList(boolean bl) {
        if (bl) {
            this.refreshSeqList(this.getSelectedSequence());
        } else {
            this.refreshSeqList();
        }
    }

    private void refreshSeqList(SequenceItem sequenceItem) {
        this.refreshSeqList();
        this.setSelectedSequence(sequenceItem);
    }

    private void refreshSeqList() {
        this.lstSeqs.setListData((SequenceItem[])this.seqList.toArray(new SequenceItem[this.seqList.size()]));
    }

    private SequenceItem getSelectedSequence() {
        SequenceItem sequenceItem = this.lstSeqs.getSelectedValue();
        return sequenceItem instanceof SequenceItem ? sequenceItem : null;
    }

    private void setSelectedSequence(SequenceItem sequenceItem) {
        this.lstSeqs.setSelectedValue(sequenceItem, true);
    }

    private void deleteSequence(SequenceItem sequenceItem) {
        int n;
        int n2 = n = sequenceItem == null ? -1 : this.seqList.indexOf(sequenceItem);
        if (n == -1) {
            return;
        }
        this.seqList.remove(n);
        this.refreshSeqList();
        if (n < this.seqList.size()) {
            this.setSelectedSequence(this.seqList.get(n));
        } else if (this.seqList.size() != 0) {
            this.setSelectedSequence(this.seqList.get(this.seqList.size() - 1));
        }
    }

    private void moveSequence(SequenceItem sequenceItem, int n) {
        int n2;
        int n3 = n2 = sequenceItem == null ? -1 : this.seqList.indexOf(sequenceItem);
        if (n2 == -1) {
            return;
        }
        int n4 = n2 + n;
        if (n4 < 0 || n4 >= this.seqList.size()) {
            return;
        }
        this.seqList.set(n2, this.seqList.get(n4));
        this.seqList.set(n4, sequenceItem);
        this.refreshSeqList(sequenceItem);
    }

    private void addSequenceFile(String string, boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("Not yet implmented.");
        }
        RNA rNA = new RNA(string, RNABackend.FILE_SEQ, "rna", false, true);
        if (rNA.GetErrorCode() != 0) {
            Dialogs.showError(rNA.GetFullErrorMessage(), "Sequence File Error");
        } else {
            this.addSequence(rNA.GetStructure().GetSequenceLabel(), string, ModuleWindow.getOutputFile(string, "ct"));
        }
    }

    private void addSequence(String string, String string2, String string3) {
        SequenceItem sequenceItem = new SequenceItem(string, string2, string3);
        this.seqList.add(sequenceItem);
        this.refreshSeqList(sequenceItem);
    }

    private void resetOptionsInPanel(JComponent jComponent) {
        for (JComponent jComponent2 : this.optionsControls) {
            if (!jComponent.isAncestorOf(jComponent2)) continue;
            this.setControlValue(jComponent2, this.defaultOptionValues.get(jComponent2));
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setAutoscrolls(false);
        this.contentPanel.setName("contentPanel");
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 14));
        jLabel.setOpaque(false);
        jLabel.setText("Predict a Secondary Structure Common to Multiple Sequences");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.contentPanel.add((Component)jLabel, gridBagConstraints);
        this.tabControls = new JTabbedPane();
        this.tabControls.setName("tabbedPane1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.contentPanel.add((Component)this.tabControls, gridBagConstraints);
        this.pnlSequences = new JPanel();
        this.pnlSequences.setLayout(new GridBagLayout());
        this.tabControls.addTab("Sequences", this.pnlSequences);
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font(jLabel2.getFont().getName(), jLabel2.getFont().getStyle(), 14));
        jLabel2.setText("Load two or more sequences to align/fold.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlSequences.add((Component)jLabel2, gridBagConstraints);
        JButton jButton = new JButton();
        jButton.setActionCommand("recent-seq");
        jButton.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSequences.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton();
        jButton2.setActionCommand("browse-seq");
        jButton2.setText("Add Sequence File ...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSequences.add((Component)jButton2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(" Add a sequence from a SEQ, FASTA, or Text file.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlSequences.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(new Font(jLabel4.getFont().getName(), jLabel4.getFont().getStyle(), 14));
        jLabel4.setText("Loaded Sequences:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlSequences.add((Component)jLabel4, gridBagConstraints);
        this.btnMoveUp = new JButton();
        this.btnMoveUp.setActionCommand("list-moveup");
        this.btnMoveUp.setText("Move Up");
        this.btnMoveUp.setToolTipText("Move the sequence down in the list.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.pnlSequences.add((Component)this.btnMoveUp, gridBagConstraints);
        this.btnMoveDn = new JButton();
        this.btnMoveDn.setActionCommand("list-movedn");
        this.btnMoveDn.setText("Move Down");
        this.btnMoveDn.setToolTipText("Move the sequence up in the list.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.pnlSequences.add((Component)this.btnMoveDn, gridBagConstraints);
        this.btnRemove = new JButton();
        this.btnRemove.setActionCommand("list-remove");
        this.btnRemove.setText("Remove");
        this.btnRemove.setToolTipText("Remvoe the selected sequence from the list.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.pnlSequences.add((Component)this.btnRemove, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.pnlSequences.add((Component)jScrollPane, gridBagConstraints);
        this.lstSeqs.setSelectionMode(0);
        jScrollPane.setViewportView(this.lstSeqs);
        this.btnClearList = new JButton();
        this.btnClearList.setActionCommand("list-clear");
        this.btnClearList.setText("Clear");
        this.btnClearList.setToolTipText("Remove ALL sequences from the list (!)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.pnlSequences.add((Component)this.btnClearList, gridBagConstraints);
        this.pnlSeqInfo = new JPanel();
        this.pnlSeqInfo.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.pnlSequences.add((Component)this.pnlSeqInfo, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Output File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlSeqInfo.add((Component)jLabel5, gridBagConstraints);
        this.txtOutputFile = new JTextField();
        this.txtOutputFile.setName("txtOutputFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlSeqInfo.add((Component)this.txtOutputFile, gridBagConstraints);
        JButton jButton3 = new JButton();
        jButton3.setActionCommand("browse-out");
        jButton3.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSeqInfo.add((Component)jButton3, gridBagConstraints);
        JButton jButton4 = new JButton();
        jButton4.setActionCommand("recent-out");
        jButton4.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSeqInfo.add((Component)jButton4, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setFont(new Font(jLabel6.getFont().getName(), jLabel6.getFont().getStyle(), 14));
        jLabel6.setText("Options for the Selected Sequence:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlSequences.add((Component)jLabel6, gridBagConstraints);
        this.pnlOptions = new JPanel();
        this.pnlOptions.setLayout(new GridBagLayout());
        this.tabControls.addTab("General Options", this.pnlOptions);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Temperature");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pnlOptions.add((Component)jLabel7, gridBagConstraints);
        this.spnTemperature = new JSpinner();
        this.spnTemperature.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOptions.add((Component)this.spnTemperature, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlOptions.add((Component)jPanel, gridBagConstraints);
        this.btnResetOptions = new JButton();
        this.btnResetOptions.setActionCommand("reset-options-general");
        this.btnResetOptions.setText("Reset All to Defaults");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.pnlOptions.add((Component)this.btnResetOptions, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("K");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pnlOptions.add((Component)jLabel8, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.pnlOptions.add((Component)jPanel2, gridBagConstraints);
        this.pnlTurboOptions = new JPanel();
        this.pnlTurboOptions.setLayout(new GridBagLayout());
        this.tabControls.addTab("TurboFold Options", this.pnlTurboOptions);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("TurboFold Mode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pnlTurboOptions.add((Component)jLabel9, gridBagConstraints);
        this.cmbTurboMode = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Maximum Expected Accuracy");
        defaultComboBoxModel.addElement("Pseudoknots");
        defaultComboBoxModel.addElement("Threshold");
        this.cmbTurboMode.setModel(defaultComboBoxModel);
        this.cmbTurboMode.setName("cmbPartsMode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.pnlTurboOptions.add((Component)this.cmbTurboMode, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.pnlTurboOptions.add((Component)jPanel3, gridBagConstraints);
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("TurboFold Gamma");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.pnlTurboOptions.add((Component)jLabel10, gridBagConstraints);
        this.spnTurboGamma = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlTurboOptions.add((Component)this.spnTurboGamma, gridBagConstraints);
        this.btnResetTurboOptions = new JButton();
        this.btnResetTurboOptions.setActionCommand("reset-options-turbo");
        this.btnResetTurboOptions.setText("Reset All to Defaults");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.pnlTurboOptions.add((Component)this.btnResetTurboOptions, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.pnlTurboOptions.add((Component)jPanel4, gridBagConstraints);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options for Maximum Expected Accuracy Mode:", 0, 0, new Font(jPanel4.getFont().getName(), 1, jPanel4.getFont().getSize())));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Max % Energy Difference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 2);
        jPanel4.add((Component)jLabel11, gridBagConstraints);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Window Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 2);
        jPanel4.add((Component)jLabel12, gridBagConstraints);
        this.spnTurboMaxEnergyDiff = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.spnTurboMaxEnergyDiff, gridBagConstraints);
        this.spnTurboWindowSize = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.spnTurboWindowSize, gridBagConstraints);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Max Number of Structures");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 2);
        jPanel4.add((Component)jLabel13, gridBagConstraints);
        this.spnTurboMaxStructures = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.spnTurboMaxStructures, gridBagConstraints);
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("MEA-Gamma");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 2);
        jPanel4.add((Component)jLabel14, gridBagConstraints);
        this.spnTurboMEAGamma = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel4.add((Component)this.spnTurboMEAGamma, gridBagConstraints);
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("TurboFold Iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.pnlTurboOptions.add((Component)jLabel15, gridBagConstraints);
        this.spnTurboIterations = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlTurboOptions.add((Component)this.spnTurboIterations, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.pnlTurboOptions.add((Component)jPanel5, gridBagConstraints);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options for Pseudoknot Mode:", 0, 0, new Font(jPanel5.getFont().getName(), 1, jPanel5.getFont().getSize())));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("Pseudoknot Iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 2);
        jPanel5.add((Component)jLabel16, gridBagConstraints);
        this.spnTurboPKIterations = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel5.add((Component)this.spnTurboPKIterations, gridBagConstraints);
        JLabel jLabel17 = new JLabel();
        jLabel17.setText("Minimum Helix Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 2);
        jPanel5.add((Component)jLabel17, gridBagConstraints);
        this.spnTurboMinHelix = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel5.add((Component)this.spnTurboMinHelix, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.pnlTurboOptions.add((Component)jPanel6, gridBagConstraints);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options for Threshold Mode:", 0, 0, new Font(jPanel6.getFont().getName(), 1, jPanel6.getFont().getSize())));
        this.spnTurboThreshold = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel6.add((Component)this.spnTurboThreshold, gridBagConstraints);
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("Threshold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 2);
        jPanel6.add((Component)jLabel18, gridBagConstraints);
        this.pnlMultiOptions = new JPanel();
        this.pnlMultiOptions.setLayout(new GridBagLayout());
        this.tabControls.addTab("Multilign Options", this.pnlMultiOptions);
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("Multilign Iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel19, gridBagConstraints);
        this.spnMultiIterations = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlMultiOptions.add((Component)this.spnMultiIterations, gridBagConstraints);
        JLabel jLabel20 = new JLabel();
        jLabel20.setText("Maximum DSV Change");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel20, gridBagConstraints);
        this.spnMultiDsvChange = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlMultiOptions.add((Component)this.spnMultiDsvChange, gridBagConstraints);
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("Maximum % Energy Difference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel21, gridBagConstraints);
        JLabel jLabel22 = new JLabel();
        jLabel22.setText("Maximum Number of Structures");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel22, gridBagConstraints);
        JLabel jLabel23 = new JLabel();
        jLabel23.setText("Structure Window Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel23, gridBagConstraints);
        JLabel jLabel24 = new JLabel();
        jLabel24.setText("Alignment Window Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel24, gridBagConstraints);
        JLabel jLabel25 = new JLabel();
        jLabel25.setText("Gap Penalty");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel25, gridBagConstraints);
        this.lblBaseInserts = new JLabel();
        this.lblBaseInserts.setText(" Allow Single Base Pair Inserts");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)this.lblBaseInserts, gridBagConstraints);
        this.spnMultiMaxEnergyDiff = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlMultiOptions.add((Component)this.spnMultiMaxEnergyDiff, gridBagConstraints);
        this.spnMultiMaxStructures = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlMultiOptions.add((Component)this.spnMultiMaxStructures, gridBagConstraints);
        this.spnMultiWindowSize = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlMultiOptions.add((Component)this.spnMultiWindowSize, gridBagConstraints);
        this.spnMultiAlnSize = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlMultiOptions.add((Component)this.spnMultiAlnSize, gridBagConstraints);
        this.spnMultiGapPenalty = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlMultiOptions.add((Component)this.spnMultiGapPenalty, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 3;
        this.pnlMultiOptions.add((Component)jPanel7, gridBagConstraints);
        this.chkAllowBaseInserts = new JCheckBox();
        this.chkAllowBaseInserts.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.pnlMultiOptions.add((Component)this.chkAllowBaseInserts, gridBagConstraints);
        JLabel jLabel26 = new JLabel();
        jLabel26.setText("Maximum Pairs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel26, gridBagConstraints);
        this.spnMultiMaxPairs = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlMultiOptions.add((Component)this.spnMultiMaxPairs, gridBagConstraints);
        this.btnResetMultiOptions = new JButton();
        this.btnResetMultiOptions.setActionCommand("reset-options-multi");
        this.btnResetMultiOptions.setText("Reset All to Defaults");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.pnlMultiOptions.add((Component)this.btnResetMultiOptions, gridBagConstraints);
        JLabel jLabel27 = new JLabel();
        jLabel27.setText("(-1 means use the default calculated value)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 2);
        this.pnlMultiOptions.add((Component)jLabel27, gridBagConstraints);
        this.pnlOutput = new JPanel();
        this.pnlOutput.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)this.pnlOutput, gridBagConstraints);
        this.lblOptionWarning = new JLabel();
        this.lblOptionWarning.setBackground(new Color(-2171392));
        this.lblOptionWarning.setForeground(new Color(-16777216));
        this.lblOptionWarning.setHorizontalAlignment(0);
        this.lblOptionWarning.setHorizontalTextPosition(0);
        this.lblOptionWarning.setOpaque(true);
        this.lblOptionWarning.setText("<html><center>Warning: Some options have been set to non-default values.<br>---List---");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlOutput.add((Component)this.lblOptionWarning, gridBagConstraints);
        this.btnStartCalc = new JButton();
        this.btnStartCalc.setActionCommand("start");
        this.btnStartCalc.setHorizontalTextPosition(0);
        this.btnStartCalc.setMinimumSize(new Dimension(54, 40));
        this.btnStartCalc.setName("btnStartCalc");
        this.btnStartCalc.setOpaque(false);
        this.btnStartCalc.setPreferredSize(new Dimension(54, 40));
        this.btnStartCalc.setText("Start");
        this.btnStartCalc.setMnemonic('S');
        this.btnStartCalc.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlOutput.add((Component)this.btnStartCalc, gridBagConstraints);
        this.btnResetAll = new JButton();
        this.btnResetAll.setActionCommand("reset-options-all");
        this.btnResetAll.setText("Reset All Options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.pnlOutput.add((Component)this.btnResetAll, gridBagConstraints);
        this.pnlTaskStatus = new JPanel();
        this.pnlTaskStatus.setLayout(new GridBagLayout());
        this.pnlTaskStatus.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)this.pnlTaskStatus, gridBagConstraints);
        this.btnCancelTask = new JButton();
        this.btnCancelTask.setActionCommand("cancel-task");
        this.btnCancelTask.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.pnlTaskStatus.add((Component)this.btnCancelTask, gridBagConstraints);
        this.prgTaskProgress = new JProgressBar();
        this.prgTaskProgress.setMinimumSize(new Dimension(10, 40));
        this.prgTaskProgress.setPreferredSize(new Dimension(146, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlTaskStatus.add((Component)this.prgTaskProgress, gridBagConstraints);
        this.lblTaskStatus = new JLabel();
        this.lblTaskStatus.setText("Status of background Task");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.pnlTaskStatus.add((Component)this.lblTaskStatus, gridBagConstraints);
        this.lblProgressPercent = new JLabel();
        this.lblProgressPercent.setHorizontalAlignment(0);
        this.lblProgressPercent.setPreferredSize(new Dimension(40, 16));
        this.lblProgressPercent.setText("0%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.pnlTaskStatus.add((Component)this.lblProgressPercent, gridBagConstraints);
        this.chkShowDescription = new JCheckBox();
        this.chkShowDescription.setActionCommand("");
        this.chkShowDescription.setSelected(true);
        this.chkShowDescription.setText("Show Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.contentPanel.add((Component)this.chkShowDescription, gridBagConstraints);
        this.lblToolDescription = new JLabel();
        this.lblToolDescription.setName("lblToolDescription");
        this.lblToolDescription.setText("<html>This tool takes two or more sequences and folds them into their common lowest free energy conformations. It combines the capabilities of <b>Multilign</b> and <b>TurboFold</b> to create distinct sets of possible structures for multiple sequences.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.contentPanel.add((Component)this.lblToolDescription, gridBagConstraints);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setMinimumSize(new Dimension(1, 3));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)jSeparator, gridBagConstraints);
        jLabel5.setLabelFor(this.txtOutputFile);
        jLabel7.setLabelFor(this.spnTemperature);
        jLabel9.setLabelFor(this.cmbTurboMode);
        jLabel10.setLabelFor(this.spnTurboGamma);
        jLabel11.setLabelFor(this.spnTurboMaxEnergyDiff);
        jLabel12.setLabelFor(this.spnTurboWindowSize);
        jLabel13.setLabelFor(this.spnTurboMaxStructures);
        jLabel14.setLabelFor(this.spnTurboMEAGamma);
        jLabel15.setLabelFor(this.spnTurboIterations);
        jLabel16.setLabelFor(this.spnTurboPKIterations);
        jLabel17.setLabelFor(this.spnTurboMinHelix);
        jLabel18.setLabelFor(this.spnTurboThreshold);
        jLabel19.setLabelFor(this.spnMultiIterations);
        jLabel20.setLabelFor(this.spnMultiDsvChange);
        jLabel21.setLabelFor(this.spnMultiMaxEnergyDiff);
        jLabel22.setLabelFor(this.spnMultiMaxStructures);
        jLabel23.setLabelFor(this.spnMultiWindowSize);
        jLabel24.setLabelFor(this.spnMultiAlnSize);
        jLabel25.setLabelFor(this.spnMultiGapPenalty);
        jLabel26.setLabelFor(this.spnMultiMaxPairs);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }

    @Override
    protected void updateFormUI() {
        int n;
        Object object;
        PredictTask predictTask = (PredictTask)this.getRunningTask();
        if (predictTask != null) {
            this.setTaskStatus(predictTask.getProgress(), predictTask.getStatus());
            this.btnCancelTask.setEnabled(predictTask.canCancel);
            return;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = this.optionsControls.iterator();
        while (object2.hasNext()) {
            JComponent jComponent = object2.next();
            object = this.getControlValue(jComponent);
            if (Objects.equals(object, this.defaultOptionValues.get(jComponent))) continue;
            stringBuilder.append(this.getControlDescription(jComponent)).append(": ").append(this.formatValue(object)).append("    ");
            bl = true;
        }
        if (bl && !((String)(object = ((String)(object2 = this.lblOptionWarning.getText())).substring(0, (n = ((String)object2).indexOf("<br>")) + 4) + stringBuilder)).equals(object2)) {
            this.lblOptionWarning.setText((String)object);
        }
        this.lblOptionWarning.setVisible(bl);
        this.btnResetAll.setVisible(bl);
        this.btnResetOptions.setEnabled(bl);
        this.btnResetTurboOptions.setEnabled(bl);
        this.btnResetMultiOptions.setEnabled(bl);
        if (this.lblToolDescription.isVisible() != this.chkShowDescription.isSelected()) {
            this.lblToolDescription.setVisible(this.chkShowDescription.isSelected());
            if (this.isVisible()) {
                this.pack();
            }
        }
    }

    private void runCalc() {
        this.handleSettings(true);
        this.btnStartCalc.setVisible(false);
        this.pnlTaskStatus.setVisible(true);
        this.enableDescendants(this.tabControls, false, new Component[0]);
        this.enableDescendants(this.pnlOutput, false, new Component[0]);
        this.setTaskStatus(0, "Starting calculation...");
        PredictTask predictTask = new PredictTask();
        predictTask.turboMode = this.cmbTurboMode.getSelectedIndex();
        predictTask.multiIterations = this.getSpinInt(this.spnMultiIterations);
        predictTask.multiDsvChange = this.getSpinInt(this.spnMultiDsvChange);
        predictTask.multiMaxEnergyDiff = this.getSpinInt(this.spnMultiMaxEnergyDiff);
        predictTask.multiMaxStructures = this.getSpinInt(this.spnMultiMaxStructures);
        predictTask.multiMaxPairs = this.getSpinInt(this.spnMultiMaxPairs);
        predictTask.multiWindowSize = this.getSpinInt(this.spnMultiWindowSize);
        predictTask.multiAlnSize = this.getSpinInt(this.spnMultiAlnSize);
        predictTask.multiGapPenalty = this.getSpinDbl(this.spnMultiGapPenalty);
        predictTask.allowBaseInserts = this.chkAllowBaseInserts.isSelected();
        predictTask.temperature = this.getSpinDbl(this.spnTemperature);
        predictTask.turboGamma = this.getSpinDbl(this.spnTurboGamma);
        predictTask.turboMaxEnergyDiff = this.getSpinInt(this.spnTurboMaxEnergyDiff);
        predictTask.turboWindowSize = this.getSpinInt(this.spnTurboWindowSize);
        predictTask.turboMaxStructures = this.getSpinInt(this.spnTurboMaxStructures);
        predictTask.turboMEAGamma = this.getSpinDbl(this.spnTurboMEAGamma);
        predictTask.turboIterations = this.getSpinInt(this.spnTurboIterations);
        predictTask.turboPKIterations = this.getSpinInt(this.spnTurboPKIterations);
        predictTask.turboMinHelix = this.getSpinInt(this.spnTurboMinHelix);
        predictTask.turboThreshold = this.getSpinDbl(this.spnTurboThreshold);
        this.runInBackground(predictTask, this::calcComplete);
    }

    private void calcComplete(PredictTask predictTask) {
        this.btnStartCalc.setVisible(true);
        this.pnlTaskStatus.setVisible(false);
        this.enableDescendants(this.tabControls, true, new Component[0]);
        this.enableDescendants(this.pnlOutput, true, new Component[0]);
        if (predictTask.isCanceled) {
            return;
        }
        if (predictTask.onComplete()) {
            this.dispose();
        }
    }

    private void setTaskStatus(int n, String string) {
        int n2;
        this.lblTaskStatus.setText(string);
        this.prgTaskProgress.setIndeterminate(n < 0);
        this.lblProgressPercent.setVisible(n >= 0);
        int n3 = n2 = n > 100 ? 100 : n;
        if (n >= 0) {
            this.lblProgressPercent.setText(n2 + "%");
            this.prgTaskProgress.setValue(n2);
        }
    }

    private boolean verifyInput() {
        try {
            if (this.seqList.size() < 2) {
                this.validateFailed(this.lstSeqs, "At least two sequences are required.", new Object[0]);
            }
            int n = 0;
            for (SequenceItem sequenceItem : this.seqList) {
                ++n;
                if (PathTools.isFile(sequenceItem.inSeqFile)) continue;
                this.setSelectedSequence(sequenceItem);
                this.validateFailed(this.lstSeqs, "Sequence file %s does not exist.", n);
            }
        }
        catch (FormValidationException formValidationException) {
            Dialogs.showError(formValidationException.getMessage(), "Error in User Input");
            this.focusField(formValidationException.getControl());
            return false;
        }
        return true;
    }

    @Override
    protected void handleSettings(boolean bl) {
        this.handleRecentControlValues(bl, "PredictMulti", this.settingsControls);
    }

    private class PredictTask
    extends PredictWindowBase.PredictTaskBase {
        RNAstructureBackendCalculator bc;
        int turboMode;
        int multiIterations;
        int multiDsvChange;
        int multiMaxPairs;
        int multiMaxEnergyDiff;
        int multiMaxStructures;
        int multiWindowSize;
        int multiAlnSize;
        double multiGapPenalty;
        boolean allowBaseInserts;
        double temperature;
        double turboGamma;
        int turboMaxEnergyDiff;
        int turboWindowSize;
        int turboMaxStructures;
        double turboMEAGamma;
        int turboIterations;
        int turboPKIterations;
        int turboMinHelix;
        double turboThreshold;
        String[] turboCTs;
        String[] turboPFSs;
        String[] multiCTs;
        String[] multiPFSs;
        String turboAln;
        String multiAln;

        private PredictTask() {
        }

        @Override
        public int getProgress() {
            if (this.bc == null) {
                return this.workDone;
            }
            return this.workDone + this.bc.getProgressNumber() * this.nextStepWork / 100;
        }

        @Override
        protected void runCalc() {
            int n;
            String string;
            int n2 = PredictMultiStructureWindow.this.seqList.size();
            this.turboCTs = new String[n2];
            this.turboPFSs = new String[n2];
            this.multiCTs = new String[n2];
            this.multiPFSs = new String[n2];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(PathTools.getDir(PredictMultiStructureWindow.this.seqList.get((int)0).outCtFile, true));
            this.bc = new RNAstructureBackendCalculator();
            this.bc.activateTurboFold();
            for (int i = 0; i < n2; ++i) {
                SequenceItem sequenceItem = PredictMultiStructureWindow.this.seqList.get(i);
                String string2 = PathTools.changeExtension(sequenceItem.outCtFile, null);
                this.turboCTs[i] = string2 + "_Turbo.ct";
                this.turboPFSs[i] = string2 + "_Turbo.pfs";
                this.multiCTs[i] = sequenceItem.outCtFile;
                this.bc.addTurboFoldTuple(sequenceItem.inSeqFile, this.turboCTs[i], this.turboPFSs[i]);
                stringBuilder.append(PathTools.getBaseName(sequenceItem.outCtFile)).append("_");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            this.turboAln = stringBuilder + "_Turbo.aln";
            this.multiAln = stringBuilder + ".aln";
            this.nextStep("Running TurboFold...", false, 25);
            switch (this.turboMode) {
                case 0: {
                    string = this.bc.runTurboFoldMaximumExpectedAccuracy(this.turboGamma, this.turboIterations, this.turboMaxEnergyDiff, this.turboMaxStructures, this.turboWindowSize, this.turboMEAGamma, this.turboAln);
                    break;
                }
                case 1: {
                    string = this.bc.runTurboFoldPseudoknot(this.turboGamma, this.turboIterations, this.turboPKIterations, this.turboMinHelix, this.turboAln);
                    break;
                }
                default: {
                    string = this.bc.runTurboFoldThreshold(this.turboGamma, this.turboIterations, this.turboThreshold, this.turboAln);
                }
            }
            if (!Strings.isEmpty(string)) {
                this.setError(string);
                return;
            }
            this.bc = new RNAstructureBackendCalculator();
            this.nextStep("Running Multilign...", false, 75);
            this.bc.activateMultilign();
            for (n = 0; n < n2; ++n) {
                this.bc.addMultilignTuple(PredictMultiStructureWindow.this.seqList.get((int)n).inSeqFile, this.multiCTs[n]);
            }
            n = this.multiMaxPairs == -1 ? this.bc.getMultilignMaxPairs() : this.multiMaxPairs;
            string = this.bc.runMultilign(this.multiMaxEnergyDiff, this.multiMaxStructures, this.multiWindowSize, this.multiAlnSize, this.multiGapPenalty, this.allowBaseInserts, this.multiDsvChange, n, this.multiIterations, this.multiAln, false, true);
            if (!Strings.isEmpty(string)) {
                this.setError(string);
            }
        }

        @Override
        protected boolean showResults() {
            String string;
            int n;
            PredictionResultsWindow predictionResultsWindow = new PredictionResultsWindow("Results of Multiple Structure Prediction");
            int n2 = PredictMultiStructureWindow.this.seqList.size();
            for (n = 0; n < n2; ++n) {
                if (!PathTools.isFile(this.turboCTs[n])) continue;
                predictionResultsWindow.addFile(this.turboCTs[n], "TurboFold Structures from Sequence " + (n + 1));
            }
            for (n = 0; n < n2; ++n) {
                if (!PathTools.isFile(this.multiCTs[n])) continue;
                predictionResultsWindow.addFile(this.multiCTs[n], "Multilign Structures from Sequence " + (n + 1));
            }
            for (n = 0; n < n2; ++n) {
                if (!PathTools.isFile(this.turboPFSs[n])) continue;
                predictionResultsWindow.addFile(this.turboPFSs[n], "TurboFold Partition File (PFS) from Sequence " + (n + 1));
            }
            if (PathTools.isFile(this.turboAln)) {
                predictionResultsWindow.addFile(this.turboAln, "TurboFold Alignment File");
            }
            if (PathTools.isFile(this.multiAln)) {
                predictionResultsWindow.addFile(this.multiAln, "Multilign Alignment File");
            }
            predictionResultsWindow.addPlotHeader("TurboFold Structures (without color annotations)", n2);
            for (n = 0; n < n2; ++n) {
                string = this.turboCTs[n];
                if (!PathTools.isFile(string)) continue;
                predictionResultsWindow.addPlot("Sequence " + (n + 1), "Aligned structures from Sequence " + (n + 1), () -> PredictWindowBase.launchDrawing(string, FileType.CT, null, null, 1));
            }
            predictionResultsWindow.addPlotHeader("TurboFold Structures, Color-Annotated by Base-Pairing Probability", n2);
            for (n = 0; n < n2; ++n) {
                string = this.turboCTs[n];
                String string2 = this.turboPFSs[n];
                if (!PathTools.isFile(string) || !PathTools.isFile(string2)) continue;
                predictionResultsWindow.addPlot("Sequence " + (n + 1), "Aligned structures from Sequence " + (n + 1), () -> PredictWindowBase.launchDrawing(string, FileType.CT, string2, FileType.PFS, 1));
            }
            predictionResultsWindow.addPlotHeader("Multilign Structures (without color annotations)", n2);
            for (n = 0; n < n2; ++n) {
                string = this.multiCTs[n];
                if (!PathTools.isFile(string)) continue;
                predictionResultsWindow.addPlot("Sequence " + (n + 1), "Aligned structures from Sequence " + (n + 1), () -> PredictWindowBase.launchDrawing(string, FileType.CT, null, null, 1));
            }
            predictionResultsWindow.showAbbreviations(false);
            predictionResultsWindow.showWindow();
            return true;
        }
    }

    private class SequenceItem {
        public String label;
        public String inSeqFile;
        public String outCtFile;

        public String toString() {
            return this.label + " (" + this.inSeqFile + ")";
        }

        public SequenceItem(String string, String string2, String string3) {
            this.label = string;
            this.inSeqFile = string2;
            this.outCtFile = string3;
        }
    }
}

