/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import ur_rna.RNAstructure.backend.HybridRNA;
import ur_rna.RNAstructure.backend.RNABackend;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.utilities.FileType;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.RNAstructureUI.windows.PredictWindowBase;
import ur_rna.RNAstructureUI.windows.PredictionResultsWindow;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.swing.FormValidationException;

public class PredictBimolStructureWindow
extends PredictWindowBase {
    private static final long serialVersionUID = 20160122L;
    private JPanel contentPanel;
    private JTextField txtSeqFile1;
    private JTabbedPane tabControls;
    private JSpinner spnMaxEnergyDiff;
    private JSpinner spnWindowSize;
    private JSpinner spnMaxStructs;
    private JTextField txtConFile1;
    private JButton btnStartCalc;
    private JTextField txtOutputFile1;
    private JTextField txtOutputFile2;
    private JButton btnResetOptions;
    private JLabel lblOptionWarning;
    private JButton btnCancelTask;
    private JProgressBar prgTaskProgress;
    private JLabel lblTaskStatus;
    private JPanel pnlTaskStatus;
    private JCheckBox chkShowDescription;
    private JLabel lblToolDescription;
    private JTextField txtSeqFile2;
    private JTextField txtConFile2;
    private JPanel pnlOutput;
    private JPanel pnlSequences;
    private JPanel pnlOptions;
    private JPanel pnlConstraints;
    private JButton btnResetAll;
    private JLabel lblProgressPercent;
    private JRadioButton optRNA;
    private JRadioButton optDNA;
    private JSpinner spnMaxLoopSize;
    private JSpinner spnTemperature;
    private HashMap<JComponent, Object> defaultOptionValues = new HashMap();
    private ArrayList<JComponent> optionsControls = new ArrayList();
    private ArrayList<JComponent> settingsControls = new ArrayList();
    private final String settingsNodeName = "PredictBimol";
    private String lastSeqFile1 = "";
    private String lastOutFile1 = "";
    private String lastSeqFile2 = "";
    private String lastOutFile2 = "";

    public PredictBimolStructureWindow() {
        this.$$$setupUI$$$();
        this.autoSetFieldNames();
        this.setCaption("Predict a Bimolecular Structure");
        this.listenForActions(this.contentPanel, JButton.class, this);
        this.addFileField("seq1", this.txtSeqFile1, FileFilters.Sequence, false);
        this.addFileField("seq2", this.txtSeqFile2, FileFilters.Sequence, false);
        this.addFileField("con1", this.txtConFile1, FileFilters.Constraints, false);
        this.addFileField("con2", this.txtConFile2, FileFilters.Constraints, false);
        this.addFileField("out1", this.txtOutputFile1, FileFilters.CT, true);
        this.addFileField("out2", this.txtOutputFile2, FileFilters.CT, true);
        this.pnlTaskStatus.setVisible(false);
        this.setContent(this.contentPanel);
        this.setPreferredSize(new Dimension(700, 600));
        this.addOptionControls(this.pnlOptions);
        this.settingsControls.addAll(this.optionsControls);
        this.settingsControls.addAll(Arrays.asList(this.optRNA, this.chkShowDescription));
        this.loadSettingsDefaults();
        for (JComponent jComponent : this.optionsControls) {
            this.defaultOptionValues.put(jComponent, this.getControlValue(jComponent));
        }
        this.handleSettings(false);
        this.btnResetOptions.setEnabled(false);
        this.lblOptionWarning.setVisible(false);
        this.btnResetAll.setVisible(false);
        this.updateFormUI();
        this.startUiTimer();
    }

    void addOptionControls(JComponent jComponent) {
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            if (component instanceof JCheckBox || component instanceof JTextComponent || component instanceof JSpinner || component instanceof JComboBox || component instanceof JRadioButton) {
                this.optionsControls.add((JComponent)component);
            }
            if (((JComponent)component).getComponentCount() == 0) continue;
            this.addOptionControls((JComponent)component);
        }
    }

    @Override
    public void showWindow() {
        super.showWindow();
        SwingUtilities.invokeLater(this::pack);
    }

    private void createUIComponents() {
    }

    private void loadSettingsDefaults() {
        this.setSpin(this.spnMaxEnergyDiff, 5, 1, 200);
        this.setSpin(this.spnMaxStructs, 20, 1, 1000);
        this.setSpin(this.spnWindowSize, 0, 0, 100);
        this.setSpin(this.spnMaxLoopSize, 30, 3, 200);
        this.setSpin(this.spnTemperature, 310.15, 0.0, 600.0);
        this.optRNA.setSelected(true);
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        switch (commandInfo.getCommand()) {
            case "reset-options-all": {
                for (JComponent jComponent : this.optionsControls) {
                    this.setControlValue(jComponent, this.defaultOptionValues.get(jComponent));
                }
                break;
            }
            case "reset-options-general": {
                for (JComponent jComponent : this.optionsControls) {
                    if (!this.pnlOptions.isAncestorOf(jComponent)) continue;
                    this.setControlValue(jComponent, this.defaultOptionValues.get(jComponent));
                }
                break;
            }
            case "start": {
                if (!this.verifyInput()) break;
                this.runCalc();
                break;
            }
            case "cancel-task": {
                PredictWindowBase.BackgroundTask backgroundTask = this.getRunningTask();
                if (backgroundTask == null) break;
                backgroundTask.cancel();
                break;
            }
            default: {
                super.processCommand(commandInfo);
            }
        }
    }

    @Override
    protected void updateFormUI() {
        int n;
        Object object;
        PredictTask predictTask = (PredictTask)this.getRunningTask();
        if (predictTask != null) {
            this.setTaskStatus(predictTask.getProgress(), predictTask.getStatus());
            this.btnCancelTask.setEnabled(predictTask.canCancel);
            return;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = this.optionsControls.iterator();
        while (object2.hasNext()) {
            JComponent jComponent = object2.next();
            object = this.getControlValue(jComponent);
            if (Objects.equals(object, this.defaultOptionValues.get(jComponent))) continue;
            stringBuilder.append(this.getControlDescription(jComponent)).append(": ").append(this.formatValue(object)).append("    ");
            bl = true;
        }
        if (bl && !((String)(object = ((String)(object2 = this.lblOptionWarning.getText())).substring(0, (n = ((String)object2).indexOf("<br>")) + 4) + stringBuilder)).equals(object2)) {
            this.lblOptionWarning.setText((String)object);
        }
        this.lblOptionWarning.setVisible(bl);
        this.btnResetAll.setVisible(bl);
        this.btnResetOptions.setEnabled(bl);
        this.btnResetOptions.setEnabled(bl);
        if (!this.lastSeqFile1.equals(this.txtSeqFile1.getText())) {
            this.lastSeqFile1 = this.txtSeqFile1.getText();
            if (this.txtOutputFile1.getText().isEmpty() || this.lastOutFile1.equals(this.txtOutputFile1.getText())) {
                this.lastOutFile1 = ModuleWindow.getOutputFile(this.txtSeqFile1.getText(), "ct");
                this.txtOutputFile1.setText(this.lastOutFile1);
            }
        }
        if (!this.lastSeqFile2.equals(this.txtSeqFile2.getText())) {
            this.lastSeqFile2 = this.txtSeqFile2.getText();
            if (this.txtOutputFile2.getText().isEmpty() || this.lastOutFile2.equals(this.txtOutputFile2.getText())) {
                this.lastOutFile2 = ModuleWindow.getOutputFile(this.txtSeqFile2.getText(), "ct");
                this.txtOutputFile2.setText(this.lastOutFile2);
            }
        }
        if (this.lblToolDescription.isVisible() != this.chkShowDescription.isSelected()) {
            this.lblToolDescription.setVisible(this.chkShowDescription.isSelected());
            if (this.isVisible()) {
                this.pack();
            }
        }
    }

    private void runCalc() {
        this.saveRecentFiles(this.txtConFile1, this.txtConFile2, this.txtSeqFile1, this.txtSeqFile2, this.txtOutputFile1, this.txtOutputFile2);
        this.handleSettings(true);
        this.btnStartCalc.setVisible(false);
        this.pnlTaskStatus.setVisible(true);
        this.enableDescendants(this.tabControls, false, new Component[0]);
        this.enableDescendants(this.pnlOutput, false, new Component[0]);
        this.setTaskStatus(0, "Starting calculation...");
        PredictTask predictTask = new PredictTask();
        predictTask.sequence1 = this.txtSeqFile1.getText();
        predictTask.sequence2 = this.txtSeqFile1.getText();
        predictTask.seqType1 = RNABackend.FILE_SEQ;
        predictTask.seqType2 = RNABackend.FILE_SEQ;
        predictTask.isRNA = !this.optDNA.isSelected();
        predictTask.outBase1 = PathTools.changeExtension(this.txtOutputFile1.getText().trim(), "");
        predictTask.outBase2 = PathTools.changeExtension(this.txtOutputFile2.getText().trim(), "");
        predictTask.maxEnergyDiff = this.getSpinInt(this.spnMaxEnergyDiff);
        predictTask.maxStructures = this.getSpinInt(this.spnMaxStructs);
        predictTask.windowSize = this.getSpinInt(this.spnWindowSize);
        predictTask.maxLoopSize = this.getSpinInt(this.spnMaxLoopSize);
        predictTask.temperature = this.getSpinDbl(this.spnTemperature);
        predictTask.conFile1 = this.txtConFile1.getText();
        predictTask.conFile2 = this.txtConFile2.getText();
        this.runInBackground(predictTask, this::calcComplete);
    }

    private void calcComplete(PredictTask predictTask) {
        this.btnStartCalc.setVisible(true);
        this.pnlTaskStatus.setVisible(false);
        this.enableDescendants(this.tabControls, true, new Component[0]);
        this.enableDescendants(this.pnlOutput, true, new Component[0]);
        if (predictTask.isCanceled) {
            return;
        }
        if (predictTask.onComplete()) {
            this.dispose();
        }
    }

    private void $$$setupUI$$$() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setAutoscrolls(false);
        this.contentPanel.setName("contentPanel");
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 14));
        jLabel.setOpaque(false);
        jLabel.setText("Predict a Bimolecular Structure");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.contentPanel.add((Component)jLabel, gridBagConstraints);
        this.tabControls = new JTabbedPane();
        this.tabControls.setName("tabbedPane1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.contentPanel.add((Component)this.tabControls, gridBagConstraints);
        this.pnlSequences = new JPanel();
        this.pnlSequences.setLayout(new GridBagLayout());
        this.tabControls.addTab("Sequences", this.pnlSequences);
        this.txtSeqFile1 = new JTextField();
        this.txtSeqFile1.setName("txtSeqFile1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlSequences.add((Component)this.txtSeqFile1, gridBagConstraints);
        JButton jButton = new JButton();
        jButton.setActionCommand("browse-seq1");
        jButton.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSequences.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton();
        jButton2.setActionCommand("recent-seq1");
        jButton2.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSequences.add((Component)jButton2, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Sequence File 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlSequences.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Sequence File 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlSequences.add((Component)jLabel3, gridBagConstraints);
        this.txtSeqFile2 = new JTextField();
        this.txtSeqFile2.setName("txtSeqFile2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlSequences.add((Component)this.txtSeqFile2, gridBagConstraints);
        JButton jButton3 = new JButton();
        jButton3.setActionCommand("browse-seq2");
        jButton3.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSequences.add((Component)jButton3, gridBagConstraints);
        JButton jButton4 = new JButton();
        jButton4.setActionCommand("recent-seq2");
        jButton4.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlSequences.add((Component)jButton4, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.pnlSequences.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Nucleic Acid Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlSequences.add((Component)jLabel4, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        this.pnlSequences.add((Component)jPanel2, gridBagConstraints);
        this.optRNA = new JRadioButton();
        this.optRNA.setSelected(true);
        this.optRNA.setText("RNA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.optRNA, gridBagConstraints);
        this.optDNA = new JRadioButton();
        this.optDNA.setText("DNA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.optDNA, gridBagConstraints);
        this.pnlOptions = new JPanel();
        this.pnlOptions.setLayout(new GridBagLayout());
        this.tabControls.addTab("Options", this.pnlOptions);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Maximum % Energy Difference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pnlOptions.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Maximum Number of Structures");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pnlOptions.add((Component)jLabel6, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Window Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pnlOptions.add((Component)jLabel7, gridBagConstraints);
        this.spnMaxEnergyDiff = new JSpinner();
        this.spnMaxEnergyDiff.setName("spnMaxEnergyDiff");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOptions.add((Component)this.spnMaxEnergyDiff, gridBagConstraints);
        this.spnMaxStructs = new JSpinner();
        this.spnMaxStructs.setName("spnMaxStructs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOptions.add((Component)this.spnMaxStructs, gridBagConstraints);
        this.spnWindowSize = new JSpinner();
        this.spnWindowSize.setName("spnWindowSize");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOptions.add((Component)this.spnWindowSize, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Temperature");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pnlOptions.add((Component)jLabel8, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Maximum Loop Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pnlOptions.add((Component)jLabel9, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlOptions.add((Component)jPanel3, gridBagConstraints);
        this.btnResetOptions = new JButton();
        this.btnResetOptions.setActionCommand("reset-options-general");
        this.btnResetOptions.setText("Reset All to Defaults");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.pnlOptions.add((Component)this.btnResetOptions, gridBagConstraints);
        JLabel jLabel10 = new JLabel();
        jLabel10.setFont(new Font(jLabel10.getFont().getName(), jLabel10.getFont().getStyle(), 14));
        jLabel10.setText("These options apply to both bifold and DuplexFold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 3, 2);
        this.pnlOptions.add((Component)jLabel10, gridBagConstraints);
        this.spnMaxLoopSize = new JSpinner();
        this.spnMaxLoopSize.setName("spnWindowSize");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOptions.add((Component)this.spnMaxLoopSize, gridBagConstraints);
        this.spnTemperature = new JSpinner();
        this.spnTemperature.setName("spnWindowSize");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOptions.add((Component)this.spnTemperature, gridBagConstraints);
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("K");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlOptions.add((Component)jLabel11, gridBagConstraints);
        this.pnlConstraints = new JPanel();
        this.pnlConstraints.setLayout(new GridBagLayout());
        this.tabControls.addTab("Constraints", this.pnlConstraints);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Folding Constraints (Seq 1)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlConstraints.add((Component)jLabel12, gridBagConstraints);
        this.txtConFile1 = new JTextField();
        this.txtConFile1.setName("txtConFile1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlConstraints.add((Component)this.txtConFile1, gridBagConstraints);
        JButton jButton5 = new JButton();
        jButton5.setActionCommand("browse-con1");
        jButton5.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlConstraints.add((Component)jButton5, gridBagConstraints);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("SHAPE Slope");
        jLabel13.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlConstraints.add((Component)jLabel13, gridBagConstraints);
        JButton jButton6 = new JButton();
        jButton6.setActionCommand("recent-con1");
        jButton6.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlConstraints.add((Component)jButton6, gridBagConstraints);
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Folding Constraints (Seq 2)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlConstraints.add((Component)jLabel14, gridBagConstraints);
        this.txtConFile2 = new JTextField();
        this.txtConFile2.setName("txtConFile2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlConstraints.add((Component)this.txtConFile2, gridBagConstraints);
        JButton jButton7 = new JButton();
        jButton7.setActionCommand("browse-con2");
        jButton7.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlConstraints.add((Component)jButton7, gridBagConstraints);
        JButton jButton8 = new JButton();
        jButton8.setActionCommand("recent-con2");
        jButton8.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlConstraints.add((Component)jButton8, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.pnlConstraints.add((Component)jPanel4, gridBagConstraints);
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("<html>This calculation will produce multiple files in the same directory as the output file you choose below.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.contentPanel.add((Component)jLabel15, gridBagConstraints);
        this.pnlOutput = new JPanel();
        this.pnlOutput.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)this.pnlOutput, gridBagConstraints);
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("Output File 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlOutput.add((Component)jLabel16, gridBagConstraints);
        this.txtOutputFile1 = new JTextField();
        this.txtOutputFile1.setName("txtOutputFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlOutput.add((Component)this.txtOutputFile1, gridBagConstraints);
        this.lblOptionWarning = new JLabel();
        this.lblOptionWarning.setBackground(new Color(-2171392));
        this.lblOptionWarning.setForeground(new Color(-16777216));
        this.lblOptionWarning.setHorizontalAlignment(0);
        this.lblOptionWarning.setHorizontalTextPosition(0);
        this.lblOptionWarning.setOpaque(true);
        this.lblOptionWarning.setText("<html><center>Warning: Some options have been set to non-default values.<br>---List---");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlOutput.add((Component)this.lblOptionWarning, gridBagConstraints);
        this.btnStartCalc = new JButton();
        this.btnStartCalc.setActionCommand("start");
        this.btnStartCalc.setHorizontalTextPosition(0);
        this.btnStartCalc.setMinimumSize(new Dimension(54, 40));
        this.btnStartCalc.setName("btnStartCalc");
        this.btnStartCalc.setOpaque(false);
        this.btnStartCalc.setPreferredSize(new Dimension(54, 40));
        this.btnStartCalc.setText("Start");
        this.btnStartCalc.setMnemonic('S');
        this.btnStartCalc.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlOutput.add((Component)this.btnStartCalc, gridBagConstraints);
        JLabel jLabel17 = new JLabel();
        jLabel17.setText("Output File 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.pnlOutput.add((Component)jLabel17, gridBagConstraints);
        this.txtOutputFile2 = new JTextField();
        this.txtOutputFile2.setName("txtOutputFile2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlOutput.add((Component)this.txtOutputFile2, gridBagConstraints);
        this.btnResetAll = new JButton();
        this.btnResetAll.setActionCommand("reset-options-all");
        this.btnResetAll.setText("Reset All Options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.pnlOutput.add((Component)this.btnResetAll, gridBagConstraints);
        JButton jButton9 = new JButton();
        jButton9.setActionCommand("recent-out2");
        jButton9.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOutput.add((Component)jButton9, gridBagConstraints);
        JButton jButton10 = new JButton();
        jButton10.setActionCommand("recent-out1");
        jButton10.setText("Recent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOutput.add((Component)jButton10, gridBagConstraints);
        JButton jButton11 = new JButton();
        jButton11.setActionCommand("browse-out2");
        jButton11.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOutput.add((Component)jButton11, gridBagConstraints);
        JButton jButton12 = new JButton();
        jButton12.setActionCommand("browse-out1");
        jButton12.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.pnlOutput.add((Component)jButton12, gridBagConstraints);
        this.pnlTaskStatus = new JPanel();
        this.pnlTaskStatus.setLayout(new GridBagLayout());
        this.pnlTaskStatus.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)this.pnlTaskStatus, gridBagConstraints);
        this.btnCancelTask = new JButton();
        this.btnCancelTask.setActionCommand("cancel-task");
        this.btnCancelTask.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.pnlTaskStatus.add((Component)this.btnCancelTask, gridBagConstraints);
        this.prgTaskProgress = new JProgressBar();
        this.prgTaskProgress.setMinimumSize(new Dimension(10, 40));
        this.prgTaskProgress.setPreferredSize(new Dimension(146, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlTaskStatus.add((Component)this.prgTaskProgress, gridBagConstraints);
        this.lblTaskStatus = new JLabel();
        this.lblTaskStatus.setText("Status of background Task");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.pnlTaskStatus.add((Component)this.lblTaskStatus, gridBagConstraints);
        this.lblProgressPercent = new JLabel();
        this.lblProgressPercent.setHorizontalAlignment(0);
        this.lblProgressPercent.setPreferredSize(new Dimension(40, 16));
        this.lblProgressPercent.setText("0%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.pnlTaskStatus.add((Component)this.lblProgressPercent, gridBagConstraints);
        this.chkShowDescription = new JCheckBox();
        this.chkShowDescription.setActionCommand("");
        this.chkShowDescription.setSelected(true);
        this.chkShowDescription.setText("Show Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.contentPanel.add((Component)this.chkShowDescription, gridBagConstraints);
        this.lblToolDescription = new JLabel();
        this.lblToolDescription.setName("lblToolDescription");
        this.lblToolDescription.setText("<html>This tool folds two sequences into their lowest hybrid free energy conformation. This combines the capabilities of <b>bifold</b> (which allows intramolecular pairs) and <b>DuplexFold</b> (which does <b>not</b> allow intramolecular pairs).<br>The result is two distinct sets of possible bimolecular structures.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.contentPanel.add((Component)this.lblToolDescription, gridBagConstraints);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setMinimumSize(new Dimension(1, 3));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)jSeparator, gridBagConstraints);
        jLabel2.setLabelFor(this.txtSeqFile1);
        jLabel3.setLabelFor(this.txtSeqFile2);
        jLabel5.setLabelFor(this.spnMaxEnergyDiff);
        jLabel6.setLabelFor(this.spnMaxStructs);
        jLabel7.setLabelFor(this.spnWindowSize);
        jLabel8.setLabelFor(this.spnTemperature);
        jLabel9.setLabelFor(this.spnMaxLoopSize);
        jLabel10.setLabelFor(this.spnMaxEnergyDiff);
        jLabel12.setLabelFor(this.txtConFile1);
        jLabel14.setLabelFor(this.txtConFile2);
        jLabel16.setLabelFor(this.txtOutputFile1);
        jLabel17.setLabelFor(this.txtOutputFile2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.optRNA);
        buttonGroup.add(this.optDNA);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }

    private void setTaskStatus(int n, String string) {
        int n2;
        this.lblTaskStatus.setText(string);
        this.prgTaskProgress.setIndeterminate(n < 0);
        this.lblProgressPercent.setVisible(n >= 0);
        int n3 = n2 = n > 100 ? 100 : n;
        if (n >= 0) {
            this.lblProgressPercent.setText(n2 + "%");
            this.prgTaskProgress.setValue(n2);
        }
    }

    private boolean verifyInput() {
        try {
            this.validateFileField(this.txtOutputFile1, false, true);
            this.validateFileField(this.txtOutputFile2, false, true);
            this.validateFileField(this.txtSeqFile1, false);
            this.validateFileField(this.txtSeqFile2, false);
            this.validateFileField(this.txtConFile1, true);
            this.validateFileField(this.txtConFile2, true);
        }
        catch (FormValidationException formValidationException) {
            Dialogs.showError(formValidationException.getMessage(), "Error in User Input");
            this.focusField(formValidationException.getControl());
            return false;
        }
        return true;
    }

    @Override
    protected void handleSettings(boolean bl) {
        this.handleRecentControlValues(bl, "PredictBimol", this.settingsControls);
    }

    private class PredictTask
    extends PredictWindowBase.PredictTaskBase {
        String sequence1;
        String sequence2;
        int seqType1;
        int seqType2;
        boolean isRNA;
        int maxEnergyDiff;
        int maxStructures;
        int windowSize;
        int maxLoopSize;
        double temperature;
        String conFile1;
        String conFile2;
        String outBase1;
        String outBase2;
        String outShared;
        String outBiCt;
        String outDupCt;

        private PredictTask() {
        }

        @Override
        protected void runCalc() {
            this.outShared = PathTools.getDir(this.outBase1, true) + PathTools.getBaseName(this.outBase1) + "_" + PathTools.getBaseName(this.outBase2);
            this.outBiCt = this.outShared + ".ct";
            this.outDupCt = this.outShared + "_dup.ct";
            this.nextStep("Loading sequences...", true, 2);
            HybridRNA hybridRNA = new HybridRNA(this.sequence1, this.seqType1, this.sequence2, this.seqType2, this.isRNA);
            if (this.checkError(hybridRNA) || this.isCanceled) {
                return;
            }
            hybridRNA.SetProgress(this.stepProgress);
            this.nextStep("Running bifold...", true, 50);
            int n = hybridRNA.FoldBimolecular(this.maxEnergyDiff, this.maxStructures, this.windowSize, "", this.maxLoopSize);
            if (this.checkError(n) || this.checkError(hybridRNA)) {
                return;
            }
            if (this.checkError(hybridRNA.WriteCt(this.outBiCt))) {
                return;
            }
            if (this.checkError(hybridRNA)) {
                return;
            }
            hybridRNA.GetStructure().RemoveAllStructures();
            this.nextStep("Running DuplexFold...", true, 50);
            n = hybridRNA.FoldDuplex(this.maxEnergyDiff, this.maxStructures, this.windowSize, this.maxLoopSize);
            if (this.checkError(n) || this.checkError(hybridRNA)) {
                return;
            }
            if (this.checkError(hybridRNA.WriteCt(this.outDupCt))) {
                return;
            }
            if (this.checkError(hybridRNA)) {
                return;
            }
            hybridRNA.GetStructure().RemoveAllStructures();
            hybridRNA.StopProgress();
        }

        @Override
        protected boolean showResults() {
            PredictionResultsWindow predictionResultsWindow = new PredictionResultsWindow("Results of Bimolecular Structure Prediction");
            if (PathTools.isFile(this.outBiCt)) {
                predictionResultsWindow.addFile(this.outBiCt, "Structures Predicted by bifold (intramolecular pairs allowed)");
            }
            if (PathTools.isFile(this.outDupCt)) {
                predictionResultsWindow.addFile(this.outDupCt, "Structures Predicted by DuplexFold (intramolecular pairs forbidden)");
            }
            predictionResultsWindow.addPlotHeader("Drawings of Predicted Bimolecular Structures", 3);
            if (PathTools.isFile(this.outBiCt)) {
                predictionResultsWindow.addPlot("bifold Structures", "bifold Structures (intramolecular pairs allowed)", () -> PredictWindowBase.launchDrawing(this.outBiCt, FileType.CT, null, null, 1));
            }
            if (PathTools.isFile(this.outDupCt)) {
                predictionResultsWindow.addPlot("DuplexFold Structures", "DuplexFold Structures (intramolecular pairs forbidden).", () -> PredictWindowBase.launchDrawing(this.outDupCt, FileType.CT, null, null, 1));
            }
            predictionResultsWindow.showAbbreviations(false);
            predictionResultsWindow.showWindow();
            return true;
        }
    }
}

