/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.ProgressPanel;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.PathTools;

public abstract class ModuleWindow
extends InternalWindow {
    private static final long serialVersionUID = 20120802L;
    protected final ModuleWindow self = this;
    protected static final AppLog log = RNAstructure.log;
    private GridBagConstraints constraints;
    private GridBagLayout layout;
    protected boolean isRNA;
    protected volatile Component progressIndicator;
    protected Thread mainCalcThread;
    protected JButton startButton;
    private ActionListener calcCancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModuleWindow.this.cancelMainCalculation();
        }
    };
    private long calcCompleted;
    private ActionListener calcProgressListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component = ModuleWindow.this.progressIndicator;
            if (component instanceof ProgressPanel) {
                ModuleWindow.this.updateCalcProgress((ProgressPanel)component);
            }
        }
    };
    long lastUpdate;
    private boolean calcCanceled;
    private HashMap<Component, Boolean> enabledState = new HashMap();
    private static HashMap<String, Boolean> knownDirs = new HashMap();
    protected static String protectedExamplesDir;

    protected void updateCalcProgress(ProgressPanel progressPanel) {
        int n = this.backend.getProgressNumber();
        if (n >= 100) {
            if (this.calcCompleted == 0L) {
                this.calcCompleted = System.currentTimeMillis();
                progressPanel.setProgress(100);
                progressPanel.setAllowCancel(false);
            } else if (System.currentTimeMillis() - this.calcCompleted > 1000L) {
                progressPanel.setIndeterminate(true);
                progressPanel.setMessage("Performing final steps...");
            }
        } else {
            progressPanel.setProgress(n);
        }
    }

    protected boolean calcWasCanceled() {
        return this.calcCanceled;
    }

    protected void cancelMainCalculation() {
        this.calcCanceled = true;
        this.backend.cancelOperation();
    }

    protected void closeProgress() {
        this.closeProgress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProgress(final boolean bl) {
        Component component;
        ModuleWindow moduleWindow = this;
        synchronized (moduleWindow) {
            component = this.progressIndicator;
            this.progressIndicator = null;
        }
        if (component != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ModuleWindow.this.enableControls(ModuleWindow.this.self, true);
                    if (component instanceof ProgressPanel) {
                        ((ProgressPanel)component).stop();
                    }
                    ModuleWindow.this.self.remove(component);
                    if (bl) {
                        ModuleWindow.this.self.pack();
                    }
                }
            });
        }
    }

    void runOnUiThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void enableControls(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            if (!bl) {
                this.enabledState.put(component, component.isEnabled());
                component.setEnabled(false);
            } else if (this.enabledState.get(component) == Boolean.TRUE) {
                component.setEnabled(true);
            }
            if (!(component instanceof Container)) continue;
            this.enableControls((Container)component, bl);
        }
    }

    protected ModuleWindow(String string, String string2) {
        this.isRNA = "RNA".equalsIgnoreCase(string);
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.constraints = new GridBagConstraints();
        this.setCaption(string2);
        this.makeInputControls();
    }

    protected final String combineFileNames(String string, String string2, String string3) {
        String string4 = File.separator;
        String string5 = new File(string).getAbsolutePath();
        String string6 = new File(string2).getAbsolutePath();
        String string7 = string5.substring(0, string5.lastIndexOf(string4) + 1);
        string5 = string5.substring(string5.lastIndexOf(string4) + 1, string5.lastIndexOf("."));
        string6 = string6.substring(string6.lastIndexOf(string4) + 1, string6.lastIndexOf("."));
        return string7 + string5 + "_" + string6 + "." + string3;
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        if (commandInfo.command.equals("START")) {
            this.calcCompleted = 0L;
            this.calcCanceled = false;
            this.mainCalcThread = new Thread(){

                @Override
                public void run() {
                    if (ModuleWindow.this.runMainCalculation()) {
                        ModuleWindow.this.self.close();
                    } else {
                        ModuleWindow.this.closeProgress();
                    }
                }
            };
            this.mainCalcThread.start();
        } else {
            super.processCommand(commandInfo);
        }
    }

    protected final boolean displayCalcError(String string) {
        this.closeProgress();
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (this.backend.wasCanceled()) {
            Dialogs.showMessage("Calculation cancelled.");
        } else {
            Dialogs.showError(string);
        }
        return false;
    }

    protected boolean drawStructures(String string) {
        if (ModuleWindow.promptDraw()) {
            this.showDrawProgress();
            DrawingWindow drawingWindow = new DrawingWindow(string);
            if (drawingWindow.isError()) {
                return false;
            }
            drawingWindow.showWindow();
        }
        return true;
    }

    protected final JComponent getInputControl(int n) {
        return this.getInputControl(this.getContentPane(), n);
    }

    protected final JComponent getInputControl(Container container, int n) {
        return (JComponent)container.getComponent(n - 1);
    }

    protected abstract void makeInputControls();

    protected final void makeStartButton(int n, int n2) {
        this.startButton = new JButton("START");
        this.startButton.addActionListener(this);
        this.setPad(15, 15);
        this.setInsets(10, 10, 10, 10);
        this.setFillCenter();
        this.placeComponent(n, n2, this.startButton);
    }

    protected final boolean verifyBackendResult(String object, String string, Object ... objectArray) {
        if (((String)object).equals("")) {
            return true;
        }
        if (string != null && string.length() != 0) {
            object = (String)object + "\n\nAdditional Details:\n" + String.format(string, objectArray);
        }
        Dialogs.showError((String)object);
        return false;
    }

    protected final void placeComponent(int n, int n2, JComponent jComponent) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.add((Component)jComponent, this.constraints);
    }

    public static String getOutputFile(String string, String string2) {
        return ModuleWindow.getOutputFile(PathTools.changeExtension(string, string2));
    }

    public static String getOutputFile(String string) {
        String string2;
        Comparable<File> comparable;
        File file = new File(string);
        try {
            if (protectedExamplesDir == null) {
                comparable = PathTools.findLocalPath("examples");
                protectedExamplesDir = comparable == null ? "<>" : ((File)comparable).getCanonicalFile().toString();
            }
            if ((string2 = file.getCanonicalFile().getParent()) != null) {
                comparable = knownDirs.get(string2);
                if (comparable == null) {
                    File file2 = file.getParentFile();
                    if (file2 == null) {
                        file2 = new File(".");
                    }
                    comparable = PathTools.verifyWritable(file2);
                    knownDirs.put(string2, (Boolean)comparable);
                }
                if (!((Boolean)comparable).booleanValue()) {
                    string2 = null;
                }
            }
        }
        catch (IOException iOException) {
            string2 = null;
        }
        if (string2 == null || string2.equals(protectedExamplesDir)) {
            comparable = PathTools.getHomeDir();
            if (!"documents".equalsIgnoreCase(((File)comparable).getName())) {
                if (PathTools.isDir((File)comparable + "/Documents")) {
                    comparable = new File(comparable + "/Documents");
                } else if (PathTools.isDir(comparable + "/documents")) {
                    comparable = new File(comparable + "/documents");
                }
            }
            string2 = ((File)comparable).toString();
        } else {
            string2 = file.getParent();
        }
        return string2 + File.separator + file.getName();
    }

    protected abstract boolean runMainCalculation();

    protected final void setAnchorCenter() {
        this.constraints.anchor = 10;
    }

    protected final void setAnchorNorth() {
        this.constraints.anchor = 11;
    }

    protected final void setFillCenter() {
        this.constraints.fill = 10;
    }

    protected final void setFillHorizontal() {
        this.constraints.fill = 2;
    }

    protected final void setGrid(int n, int n2) {
        this.constraints.gridwidth = n;
        this.constraints.gridheight = n2;
    }

    protected final void setInsets(int n, int n2, int n3, int n4) {
        this.constraints.insets = new Insets(n, n2, n3, n4);
    }

    protected final void setPad(int n, int n2) {
        this.constraints.ipadx = n;
        this.constraints.ipady = n2;
    }

    protected void showProgress() {
        this.showProgress(true);
    }

    protected void showProgress(boolean bl) {
        this.showProgress(bl, false);
    }

    protected void showProgress(boolean bl, boolean bl2) {
        this.showProgress(bl, bl2, null);
    }

    protected void showProgress(boolean bl, boolean bl2, String string) {
        this.closeProgress(false);
        this.enableControls(this, false);
        if (string == null) {
            string = bl ? "Calculation progress: " : "Calculating...";
        }
        ProgressPanel progressPanel = new ProgressPanel(string, bl2 ? this.calcCancelListener : null, this.calcProgressListener);
        progressPanel.setIndeterminate(!bl);
        progressPanel.setProgress(0);
        progressPanel.start();
        int[][] nArray = this.layout.getLayoutDimensions();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = nArray[0].length;
        gridBagConstraints.gridy = nArray[1].length;
        gridBagConstraints.fill = 2;
        progressPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)progressPanel, gridBagConstraints);
        this.pack();
        this.progressIndicator = progressPanel;
    }

    public static boolean promptDraw() {
        return ModuleWindow.promptDraw(null, null);
    }

    public static boolean promptDraw(String string, String string2) {
        if (string == null) {
            string = "Do you want to draw structures?";
        }
        if (string2 == null) {
            string2 = RNAstructure.options.drawStructures;
        }
        switch (string2) {
            case "Y": {
                return true;
            }
            case "N": {
                return false;
            }
        }
        return Dialogs.showConfirm(string);
    }

    protected void showDrawProgress() {
        this.showDrawProgress(null);
    }

    protected void showDrawProgress(String string) {
        if (string == null) {
            string = "Calculation Complete.  Now Drawing...";
        }
        this.showProgress(false, false, string);
    }

    public void close() {
        try {
            this.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }
}

