/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.Menus;
import ur_rna.Utilities.swing.MergeMenu;

public class MaxExpectWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public MaxExpectWindow(String string) {
        super(string, string + " Maximium Expected Accuracy");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("CT File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Partition Function Save File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.PartitionSav);
            if (string == null) {
                return;
            }
            String string2 = this.backend.buildMaxExpectDataStructure(string);
            if (!this.verifyBackendResult(string2, "File: %s", string)) {
                return;
            }
            String string3 = MaxExpectWindow.getOutputFile(string, "ct");
            filePanel.setFile(1, string);
            filePanel.setFile(2, string3);
            Menus.setEnabled(this.getCustomMenus(), true);
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Partition Function Save File").inputFile(FileFilters.PartitionSav);
        FileField fileField2 = FileField.createEnabled("CT File").outputFile(FileFilters.CT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        NumberField.DoubleField doubleField = new NumberField.DoubleField("Gamma", (Number)1);
        FieldPanel fieldPanel = new FieldPanel(doubleField);
        fieldPanel.setPanelWidth(200);
        fieldPanel.makePanel();
        NumberField.DoubleField doubleField2 = new NumberField.DoubleField("Max % Score Difference", 50, (Number)0);
        NumberField.IntegerField integerField = new NumberField.IntegerField("Max Number of Structures", 1000, (Integer)1);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Window Size", 5, (Integer)0);
        FieldPanel fieldPanel2 = new FieldPanel(doubleField2, integerField, integerField2);
        fieldPanel2.setPanelWidth(300);
        fieldPanel2.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setFillCenter();
        this.placeComponent(0, 1, fieldPanel);
        this.setGrid(1, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 2, fieldPanel2);
        this.makeStartButton(1, 2);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        FieldPanel fieldPanel2 = (FieldPanel)this.getInputControl(3);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        Double d = ((NumberField.DoubleField)fieldPanel.getField(1)).getValue();
        Double d2 = ((NumberField.DoubleField)fieldPanel2.getField(1)).getValue();
        Integer n = ((NumberField.IntegerField)fieldPanel2.getField(2)).getValue();
        Integer n2 = ((NumberField.IntegerField)fieldPanel2.getField(3)).getValue();
        this.showProgress();
        String string2 = this.backend.runMaxExpect(string, d2, n, n2, d);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        return this.drawStructures(string);
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        return null;
    }
}

