/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import ur_rna.RNAstructureUI.AppMainFrame;
import ur_rna.RNAstructureUI.RNAstructureBackendCalculator;
import ur_rna.RNAstructureUI.menus.MenuList;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.OSInfo;
import ur_rna.Utilities.swing.MergeMenu;

public abstract class InternalWindow
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = 20120802L;
    private final AppMainFrame mainFrame = AppMainFrame.getFrame();
    private final JDesktopPane desktop;
    private boolean disableClose;
    protected AppLog log;
    protected final RNAstructureBackendCalculator backend;
    private MenuList customMenus;
    protected HashSet<String> warnings;
    protected final InternalFrameListener frameListener;
    protected final VetoableChangeListener changeListener;

    protected void propertyChanged(String string, PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (string.equals("closed") && this.disableClose) {
            throw new PropertyVetoException("Close operation cancelled.", propertyChangeEvent);
        }
    }

    protected boolean frameClosing(InternalFrameEvent internalFrameEvent) {
        return true;
    }

    protected void frameClosed(InternalFrameEvent internalFrameEvent) {
    }

    protected void frameActivated(boolean bl, InternalFrameEvent internalFrameEvent) {
    }

    protected InternalWindow() {
        this.desktop = this.mainFrame.desktop;
        this.log = AppLog.getDefault();
        this.warnings = new HashSet();
        this.frameListener = new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                InternalWindow.this.disableClose = !InternalWindow.this.frameClosing(internalFrameEvent);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                InternalWindow.this.frameClosed(internalFrameEvent);
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                InternalWindow.this.frameActivated(true, internalFrameEvent);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                InternalWindow.this.frameActivated(false, internalFrameEvent);
            }
        };
        this.changeListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                InternalWindow.this.propertyChanged(propertyChangeEvent.getPropertyName(), propertyChangeEvent);
            }
        };
        this.backend = new RNAstructureBackendCalculator();
        this.setDefaultCloseOperation(2);
        this.setClosable(true);
        this.setFocusable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.mainFrame.addChild(this);
        if (!OSInfo.isMac()) {
            this.setFrameIcon(new ImageIcon(this.mainFrame.getIconImage()));
        }
        InternalWindow internalWindow = this;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InternalWindow.this.onFocusGained(focusEvent);
            }
        });
        this.addInternalFrameListener(this.frameListener);
    }

    protected void processCommand(CommandInfo commandInfo) {
        if (this.log.isDebugEnabled() && !this.warnings.contains(commandInfo.command)) {
            AppLog.getDefault().warn("Unprocessed UI command: '%s' (in %s; from %s)", commandInfo.getCommand(), this.describeSource(this), this.describeSource(commandInfo.source));
            this.warnings.add(commandInfo.command);
        }
    }

    protected void invokeCommand(String string) {
        this.processCommand(new CommandInfo(string, this));
    }

    protected void invokeCommand(String string, ActionEvent actionEvent) {
        this.processCommand(new CommandInfo(string, this, actionEvent));
    }

    protected void invokeCommand(String string, Object object) {
        this.processCommand(new CommandInfo(string, object));
    }

    protected void onFocusGained(FocusEvent focusEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.processCommand(new CommandInfo(actionEvent));
    }

    private String describeSource(Object object) {
        if (object == null) {
            return "NULL";
        }
        String string = object.getClass().getSimpleName();
        String string2 = null;
        if (object instanceof Component) {
            string2 = ((Component)object).getName();
        }
        if (object instanceof JInternalFrame) {
            string2 = ((JInternalFrame)object).getTitle();
        } else if (object instanceof Dialog) {
            string2 = ((Dialog)object).getTitle();
        } else if (object instanceof AbstractButton) {
            string2 = ((AbstractButton)object).getText();
        }
        if (string2 == null) {
            return string;
        }
        return String.format("%s '%s'", string, string2);
    }

    public void setCustomMenus(MenuList menuList) {
        this.customMenus = menuList;
    }

    public MenuList getCustomMenus() {
        if (this.customMenus == null) {
            this.customMenus = new MenuList();
            MergeMenu[] mergeMenuArray = this.createCustomMenus();
            if (mergeMenuArray != null) {
                this.customMenus.add(mergeMenuArray);
            }
        }
        return this.customMenus;
    }

    protected void setCaption(String string) {
        super.setTitle(string);
        this.notifyUpdated();
    }

    protected void notifyUpdated() {
        if (this.isActiveFrame()) {
            this.mainFrame.updateActiveFrameInfo();
        }
    }

    protected MergeMenu[] createCustomMenus() {
        return null;
    }

    protected boolean isActiveFrame() {
        return this == this.desktop.getSelectedFrame();
    }

    public void showWindow() {
        this.pack();
        this.setLocation(0, 0);
        this.setVisible(true);
        this.toFront();
        this.grabFocus();
    }

    protected static class CommandInfo {
        public final String command;
        public final Object source;
        public final ActionEvent event;

        public CommandInfo(String string) {
            this(string, null, null);
        }

        public CommandInfo(ActionEvent actionEvent) {
            this(actionEvent.getActionCommand(), actionEvent.getSource(), actionEvent);
        }

        public CommandInfo(String string, Object object) {
            this(string, object, null);
        }

        public CommandInfo(String string, Object object, ActionEvent actionEvent) {
            this.command = string;
            this.source = object;
            this.event = actionEvent;
        }

        public String getCommand() {
            return this.command;
        }

        public int getId() {
            return this.event == null ? 0 : this.event.getID();
        }

        public Object getSource() {
            return this.source;
        }
    }
}

