/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class FoldSuboptimalWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public FoldSuboptimalWindow(String string) {
        super(string, "Generate All Suboptimal " + string + " Structures");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        if (commandInfo.command.equals("CT File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Sequence File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string == null) {
                return;
            }
            String string2 = this.backend.buildAllSubDataStructure(string, this.isRNA);
            if (!this.verifyBackendResult(string2, "File: %s\nRNA: %s", string, this.isRNA)) {
                return;
            }
            float f = this.backend.getSuboptimalPercentDiff();
            ((NumberField.FloatField)fieldPanel.getField(1)).resetField(Float.valueOf(f), 0, Float.valueOf(Float.MAX_VALUE));
            double d = this.backend.getSuboptimalAbsoluteDiff();
            ((NumberField.DoubleField)fieldPanel.getField(2)).resetField(d, 0, Double.MAX_VALUE);
            String string3 = FoldSuboptimalWindow.getOutputFile(string, "ct");
            filePanel.setFile(1, string);
            filePanel.setFile(2, string3);
            this.getCustomMenus().enableMenus();
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Sequence File").inputFile(FileFilters.Sequence);
        FileField fileField2 = FileField.createEnabled("CT File").outputFile(FileFilters.CT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        NumberField.FloatField floatField = new NumberField.FloatField("Max % Energy Difference", 0, (Number)0);
        NumberField.DoubleField doubleField = new NumberField.DoubleField("Max Absolute Energy Difference", 0, (Number)0);
        FieldPanel fieldPanel = new FieldPanel(floatField, doubleField);
        fieldPanel.setPanelWidth(350);
        fieldPanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setGrid(1, 1);
        this.placeComponent(0, 1, fieldPanel);
        this.makeStartButton(1, 1);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        Float f = ((NumberField.FloatField)fieldPanel.getField(1)).getValue();
        Double d = ((NumberField.DoubleField)fieldPanel.getField(2)).getValue();
        this.showProgress(true, true);
        String string2 = this.backend.runAllSub(string, f.floatValue(), d);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        if (FoldSuboptimalWindow.promptDraw(null, "P")) {
            this.showDrawProgress("Drawing Structures (this may take a long time)...");
            DrawingWindow drawingWindow = new DrawingWindow(string);
            if (drawingWindow.isError()) {
                return false;
            }
            drawingWindow.showWindow();
        }
        return true;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        ConstraintsMenu constraintsMenu2 = new ConstraintsMenu(this.backend);
        constraintsMenu2.addGeneralSection();
        constraintsMenu2.addMaxPairingDistanceSection();
        constraintsMenu2.addSHAPESection();
        constraintsMenu2.addShowResetSection();
        constraintsMenu2.addSaveRestoreSection();
        return new ConstraintsMenu[]{constraintsMenu, constraintsMenu2};
    }
}

