/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class DynalignRefoldWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public DynalignRefoldWindow() {
        super("", "Refold From Dynalign Save File");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("Alignment File")) {
            String string = StandardFileChooser.getSaveName(FileFilters.Alignment);
            if (string != null) {
                filePanel.setFile(4, string);
            }
        } else if (commandInfo.command.startsWith("CT File")) {
            String string = StandardFileChooser.getSaveName(FileFilters.CT);
            if (string != null) {
                int n = commandInfo.command.endsWith("1") ? 2 : 3;
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Save File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.DynalignSav);
            if (string == null) {
                return;
            }
            filePanel.setFile(1, string);
            String string2 = this.backend.buildRefoldDynalignDataStructure(string);
            if (!this.verifyBackendResult(string2, "File: %s", string)) {
                return;
            }
            this.getCustomMenus().enableMenus();
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Save File").inputFile(FileFilters.DynalignSav);
        FileField fileField2 = FileField.createEnabled("CT File 1").outputFile(FileFilters.CT);
        FileField fileField3 = FileField.createEnabled("CT File 2").outputFile(FileFilters.CT);
        FileField fileField4 = FileField.createEnabled("Alignment File").outputFile(FileFilters.Alignment);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2, fileField3, fileField4);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        NumberField.IntegerField integerField = new NumberField.IntegerField("Max % Energy Difference", 20, (Integer)0);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Max Number of Structures", 750, (Integer)1);
        NumberField.IntegerField integerField3 = new NumberField.IntegerField("Structure Window Size", 0, (Integer)0);
        NumberField.IntegerField integerField4 = new NumberField.IntegerField("Alignment Window Size", 0, (Integer)0);
        FieldPanel fieldPanel = new FieldPanel(integerField, integerField2, integerField3, integerField4);
        fieldPanel.setPanelWidth(300);
        fieldPanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setGrid(1, 1);
        this.placeComponent(0, 1, fieldPanel);
        this.makeStartButton(1, 1);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        String string2 = filePanel.getFile(3);
        String string3 = filePanel.getFile(4);
        if (filePanel.isError()) {
            return false;
        }
        Integer n = ((NumberField.IntegerField)fieldPanel.getField(1)).getValue();
        Integer n2 = ((NumberField.IntegerField)fieldPanel.getField(2)).getValue();
        Integer n3 = ((NumberField.IntegerField)fieldPanel.getField(3)).getValue();
        Integer n4 = ((NumberField.IntegerField)fieldPanel.getField(4)).getValue();
        this.showProgress();
        String string4 = this.backend.runDynalignRefold(string, string2, string3, n, n2, n3, n4);
        this.displayCalcError(string4);
        if (!string4.equals("")) {
            return false;
        }
        if (DynalignRefoldWindow.promptDraw()) {
            this.showDrawProgress();
            DrawingWindow drawingWindow = new DrawingWindow(string);
            DrawingWindow drawingWindow2 = new DrawingWindow(string2);
            if (drawingWindow.isError() || drawingWindow2.isError()) {
                return false;
            }
            drawingWindow.showWindow();
            drawingWindow2.showWindow();
        }
        return true;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        return null;
    }
}

