/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import ur_rna.RNAstructureUI.AppMainFrame;
import ur_rna.RNAstructureUI.menus.MenuList;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.OSInfo;

public abstract class ChildWindow
extends JInternalFrame
implements FocusListener {
    private static final long serialVersionUID = 20120802L;
    private boolean disableClose;
    protected final AppMainFrame mainFrame;
    protected MenuList customMenus;
    protected AppLog log = AppLog.getDefault();
    protected HashSet<String> warnings = new HashSet();
    protected final ActionListener commandListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommandInfo commandInfo = new CommandInfo(actionEvent.getActionCommand(), actionEvent.getID(), actionEvent.getSource());
            ChildWindow.this.processCommand(commandInfo.getCommand(), commandInfo);
            if (!commandInfo.isHandled() && ChildWindow.this.log.isDebugEnabled() && !ChildWindow.this.warnings.contains(commandInfo.getCommand())) {
                AppLog.getDefault().warn("Unprocessed UI command: '%s' (in %s; from %s)", commandInfo.getCommand(), this.describeSource(ChildWindow.this), this.describeSource(commandInfo.source));
                ChildWindow.this.warnings.add(commandInfo.getCommand());
            }
        }

        private String describeSource(Object object) {
            if (object == null) {
                return "NULL";
            }
            String string = object.getClass().getSimpleName();
            String string2 = null;
            if (object instanceof Component) {
                string2 = ((Component)object).getName();
            }
            if (object instanceof JInternalFrame) {
                string2 = ((JInternalFrame)object).getTitle();
            } else if (object instanceof Dialog) {
                string2 = ((Dialog)object).getTitle();
            } else if (object instanceof AbstractButton) {
                string2 = ((AbstractButton)object).getText();
            }
            if (string2 == null) {
                return string;
            }
            return String.format("%s '%s'", string, string2);
        }
    };
    protected final InternalFrameListener frameListener = new InternalFrameAdapter(){

        @Override
        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            ChildWindow.this.disableClose = !ChildWindow.this.frameClosing(internalFrameEvent);
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            ChildWindow.this.frameClosed(internalFrameEvent);
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            ChildWindow.this.frameActivated(true, internalFrameEvent);
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            ChildWindow.this.frameActivated(false, internalFrameEvent);
        }
    };
    protected final VetoableChangeListener changeListener = new VetoableChangeListener(){

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            ChildWindow.this.propertyChanged(propertyChangeEvent.getPropertyName(), propertyChangeEvent);
        }
    };

    protected void propertyChanged(String string, PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (string.equals("closed") && this.disableClose) {
            throw new PropertyVetoException("Close operation cancelled.", propertyChangeEvent);
        }
    }

    protected boolean frameClosing(InternalFrameEvent internalFrameEvent) {
        return true;
    }

    protected void frameClosed(InternalFrameEvent internalFrameEvent) {
    }

    protected void frameActivated(boolean bl, InternalFrameEvent internalFrameEvent) {
    }

    protected ChildWindow() {
        super("ChildWindow", true, true, true, true);
        this.setDefaultCloseOperation(2);
        this.addVetoableChangeListener(this.changeListener);
        this.mainFrame = AppMainFrame.getAppRoot();
        this.mainFrame.addChild(this);
        if (!OSInfo.isMac()) {
            this.setFrameIcon(new ImageIcon(this.mainFrame.getIconImage()));
        }
        this.addFocusListener(this);
        this.addInternalFrameListener(this.frameListener);
    }

    protected abstract void processCommand(String var1, CommandInfo var2);

    protected CommandInfo processCommand(String string) {
        CommandInfo commandInfo = new CommandInfo(string);
        this.processCommand(string, commandInfo);
        return commandInfo;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    protected void updateMainFrame() {
        this.mainFrame.updateActiveFrameInfo();
    }

    public AppMainFrame getMainWindow() {
        return this.mainFrame;
    }

    public MenuList getCustomMenus() {
        return this.customMenus;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void showWindow() {
        this.pack();
        this.setLocation(0, 0);
        this.setVisible(true);
    }

    protected static class CommandInfo {
        private String command;
        private int id;
        private Object source;
        private boolean handled;
        public ActionEvent event;

        public CommandInfo(String string, int n, Object object) {
            this.command = string;
            this.id = n;
            this.source = object;
        }

        public CommandInfo(String string, Object object) {
            this.command = string;
            this.source = object;
        }

        public CommandInfo(String string) {
            this.command = string;
        }

        public String getCommand() {
            return this.command;
        }

        public int getId() {
            return this.id;
        }

        public Object getSource() {
            return this.source;
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void markHandled() {
            this.handled = true;
        }
    }
}

