/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.utilities;

import java.io.IOException;
import java.io.InputStream;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.Utilities.ResourceLoader;

public final class Resources {
    private static ResourceLoader _res;

    private Resources() {
    }

    public static ResourceLoader loader() {
        if (_res == null) {
            _res = new ResourceLoader();
            Resources.searchForResources(_res);
        }
        return _res;
    }

    public static InputStream get(String string) throws IOException {
        return Resources.loader().getStream(string);
    }

    public static InputStream tryGet(String string) {
        return Resources.loader().tryGetStream(string);
    }

    private static void searchForResources(ResourceLoader resourceLoader) {
        ResourceLoader resourceLoader2 = Resources.loader();
        resourceLoader2.setBaseDir(RNAstructure.class, "resources");
        String[] stringArray = new String[]{"images", "sounds"};
        String[] stringArray2 = new String[]{ResourceLoader.getDirFromPackage(Resources.class, "resources"), "ur_rna/resources", "resources"};
        resourceLoader2.addSearchDirs(stringArray);
        for (String string : stringArray2) {
            resourceLoader2.addSearchDir("/" + string);
            for (String string2 : stringArray) {
                resourceLoader2.addSearchDir("/" + string + "/" + string2);
            }
        }
    }

    public static boolean verify() {
        if (Resources.loader().hasResource("res.dir")) {
            return true;
        }
        Dialogs.showMessage("Could not locate program resources. The following locations were searched:" + String.join((CharSequence)"\n\t", Resources.loader().getAllSearchDirs()));
        return false;
    }
}

