/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.menus;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.windows.AccessFoldWindow;
import ur_rna.RNAstructureUI.windows.DuplexFoldWindow;
import ur_rna.RNAstructureUI.windows.DynalignFoldWindow;
import ur_rna.RNAstructureUI.windows.Efn2Window;
import ur_rna.RNAstructureUI.windows.FoldDoubleWindow;
import ur_rna.RNAstructureUI.windows.FoldSingleWindow;
import ur_rna.RNAstructureUI.windows.FoldSuboptimalWindow;
import ur_rna.RNAstructureUI.windows.MaxExpectWindow;
import ur_rna.RNAstructureUI.windows.MultilignWindow;
import ur_rna.RNAstructureUI.windows.OligoWalkWindow;
import ur_rna.RNAstructureUI.windows.PartitionDoubleWindow;
import ur_rna.RNAstructureUI.windows.PartitionSingleWindow;
import ur_rna.RNAstructureUI.windows.ProbKnotWindow;
import ur_rna.RNAstructureUI.windows.PseudoknotWindow;
import ur_rna.RNAstructureUI.windows.StochasticWindow;
import ur_rna.RNAstructureUI.windows.TurboFoldWindow;
import ur_rna.Utilities.AppLog;

public class NucleicAcidMenu
extends MainMenu {
    private static final long serialVersionUID = 20120802L;
    private final String acidName;

    private NucleicAcidMenu(String string) {
        super(string);
        this.acidName = string;
        this.addAcidMenuItem("FoldSingleStrand", "Fold {acid} &Single Strand", "Predict a secondary structure for a single strand using {acid} thermodynamics.");
        this.addAcidMenuItem("FoldBimolecular", "Fold {acid} &Bimolecular", "Predict a secondary structure for two strands using {acid} thermodynamics.");
        this.addAcidMenuItem("AccessFold", "{acid} &AccessFold", "Predict a secondary structure for two strands using the AccessFold algorithm.");
        this.addAcidMenuItem("DuplexFold", "{acid} &DuplexFold", "Predict a secondary structure for two strands using the DuplexFold algorithm.");
        this.addSeparator();
        this.addAcidMenuItem("Partition", "&Partition Function {acid}", "Predict base pairing probabilities for all {acid} pairs.");
        this.addAcidMenuItem("PartitionBimolecular", "Partition Function {acid} Bi&molecular", "Predict base pairing probabilities for all {acid} pairs for two strands.");
        this.addSeparator();
        this.addAcidMenuItem("AllSub", "Generate &All Suboptimal {acid} Structures", "Generate all {acid} structures within a given increment of the lowest free energy structure.");
        this.addAcidMenuItem("Stochastic", "Stoc&hastic {acid} Sampling", "Predict {acid} structures using stochastic sampling.");
        this.addAcidMenuItem("MaxExpect", "Max&Expect: Predict {acid} MEA Structure", "Predict the maximum expected accuracy {acid} structure.");
        this.addAcidMenuItem("ProbKnot", "Prob&Knot: Predict {acid} Structures Including Pseudoknots", "Predict pseudoknots in a {acid} structure.");
        this.addAcidMenuItem("Efn2", "E&fn2 {acid}", "Calculate the free energy of a {acid} structure.");
        this.addSeparator();
        this.addAcidMenuItem("Dynalign", "{acid} &Dynalign", "Find a common secondary structure for two {acid} sequences.");
        this.addAcidMenuItem("Multilign", "{acid} M&ultilign", "Predict a secondary structure common to multiple {acid} sequences.");
        this.addSeparator();
        this.addAcidMenuItem("BreakPseudoknots", "&Break {acid} Pseudoknots", "Break pseudoknots in a structure, leaving the lowest free energy pseudoknot-free structure.");
        if (string.equals("RNA")) {
            this.addAcidMenuItem("Oligo&Walk", "{acid} OligoWalk", "RNA OligoWalk calculation.");
            this.addAcidMenuItem("&TurboFold", "{acid} TurboFold", "Find common structures for multiple sequences using base pair probabilities.");
        }
    }

    private void addAcidMenuItem(String string, String string2, String string3) {
        super.addItem(string2.replace("{acid}", this.acidName), string3.replace("{acid}", this.acidName), (KeyStroke)null, string.replace("{acid}", this.acidName));
    }

    public static NucleicAcidMenu createDNA() {
        return new NucleicAcidMenu("DNA");
    }

    public static NucleicAcidMenu createRNA() {
        return new NucleicAcidMenu("RNA");
    }

    @Override
    protected void onMenuAction(String string, ActionEvent actionEvent) {
        String string2 = this.acidName;
        switch (string) {
            case "FoldSingleStrand": {
                new FoldSingleWindow(string2).showWindow();
                break;
            }
            case "FoldBimolecular": {
                new FoldDoubleWindow(string2).showWindow();
                break;
            }
            case "AccessFold": {
                new AccessFoldWindow(string2).showWindow();
                break;
            }
            case "DuplexFold": {
                new DuplexFoldWindow(string2).showWindow();
                break;
            }
            case "Partition": {
                new PartitionSingleWindow(string2).showWindow();
                break;
            }
            case "PartitionBimolecular": {
                new PartitionDoubleWindow(string2).showWindow();
                break;
            }
            case "AllSub": {
                new FoldSuboptimalWindow(string2).showWindow();
                break;
            }
            case "Stochastic": {
                new StochasticWindow(string2).showWindow();
                break;
            }
            case "MaxExpect": {
                new MaxExpectWindow(string2).showWindow();
                break;
            }
            case "ProbKnot": {
                new ProbKnotWindow(string2).showWindow();
                break;
            }
            case "Efn2": {
                new Efn2Window(string2).showWindow();
                break;
            }
            case "Dynalign": {
                new DynalignFoldWindow(string2).showWindow();
                break;
            }
            case "Multilign": {
                new MultilignWindow(string2).showWindow();
                break;
            }
            case "BreakPseudoknots": {
                new PseudoknotWindow(string2).showWindow();
                break;
            }
            case "OligoWalk": {
                new OligoWalkWindow().showWindow();
                break;
            }
            case "TurboFold": {
                new TurboFoldWindow().showWindow();
                break;
            }
            default: {
                AppLog.getDefault().warn("Unknown menu command in " + this.getClass().getName() + "#onMenuAction");
            }
        }
    }
}

