/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.menus;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import ur_rna.RNAstructureUI.AppMainFrame;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;

public class HelpMenu
extends MainMenu {
    private static final long serialVersionUID = 20120802L;
    private static final String WEB_URL = "http://rna.urmc.rochester.edu/";
    private static final String HELP_URL = "http://rna.urmc.rochester.edu/GUI/html/Contents.html";
    private static final String LOCAL_HELP_PAGE = "Contents.html";
    private final MouseAdapter guiInfoListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.showInfo(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.showInfo(mouseEvent);
        }

        void showInfo(MouseEvent mouseEvent) {
            AppMainFrame.getFrame().setInfoLabel(HelpMenu.this.getGuiInfo(mouseEvent.getSource()));
        }
    };

    public HelpMenu() {
        super("Help");
        this.addItem("Program Help", "View the RNAstructure Manual.", "F1");
        this.addItem("Online Help", "View the online RNAstructure help.", "*F1");
        if (PathTools.findLocalPath("examples") != null) {
            this.addSeparator();
            this.addItem("Extract Examples", "Extract example files to a folder of your choice.");
        }
        this.addSeparator();
        if (Strings.asBool(System.getProperty("show-gui-info-menu"))) {
            this.addItem("Show GUI Info", "Add mouse-over information for GUI Components.");
            this.addItem("Copy GUI Info Tree", "Copy the GUI Component hierarchy.");
            this.addSeparator();
        }
        this.addItem("About RNAstructure...", "Display program information, version number, and copyright.");
    }

    @Override
    protected void onMenuAction(String string, ActionEvent actionEvent) {
        if (string.startsWith("About")) {
            try {
                AppMainFrame.getFrame().showAboutWindow();
            }
            catch (Exception exception) {
                Dialogs.showError("error showing about screen.\n" + AppLog.getErrorInfo(exception));
            }
        } else if ("Program Help".equals(string)) {
            String string2 = HELP_URL;
            File file = PathTools.findLocalPath("manual/html/Contents.html");
            if (file == null) {
                file = PathTools.findLocalPath("manual/GUI/html/Contents.html");
            }
            if (file != null) {
                string2 = file.toURI().toString();
            }
            HelpMenu.browse(string2);
        } else if ("Online Help".equals(string)) {
            HelpMenu.browseHelp();
        } else if ("Extract Examples".equals(string)) {
            RNAstructure.ExtractExamples();
        } else if ("Show GUI Info".equals(string)) {
            for (Window window : Window.getWindows()) {
                this.addGuiInfo(window);
            }
        } else if ("Copy GUI Info Tree".equals(string)) {
            String string3 = this.getGuiTree(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string3), null);
        }
    }

    private void addGuiInfo(Component component) {
        if (component instanceof Window) {
            Component[] componentArray = (Component[])component;
            Window[] windowArray = componentArray.getOwnedWindows();
            int n = windowArray.length;
            for (int i = 0; i < n; ++i) {
                Window window = windowArray[i];
                this.addGuiInfo(window);
            }
        }
        component.removeMouseListener(this.guiInfoListener);
        component.addMouseListener(this.guiInfoListener);
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.addGuiInfo(component2);
            }
        }
    }

    private String getGuiTree(Component component) {
        HashMap<Component, Integer> hashMap = new HashMap<Component, Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        this.appendGuiTree("", component, hashMap, stringBuilder);
        return stringBuilder.toString();
    }

    private void appendGuiTree(String object, Component component, HashMap<Component, Integer> hashMap, StringBuilder stringBuilder) {
        Integer n = hashMap.get(component);
        if (n != null) {
            stringBuilder.append((String)object).append(n).append("\t(ref) ").append(component.getClass().getSimpleName());
            return;
        }
        n = hashMap.size() + 1;
        hashMap.put(component, n);
        stringBuilder.append((String)object).append(n).append('\t').append(this.getGuiInfo(component)).append('\n');
        object = (String)object + "..";
        if (component instanceof Window) {
            for (Component component2 : ((Window)component).getOwnedWindows()) {
                this.appendGuiTree((String)object, component2, hashMap, stringBuilder);
            }
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.appendGuiTree((String)object, component2, hashMap, stringBuilder);
            }
        }
    }

    private String getGuiInfo(Object object) {
        if (object == null) {
            return "Source: NULL";
        }
        if (!(object instanceof Component)) {
            return "Source Type: " + object.getClass().getSimpleName();
        }
        return HelpMenu.getComponentInfo((Component)object);
    }

    public static String getComponentInfo(Component component) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(component.getClass().getSimpleName());
        HelpMenu.appendInfo(stringBuilder, "Name", component.getName());
        if (component instanceof JComponent) {
            HelpMenu.appendInfo(stringBuilder, "ToolTip", ((JComponent)component).getToolTipText());
        }
        if (component instanceof JTextComponent) {
            HelpMenu.appendInfo(stringBuilder, "InputText", ((JTextComponent)component).getText());
        } else if (component instanceof TextComponent) {
            HelpMenu.appendInfo(stringBuilder, "InputText", ((TextComponent)component).getText());
        }
        if (component instanceof AbstractButton) {
            HelpMenu.appendInfo(stringBuilder, "Caption", ((AbstractButton)component).getText());
        } else if (component instanceof Button) {
            HelpMenu.appendInfo(stringBuilder, "Caption", ((Button)component).getLabel());
        } else if (component instanceof JLabel) {
            HelpMenu.appendInfo(stringBuilder, "Caption", ((JLabel)component).getText());
        } else if (component instanceof Label) {
            HelpMenu.appendInfo(stringBuilder, "Caption", ((Label)component).getText());
        } else if (component instanceof Frame) {
            HelpMenu.appendInfo(stringBuilder, "Caption", ((Frame)component).getTitle());
        } else if (component instanceof Dialog) {
            HelpMenu.appendInfo(stringBuilder, "Caption", ((Dialog)component).getTitle());
        }
        if (component instanceof JList) {
            HelpMenu.appendInfo(stringBuilder, "SelItem", "" + ((JList)component).getSelectedValue());
        } else if (component instanceof JComboBox) {
            HelpMenu.appendInfo(stringBuilder, "SelItem", "" + ((JComboBox)component).getSelectedItem());
        }
        AccessibleContext accessibleContext = component.getAccessibleContext();
        if (accessibleContext != null) {
            if (!Objects.equals(component.getName(), accessibleContext.getAccessibleName())) {
                HelpMenu.appendInfo(stringBuilder, "AccessName", accessibleContext.getAccessibleName());
            }
            HelpMenu.appendInfo(stringBuilder, "AccessDesc", accessibleContext.getAccessibleDescription());
        }
        return stringBuilder.toString();
    }

    public static void appendInfo(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null) {
            stringBuilder.append(' ').append(string).append(": \"").append(string2).append('\"');
        }
    }

    public static void browseHelp() {
        HelpMenu.browse(HELP_URL);
    }

    public static void browseWebsite() {
        HelpMenu.browse(WEB_URL);
    }

    public static void browse(String string) {
        try {
            if (Strings.isEmpty(string)) {
                string = WEB_URL;
            }
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (Exception exception) {
            Dialogs.showError("error showing webpage in browser: " + string);
        }
    }
}

