/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.menus.FileMenu;
import ur_rna.RNAstructureUI.menus.HelpMenu;
import ur_rna.RNAstructureUI.menus.MenuList;
import ur_rna.RNAstructureUI.menus.NucleicAcidMenu;
import ur_rna.RNAstructureUI.menus.PredictMenu;
import ur_rna.RNAstructureUI.menus.RolloverListener;
import ur_rna.RNAstructureUI.utilities.ImageGrabber;
import ur_rna.RNAstructureUI.windows.AboutWindow;
import ur_rna.RNAstructureUI.windows.ChildWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.OSInfo;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.swing.Menus;
import ur_rna.Utilities.swing.MergeManager;
import ur_rna.Utilities.swing.MergeMenu;

public class AppMainFrame
extends JFrame {
    private static final long serialVersionUID = 20160128L;
    private final AppLog log = AppLog.getDefault();
    private static boolean useSimpleFileChooser;
    private final JMenuBar menuBar;
    private final JToolBar toolBar;
    private final JPanel statusBar;
    private final JLabel infoLabel;
    public final JDesktopPane desktop;
    private static AppMainFrame activeRoot;
    private MenuList mainMenus;
    private MergeManager menuMerger = new MergeManager();
    public static final int FileMenuSection = -100;
    public static final int EditMenuSection = -80;
    public static final int PredictMenuSection = -60;
    public static final int NucleicAcidMenuSection = -40;
    public static final int HelpMenuSection = 1000;
    public Consumer<String> InfoLabelConsumer = new Consumer<String>(){

        @Override
        public void accept(String string) {
            if (string == null) {
                AppMainFrame.this.resetInfoLabel();
            } else {
                AppMainFrame.this.setInfoLabel(string);
            }
        }
    };
    private Component[] keepToolBarItems = null;
    protected InternalFrameListener frameListener = new InternalFrameAdapter(){

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            AppMainFrame.this.updateActiveFrameInfo();
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            AppMainFrame.this.updateActiveFrameInfo();
        }
    };

    public AppMainFrame() {
        super("RNAstructure");
        activeRoot = this;
        String string = "Icon.gif";
        this.setIconImage(ImageGrabber.tryGetImage(string));
        this.setLayout(new BorderLayout());
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.mainMenus = this.buildMainMenu();
        this.toolBar = this.buildToolBar();
        this.desktop = this.buildDesktop();
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.desktop, "Center");
        this.statusBar = this.buildStatusBar();
        this.infoLabel = this.buildInfoLabel(this.statusBar);
        this.resetInfoLabel();
        this.updateActiveFrameInfo();
        this.setDefaultCloseOperation(3);
        this.setSize(1024, 730);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.showStartupInfo();
    }

    private void showStartupInfo() {
        String string = RNAstructure.getPref("initial_run_6.2");
        if (!ObjTools.asBool(string)) {
            RNAstructure.setPref("initial_run_6.2", "1");
            this.showAboutWindow();
            RNAstructure.createDocsFolder();
        }
    }

    public void showAboutWindow() {
        AboutWindow aboutWindow = new AboutWindow();
        aboutWindow.setVisible(false);
        this.desktop.add(aboutWindow);
        Dimension dimension = this.desktop.getSize();
        Dimension dimension2 = aboutWindow.getSize();
        aboutWindow.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        aboutWindow.setVisible(true);
        aboutWindow.requestFocus();
        aboutWindow.initFocus();
    }

    private JDesktopPane buildDesktop() {
        JDesktopPane jDesktopPane = new JDesktopPane();
        jDesktopPane.setBackground(Color.GRAY);
        jDesktopPane.removeAll();
        return jDesktopPane;
    }

    private JPanel buildStatusBar() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(100, 16));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new BevelBorder(1));
        this.add((Component)jPanel, "South");
        return jPanel;
    }

    private MenuList buildMainMenu() {
        MenuList menuList = new MenuList();
        menuList.add((MergeMenu)new FileMenu(), -100);
        menuList.add(new MergeMenu("&Edit"), -80);
        menuList.add((MergeMenu)new PredictMenu(), -60);
        menuList.add((MergeMenu)NucleicAcidMenu.createRNA(), -40);
        menuList.add((MergeMenu)NucleicAcidMenu.createDNA(), -40);
        menuList.add((MergeMenu)new HelpMenu(), 1000);
        for (JMenu jMenu : menuList) {
            this.menuBar.add(jMenu);
        }
        return menuList;
    }

    private void addMainMenu(MergeMenu mergeMenu, int n) {
        mergeMenu.setMergePos(n);
        this.menuBar.add(mergeMenu);
    }

    private JLabel buildInfoLabel(JComponent jComponent) {
        final JLabel jLabel = new JLabel("RNAstructure");
        jLabel.setFont(new Font(jLabel.getFont().getFontName(), 0, 16));
        jLabel.setHorizontalAlignment(2);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (0 != (mouseEvent.getModifiers() & 1)) {
                    StringSelection stringSelection = new StringSelection(jLabel.getText());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                }
            }
        });
        this.add((Component)jLabel, "South");
        return jLabel;
    }

    private JToolBar buildToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(true);
        this.createToolbar(jToolBar);
        return jToolBar;
    }

    private void copyAction(String string, AbstractButton abstractButton) {
        JMenuItem jMenuItem = Menus.findByName(this.mainMenus, string);
        if (jMenuItem == null) {
            AppLog.getDefault().error("There is no existing menu item with the name or title '" + string + "'.");
        } else {
            this.copyAction(jMenuItem, abstractButton);
        }
    }

    private void copyAction(AbstractButton abstractButton, AbstractButton abstractButton2) {
        abstractButton2.setActionCommand(abstractButton.getActionCommand());
        for (ActionListener actionListener : abstractButton.getActionListeners()) {
            abstractButton2.addActionListener(actionListener);
        }
    }

    public static AppMainFrame getFrame() {
        return activeRoot;
    }

    @NotNull
    public static AppMainFrame getAppRoot() {
        return activeRoot;
    }

    public InternalWindow getMostRecentFrame() {
        return (InternalWindow)this.desktop.getSelectedFrame();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void resetInfoLabel() {
        this.setInfoLabel("For help, press F1.");
    }

    public void setInfoLabel(String string) {
        this.infoLabel.setText(" " + string);
    }

    public static boolean getUseSimpleFileChooser() {
        return useSimpleFileChooser;
    }

    public static void setUseSimpleFileChooser(boolean bl) {
        useSimpleFileChooser = bl;
    }

    public void updateActiveFrameInfo() {
        String string;
        JInternalFrame jInternalFrame = this.desktop.getSelectedFrame();
        MenuList menuList = null;
        if (jInternalFrame == null) {
            string = "";
        } else {
            string = ObjTools.toStr(jInternalFrame.getTitle(), "").trim();
            if (jInternalFrame instanceof ChildWindow) {
                menuList = ((ChildWindow)jInternalFrame).getCustomMenus();
            } else if (jInternalFrame instanceof InternalWindow) {
                menuList = ((InternalWindow)jInternalFrame).getCustomMenus();
            }
        }
        if (string.length() == 0) {
            this.setTitle("RNAstructure");
        } else {
            this.setTitle("RNAstructure - " + string);
        }
        this.rebuildMainMenu(menuList);
        this.rebuildToolBar();
        this.repaint();
    }

    private void rebuildToolBar() {
        JToolBar jToolBar = this.toolBar;
        if (this.keepToolBarItems != null) {
            for (Component component : jToolBar.getComponents()) {
                if (ObjTools.contains(this.keepToolBarItems, component)) continue;
                jToolBar.remove(component);
            }
        }
    }

    private void createToolbar(JToolBar jToolBar) {
        JButton jButton = new JButton();
        jButton.setToolTipText("New Sequence");
        jButton.setActionCommand(jButton.getToolTipText());
        jButton.setIcon(ImageGrabber.tryGetImageIcon("NewSequence.gif"));
        this.copyAction("File->New Sequence", (AbstractButton)jButton);
        jToolBar.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.setToolTipText("Open Sequence");
        jButton2.setActionCommand(jButton2.getToolTipText());
        jButton2.setIcon(ImageGrabber.tryGetImageIcon("OpenSequence.gif"));
        this.copyAction("File->Open Sequence", (AbstractButton)jButton2);
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        JButton jButton3 = new JButton();
        jButton3.setToolTipText("Save");
        jButton3.setName("Save");
        jButton3.setActionCommand("Save Sequence");
        jButton3.setIcon(ImageGrabber.tryGetImageIcon("Save.gif"));
        jButton3.setEnabled(false);
        jButton3.setFocusable(false);
        jToolBar.add(jButton3);
        jToolBar.addSeparator();
        JButton jButton4 = new JButton();
        jButton4.setToolTipText("Draw");
        jButton4.setActionCommand(jButton4.getToolTipText());
        jButton4.setIcon(ImageGrabber.tryGetImageIcon("Draw.gif"));
        this.copyAction("File->Draw", (AbstractButton)jButton4);
        jToolBar.add(jButton4);
        JButton jButton5 = new JButton();
        jButton5.setToolTipText("Fold RNA Single Strand");
        jButton5.setActionCommand(jButton5.getToolTipText());
        jButton5.setIcon(ImageGrabber.tryGetImageIcon("FoldRNASingle.gif"));
        this.copyAction("RNA->FoldSingleStrand", (AbstractButton)jButton5);
        jToolBar.add(jButton5);
        JButton jButton6 = new JButton();
        jButton6.setToolTipText("RNA OligoWalk");
        jButton6.setActionCommand(jButton6.getToolTipText());
        jButton6.setIcon(ImageGrabber.tryGetImageIcon("OligoWalk.gif"));
        this.copyAction("RNA->OligoWalk", (AbstractButton)jButton6);
        jToolBar.add(jButton6);
        JButton jButton7 = new JButton();
        jButton7.setToolTipText("RNA Dynalign");
        jButton7.setActionCommand(jButton7.getToolTipText());
        jButton7.setIcon(ImageGrabber.tryGetImageIcon("Dynalign.gif"));
        this.copyAction("RNA->Dynalign", (AbstractButton)jButton7);
        jToolBar.add(jButton7);
        this.keepToolBarItems = jToolBar.getComponents();
    }

    private void convertTooltipsToRollovers(JMenuItem jMenuItem) {
        String string = jMenuItem.getToolTipText();
        if (!Strings.isEmpty(string)) {
            RolloverListener rolloverListener = ObjTools.firstOfType(jMenuItem.getMouseListeners(), RolloverListener.class);
            if (rolloverListener != null) {
                return;
            }
            jMenuItem.setToolTipText(null);
            jMenuItem.addMouseListener(new RolloverListener(this.InfoLabelConsumer, string));
        }
        if (jMenuItem instanceof JMenu) {
            for (JMenuItem jMenuItem2 : Menus.getMenuItems(jMenuItem)) {
                this.convertTooltipsToRollovers(jMenuItem2);
            }
        }
    }

    private void rebuildMainMenu(MenuList menuList) {
        this.menuMerger.reset();
        if (menuList != null) {
            this.menuMerger.merge((Component)this.menuBar, menuList.toArray(new Component[menuList.size()]));
        }
        this.menuMerger.sort(this.menuBar);
        for (JMenu jMenu : Menus.getMenus(this.menuBar)) {
            this.convertTooltipsToRollovers(jMenu);
        }
        if (OSInfo.isMac()) {
            this.removeMenuMnemonics(this.menuBar.getComponents());
        } else {
            this.verifyMenuMnemonics(this.menuBar.getComponents());
        }
    }

    private void removeMenuMnemonics(Component[] componentArray) {
        for (Component component : componentArray) {
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).setMnemonic(0);
            }
            if (!(component instanceof Container)) continue;
            this.removeMenuMnemonics(((Container)component).getComponents());
        }
    }

    private void verifyMenuMnemonics(Component[] componentArray) {
        for (Component component : componentArray) {
            String string;
            AbstractButton abstractButton;
            if (component instanceof AbstractButton && (abstractButton = (AbstractButton)component).getMnemonic() == 0 && !Strings.isEmpty(string = abstractButton.getText())) {
                abstractButton.setMnemonic(string.charAt(0));
            }
            if (!(component instanceof Container)) continue;
            this.verifyMenuMnemonics(((Container)component).getComponents());
        }
    }

    public JMenuBar getMainMenu() {
        return this.menuBar;
    }

    public MenuList getMenus() {
        return this.mainMenus;
    }

    public void addChild(JInternalFrame jInternalFrame) {
        this.desktop.add(jInternalFrame);
        jInternalFrame.addInternalFrameListener(this.frameListener);
    }

    public JButton getToolBarItem(String string) {
        if (string == null) {
            return null;
        }
        for (Component component : this.toolBar.getComponents()) {
            if (!(component instanceof JButton) || !string.equals(component.getName())) continue;
            return (JButton)component;
        }
        for (Component component : this.toolBar.getComponents()) {
            if (!(component instanceof JButton) || !string.equals(((JButton)component).getText())) continue;
            return (JButton)component;
        }
        for (Component component : this.toolBar.getComponents()) {
            if (!(component instanceof JButton) || !string.equals(((JButton)component).getActionCommand())) continue;
            return (JButton)component;
        }
        if (this.log.isDebugEnabled()) {
            AppLog.getDefault().warn("Unknown Toolbar Item: " + string);
        }
        return null;
    }
}

