/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import ur_rna.Utilities.swing.UiAction;

public class JActionLabel
extends JLabel {
    private String link;
    private URI linkURI;
    private Action action;
    private String actionCommand;
    private ActionListener listener;
    private List<ActionListener> listeners = null;

    public JActionLabel(Icon icon) {
        this(null, icon, 0);
    }

    public JActionLabel(String string) {
        this(string, string);
    }

    public JActionLabel(String string, String string2) {
        this(string, null, 0);
        this.actionCommand = string2;
    }

    public JActionLabel(Action action) {
        this(UiAction.getName(action), UiAction.getCommand(action));
        this.setAction(action);
    }

    public JActionLabel(String string, Icon icon) {
        super(string, icon, 0);
    }

    public JActionLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.addClickListener();
    }

    public JActionLabel() {
        this.addClickListener();
    }

    private void addClickListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JActionLabel.this.fireActionPerformed(new ActionEvent(this, 1001, JActionLabel.this.actionCommand, System.currentTimeMillis(), mouseEvent.getModifiersEx()));
            }
        });
    }

    public void setAction(Action action) {
        int n;
        Object object;
        this.action = action;
        this.updateCursor();
        if (this.action == null) {
            return;
        }
        String string = UiAction.getName(action);
        if (string != null && (this.getText() == null || this.getText().isEmpty())) {
            this.setText(string);
        }
        if (this.getName() == null || this.getName().isEmpty()) {
            this.setName(string);
        }
        if (this.getActionCommand() == null) {
            this.setActionCommand(UiAction.getCommand(action));
        }
        if (this.getIcon() == null && (object = UiAction.getIcon(action)) != null) {
            this.setIcon((Icon)object);
        }
        if (this.getToolTipText() == null && (object = UiAction.getDesc(action)) != null) {
            this.setToolTipText((String)object);
        }
        if (this.getDisplayedMnemonic() <= 0 && (n = UiAction.getMnemonic(action)) != 0) {
            this.setDisplayedMnemonic(n);
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.linkURI != null) {
            try {
                Desktop.getDesktop().browse(this.linkURI);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.action != null) {
            this.action.actionPerformed(actionEvent);
        }
        if (this.listener != null) {
            this.listener.actionPerformed(actionEvent);
        }
        if (this.listeners != null) {
            for (ActionListener actionListener : this.listeners) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public void setLink(String string) {
        this.link = string;
        try {
            this.linkURI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.linkURI = null;
        }
        this.updateCursor();
    }

    public String getLink() {
        return this.link;
    }

    public URI getLinkUri() {
        return this.linkURI;
    }

    public void setLinkUri(URI uRI) {
        this.linkURI = uRI;
        this.link = uRI.toString();
        this.updateCursor();
    }

    public Action getAction() {
        return this.action;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listener == null) {
            this.listener = actionListener;
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ActionListener>();
            }
            this.listeners.add(actionListener);
        }
        this.updateCursor();
    }

    private void updateCursor() {
        if (this.hasClickAction()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean hasClickAction() {
        return this.listener != null || this.listeners != null && this.listeners.size() != 0 || this.action != null || this.linkURI != null;
    }

    public boolean removeActionListener(ActionListener actionListener) {
        boolean bl = false;
        if (this.listener == actionListener) {
            this.listener = null;
            bl = true;
        } else if (this.listeners != null) {
            bl = this.listeners.remove(actionListener);
        }
        this.updateCursor();
        return bl;
    }

    public ActionListener[] getActionListeners() {
        if (this.listeners == null || this.listeners.size() == 0) {
            if (this.listener == null) {
                return new ActionListener[0];
            }
            return new ActionListener[]{this.listener};
        }
        if (this.listener == null) {
            return this.listeners.toArray(new ActionListener[this.listeners.size()]);
        }
        ActionListener[] actionListenerArray = new ActionListener[this.listeners.size() + 1];
        actionListenerArray[0] = this.listener;
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            actionListenerArray[i + 1] = this.listeners.get(0);
        }
        return actionListenerArray;
    }
}

