/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.swing.Components;
import ur_rna.Utilities.swing.Menus;

public interface IMenuItem {
    public Component getComponent();

    default public JMenuItem getMenuItem() {
        Component component = this.getComponent();
        return component instanceof JMenuItem ? (JMenuItem)component : null;
    }

    default public JComponent getContainer() {
        return Menus.getSubItemContainer(this.getComponent());
    }

    default public boolean hasSubItems() {
        return Menus.hasSubItems(this.getContainer());
    }

    @NotNull
    default public String getItemName() {
        return Components.getNameOrText(this.getComponent());
    }

    default public List<? extends JMenu> getMenus() {
        return Menus.getMenus(this.getContainer());
    }

    default public List<? extends JMenuItem> getMenuItems() {
        return Menus.getMenuItems(this.getContainer());
    }

    default public JMenuItem findByTreePath(String string) {
        return Menus.findByTreePath(this, string);
    }

    default public JMenuItem findByName(String string) {
        return Menus.findByName(this, string);
    }

    default public JMenuItem findByAction(Action action) {
        return Menus.findByAction(this, action);
    }

    public static IMenuItem from(final Component component) {
        if (component == null) {
            throw new NullPointerException("Cannot create an IMenuItem from a NULL Component reference.");
        }
        if (component instanceof IMenuItem) {
            return (IMenuItem)((Object)component);
        }
        if (component instanceof JMenu) {
            return new IMenuItem(){
                JMenu c;
                {
                    this.c = (JMenu)component;
                }

                @Override
                public Component getComponent() {
                    return this.c;
                }

                @Override
                public JComponent getContainer() {
                    return this.c.getPopupMenu();
                }
            };
        }
        return new IMenuItem(){
            Component c;
            {
                this.c = component;
            }

            @Override
            public Component getComponent() {
                return this.c;
            }
        };
    }
}

