/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import ur_rna.Utilities.annotation.Nullable;

public class Dialogs {
    public static String programTitle;
    public static Component owningComponent;
    private static Font defaultFont;
    private static Font monospaceFont;
    public static int ERROR;
    public static int QUESTION;
    public static int WARNING;
    public static int INFO;
    public static int PLAIN;
    public static int PROMPT_YES_NO;
    public static int PROMPT_YES_NO_CANCEL;
    public static int PROMPT_OK_CANCEL;
    public static int PROMPT_NONE;

    public static void showWarning(String string) {
        Dialogs.showMessage(string, programTitle, WARNING);
    }

    public static void showWarning(String string, String string2) {
        Dialogs.showMessage(string, string2, WARNING);
    }

    public static void showInfo(String string) {
        Dialogs.showMessage(string, programTitle, INFO);
    }

    public static void showInfo(String string, String string2) {
        Dialogs.showMessage(string, string2, INFO);
    }

    public static void showMessage(String string, String string2, int n) {
        Dialogs.showMessage(string, string2, n, false);
    }

    public static void showMessage(String string, String string2, int n, boolean bl) {
        Dialogs.showMessage(string, string2, n, bl ? Dialogs.getMonospaceFont() : null);
    }

    public static void showMessage(String string, String string2, int n, Font font) {
        JOptionPane.showMessageDialog(owningComponent, Dialogs.createTextPanel(string, font), string2, n);
    }

    public static int prompt(String string) {
        return Dialogs.prompt(string, programTitle, PROMPT_OK_CANCEL);
    }

    public static int prompt(String string, String string2, int n) {
        return JOptionPane.showConfirmDialog(owningComponent, Dialogs.createTextPanel(string, null), string2, n, QUESTION);
    }

    public static int prompt(String string, String string2, Object[] objectArray, Object object) {
        return JOptionPane.showOptionDialog(owningComponent, Dialogs.createTextPanel(string, null), string2, PROMPT_NONE, QUESTION, null, objectArray, object);
    }

    public static String input(String string, String string2, String string3) {
        return (String)JOptionPane.showInputDialog(owningComponent, Dialogs.createTextPanel(string, null), string2, QUESTION, null, null, string3);
    }

    public static JPanel createTextPanel(String string, @Nullable Font font) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextPane jTextPane = new JTextPane();
        jTextPane.setFont(font == null ? jPanel.getFont() : font);
        jTextPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        Rectangle rectangle = Dialogs.getScreenWorkingArea(null);
        int n = Math.min((int)((float)rectangle.width * 0.6f), 600);
        int n2 = (int)((float)rectangle.height * 0.7f);
        jTextPane.setSize(new Dimension(n, 10));
        if (string.startsWith("<html>")) {
            jTextPane.setContentType("text/html");
        }
        jTextPane.setBackground(jPanel.getBackground());
        jTextPane.setForeground(jPanel.getForeground());
        jTextPane.setText(string);
        jScrollPane.setPreferredSize(new Dimension(n, Math.min(jTextPane.getPreferredSize().height, n2)));
        SwingUtilities.invokeLater(() -> {
            jScrollPane.getVerticalScrollBar().setValue(0);
            jScrollPane.getHorizontalScrollBar().setValue(0);
        });
        return jPanel;
    }

    public static Rectangle getScreenWorkingArea(Window window) {
        Rectangle rectangle;
        Insets insets;
        if (window == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration());
            rectangle = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        } else {
            GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
            insets = window.getToolkit().getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
        }
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            defaultFont = Font.decode(null);
        }
        return defaultFont;
    }

    public static Font getMonospaceFont() {
        if (monospaceFont == null) {
            Font font = Dialogs.getDefaultFont();
            monospaceFont = new Font("Monospaced", font.getStyle(), font.getSize());
        }
        return monospaceFont;
    }

    static {
        ERROR = 0;
        QUESTION = 3;
        WARNING = 2;
        INFO = 1;
        PLAIN = -1;
        PROMPT_YES_NO = 0;
        PROMPT_YES_NO_CANCEL = 1;
        PROMPT_OK_CANCEL = 2;
        PROMPT_NONE = -1;
    }
}

