/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.KeyStroke;
import ur_rna.Utilities.OSInfo;
import ur_rna.Utilities.Strings;

public class AcceleratorKey {
    public static int SystemMenuKeyModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static KeyStroke getKey(char c) {
        return KeyStroke.getKeyStroke((int)c, SystemMenuKeyModifier);
    }

    public static KeyStroke getKey(String string) {
        if (Strings.isEmpty(string)) {
            return null;
        }
        int n = 0;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    n |= SystemMenuKeyModifier;
                    continue block7;
                }
                case '^': {
                    n |= 2;
                    continue block7;
                }
                case '#': {
                    n |= 4;
                    continue block7;
                }
                case '+': {
                    n |= 1;
                    continue block7;
                }
                case '%': {
                    n |= 8;
                    continue block7;
                }
                default: {
                    KeyStroke keyStroke;
                    string = string.substring(i);
                    if (string.length() == 1) {
                        keyStroke = KeyStroke.getKeyStroke((int)Character.toUpperCase(string.charAt(0)), n);
                    } else {
                        keyStroke = KeyStroke.getKeyStroke(string.toUpperCase());
                        if (keyStroke != null && n != 0) {
                            keyStroke = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n);
                        }
                    }
                    if (keyStroke == null) {
                        throw new RuntimeException(String.format("No KeyStroke can be obtained from the string '%s'", string));
                    }
                    return keyStroke;
                }
            }
        }
        return KeyStroke.getKeyStroke(n, 0);
    }

    public static String toString(KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        StringBuilder stringBuilder = new StringBuilder();
        if (0 != (n & 2)) {
            stringBuilder.append("Ctrl-");
        }
        if (0 != (n & 1)) {
            stringBuilder.append("Shift-");
        }
        if (0 != (n & 4)) {
            if (OSInfo.isMac()) {
                stringBuilder.append("Command-");
            } else if (OSInfo.isWin()) {
                stringBuilder.append("Win-");
            } else {
                stringBuilder.append("Meta-");
            }
        }
        if (0 != (n & 8)) {
            stringBuilder.append(OSInfo.isMac() ? "Option-" : "Alt-");
        }
        stringBuilder.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        return stringBuilder.toString();
    }

    public static String getShortcutModifierKeyName() {
        return AcceleratorKey.getShortcutModifierKeyName(false);
    }

    public static String getShortcutModifierKeyName(boolean bl) {
        return AcceleratorKey.getModifierKeyName(SystemMenuKeyModifier, bl);
    }

    public static String getAltKeyName() {
        return AcceleratorKey.getAltKeyName(false);
    }

    public static String getAltKeyName(boolean bl) {
        return OSInfo.isMac() ? "Option" : "Alt";
    }

    public static String getMetaKeyName() {
        return AcceleratorKey.getMetaKeyName(false);
    }

    public static String getMetaKeyName(boolean bl) {
        if (OSInfo.isMac()) {
            return "Command";
        }
        if (OSInfo.isWin()) {
            return bl ? "Win" : "Windows";
        }
        if (OSInfo.isNix()) {
            return "Super";
        }
        return "Meta";
    }

    public static String getModifierKeyName(int n) {
        return AcceleratorKey.getModifierKeyName(n, false);
    }

    public static String getModifierKeyName(int n, boolean bl) {
        switch (n) {
            case 2: 
            case 17: 
            case 128: {
                return bl ? "Ctrl" : "Control";
            }
            case 1: 
            case 16: 
            case 64: {
                return "Shift";
            }
            case 8: 
            case 18: 
            case 512: {
                return AcceleratorKey.getAltKeyName(bl);
            }
            case 4: 
            case 157: 
            case 256: {
                return AcceleratorKey.getMetaKeyName(bl);
            }
        }
        String string = KeyStroke.getKeyStroke(Character.valueOf('A'), n).toString();
        int n2 = string.indexOf(" typed");
        return n2 == -1 ? string : string.substring(0, n2);
    }

    public static void resetTabTraversalKeys(Component ... componentArray) {
        for (Component component : componentArray) {
            component.setFocusTraversalKeys(0, null);
            component.setFocusTraversalKeys(1, null);
        }
    }

    public static void removeAllTabTraversalKeys(Component ... componentArray) {
        for (Component component : componentArray) {
            component.setFocusTraversalKeys(0, Collections.emptySet());
            component.setFocusTraversalKeys(1, Collections.emptySet());
        }
    }

    public static void removeTabTraversalKeys(Component component, AWTKeyStroke ... aWTKeyStrokeArray) {
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(0));
        hashSet.removeAll(Arrays.asList(aWTKeyStrokeArray));
        component.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(1));
        hashSet.removeAll(Arrays.asList(aWTKeyStrokeArray));
        component.setFocusTraversalKeys(1, hashSet);
    }
}

