/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.geom;

import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import ur_rna.Utilities.geom.Matrix3D;
import ur_rna.Utilities.geom.Vec2D;

public class Ellipses {
    public static final double toScreenDegrees = -57.29577951308232;

    public static Ellipse2D.Double fromRect(Rectangle2D rectangle2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        double_.setFrame(rectangle2D);
        return double_;
    }

    public static Ellipse2D.Double fromCenter(Point2D point2D, double d, double d2) {
        return Ellipses.fromCenter(point2D.getX(), point2D.getY(), d, d2);
    }

    public static Ellipse2D.Double fromCenter(Vec2D vec2D, double d, double d2) {
        return Ellipses.fromCenter(vec2D.x, vec2D.y, d, d2);
    }

    public static Ellipse2D.Double fromCenter(double d, double d2, double d3, double d4) {
        return new Ellipse2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
    }

    public static Ellipse2D.Double fromCenter(Point2D point2D, double d) {
        return Ellipses.fromCenter(point2D.getX(), point2D.getY(), d);
    }

    public static Ellipse2D.Double fromCenter(Vec2D vec2D, double d) {
        return Ellipses.fromCenter(vec2D.x, vec2D.y, d);
    }

    public static Ellipse2D.Double fromCenter(double d, double d2, double d3) {
        return new Ellipse2D.Double(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
    }

    public static Arc2D.Double arc(Point2D point2D, double d, double d2, double d3, int n) {
        return new Arc2D.Double(point2D.getX() - d, point2D.getY() - d, d * 2.0, d * 2.0, d2 * -57.29577951308232, d3 * -57.29577951308232, n);
    }

    public static Arc2D.Double arc(Point2D point2D, double d, double d2, double d3, boolean bl, int n) {
        return Ellipses.arc(point2D, d, d2, Ellipses.calcArcExtent(d2, d3, bl), n);
    }

    public static double calcArcExtent(double d, double d2, boolean bl) {
        double d3 = (d2 - d) % Math.PI;
        if (!bl && d3 < 0.0) {
            d3 += Math.PI * 2;
        } else if (bl && d3 > 0.0) {
            d3 -= Math.PI * 2;
        }
        return d3;
    }

    public static class Circle
    extends Ellipse2D.Float {
        private float _radius = 1.0f;
        private Point2D.Float _center = new Point2D.Float();

        public Circle(Point2D point2D, double d) {
            this(point2D.getX(), point2D.getY(), d);
        }

        public Circle(double d) {
            this(0.0, 0.0, d);
        }

        public Circle(double d, double d2, double d3) {
            this.radius(d3);
            this.center(d, d2);
        }

        public static double getRadiusFromArcAndChord(double d, double d2) {
            double d3 = d2 / d;
            double d4 = -0.1549 * d3 * d3 + 1.0574 * d3 + 0.0975;
            double d5 = 2.0 * Math.asin(d4);
            double d6 = d2 / 2.0 / Math.sin(d5);
            double d7 = d + d6 * 2.0 * d5;
            return d7 / (Math.PI * 2);
        }

        public Arc2D arc(double d, double d2) {
            return Ellipses.arc(this._center, this._radius, d, d2, 0);
        }

        public double getCircleX(double d) {
            return (double)this._center.x + (double)this._radius * Math.cos(d);
        }

        public double getCircleY(double d) {
            return (double)this._center.y + (double)this._radius * Math.sin(d);
        }

        public void getPoint(double d, Point2D point2D) {
            point2D.setLocation(this.getCircleX(d), this.getCircleY(d));
        }

        public Point2D getPoint(double d) {
            return new Point2D.Double(this.getCircleX(d), this.getCircleY(d));
        }

        public void translate(float f, float f2) {
            this.x += f;
            this.y += f2;
            this._center.x += f;
            this._center.y += f2;
        }

        public float radius() {
            return this._radius;
        }

        public void radius(double d) {
            this._radius = (float)d;
            this.width = this.height = (float)(d * 2.0);
            this.x = this._center.x - this._radius;
            this.y = this._center.y - this._radius;
        }

        public Point2D.Float center() {
            return this._center;
        }

        public void center(Point2D point2D) {
            this.center(point2D.getX(), point2D.getY());
        }

        public void center(double d, double d2) {
            this._center.setLocation(d, d2);
            this.x = (float)(d - (double)this._radius);
            this.y = (float)(d2 - (double)this._radius);
        }

        public void setCircle(Point2D point2D, float f) {
            this.center(point2D);
            this.radius(f);
        }

        public static Circle calcFromPoints(Point2D point2D, Point2D point2D2, Point2D point2D3) {
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            double d5 = point2D3.getX();
            double d6 = point2D3.getY();
            Matrix3D matrix3D = new Matrix3D(d, d2, 1.0, d3, d4, 1.0, d5, d6, 1.0);
            double[] dArray = new double[]{d * d + d2 * d2, d3 * d3 + d4 * d4, d5 * d5 + d6 * d6};
            if (!matrix3D.invert()) {
                return null;
            }
            matrix3D.transform(dArray, 0, 0);
            double d7 = dArray[0] / 2.0;
            double d8 = dArray[1] / 2.0;
            return new Circle(d7, d8, Math.sqrt(dArray[2] + d7 * d7 + d8 * d8));
        }

        public static Circle calcLeastSquaresFit(Point2D ... point2DArray) {
            double d;
            double d2;
            if (point2DArray.length < 3) {
                throw new IllegalArgumentException("At least 3 points are required to determine a circle.");
            }
            if (point2DArray.length == 3) {
                return Circle.calcFromPoints(point2DArray[0], point2DArray[1], point2DArray[2]);
            }
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            for (Point2D point2D : point2DArray) {
                d2 = point2D.getX();
                d = point2D.getY();
                double d10 = d2 * d2;
                double d11 = d * d;
                d3 += d10;
                d4 += d11;
                d5 += d2 * d;
                d6 += d2;
                d7 += d;
                d8 += d2 * (d10 + d11);
                d9 += d * (d10 + d11);
            }
            Matrix3D matrix3D = new Matrix3D(d3, d5, d6, d5, d4, d7, d6, d7, point2DArray.length);
            if (!matrix3D.invert()) {
                return null;
            }
            double[] dArray = new double[]{d8, d9, d3 + d4};
            matrix3D.transform(dArray);
            double d12 = dArray[0] / 2.0;
            d2 = dArray[1] / 2.0;
            d = Math.sqrt(dArray[2] + d12 * d12 + d2 * d2);
            return new Circle(d12, d2, d);
        }
    }
}

