/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.util.Comparator;
import java.util.Objects;

public abstract class Tuple {

    public static final class Quad<T1, T2, T3, T4> {
        public T1 item1;
        public T2 item2;
        public T3 item3;
        public T4 item4;

        public Quad(T1 T1, T2 T2, T3 T3, T4 T4) {
            this.item1 = T1;
            this.item2 = T2;
            this.item3 = T3;
            this.item4 = T4;
        }

        public Quad() {
        }

        public boolean itemsEqual(Quad<T1, T2, T3, T4> quad) {
            return quad == this || Objects.equals(this.item1, quad.item1) && Objects.equals(this.item2, quad.item2) && Objects.equals(this.item3, quad.item3) && Objects.equals(this.item4, quad.item4);
        }

        protected Quad<T1, T2, T3, T4> clone() {
            try {
                return (Quad)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
        }

        public String toString() {
            return String.format("%s { %s, %s, %s, %s }", Quad.class.getSimpleName(), this.item1, this.item2, this.item3, this.item4);
        }
    }

    public static final class Triplet<T1, T2, T3>
    implements Cloneable {
        public T1 item1;
        public T2 item2;
        public T3 item3;

        public Triplet(T1 T1, T2 T2, T3 T3) {
            this.item1 = T1;
            this.item2 = T2;
            this.item3 = T3;
        }

        public Triplet() {
        }

        public boolean itemsEqual(Triplet<T1, T2, T3> triplet) {
            return triplet == this || Objects.equals(this.item1, triplet.item1) && Objects.equals(this.item2, triplet.item2) && Objects.equals(this.item3, triplet.item3);
        }

        protected Triplet<T1, T2, T3> clone() {
            try {
                return (Triplet)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
        }

        public String toString() {
            return String.format("%s { %s, %s, %s }", Triplet.class.getSimpleName(), this.item1, this.item2, this.item3);
        }
    }

    public static final class Pair<T1, T2>
    implements Cloneable {
        public T1 item1;
        public T2 item2;

        public Pair(T1 T1, T2 T2) {
            this.item1 = T1;
            this.item2 = T2;
        }

        public Pair() {
        }

        public static <T extends Comparable<? super T>> Comparator<Pair<? extends T, ?>> compareFirstItem() {
            return (pair, pair2) -> ((Comparable)pair.item1).compareTo(pair2.item1);
        }

        public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>> Comparator<Pair<? extends T1, ? extends T2>> compareBothItems() {
            return (pair, pair2) -> {
                int n = ((Comparable)pair.item1).compareTo(pair2.item1);
                return n != 0 ? n : ((Comparable)pair.item2).compareTo(pair2.item2);
            };
        }

        public boolean itemsEqual(Pair<T1, T2> pair) {
            return pair == this || Objects.equals(this.item1, pair.item1) && Objects.equals(this.item2, pair.item2);
        }

        protected Pair<T1, T2> clone() {
            try {
                return (Pair)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
        }

        public String toString() {
            return String.format("%s { %s, %s }", Pair.class.getSimpleName(), this.item1, this.item2);
        }
    }

    public static final class Singlet<T1> {
        public T1 item1;

        public Singlet(T1 T1) {
            this.item1 = T1;
        }

        public Singlet() {
        }
    }
}

