/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import ur_rna.Utilities.StringBuilderEx;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.annotation.Nullable;

public class SyntaxErrorException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static String leftCodeQuote = ">>";
    public static String rightCodeQuote = "<<";
    protected String errorDescription;
    protected String offendingText;
    protected String location;
    protected int lineOffset = -1;
    protected int columnOffset = -1;

    public SyntaxErrorException() {
    }

    public SyntaxErrorException(String string) {
        super(string);
    }

    public SyntaxErrorException(Throwable throwable) {
        super(throwable);
    }

    public SyntaxErrorException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public SyntaxErrorException(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, int n, int n2, @Nullable Throwable throwable) {
        super(string == null || string.isEmpty() ? SyntaxErrorException.buildMessage(string2, string3, n, n2, null) : string);
        if (throwable != null) {
            this.initCause(throwable);
        }
        this.errorDescription = string2;
        this.offendingText = string3;
        this.location = string4;
        this.lineOffset = n;
        this.columnOffset = n2;
    }

    public SyntaxErrorException(@Nullable String string, @Nullable String string2, int n, int n2) {
        this(null, string, string2, null, n, n2, null);
    }

    public SyntaxErrorException(@Nullable String string, @Nullable String string2, String string3) {
        this(null, string, string2, string3, -1, -1, null);
    }

    private static String buildMessage(String string, String string2, int n, int n2, String string3) {
        StringBuilderEx stringBuilderEx = new StringBuilderEx();
        if (string != null) {
            stringBuilderEx.append(string).trimEnd(' ').appendSeparator(".");
        }
        SyntaxErrorException.buildLocationInfo(stringBuilderEx, n, n2, string3);
        if (string2 != null) {
            stringBuilderEx.appendSeparator(" ").append(leftCodeQuote).append(Strings.escapeStringLiteral(string2, 49)).append(rightCodeQuote);
        }
        return stringBuilderEx.toString();
    }

    protected static void buildLocationInfo(StringBuilderEx stringBuilderEx, int n, int n2, String string) {
        if (string != null) {
            stringBuilderEx.appendSeparator(" ").append(string);
        }
        if (n != -1 || n2 != -1) {
            stringBuilderEx.appendSeparator(" ").append("(");
            if (n != -1) {
                stringBuilderEx.append("line ").append(n);
            }
            if (n2 != -1) {
                if (n != -1) {
                    stringBuilderEx.append(", ");
                }
                stringBuilderEx.append("col ").append(n2);
            }
            stringBuilderEx.append(")");
        }
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public String getOffendingText() {
        return this.offendingText;
    }

    public String getLocationDescription() {
        return this.location;
    }

    public String getLocation() {
        StringBuilderEx stringBuilderEx = new StringBuilderEx();
        SyntaxErrorException.buildLocationInfo(stringBuilderEx, this.lineOffset, this.columnOffset, this.location);
        return stringBuilderEx.toString();
    }

    public boolean hasLocationInfo() {
        return this.lineOffset != -1 || this.columnOffset != -1 || this.location != null;
    }

    public int getLine() {
        return this.lineOffset;
    }

    public int getColumn() {
        return this.columnOffset;
    }
}

