/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import ur_rna.Utilities.KeyAlreadyExistsException;

public class StopWatch {
    public static PrintWriter defaultOutput = new PrintWriter(System.out, true);
    public static final Map<String, StopWatch> watches = new LinkedHashMap<String, StopWatch>();
    private long time;
    private PrintWriter out;

    public static StopWatch get(String string, boolean bl) {
        StopWatch stopWatch = watches.get(string);
        if (stopWatch == null) {
            stopWatch = StopWatch.create(string, bl);
        }
        return stopWatch;
    }

    public static StopWatch get(String string) {
        return watches.get(string);
    }

    public static StopWatch create(String string, boolean bl) {
        StopWatch stopWatch = new StopWatch(bl);
        if (watches.containsKey(string)) {
            throw new KeyAlreadyExistsException("StopWatch " + string + " already exists.");
        }
        watches.put(string, stopWatch);
        return stopWatch;
    }

    public static StopWatch println(String string, String string2) {
        return watches.get(string).println(string2);
    }

    public static StopWatch printf(String string, String string2, Object ... objectArray) {
        return watches.get(string).printf(string2, objectArray);
    }

    public static long elapsed(String string) {
        return watches.get(string).elapsed();
    }

    public static StopWatch enter(String string) {
        return StopWatch.get(string, true).start();
    }

    public static StopWatch exit(String string) {
        StopWatch stopWatch = StopWatch.get(string, true);
        if (!stopWatch.isStarted()) {
            throw new IllegalStateException("StopWatch " + string + "is not yet started.");
        }
        return stopWatch.stop();
    }

    public void printAll() {
        this.printAll(0L);
    }

    public void printAll(long l) {
        this.printAll(l == 0L ? "\t%1$5d\t%4$5s%%\t%2$3s\t%3$s%n" : "\t%1$5d\t%2$3s\t%3$s%n", l);
    }

    public void printAll(String string, long l) {
        for (Map.Entry<String, StopWatch> entry : watches.entrySet()) {
            StopWatch stopWatch = entry.getValue();
            defaultOutput.printf(string, stopWatch.elapsed(), stopWatch.isStarted() ? "on" : "off", entry.getKey(), l == 0L ? 0L : 0x64L & stopWatch.elapsed() / l);
        }
    }

    public void clearNamed() {
        watches.clear();
    }

    public StopWatch() {
        this(false, defaultOutput);
    }

    public StopWatch(boolean bl) {
        this(bl, defaultOutput);
    }

    public StopWatch(boolean bl, PrintWriter printWriter) {
        this.out = printWriter;
        if (bl) {
            this.start();
        }
    }

    public StopWatch(boolean bl, PrintStream printStream) {
        this(bl, new PrintWriter(printStream, true));
    }

    public StopWatch start() {
        if (this.time == 0L) {
            this.time = StopWatch.time();
        } else if (this.time < 0L) {
            this.time += System.currentTimeMillis();
        }
        return this;
    }

    public StopWatch stop() {
        if (this.time > 0L) {
            this.time -= System.currentTimeMillis();
        }
        return this;
    }

    public long elapsed() {
        if (this.time == 0L) {
            return 0L;
        }
        return (this.time < 0L ? 0L : StopWatch.time()) - this.time;
    }

    public StopWatch reset() {
        this.time = 0L;
        return this;
    }

    public StopWatch restart() {
        this.time = StopWatch.time();
        return this;
    }

    public boolean isStarted() {
        return this.time > 0L;
    }

    public static long time() {
        return System.currentTimeMillis();
    }

    public StopWatch println(String string) {
        this.out.printf("@\t%5d\t%s%n", this.elapsed(), string);
        return this;
    }

    public StopWatch printf(String string, Object ... objectArray) {
        this.out.printf("@\t%5d\t%s", this.elapsed(), String.format(string, objectArray));
        return this;
    }
}

