/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ur_rna.Utilities.Convert;
import ur_rna.Utilities.FormatterException;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.SyntaxErrorException;
import ur_rna.Utilities.annotation.Nullable;

public class SimpleDataSerializer {
    private static transient Matcher identifierMatcher;
    private static final int STRING_ESCAPE_OPTIONS = 655360;
    private static final String END_TOKEN = "(?=\\s|[:{}()\\[\\]\"]|$)";

    public Object parse(CharSequence charSequence, @Nullable int[] nArray) throws SyntaxErrorException {
        if (nArray == null) {
            nArray = this.buildSourceIndex(charSequence);
        }
        Token[] tokenArray = this.tokenize(charSequence, nArray, true, true);
        ParseContext parseContext = new ParseContext(tokenArray, 0, nArray);
        Object object = this.parseSONValue(parseContext);
        if (parseContext.hasNext()) {
            Token token = parseContext.next();
            throw this.syntaxErr("unexpected " + token.type().name() + " (expected END-OF-DOCUMENT)", token.start(), parseContext.sourceIndex, token.text());
        }
        return object;
    }

    private int[] buildSourceIndex(CharSequence charSequence) {
        int n = charSequence.length();
        int[] nArray = new int[30];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) != '\n') continue;
            if (nArray.length < (++n2 + 1) * 3) {
                nArray = Arrays.copyOf(nArray, nArray.length * 2);
            }
            nArray[n2 * 3] = i + 1;
            nArray[n2 * 3 + 1] = n2;
        }
        return nArray;
    }

    public String toString(Object object, OutputFormatSettings outputFormatSettings) throws FormatterException {
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(object, stringWriter, outputFormatSettings);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new FormatterException("Unexpected IO Error", iOException);
        }
    }

    public void write(Object object, Writer writer, OutputFormatSettings outputFormatSettings) throws IOException, FormatterException {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        if (outputFormatSettings == null) {
            outputFormatSettings = OutputFormatSettings.SSON;
        }
        this.write(object, writer, outputFormatSettings, arrayDeque);
    }

    private void write(Object object, Writer writer, OutputFormatSettings outputFormatSettings, Queue<String> queue) throws IOException, FormatterException {
        if (object == null) {
            writer.write("null");
        } else if (object instanceof String) {
            writer.write(this.writeString((String)object, outputFormatSettings.quoteAlways));
        } else if (object instanceof Boolean) {
            writer.write((Boolean)object != false ? "true" : "false");
        } else if (object instanceof Number) {
            writer.write(this.writeNumber((Number)object, outputFormatSettings));
        } else if (object instanceof Character) {
            writer.write(this.writeString(object.toString(), outputFormatSettings.quoteAlways));
        } else if (object instanceof List) {
            this.writeList((List)object, writer, outputFormatSettings, queue);
        } else if (object instanceof Map) {
            this.writeMap((Map)object, writer, outputFormatSettings, queue);
        } else {
            throw new FormatterException(String.format("Cannot serialize a value of type %s.\nAt: %s", object.getClass().getSimpleName(), this.formatTrace(queue)));
        }
    }

    private void writeMap(Map<?, ?> map, Writer writer, OutputFormatSettings outputFormatSettings, Queue<String> queue) throws IOException, FormatterException {
        int n = map.size();
        if (n == 0) {
            writer.write("{ }");
            return;
        }
        boolean bl = false;
        int n2 = queue.size() + 1;
        if (outputFormatSettings.indent != 0) {
            if (outputFormatSettings.inlineMaps) {
                for (Iterator<Map.Entry<Object, Object>> iterator : map.values()) {
                    if (!this.isListOrMap(iterator)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
        }
        writer.write(123);
        int n3 = n;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (bl) {
                writer.write(System.lineSeparator());
                this.writeIndent(writer, outputFormatSettings, n2);
            } else {
                writer.write(32);
            }
            String string = entry.getKey().toString();
            writer.write(this.writeString(string, outputFormatSettings.quoteProps));
            writer.write(58);
            if (outputFormatSettings.spaceAfterProp) {
                writer.write(32);
            }
            queue.add("map:" + string);
            this.write(entry.getValue(), writer, outputFormatSettings, queue);
            queue.remove();
            if (!outputFormatSettings.commasInMaps || --n3 <= 0) continue;
            writer.write(44);
        }
        if (bl) {
            writer.write(System.lineSeparator());
            this.writeIndent(writer, outputFormatSettings, n2 - 1);
        } else {
            writer.write(32);
        }
        writer.write(125);
    }

    private void writeList(List<?> list, Writer writer, OutputFormatSettings outputFormatSettings, Queue<String> queue) throws IOException, FormatterException {
        int n;
        int n2 = list.size();
        if (n2 == 0) {
            writer.write("[ ]");
            return;
        }
        boolean bl = false;
        int n3 = queue.size() + 1;
        if (outputFormatSettings.indent != 0) {
            if (outputFormatSettings.inlineLists) {
                for (n = 0; n < n2; ++n) {
                    if (!this.isListOrMap(list.get(n))) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
        }
        writer.write(91);
        for (n = 0; n < n2; ++n) {
            if (bl) {
                writer.write(System.lineSeparator());
                this.writeIndent(writer, outputFormatSettings, n3);
            } else {
                writer.write(32);
            }
            queue.add("list#" + n);
            this.write(list.get(n), writer, outputFormatSettings, queue);
            queue.remove();
            if (!outputFormatSettings.commasInLists || n >= n2 - 1) continue;
            writer.write(44);
        }
        if (bl) {
            writer.write(System.lineSeparator());
            this.writeIndent(writer, outputFormatSettings, n3 - 1);
        } else {
            writer.write(32);
        }
        writer.write(93);
    }

    private void writeIndent(Writer writer, OutputFormatSettings outputFormatSettings, int n) throws IOException {
        int n2 = outputFormatSettings.indent * n;
        for (int i = 0; i < n2; ++i) {
            writer.write(32);
        }
    }

    private boolean isListOrMap(Object object) {
        return object instanceof List || object instanceof Map;
    }

    private String formatTrace(Queue<String> queue) {
        if (queue.size() == 0) {
            return "/";
        }
        if (queue.size() == 1) {
            return queue.poll();
        }
        StringBuilder stringBuilder = new StringBuilder(queue.size() * 5);
        for (String string : queue) {
            stringBuilder.append('/').append(Strings.replaceNonPrintable(string, '?', '_'));
        }
        return stringBuilder.toString();
    }

    private String writeString(String string, boolean bl) {
        if (bl) {
            return '\"' + Strings.escapeStringLiteral(string, 655360) + '\"';
        }
        return SimpleDataSerializer.quoteIfNeeded(string);
    }

    private String writeNumber(Number number, OutputFormatSettings outputFormatSettings) {
        return number.toString();
    }

    Token[] tokenize(CharSequence charSequence, int[] nArray, boolean bl, boolean bl2) throws SyntaxErrorException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        TokenPattern[] tokenPatternArray = TokenPattern.values();
        int n = 0;
        int n2 = charSequence.length();
        block0: while (n < n2) {
            for (TokenPattern tokenPattern : tokenPatternArray) {
                Token token = tokenPattern.match(charSequence, n);
                if (token == null) continue;
                n = token.end();
                boolean bl3 = bl && tokenPattern == TokenPattern.WHITESPACE || bl2 && tokenPattern == TokenPattern.COMMENT;
                if (bl3) continue block0;
                arrayList.add(token);
                continue block0;
            }
            throw this.syntaxErr("syntax error", n, nArray, charSequence.subSequence(n, Math.min(n + 8, n2)) + "...");
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    SyntaxErrorException syntaxErr(String string, int n, int[] nArray, @Nullable String string2) {
        int n2 = 0;
        int n3 = n;
        if (nArray != null && nArray.length >= 3) {
            int n4 = nArray.length - 3;
            for (int i = 3; i < nArray.length; i += 3) {
                if (nArray[i] <= n) continue;
                n4 = i - 3;
                break;
            }
            n2 = nArray[n4 + 1];
            n3 = n - nArray[n4] + nArray[n4 + 2];
        }
        return new SyntaxErrorException("Error parsing object tree: " + string, string2, n2 + 1, n3 + 1);
    }

    public static String quoteIfNeeded(String string) {
        if (identifierMatcher == null) {
            identifierMatcher = TokenPattern.IDENTIFIER.pattern().matcher(string);
        } else {
            identifierMatcher.reset(string);
        }
        if (identifierMatcher.matches()) {
            return string;
        }
        return '\"' + Strings.escapeStringLiteral(string, 655360) + '\"';
    }

    private Object parseSONValue(ParseContext parseContext) throws SyntaxErrorException {
        Token token = parseContext.next();
        switch (token.type()) {
            case BOOL: {
                return Boolean.valueOf(token.text());
            }
            case NUMBER: {
                return this.parseNumber(token, parseContext);
            }
            case IDENTIFIER: 
            case STRING: {
                return this.parseString(token, parseContext);
            }
            case NULL: {
                return null;
            }
            case OPEN_BRACKET: {
                return this.parseArray(parseContext);
            }
            case OPEN_BRACE: {
                return this.parseObject(parseContext);
            }
        }
        throw this.syntaxErr("unexpected " + token.type().name(), token.start(), parseContext.sourceIndex, token.text());
    }

    private Object parseArray(ParseContext parseContext) throws SyntaxErrorException {
        SSONList sSONList = new SSONList();
        Token token = parseContext.tokens[parseContext.pos - 1];
        while (parseContext.hasNext()) {
            Token token2 = parseContext.peek();
            if (token2.type() == TokenPattern.CLOSE_BRACKET) {
                parseContext.next();
                return sSONList;
            }
            sSONList.add(this.parseSONValue(parseContext));
            if (!parseContext.hasNext() || parseContext.peek().type() != TokenPattern.COMMA) continue;
            parseContext.next();
        }
        throw this.syntaxErr("array is missing its end-bracket", token.start(), parseContext.sourceIndex, null);
    }

    private Object parseObject(ParseContext parseContext) throws SyntaxErrorException {
        SSONMap sSONMap = new SSONMap();
        Token token = parseContext.tokens[parseContext.pos - 1];
        boolean bl = false;
        while (parseContext.hasNext()) {
            Token token2 = parseContext.next();
            if (token2.type() == TokenPattern.CLOSE_BRACE) {
                return sSONMap;
            }
            if (bl && token2.type() == TokenPattern.COMMA) {
                token2 = parseContext.next();
            }
            String string = this.parseString(token2, parseContext);
            if (!parseContext.hasNext() || parseContext.next().type() != TokenPattern.COLON) {
                throw this.syntaxErr("expected a colon (:) after property " + token2.text(), token2.end(), parseContext.sourceIndex, token2.text());
            }
            if (!parseContext.hasNext()) {
                throw this.syntaxErr("unexpected end of document -- expected a value for property \"" + token2.text(), token2.start(), parseContext.sourceIndex, token2.text());
            }
            sSONMap.put(string, this.parseSONValue(parseContext));
            bl = true;
        }
        throw this.syntaxErr("object is missing its end-brace", token.start(), parseContext.sourceIndex, null);
    }

    private Number parseNumber(Token token, ParseContext parseContext) throws SyntaxErrorException {
        try {
            return Double.parseDouble(token.text());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.syntaxErr("error parsing number (" + numberFormatException.getMessage() + ")", token.start(), parseContext.sourceIndex, token.text());
        }
    }

    private String parseString(Token token, ParseContext parseContext) throws SyntaxErrorException {
        if (token.type() == TokenPattern.STRING) {
            String string = token.text();
            try {
                return Strings.unescapeStringLiteral(string.substring(1, string.length() - 1));
            }
            catch (ParseException parseException) {
                throw this.syntaxErr("error parsing escape sequence in string", token.start() + parseException.getErrorOffset() + 1, parseContext.sourceIndex, token.text());
            }
        }
        if (token.type() == TokenPattern.IDENTIFIER) {
            return token.text();
        }
        throw this.syntaxErr("unexpected " + token.type().name(), token.start(), parseContext.sourceIndex, token.text());
    }

    public static class SSONMap
    extends LinkedHashMap<String, Object> {
        public int get(String string, int n) {
            return Convert.toInt(this.get(string), n);
        }

        public double get(String string, double d) {
            return Convert.toDouble(this.get(string), d);
        }

        public String get(String string, String string2) {
            return Convert.toString(this.get(string), string2);
        }

        public float get(String string, float f) {
            return Convert.toFloat(this.get(string), f);
        }

        public boolean get(String string, boolean bl) {
            return Convert.toBool(this.get(string), bl);
        }

        public SSONMap getMap(String string) {
            Object v = this.get(string);
            if (v instanceof SSONMap) {
                return (SSONMap)v;
            }
            throw new IllegalArgumentException(String.format("The value of property '%s' is of type %s, not SSONMap.", string, v == null ? "Null" : v.getClass().getSimpleName()));
        }

        public SSONList getList(String string) {
            Object v = this.get(string);
            if (v instanceof SSONList) {
                return (SSONList)v;
            }
            throw new IllegalArgumentException(String.format("The value of property '%s' is of type %s, not SSONList.", string, v == null ? "Null" : v.getClass().getSimpleName()));
        }

        public SSONList putList(String string) {
            SSONList sSONList = new SSONList();
            this.put(string, sSONList);
            return sSONList;
        }

        public SSONMap putMap(String string) {
            SSONMap sSONMap = new SSONMap();
            this.put(string, sSONMap);
            return sSONMap;
        }

        public boolean containsAnyKey(String ... stringArray) {
            for (String string : stringArray) {
                if (!this.containsKey(string)) continue;
                return true;
            }
            return false;
        }
    }

    public static class SSONList
    extends ArrayList<Object> {
        public SSONMap addMap() {
            SSONMap sSONMap = new SSONMap();
            this.add(sSONMap);
            return sSONMap;
        }

        public SSONList addList() {
            SSONList sSONList = new SSONList();
            this.add(sSONList);
            return sSONList;
        }
    }

    private class ParseContext {
        public int pos;
        public int[] sourceIndex;
        public Token[] tokens;

        public ParseContext(Token[] tokenArray, int n, int[] nArray) {
            this.pos = n;
            this.sourceIndex = nArray;
            this.tokens = tokenArray;
        }

        public Token next() throws SyntaxErrorException {
            if (this.pos >= this.tokens.length) {
                throw SimpleDataSerializer.this.syntaxErr("unexpected end of document", this.last() == null ? 0 : this.last().end(), this.sourceIndex, null);
            }
            return this.tokens[this.pos++];
        }

        public boolean hasNext() {
            return this.pos < this.tokens.length;
        }

        public Token peek() {
            return this.tokens[this.pos];
        }

        public Token last() {
            return this.tokens.length == 0 ? null : this.tokens[this.tokens.length - 1];
        }
    }

    static class Token {
        private final Matcher m;
        private final TokenPattern p;

        public TokenPattern type() {
            return this.p;
        }

        public int start() {
            return this.m.start();
        }

        public int end() {
            return this.m.end();
        }

        public int length() {
            return this.m.end() - this.m.start();
        }

        public String text() {
            return this.m.group(0);
        }

        public String group(int n) {
            return this.m.group(n);
        }

        public String group(String string) {
            return this.m.group(string);
        }

        public MatchResult result() {
            return this.m;
        }

        public Token(Matcher matcher, TokenPattern tokenPattern) {
            this.m = matcher;
            this.p = tokenPattern;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + ": " + this.type().name() + " \"" + Strings.escapeStringLiteral(this.text()) + "\"}";
        }
    }

    static enum TokenPattern {
        NUMBER(Pattern.compile("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?(?=\\s|[:{}()\\[\\]\"]|$)")),
        STRING(Pattern.compile("\"(?:[^\\\\\"]|\\\\(?:[abfnrt\"\\\\']|c[@-~]|x[A-Za-z0-9]{2}|u[A-Za-z0-9]{4}|[0-7]{1,3}))*+\"")),
        BOOL(Pattern.compile("true|false", 2)),
        NULL(Pattern.compile("null", 2)),
        IDENTIFIER(Pattern.compile("\\p{L}[\\p{L}\\p{N}\\p{Pc}_.-]*(?=\\s|[:{}()\\[\\]\"]|$)")),
        WHITESPACE(Pattern.compile("\\s+")),
        COMMENT(Pattern.compile("//[^\\n]*+|/\\*(?:[^*]|\\*(?!/))*+\\*/")),
        OPEN_BRACKET(Pattern.compile("\\[")),
        CLOSE_BRACKET(Pattern.compile("\\]")),
        OPEN_BRACE(Pattern.compile("\\{")),
        CLOSE_BRACE(Pattern.compile("\\}")),
        COMMA(Pattern.compile(",")),
        COLON(Pattern.compile(":")),
        SYM_PERCENT(Pattern.compile("%")),
        SYM_BAR(Pattern.compile("\\|"));

        private final Pattern p;

        private TokenPattern(Pattern pattern) {
            this.p = pattern;
        }

        public Pattern pattern() {
            return this.p;
        }

        public Token match(CharSequence charSequence, int n) {
            return this.match(charSequence, n, charSequence.length());
        }

        public Token match(CharSequence charSequence, int n, int n2) {
            Matcher matcher = this.p.matcher(charSequence).region(n, n2);
            if (matcher.lookingAt()) {
                return new Token(matcher, this);
            }
            return null;
        }
    }

    public static class OutputFormatSettings
    implements Cloneable {
        public static final OutputFormatSettings SSON = new OutputFormatSettings(0, false, false, true, true, false, false, false);
        public static final OutputFormatSettings PrettySSON;
        public static final OutputFormatSettings JSON;
        public static final OutputFormatSettings PrettyJSON;
        public int indent;
        public boolean quoteAlways;
        public boolean quoteProps;
        public boolean inlineLists;
        public boolean inlineMaps;
        public boolean commasInLists;
        public boolean commasInMaps;
        public boolean spaceAfterProp;

        public OutputFormatSettings() {
        }

        public OutputFormatSettings(int n, boolean bl) {
            this(n, bl, bl, !bl, !bl, bl, bl, bl);
        }

        public OutputFormatSettings(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
            this.indent = n;
            this.quoteAlways = bl;
            this.quoteProps = bl2;
            this.inlineLists = bl3;
            this.inlineMaps = bl4;
            this.commasInLists = bl5;
            this.commasInMaps = bl6;
            this.spaceAfterProp = bl7;
        }

        public OutputFormatSettings clone() {
            try {
                return (OutputFormatSettings)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OutputFormatSettings outputFormatSettings = (OutputFormatSettings)object;
            if (this.indent != outputFormatSettings.indent) {
                return false;
            }
            if (this.quoteAlways != outputFormatSettings.quoteAlways) {
                return false;
            }
            if (this.quoteProps != outputFormatSettings.quoteProps) {
                return false;
            }
            if (this.inlineLists != outputFormatSettings.inlineLists) {
                return false;
            }
            if (this.inlineMaps != outputFormatSettings.inlineMaps) {
                return false;
            }
            if (this.commasInLists != outputFormatSettings.commasInLists) {
                return false;
            }
            if (this.commasInMaps != outputFormatSettings.commasInMaps) {
                return false;
            }
            return this.spaceAfterProp == outputFormatSettings.spaceAfterProp;
        }

        public int hashCode() {
            int n = this.indent;
            n = 31 * n + (this.quoteAlways ? 1 : 0);
            n = 31 * n + (this.quoteProps ? 1 : 0);
            n = 31 * n + (this.inlineLists ? 1 : 0);
            n = 31 * n + (this.inlineMaps ? 1 : 0);
            n = 31 * n + (this.commasInLists ? 1 : 0);
            n = 31 * n + (this.commasInMaps ? 1 : 0);
            n = 31 * n + (this.spaceAfterProp ? 1 : 0);
            return n;
        }

        static {
            JSON = new OutputFormatSettings(0, true, true, false, false, true, true, true);
            PrettySSON = SSON.clone();
            OutputFormatSettings.PrettySSON.indent = 2;
            PrettyJSON = JSON.clone();
            OutputFormatSettings.PrettyJSON.indent = 2;
        }
    }
}

