/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.File;
import java.io.Serializable;
import javax.swing.UIManager;
import ur_rna.Utilities.PathTools;

public class OSInfo
implements Serializable {
    private static final long serialVersionUID = 20120802L;
    private static final OSType osType = OSInfo.getOSType(System.getProperty("os.name"));

    public static String getDocumentsDirPath() {
        File file = OSInfo.getDocumentsDir();
        return file == null ? null : file.getPath();
    }

    public static File getDocumentsDir() {
        File file = new File(System.getProperty("user.home"));
        File file2 = PathTools.getFirstExisting(file, true, false, "Documents", "My Documents", "Docs", "docs");
        return file2 == null ? file : file2;
    }

    private static OSType getOSType(String string) {
        if (string != null) {
            if ((string = string.toLowerCase()).contains("windows")) {
                return OSType.WINDOWS;
            }
            if (string.contains("linux")) {
                return OSType.LINUX;
            }
            if (string.contains("solaris") || string.contains("sunos")) {
                return OSType.SOLARIS;
            }
            if (string.contains("os x")) {
                return OSType.MACOSX;
            }
        }
        return OSType.UNKNOWN;
    }

    public static void applyNativeLookAndFeel() {
        if (OSInfo.isMac()) {
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        String string = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            System.err.println("Error setting native Look-And-Feel to " + string);
            exception.printStackTrace();
        }
    }

    public static void useNativeMenus() {
        if (OSInfo.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
    }

    public static OSType getOSType() {
        return osType;
    }

    public static boolean isMac() {
        return osType == OSType.MACOSX;
    }

    public static boolean isWin() {
        return osType == OSType.WINDOWS;
    }

    public static boolean isNix() {
        return osType == OSType.LINUX;
    }

    public static enum OSType {
        WINDOWS,
        LINUX,
        SOLARIS,
        MACOSX,
        UNKNOWN;

    }
}

