/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ConverterFilter<T, C> {
    public abstract boolean passes(T var1);

    public abstract C convert(T var1);

    public Iterator<C> filter(Iterator<T> iterator) {
        return new FilterIterator(iterator);
    }

    public Iterable<C> filter(final Iterable<T> iterable) {
        return new Iterable<C>(){

            @Override
            public Iterator<C> iterator() {
                return ConverterFilter.this.filter(iterable.iterator());
            }
        };
    }

    private class FilterIterator
    implements Iterator<C> {
        private static final int ITERATING = 0;
        private static final int AWAITING_CONSUMER = 1;
        private static final int AT_END = -1;
        private int state = 0;
        private Iterator<T> iterator;
        private T foundItem;

        private FilterIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.state != -1 && this.moveToNext();
        }

        @Override
        public C next() {
            this.moveToNext();
            if (this.state == 1) {
                this.state = 0;
            }
            return ConverterFilter.this.convert(this.foundItem);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean moveToNext() {
            switch (this.state) {
                case 0: {
                    while (this.iterator.hasNext()) {
                        Object t = this.iterator.next();
                        if (!ConverterFilter.this.passes(t)) continue;
                        this.foundItem = t;
                        this.state = 1;
                        return true;
                    }
                    this.state = -1;
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            throw new NoSuchElementException();
        }
    }

    public abstract class SimpleCast
    extends ConverterFilter {
        public Object convert(Object object) {
            return object;
        }
    }
}

