/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.lang.reflect.Method;
import java.util.Collection;
import ur_rna.Utilities.Version;
import ur_rna.Utilities.annotation.ApplicationInfo;
import ur_rna.Utilities.annotation.NotNull;

public class AppInfo {
    private static Class<?> mainClass;
    private static String appName;
    private static String appTitle;
    private static Version appVersion;
    private static AppInfoProvider provider;

    @NotNull
    public static String getAppTitle() {
        if (appTitle == null) {
            appTitle = System.getProperty("APP_TITLE");
        }
        if (appTitle == null) {
            appTitle = System.getenv("JAVA_APP_TITLE");
        }
        if (appTitle == null) {
            appTitle = AppInfo.getProvider().getAppTitle();
        }
        return appTitle;
    }

    @NotNull
    public static String getAppName() {
        if (appName == null) {
            appName = System.getProperty("APP_NAME");
        }
        if (appName == null) {
            appName = System.getenv("JAVA_APP_NAME");
        }
        if (appName == null) {
            appName = AppInfo.getProvider().getAppName();
        }
        return appName;
    }

    @NotNull
    public static Version getAppVersion() {
        if (appVersion == null) {
            appVersion = Version.tryParse(System.getProperty("APP_VERSION"));
        }
        if (appVersion == null) {
            appVersion = Version.tryParse(System.getenv("JAVA_APP_VERSION"));
        }
        if (appVersion == null) {
            appVersion = AppInfo.getProvider().getAppVersion();
        }
        return appVersion;
    }

    public static void setAppName(String string) {
        appName = string;
    }

    public static void setAppTitle(String string) {
        appTitle = string;
    }

    public static void setProvider(AppInfoProvider appInfoProvider) {
        provider = appInfoProvider;
    }

    public static void setMainClass(Class<?> clazz) {
        mainClass = clazz;
    }

    @NotNull
    public static AppInfoProvider getProvider() {
        if (provider != null) {
            return provider;
        }
        Class<?> clazz = AppInfo.getMainClass();
        if (clazz != null) {
            try {
                Method method = clazz.getMethod("getAppInfo", new Class[0]);
                provider = (AppInfoProvider)method.invoke(null, new Object[0]);
                return provider;
            }
            catch (Exception exception) {
                try {
                    ApplicationInfo applicationInfo = clazz.getAnnotation(ApplicationInfo.class);
                    if (applicationInfo != null) {
                        return new AnnotationAppInfoProvider(applicationInfo);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        provider = new AppInfoProvider(){
            private final Version ver = new Version("0.0");

            @Override
            public String getAppTitle() {
                return "JavaApplication";
            }

            @Override
            public String getAppName() {
                return "JavaApplication";
            }

            @Override
            public Version getAppVersion() {
                return this.ver;
            }
        };
        return provider;
    }

    public static Class<?> getMainClass() {
        if (mainClass != null) {
            return mainClass;
        }
        Collection<StackTraceElement[]> collection = Thread.getAllStackTraces().values();
        for (StackTraceElement[] stackTraceElementArray : collection) {
            StackTraceElement stackTraceElement;
            if (stackTraceElementArray.length == 0 || !(stackTraceElement = stackTraceElementArray[stackTraceElementArray.length - 1]).getMethodName().equals("main")) continue;
            try {
                String string = stackTraceElement.getClassName();
                mainClass = Class.forName(string);
                return mainClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return null;
    }

    public static interface AppInfoProvider {
        @NotNull
        public String getAppTitle();

        @NotNull
        public String getAppName();

        @NotNull
        public Version getAppVersion();
    }

    public static class AnnotationAppInfoProvider
    implements AppInfoProvider {
        public final ApplicationInfo info;
        public final Version ver;

        public AnnotationAppInfoProvider(ApplicationInfo applicationInfo) {
            this.info = applicationInfo;
            this.ver = new Version(applicationInfo.version());
        }

        @Override
        public String getAppTitle() {
            return this.info.title();
        }

        @Override
        public String getAppName() {
            return this.info.name();
        }

        @Override
        public Version getAppVersion() {
            return this.ver;
        }
    }
}

