/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import ur_rna.RNAstructureUI.AppMainFrame;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.ui.BorderBuilder;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.ScrollerPane;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.utilities.Resources;
import ur_rna.RNAstructureUI.windows.FoldSingleWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.annotation.Nullable;
import ur_rna.Utilities.swing.CheckMergeItem;
import ur_rna.Utilities.swing.MergeItem;
import ur_rna.Utilities.swing.MergeMenu;

public class SequenceDisplayWindow
extends InternalWindow {
    private static final long serialVersionUID = 20120802L;
    private static final String ignoreChars = " \r\n\t-";
    private static final String standardBases = "ACGTU";
    private static final String unpairedBases = "acgtu";
    private static final String unspecifiedBases = "xXN";
    private static final String allowedChars = " \r\n\t-ACGTUacgtuxXN";
    private Font defaultFont = new Font("Monospaced", 0, 12);
    private JTextArea titleBox;
    private JTextArea commentBox;
    private JTextPane sequenceBox;
    private StyledDocument sequenceDoc;
    private boolean edited = false;
    private boolean userAcceptedInvalidSequence = false;
    private int speakPosition = 0;
    private JButton speakButton;
    private boolean speakWhileTyping = false;
    private boolean speakingFullSequence = false;
    private Timer speakTimer;
    private Timer styleTimer;
    private Style styleStandardBase;
    private Style styleInvalidChar;
    private Style styleUnpairedBase;
    private Style styleUnspecifiedBase;
    private Style styleIgnoredChar;
    private SoundPlayer _speakPlayer = new SoundPlayer();
    private HashMap<Character, InputStream> _speakStreams;
    private InputStream invalidSoundClip;
    SpeakMenu speakMenu;

    public SequenceDisplayWindow() {
        this.setCaption("New Sequence");
        this.getCustomMenus().enableMenus();
        this.setDefaultCloseOperation(0);
        this.titleBox = new JTextArea();
        JPanel jPanel = this.buildTextBoxPanel(40, "Title:", this.titleBox, "titleBox");
        this.commentBox = new JTextArea();
        JPanel jPanel2 = this.buildTextBoxPanel(50, "Comment:", this.commentBox, "commentBox");
        this.sequenceDoc = this.CreateStyledDocument();
        this.sequenceBox = new JTextPane(this.sequenceDoc);
        JPanel jPanel3 = this.buildTextBoxPanel(200, "Sequence: (Nucleotides in lower case are forced single stranded in structure predictions.)", this.sequenceBox, "sequenceBox");
        Box box = Box.createVerticalBox();
        box.add(jPanel);
        box.add(jPanel2);
        box.add(jPanel3);
        box.add(this.buildButtonPanel());
        this.add(box);
        this.setResizable(true);
        this.sequenceBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (SequenceDisplayWindow.this.speakWhileTyping && !SequenceDisplayWindow.this.speakingFullSequence) {
                    char c = keyEvent.getKeyChar();
                    int n = keyEvent.getModifiers();
                    if (this.isPrintableChar(c)) {
                        SequenceDisplayWindow.this.speakSeqChar(c);
                    }
                }
            }

            private boolean isPrintableChar(char c) {
                if (Character.isISOControl(c) || c == '\uffff') {
                    return false;
                }
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
                return unicodeBlock != null && unicodeBlock != Character.UnicodeBlock.SPECIALS;
            }
        });
        final SequenceDisplayWindow sequenceDisplayWindow = this;
        final JButton jButton = (JButton)AppMainFrame.getFrame().getToolBar().getComponent(3);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                jButton.addActionListener(sequenceDisplayWindow);
                jButton.setEnabled(true);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                if (!SequenceDisplayWindow.this.edited) {
                    internalFrameEvent.getInternalFrame().dispose();
                    return;
                }
                String string = "The sequence has been modified.\nSave Changes?";
                String string2 = Dialogs.showYesNoCancel(string);
                if (string2.equals("YES")) {
                    String string3 = SequenceDisplayWindow.this.saveSequence();
                    if (Strings.isEmpty(string3)) {
                        internalFrameEvent.getInternalFrame().dispose();
                    }
                } else if (string2.equals("NO")) {
                    internalFrameEvent.getInternalFrame().dispose();
                }
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                jButton.removeActionListener(sequenceDisplayWindow);
                jButton.setEnabled(false);
            }
        });
        this.speakTimer = new Timer(100, this);
        this.speakTimer.setActionCommand("SpeakTimer");
        this.styleTimer = new Timer(250, this);
        this.styleTimer.setActionCommand("UpdateStyles");
    }

    public SequenceDisplayWindow(String string) {
        this();
        this.setCaption(string);
        if (!new File(string).exists()) {
            Dialogs.showMessage("The specified file does not exist: \n" + string);
        } else {
            this.userAcceptedInvalidSequence = false;
            this.backend.readSequenceData(string);
            this.titleBox.setText(this.backend.getSequenceTitle().trim());
            this.commentBox.setText(this.backend.getSequenceComment().trim());
            this.setSequenceText(this.backend.getSequenceData().trim());
            this.markEdited(false);
        }
    }

    private void setSequenceText(String string) {
        this.sequenceDoc.setCharacterAttributes(0, this.sequenceDoc.getLength(), this.styleStandardBase, true);
        this.sequenceBox.setText(string);
        this.sequenceDoc.setCharacterAttributes(0, this.sequenceDoc.getLength(), this.styleStandardBase, true);
    }

    void markEdited(boolean bl) {
        this.edited = bl;
    }

    @Override
    public void showWindow() {
        super.showWindow();
        this.setSize(680, 480);
    }

    private JPanel buildButtonPanel() {
        String[] stringArray = new String[]{"Format Sequence", "Fold as DNA", "Fold as RNA", "Save Sequence"};
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        for (int i = 0; i < stringArray.length; ++i) {
            JButton jButton = new JButton(stringArray[i]);
            jButton.addActionListener(this);
            jPanel.add(jButton);
        }
        return jPanel;
    }

    private JPanel buildTextBoxPanel(int n, String string, JTextComponent jTextComponent, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string), "North");
        jTextComponent.setName(string2);
        jPanel.setName(string2 + "Panel");
        jTextComponent.setFont(this.defaultFont);
        jTextComponent.setBackground(Color.WHITE);
        jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.docUpdate(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.docUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.docUpdate(documentEvent);
            }

            public void docUpdate(DocumentEvent documentEvent) {
                SequenceDisplayWindow.this.styleTimer.restart();
                SequenceDisplayWindow.this.edited = true;
            }
        });
        ScrollerPane scrollerPane = new ScrollerPane(jTextComponent, 100, n);
        jPanel.add(scrollerPane);
        BorderBuilder borderBuilder = new BorderBuilder();
        borderBuilder.makeEqualBorder(5, jPanel);
        return jPanel;
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        block19: {
            if (commandInfo.command.startsWith("Fold")) {
                String string = this.getTitle();
                if (this.edited && (string = this.saveSequence()).equals("")) {
                    return;
                }
                this.dispose();
                String string2 = commandInfo.command.endsWith("RNA") ? "RNA" : "DNA";
                FoldSingleWindow foldSingleWindow = new FoldSingleWindow(string2);
                foldSingleWindow.showWindow();
                foldSingleWindow.setDataAutomatically(string);
            } else if (commandInfo.command.equals("Format Sequence")) {
                this.formatSequenceBox();
            } else if (commandInfo.command.startsWith("Save")) {
                boolean bl;
                boolean bl2 = bl = commandInfo.command.equals("Save Sequence") && !this.getTitle().equals("New Sequence");
                if (bl) {
                    this.saveSequence(this.getTitle());
                } else {
                    this.saveSequence();
                }
            } else if (commandInfo.command.equals("SpeakTimer")) {
                if (this._speakPlayer.isPlaying()) {
                    return;
                }
                try {
                    JTextPane jTextPane = this.sequenceBox;
                    if (this.speakPosition != jTextPane.getText().length()) {
                        if (!this.isVisible()) {
                            this.speakTimer.stop();
                        }
                        jTextPane.getCaret().setSelectionVisible(false);
                        jTextPane.select(this.speakPosition, this.speakPosition + 1);
                        Character c = Character.valueOf(jTextPane.getSelectedText().toUpperCase().charAt(0));
                        if (c.charValue() != ' ') {
                            jTextPane.getCaret().setSelectionVisible(true);
                            this.speakSeqChar(c.charValue());
                        }
                        ++this.speakPosition;
                        break block19;
                    }
                    this.speakFullSequence(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (commandInfo.command.equals("UpdateStyles")) {
                this.UpdateSyntaxStyles();
            } else {
                super.processCommand(commandInfo);
            }
        }
    }

    private StyledDocument CreateStyledDocument() {
        StyleContext styleContext = new StyleContext();
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(styleContext);
        this.styleStandardBase = styleContext.getStyle("default");
        this.styleStandardBase.addAttribute(StyleConstants.FontFamily, this.defaultFont.getFamily());
        this.styleStandardBase.addAttribute(StyleConstants.FontSize, this.defaultFont.getSize());
        this.styleInvalidChar = styleContext.addStyle("Error", this.styleStandardBase);
        this.styleInvalidChar.addAttribute(StyleConstants.Background, new Color(0xFFCCCC));
        this.styleInvalidChar.addAttribute(StyleConstants.Foreground, new Color(0x990000));
        this.styleUnpairedBase = styleContext.addStyle("Unpaired", this.styleStandardBase);
        this.styleUnpairedBase.addAttribute(StyleConstants.Background, new Color(0x66FFFF));
        this.styleUnspecifiedBase = styleContext.addStyle("Unspecified", this.styleStandardBase);
        this.styleUnspecifiedBase.addAttribute(StyleConstants.Background, new Color(13625062));
        this.styleIgnoredChar = styleContext.addStyle("Ignored", this.styleStandardBase);
        this.styleIgnoredChar.addAttribute(StyleConstants.Foreground, new Color(0x666666));
        return defaultStyledDocument;
    }

    private void UpdateSyntaxStyles() {
        this.UpdateSyntaxStyles(0, this.sequenceDoc.getLength());
    }

    private void UpdateSyntaxStyles(int n, int n2) {
        boolean bl = this.edited;
        try {
            n2 = Math.min(this.sequenceDoc.getLength(), n2);
            n = Math.max(n, 0);
            char[] cArray = this.sequenceDoc.getText(n, n2).toCharArray();
            for (int i = 0; i < n2; ++i) {
                this.setCharStyle(n + i, this.getCharStyle(cArray[i]));
            }
        }
        catch (Exception exception) {
            AppLog.getDefault().error("Error updating styles in sequence file.", exception);
        }
        if (!bl) {
            this.markEdited(false);
        }
    }

    private void setCharStyle(int n, Style style) {
        if (!style.getName().equals(this.sequenceDoc.getCharacterElement(n).getAttributes().getAttribute(StyleConstants.NameAttribute))) {
            this.sequenceDoc.setCharacterAttributes(n, 1, style, true);
        }
    }

    private Style getCharStyle(char c) {
        if (this.isInvalidSeqChar(c)) {
            return this.styleInvalidChar;
        }
        if (this.isUnpairedSeqChar(c)) {
            return this.styleUnpairedBase;
        }
        if (this.isUnspecifiedSeqChar(c)) {
            return this.styleUnspecifiedBase;
        }
        if (this.isIgnoredSeqChar(c)) {
            return this.styleIgnoredChar;
        }
        return this.styleStandardBase;
    }

    private boolean isInvalidSeqChar(char c) {
        return allowedChars.indexOf(c) == -1 && !Character.isWhitespace(c);
    }

    private boolean isUnpairedSeqChar(char c) {
        return unpairedBases.indexOf(c) != -1;
    }

    private boolean isUnspecifiedSeqChar(char c) {
        return unspecifiedBases.indexOf(c) != -1;
    }

    private boolean isIgnoredSeqChar(char c) {
        return ignoreChars.indexOf(c) != -1;
    }

    private void speakFullSequence(boolean bl) {
        this.speakPosition = 0;
        this.speakingFullSequence = bl;
        this.speakMenu.speakSequence.setText(bl ? "Stop Speaking" : "Speak Sequence");
        if (bl) {
            this.speakTimer.start();
        } else {
            this.speakTimer.stop();
        }
    }

    private boolean verifySequence() {
        int n;
        if (this.userAcceptedInvalidSequence) {
            return true;
        }
        char[] cArray = this.sequenceBox.getText().toCharArray();
        HashSet<String> hashSet = null;
        for (int i = 0; i < cArray.length; ++i) {
            n = cArray[i];
            if (!this.isInvalidSeqChar((char)n)) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.sequenceBox.select(i, i + 1);
            }
            hashSet.add(Strings.escapeStringLiteral(Character.toString((char)n)));
        }
        if (hashSet != null && hashSet.size() > 0) {
            String string = "The sequence contains one or more invalid characters (" + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)hashSet) + ").\nSaving the file with invalid characters could result in unexpected behavior when the file is processed by this or another program.";
            n = JOptionPane.showOptionDialog(this, string + "\n\nDo you want to save the file anyway?", "Invalid Character(s) in Sequence", 0, 2, null, null, null);
            this.sequenceBox.grabFocus();
            if (n != 0) {
                return false;
            }
            this.userAcceptedInvalidSequence = true;
        }
        return true;
    }

    private void formatSequenceBox() {
        boolean bl = this.edited;
        this.sequenceBox.setEnabled(false);
        this.setSequenceText(this.formatSequence(this.sequenceBox.getText()));
        this.sequenceBox.setEnabled(true);
        this.markEdited(this.edited);
    }

    private String formatSequence(String string) {
        try {
            int n = 0;
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (char c : string.toCharArray()) {
                if (Character.isWhitespace(c)) continue;
                if (n == 10) {
                    n = 0;
                    if (++n2 == 5) {
                        stringBuilder.append(" \n");
                        n2 = 0;
                    } else {
                        stringBuilder.append(' ');
                    }
                }
                stringBuilder.append(c);
                ++n;
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            Dialogs.showError("error formatting sequence.");
            return string;
        }
    }

    private void loadSpeakClips() {
        this._speakStreams = new HashMap();
        for (char c : "ACGTUX".toCharArray()) {
            this._speakStreams.put(Character.valueOf(c), this.loadClip(Character.toString(c)));
        }
        this.invalidSoundClip = this.loadClip("invalid");
    }

    private InputStream loadClip(String string) {
        try {
            int n;
            InputStream inputStream = Resources.get("sounds/" + string + ".wav");
            int n2 = 0;
            byte[] byArray = new byte[inputStream.available()];
            while (0 < (n = inputStream.read(byArray, n2, inputStream.available()))) {
                n2 += n;
            }
            return new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            AppLog.getDefault().error("Failed to load audio file.", exception);
            return null;
        }
    }

    private void speakSeqChar(char c) {
        InputStream inputStream;
        if (this._speakStreams == null) {
            this.loadSpeakClips();
        }
        if ((inputStream = this._speakStreams.get(Character.valueOf(Character.toUpperCase(c)))) == null && this.isInvalidSeqChar(c)) {
            inputStream = this.invalidSoundClip;
        }
        this._speakPlayer.play(inputStream);
    }

    public String saveSequence() {
        String string = StandardFileChooser.getSaveName(FileFilters.Sequence, this.getTitle(), "Save Sequence", "sequence", this);
        if (string == null) {
            return "";
        }
        return this.saveSequence(string);
    }

    public String saveSequence(String string) {
        if (!this.verifySequence()) {
            return "";
        }
        this.backend.setSequenceTitle(this.titleBox.getText().trim());
        this.backend.setSequenceComment(this.commentBox.getText().trim());
        this.backend.setSequenceData(this.sequenceBox.getText().trim());
        if (string.toLowerCase().endsWith(".fasta")) {
            this.backend.writeFastaFile(string);
        } else {
            this.backend.writeSequenceFile(string);
        }
        this.setCaption(string);
        this.markEdited(false);
        return string;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        MainMenu mainMenu = new MainMenu("File", this);
        mainMenu.setSubItemMergePos(-100);
        mainMenu.addItem("Save Sequence", "Save a sequence with its existing name.", 'S');
        mainMenu.addItem("Save Sequence As...", "Save a sequence with a new name.", "*+S");
        mainMenu.addSeparator();
        this.speakMenu = new SpeakMenu(this);
        return new MergeMenu[]{mainMenu, new EditMenu(), this.speakMenu};
    }

    public void setSpeakWhileTyping(boolean bl) {
        this.speakWhileTyping = bl;
    }

    private class SpeakMenu
    extends MainMenu {
        private static final long serialVersionUID = 20120802L;
        public final SequenceDisplayWindow parent;
        public final CheckMergeItem speakWhileTyping;
        public final MergeItem speakSequence;

        public SpeakMenu(SequenceDisplayWindow sequenceDisplayWindow2) {
            super("Speak");
            this.parent = sequenceDisplayWindow2;
            this.speakWhileTyping = this.addCheckItem("Speak While Typing", "Read a sequence out loud as it is typed into the keyboard.");
            this.speakSequence = this.addItem("Speak Sequence", "Read the entire sequence out loud.");
        }

        @Override
        protected void onMenuAction(String string, ActionEvent actionEvent) {
            this.parent.setSpeakWhileTyping(this.speakWhileTyping.isSelected());
            if (string.equals("Speak Sequence")) {
                boolean bl = !this.parent.speakingFullSequence;
                this.parent.speakFullSequence(bl);
            }
        }
    }

    private class EditMenu
    extends MainMenu {
        private static final long serialVersionUID = 20120802L;

        public EditMenu() {
            super("Edit");
            this.addItem("Cut", "Cut a block of text to the clipboard.", 'X');
            this.addItem("Copy", "Copy a block of text to the clipboard.", 'C');
            this.addItem("Paste", "Paste a block of text from the clipboard.", 'V');
        }

        @Override
        protected void onMenuAction(String string, ActionEvent actionEvent) {
            DefaultEditorKit.CutAction cutAction = string.equals("Cut") ? new DefaultEditorKit.CutAction() : (string.equals("Copy") ? new DefaultEditorKit.CopyAction() : new DefaultEditorKit.PasteAction());
            cutAction.actionPerformed(null);
        }
    }

    private class SoundPlayer {
        private Clip _line;
        private InputStream _currentClip;
        private final Deque<InputStream> _queue = new ArrayDeque<InputStream>();
        private boolean _paused;
        private boolean _playing;

        private SoundPlayer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void play(@Nullable InputStream inputStream) {
            Deque<InputStream> deque = this._queue;
            synchronized (deque) {
                if (inputStream == null) {
                    return;
                }
                this._queue.addFirst(inputStream);
                this.playNext();
            }
        }

        private Clip createLine(AudioFormat audioFormat) {
            try {
                Clip clip = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, audioFormat));
                clip.addLineListener(new LineListener(){

                    @Override
                    public void update(LineEvent lineEvent) {
                        if (lineEvent.getType() == LineEvent.Type.STOP) {
                            try {
                                SoundPlayer.this._line.close();
                                SoundPlayer.this._currentClip.reset();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            SoundPlayer.this.playNext();
                        }
                    }
                });
                return clip;
            }
            catch (Exception exception) {
                String string = "error speaking sequence.";
                Dialogs.showError(string);
                return null;
            }
        }

        public void pause(boolean bl) {
            if (this._paused == bl) {
                return;
            }
            this._paused = bl;
            if (this._line == null) {
                return;
            }
            if (this._paused) {
                this._line.stop();
            } else {
                this._line.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void playNext() {
            InputStream inputStream;
            if (this._paused) {
                return;
            }
            if (this._line != null && this._line.isRunning()) {
                return;
            }
            Object object = this._queue;
            synchronized (object) {
                inputStream = this._queue.pollLast();
            }
            if (inputStream == null) {
                this._playing = false;
            } else {
                try {
                    inputStream.mark(inputStream.available());
                    this._currentClip = inputStream;
                    object = AudioSystem.getAudioInputStream(inputStream);
                    AudioFormat audioFormat = ((AudioInputStream)object).getFormat();
                    if (this._line == null) {
                        this._line = this.createLine(audioFormat);
                        if (this._line == null) {
                            return;
                        }
                    }
                    this._line.open((AudioInputStream)object);
                    this._playing = true;
                    this._line.start();
                    inputStream.reset();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public boolean isPlaying() {
            return this._playing && !this._paused;
        }
    }
}

