/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class RefoldWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public RefoldWindow() {
        super("", "Refold From Save File");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        if (commandInfo.command.equals("CT File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Save File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.FoldingSav);
            if (string == null) {
                return;
            }
            String string2 = this.backend.buildRefoldSingleDataStructure(string);
            if (!this.verifyBackendResult(string2, "File: %s", string)) {
                return;
            }
            String string3 = RefoldWindow.getOutputFile(string, "ct");
            filePanel.setFile(1, string);
            filePanel.setFile(2, string3);
            this.getCustomMenus().enableMenus();
            int n = this.backend.getRefoldWindowSize();
            ((NumberField.IntegerField)fieldPanel.getField(3)).resetField(n, 0, Integer.MAX_VALUE);
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Save File").inputFile(FileFilters.FoldingSav);
        FileField fileField2 = FileField.createEnabled("CT File").outputFile(FileFilters.CT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        NumberField.IntegerField integerField = new NumberField.IntegerField("Max % Energy Difference", 10, (Integer)1);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Max Number of Structures", 20, (Integer)1);
        NumberField.IntegerField integerField3 = new NumberField.IntegerField("Window Size", 0, (Integer)0);
        FieldPanel fieldPanel = new FieldPanel(integerField, integerField2, integerField3);
        fieldPanel.setPanelWidth(250);
        fieldPanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setGrid(1, 1);
        this.placeComponent(0, 1, fieldPanel);
        this.makeStartButton(1, 1);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        Integer n = ((NumberField.IntegerField)fieldPanel.getField(1)).getValue();
        Integer n2 = ((NumberField.IntegerField)fieldPanel.getField(2)).getValue();
        Integer n3 = ((NumberField.IntegerField)fieldPanel.getField(3)).getValue();
        this.showProgress();
        String string2 = this.backend.runRefold(string, n, n2, n3);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        return this.drawStructures(string);
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        ConstraintsMenu constraintsMenu2 = new ConstraintsMenu(this.backend);
        constraintsMenu2.addShowResetSection();
        ConstraintsMenu constraintsMenu3 = new ConstraintsMenu(this.backend);
        constraintsMenu3.buildMaxLoopMenu();
        return new ConstraintsMenu[]{constraintsMenu, constraintsMenu2, constraintsMenu3};
    }
}

