/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.JTextComponent;
import ur_rna.RNAstructure.backend.ProgressHandler;
import ur_rna.RNAstructure.backend.RNA;
import ur_rna.RNAstructure.backend.SimpleProgressHandler;
import ur_rna.RNAstructure.backend.TwoRNA;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.RNAstructureBackendCalculator;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.RecentFileButton;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileType;
import ur_rna.RNAstructureUI.utilities.MRUFileStorage;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.Utilities.Convert;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.swing.FormValidationException;

public abstract class PredictWindowBase
extends InternalWindow {
    public static final double TEMP_37C = 310.15;
    private Timer uiUpdateTimer;
    protected JPanel pnlClient = new JPanel();
    protected JPanel pnlContent = new JPanel();
    private HashMap<String, FileFieldInfo> fileFields = new HashMap();
    private HashMap<JComponent, FieldInfo> fields = new HashMap();
    private BackgroundTask runningTask = null;
    protected DecimalFormat numberFormatter = new DecimalFormat("0.#######");
    private static String[] controlPrefixes = "txt lbl chk opt rdo spn pnl btn cmd scrl fld cmp cmb lst cbo uic ui".split(" ");

    protected void addFileField(String string, JTextComponent jTextComponent, String string2) {
        this.addFileField(string, jTextComponent, string2, false, null);
    }

    protected void addFileField(String string, JTextComponent jTextComponent, String string2, boolean bl) {
        this.addFileField(string, jTextComponent, string2, bl, null);
    }

    protected void addFileField(String string, JTextComponent jTextComponent, String string2, boolean bl, String string3) {
        this.fileFields.put(string, new FileFieldInfo(jTextComponent, string2, bl, string3));
    }

    protected void addField(JComponent jComponent, String string, String string2) {
        this.fields.put(jComponent, new FieldInfo(jComponent, string, string2));
    }

    protected FileFieldInfo getFileField(String string, boolean bl) {
        FileFieldInfo fileFieldInfo = this.fileFields.get(string);
        if (fileFieldInfo == null && bl) {
            Dialogs.showWarning("Programming error: No file field info for \"" + string + "\"");
        }
        return fileFieldInfo;
    }

    protected FileFieldInfo getFileField(JTextComponent jTextComponent, boolean bl) {
        for (FileFieldInfo fileFieldInfo : this.fileFields.values()) {
            if (jTextComponent != fileFieldInfo.txt) continue;
            return fileFieldInfo;
        }
        if (bl) {
            Dialogs.showWarning("Programming error: No file field info for component \"" + this.getControlDescription(jTextComponent) + "\"");
        }
        return null;
    }

    public PredictWindowBase() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlClient, gridBagConstraints);
        this.pnlClient.setLayout(new GridBagLayout());
    }

    void setContent(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.pnlClient.add((Component)jPanel, gridBagConstraints);
        this.pnlContent = jPanel;
    }

    protected void startUiTimer() {
        if (this.uiUpdateTimer == null) {
            this.uiUpdateTimer = new Timer(200, actionEvent -> this.updateFormUI());
        }
        this.uiUpdateTimer.start();
    }

    protected void stopUiTimer() {
        if (this.uiUpdateTimer != null) {
            this.uiUpdateTimer.stop();
        }
    }

    protected abstract void updateFormUI();

    protected void listenForActions(JComponent jComponent) {
        this.listenForActions(jComponent, AbstractButton.class, this);
    }

    protected void listenForActions(JComponent jComponent, Class<? extends AbstractButton> clazz, ActionListener actionListener) {
        if (actionListener == null) {
            actionListener = this;
        }
        for (Component component : jComponent.getComponents()) {
            if (clazz.isAssignableFrom(component.getClass())) {
                ((AbstractButton)component).addActionListener(actionListener);
            }
            if (!(component instanceof JComponent) || ((JComponent)component).getComponentCount() == 0) continue;
            this.listenForActions((JComponent)component, clazz, actionListener);
        }
    }

    protected void listenForActions(AbstractButton ... abstractButtonArray) {
        for (AbstractButton abstractButton : abstractButtonArray) {
            abstractButton.addActionListener(this);
        }
    }

    protected BackgroundTask getRunningTask() {
        return this.runningTask;
    }

    @Override
    protected boolean frameClosing(InternalFrameEvent internalFrameEvent) {
        this.handleSettings(true);
        return this.cancelRunningTask() && super.frameClosing(internalFrameEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.startsWith("browse-")) {
            this.browseFile(this.getFileField(string.substring(7), true));
        } else if (string.startsWith("recent-")) {
            this.browseRecentFile(object instanceof JComponent ? (JComponent)object : null, this.getFileField(string.substring(7), true));
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void pack() {
        super.pack();
        if (this.pnlContent != null) {
            this.setSize(this.getWidth(), this.pnlContent.getHeight() + 10 + this.getHeight() - this.pnlClient.getHeight());
        }
    }

    protected boolean cancelRunningTask() {
        if (this.runningTask == null) {
            return true;
        }
        if (this.runningTask.isCancelable()) {
            this.runningTask.cancel();
            return true;
        }
        Dialogs.showWarning("The current running calculation cannot be canceled at this time.\nPlease wait for it to complete.\nThis calculation may have periods during which it can be canceled and others when it cannot.");
        return false;
    }

    @Override
    public void showWindow() {
        this.setLocation(0, 0);
        this.pack();
        this.setVisible(true);
    }

    protected String formatValue(Object object) {
        if (object instanceof Number) {
            return this.numberFormatter.format(object);
        }
        return object.toString();
    }

    protected String getControlDescription(JComponent jComponent) {
        Component[] componentArray;
        FieldInfo fieldInfo = this.fields.get(jComponent);
        if (fieldInfo != null && fieldInfo.desc != null) {
            return fieldInfo.desc;
        }
        if (jComponent instanceof AbstractButton && !Strings.isWhiteSpace((String)(componentArray = ((AbstractButton)jComponent).getText()))) {
            return componentArray;
        }
        for (Component component : jComponent.getParent().getComponents()) {
            if (!(component instanceof JLabel) || ((JLabel)component).getLabelFor() != jComponent) continue;
            String string = ((JLabel)component).getText().trim();
            if (string.endsWith(":")) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        return this.stripControlPrefix(this.getSettingsName(jComponent));
    }

    protected String stripControlPrefix(String string) {
        for (String string2 : controlPrefixes) {
            if (!string.startsWith(string2)) continue;
            return string.substring(string2.length());
        }
        return string;
    }

    protected abstract void handleSettings(boolean var1);

    protected Object getControlValue(JComponent jComponent) {
        if (jComponent instanceof JSpinner) {
            return ((JSpinner)jComponent).getValue();
        }
        if (jComponent instanceof AbstractButton) {
            return ((AbstractButton)jComponent).isSelected();
        }
        if (jComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText();
        }
        if (jComponent instanceof JComboBox) {
            return ((JComboBox)jComponent).getSelectedIndex();
        }
        Dialogs.showWarning("Unknown field type in getControlValue: " + jComponent.getClass().getTypeName());
        return null;
    }

    protected void setControlValue(JComponent jComponent, Object object) {
        if (jComponent instanceof JSpinner) {
            ((JSpinner)jComponent).setValue(Convert.toType(object, ((JSpinner)jComponent).getValue()));
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setSelected(Convert.toBool(object));
        } else if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setText(object.toString());
        } else if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).setSelectedIndex(Convert.toInt(object));
        } else {
            Dialogs.showWarning("Unknown field type in setControlValue: " + jComponent.getClass().getTypeName());
        }
    }

    protected void handleRecentControlValues(boolean bl, String string, Iterable<JComponent> iterable) {
        Preferences preferences = RNAstructure.getPrefs().node(string);
        for (JComponent jComponent : iterable) {
            String string2 = this.getSettingsName(jComponent);
            Object object = this.getControlValue(jComponent);
            if (bl) {
                if (object == null) {
                    preferences.remove(string2);
                    continue;
                }
                preferences.put(string2, this.formatValue(object));
                continue;
            }
            String string3 = object == null ? null : object.toString();
            this.setControlValue(jComponent, preferences.get(string2, string3));
        }
    }

    protected void loadRecent(String string, JComponent ... jComponentArray) {
        this.handleRecentControlValues(false, string, Arrays.asList(jComponentArray));
    }

    protected void saveRecent(String string, JComponent ... jComponentArray) {
        this.handleRecentControlValues(true, string, Arrays.asList(jComponentArray));
    }

    protected void autoSetFieldNames() {
        Field[] fieldArray;
        for (Field field : fieldArray = this.getClass().getDeclaredFields()) {
            try {
                JComponent jComponent;
                field.setAccessible(true);
                if (!JComponent.class.isAssignableFrom(field.getType()) || (jComponent = (JComponent)field.get(this)) == null || !Strings.isEmpty(jComponent.getName())) continue;
                jComponent.setName(field.getName());
            }
            catch (Exception exception) {
                System.out.println("Error in autoSetFieldNames: " + exception.toString());
            }
        }
    }

    protected String getSettingsName(JComponent jComponent) {
        FieldInfo fieldInfo = this.fields.get(jComponent);
        if (fieldInfo != null && fieldInfo.name != null) {
            return fieldInfo.name;
        }
        String string = jComponent.getName();
        if (string != null) {
            return string;
        }
        if (jComponent instanceof JRadioButton) {
            return "opt" + ((JRadioButton)jComponent).getText();
        }
        if (jComponent instanceof JCheckBox) {
            return "chk" + ((JCheckBox)jComponent).getText();
        }
        Dialogs.showWarning("Unknown field type in getSettingsName: " + jComponent.getClass().getTypeName());
        return jComponent.getClass().getTypeName();
    }

    protected void saveRecentFiles(JTextField ... jTextFieldArray) {
        MRUFileStorage mRUFileStorage = RNAstructure.MRUFiles;
        for (JTextField jTextField : jTextFieldArray) {
            String string = jTextField.getText();
            if (Strings.isEmpty(string)) continue;
            mRUFileStorage.add(string);
        }
        mRUFileStorage.saveToStorage();
    }

    protected void browseRecentFile(JComponent jComponent, FileFieldInfo fileFieldInfo) {
        if (fileFieldInfo != null) {
            RecentFileButton.showRecentFileMenu(jComponent, fileFieldInfo.filters, file -> {
                fileFieldInfo.txt.setText(file.toString());
                if (!Strings.isEmpty(fileFieldInfo.actionWhenSet)) {
                    this.actionPerformed(new ActionEvent(fileFieldInfo.txt, 1001, fileFieldInfo.actionWhenSet));
                }
            });
        }
    }

    protected boolean browseFile(FileFieldInfo fileFieldInfo) {
        if (fileFieldInfo != null && this.browseFile(fileFieldInfo.txt, fileFieldInfo.filters, fileFieldInfo.isOutput)) {
            if (!Strings.isEmpty(fileFieldInfo.actionWhenSet)) {
                this.actionPerformed(new ActionEvent(fileFieldInfo.txt, 1001, fileFieldInfo.actionWhenSet));
            }
            return true;
        }
        return false;
    }

    protected boolean browseFile(JTextComponent jTextComponent, String string, boolean bl) {
        String string2 = bl ? StandardFileChooser.getSaveName(string, jTextComponent.getText()) : StandardFileChooser.getOpenName(string, jTextComponent.getText());
        if (string2 != null) {
            jTextComponent.setText(string2);
        }
        return string2 != null;
    }

    protected <TTask extends BackgroundTask> void runInBackground(final TTask TTask, final Consumer<TTask> consumer) {
        if (this.runningTask != null) {
            Dialogs.showWarning("Another calculation is currently running. Please wait for that one to finish before starting a new one.");
            return;
        }
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                PredictWindowBase.this.runningTask = TTask;
                TTask.run();
                return null;
            }

            @Override
            protected void done() {
                consumer.accept(TTask);
                PredictWindowBase.this.runningTask = null;
            }
        };
        swingWorker.execute();
    }

    protected void enableDescendants(Container container, boolean bl, Component ... componentArray) {
        for (Component component : container.getComponents()) {
            if (ObjTools.contains(componentArray, component)) continue;
            component.setEnabled(bl);
            if (!(component instanceof Container) || ((Container)component).getComponentCount() == 0) continue;
            this.enableDescendants((Container)component, bl, componentArray);
        }
    }

    protected static DrawingWindow launchDrawing(String string, FileType fileType, String string2, FileType fileType2, int n) {
        if (!PathTools.isFile(string)) {
            Dialogs.showError("The drawing cannot be created because a necessary file was not found.\n(Possibly because it was moved or deleted after the calculation.)\nFile: " + string);
            return null;
        }
        if (string2 != null && !PathTools.isFile(string2)) {
            Dialogs.showError("The drawing cannot be created because a necessary file was not found.\n(Possibly because it was moved or deleted after the calculation.)\nFile: " + string2);
            return null;
        }
        DrawingWindow drawingWindow = new DrawingWindow(string, n, fileType);
        if (drawingWindow.isError()) {
            Dialogs.showWarning("Failed to draw: " + string);
            drawingWindow.dispose();
            return null;
        }
        drawingWindow.showWindow();
        if (string2 != null) {
            drawingWindow.getStructure().setAnnotation(string2, fileType2);
            if (drawingWindow.isError()) {
                Dialogs.showWarning("Failed to add color annotations from file: " + string2);
            }
        }
        return drawingWindow;
    }

    protected void setSpin(JSpinner jSpinner, double d, double d2, double d3, double d4) {
        jSpinner.setModel(new SpinnerNumberModel(d, d2, d3, d4));
    }

    protected void setSpin(JSpinner jSpinner, int n, int n2, int n3, int n4) {
        jSpinner.setModel(new SpinnerNumberModel(n, n2, n3, n4));
    }

    protected void setSpin(JSpinner jSpinner, double d, double d2, double d3) {
        jSpinner.setModel(new SpinnerNumberModel(d, d2, d3, 0.1));
    }

    protected void setSpin(JSpinner jSpinner, int n, int n2, int n3) {
        jSpinner.setModel(new SpinnerNumberModel(n, n2, n3, 1));
    }

    protected void setSpin(JSpinner jSpinner, double d) {
        jSpinner.setModel(new SpinnerNumberModel((Number)d, null, null, (Number)1));
    }

    protected void setSpin(JSpinner jSpinner, int n) {
        jSpinner.setModel(new SpinnerNumberModel((Number)n, null, null, (Number)1));
    }

    protected int getSpinInt(JSpinner jSpinner) {
        return ((Number)jSpinner.getValue()).intValue();
    }

    protected double getSpinDbl(JSpinner jSpinner) {
        return ((Number)jSpinner.getValue()).doubleValue();
    }

    protected Number getSpin(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    protected void validateFailed(JComponent jComponent, String string, Object ... objectArray) throws FormValidationException {
        if (objectArray.length != 0) {
            string = String.format(string, objectArray);
        }
        if (jComponent != null) {
            string = string.replace("<FIELD>", this.getControlDescription(jComponent));
        }
        throw new FormValidationException(string, jComponent);
    }

    protected void validateFileField(JTextComponent jTextComponent, boolean bl, boolean bl2) throws FormValidationException {
        String string = jTextComponent.getText().trim();
        if (string.isEmpty()) {
            if (!bl) {
                this.validateFailed(jTextComponent, "The <FIELD> entry cannot be blank. Please enter a valid file path.", new Object[0]);
            }
        } else if (bl2) {
            File file = new File(string).getParentFile();
            if (!file.isDirectory()) {
                this.validateFailed(jTextComponent, "The <FIELD> must be saved in an existing directory.\n(%s does not exist)", file.toString());
            }
        } else if (!PathTools.isFile(string)) {
            this.validateFailed(jTextComponent, "The <FIELD> was not found. Please enter a valid file path.", new Object[0]);
        }
    }

    protected void validateFileField(JTextComponent jTextComponent, boolean bl) throws FormValidationException {
        this.validateFileField(jTextComponent, bl, false);
    }

    protected void validateRequiredField(JTextComponent jTextComponent) throws FormValidationException {
        String string = jTextComponent.getText().trim();
        if (string.isEmpty()) {
            this.validateFailed(jTextComponent, "The <FIELD> entry cannot be blank.", new Object[0]);
        }
    }

    protected void focusField(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        jComponent.grabFocus();
    }

    public static abstract class PredictTaskBase
    implements BackgroundTask {
        public boolean hadError;
        public String errorMessage;
        protected ProgressHandler stepProgress = new SimpleProgressHandler();
        protected String status = "Starting calculation...";
        protected boolean canCancel = false;
        protected boolean isCanceled = false;
        protected int workDone;
        protected int nextStepWork;

        protected void setError(String string) {
            this.hadError = true;
            this.errorMessage = string;
        }

        protected void nextStep(String string, boolean bl, int n) {
            this.canCancel = bl;
            this.status = string;
            this.workDone += this.nextStepWork;
            this.stepProgress.update(0);
            this.nextStepWork = n;
        }

        @Override
        public int getProgress() {
            return this.workDone + this.stepProgress.progress() * this.nextStepWork / 100;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        @Override
        public boolean isCancelable() {
            return this.canCancel;
        }

        @Override
        public void cancel() {
            this.stepProgress.cancel();
            this.isCanceled = true;
            this.status = "Canceling calculation...";
        }

        @Override
        public void run() {
            block3: {
                try {
                    this.runCalc();
                    if (!this.hadError) {
                        this.nextStep("Done.", false, 0);
                    }
                }
                catch (Exception exception) {
                    if (this.hadError) break block3;
                    this.setError("Uncaught exception in runCalc: " + exception.toString());
                }
            }
        }

        public boolean onComplete() {
            try {
                if (this.isCanceled) {
                    return false;
                }
                Thread.yield();
                if (this.hadError) {
                    Dialogs.showWarning(this.errorMessage);
                    return false;
                }
                return this.showResults();
            }
            catch (Exception exception) {
                Dialogs.showError("An unexpected error occurred while post-processing the calculations results:\n" + exception.toString());
                return false;
            }
        }

        protected abstract void runCalc();

        protected abstract boolean showResults();

        protected boolean checkError(String ... stringArray) {
            for (String string : stringArray) {
                if (Strings.isWhiteSpace(string)) continue;
                this.setError(string);
                return true;
            }
            return false;
        }

        protected boolean checkError(RNAstructureBackendCalculator ... rNAstructureBackendCalculatorArray) {
            for (RNAstructureBackendCalculator rNAstructureBackendCalculator : rNAstructureBackendCalculatorArray) {
                if (rNAstructureBackendCalculator.GetErrorCode() == 0) continue;
                this.setError(rNAstructureBackendCalculator.GetFullErrorMessage());
                return true;
            }
            return false;
        }

        protected boolean checkError(RNA ... rNAArray) {
            for (RNA rNA : rNAArray) {
                if (rNA.GetErrorCode() == 0) continue;
                this.setError(rNA.GetFullErrorMessage());
                return true;
            }
            return false;
        }

        protected boolean checkError(int ... nArray) {
            for (int n : nArray) {
                if (n == 0) continue;
                this.setError(RNA.GetErrorMessage(n));
                return true;
            }
            return false;
        }

        protected boolean checkError(TwoRNA ... twoRNAArray) {
            for (TwoRNA twoRNA : twoRNAArray) {
                if (twoRNA.GetErrorCode() == 0) continue;
                this.setError(twoRNA.GetErrorMessage(twoRNA.GetErrorCode()) + twoRNA.GetErrorDetails());
                return true;
            }
            return false;
        }
    }

    protected static interface BackgroundTask
    extends Runnable {
        public int getProgress();

        public String getStatus();

        @Override
        public void run();

        public boolean isCancelable();

        public void cancel();
    }

    class FieldInfo {
        public String name;
        public String desc;
        public JComponent field;

        public FieldInfo(JComponent jComponent, String string, String string2) {
            this.name = string2;
            this.desc = string;
            this.field = jComponent;
        }
    }

    class FileFieldInfo {
        boolean isOutput;
        String filters;
        JTextComponent txt;
        String actionWhenSet;

        FileFieldInfo(JTextComponent jTextComponent, String string, boolean bl, String string2) {
            this.isOutput = bl;
            this.txt = jTextComponent;
            this.filters = string;
            this.actionWhenSet = string2;
        }
    }
}

