/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ur_rna.RNAstructureUI.ui.BorderBuilder;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.HTMLCheckBox;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.MultiWindow;

public class MultilignWindow
extends MultiWindow {
    private static final long serialVersionUID = 20120802L;

    public MultilignWindow(String string) {
        super(string, "Multilign");
    }

    @Override
    protected void activate() {
        this.backend.activateMultilign();
    }

    @Override
    protected void addBackendTuple(String string, String string2) {
        this.backend.addMultilignTuple(string, string2);
    }

    @Override
    protected void buildSpecificOptionsPanel() {
        BorderBuilder borderBuilder = new BorderBuilder();
        int n = 340;
        FileField fileField = FileField.createEnabled("Alignment File");
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField);
        filePanel.setPanelWidth(350);
        filePanel.makePanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setPreferredSize(new Dimension(350, 375));
        borderBuilder.makeEqualBorder(10, jTabbedPane);
        NumberField.IntegerField integerField = new NumberField.IntegerField("Max % Energy Difference", 20, (Integer)0);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Max Number of Structures", 20, (Integer)1);
        NumberField numberField = new NumberField.IntegerField("Structure Window Size", 2, (Integer)0);
        JComponent jComponent = new NumberField.IntegerField("Alignment Window Size", 1, (Integer)0);
        JComponent jComponent2 = new NumberField.DoubleField("Gap Penalty", 0.4);
        FieldPanel fieldPanel = new FieldPanel(new JTextField[]{integerField, integerField2, numberField, jComponent, jComponent2});
        fieldPanel.setPanelWidth(n);
        fieldPanel.makePanel();
        HTMLCheckBox hTMLCheckBox = HTMLCheckBox.createSelectedBox("Single BP Inserts Allowed");
        borderBuilder.makeLeftBorder(10, hTMLCheckBox);
        HTMLCheckBox hTMLCheckBox2 = HTMLCheckBox.createEmptyBox("Generate Save Files and Alignment Files");
        borderBuilder.makeLeftBorder(10, hTMLCheckBox2);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setPreferredSize(new Dimension(n, 30));
        jPanel.add(hTMLCheckBox);
        jPanel.add(hTMLCheckBox2);
        Box box = Box.createVerticalBox();
        box.add(fieldPanel);
        box.add(jPanel);
        box.add(Box.createVerticalGlue());
        jTabbedPane.addTab("Dynalign Parameters", box);
        integerField = new NumberField.IntegerField("Iterations", 2, (Integer)1);
        integerField2 = new NumberField.IntegerField("MaxPairs", 0, (Integer)0);
        numberField = new NumberField.DoubleField("maxdsvchange", 1, 0, 99);
        jComponent = new FieldPanel(integerField, integerField2, numberField);
        ((FieldPanel)jComponent).setPanelWidth(n);
        ((FieldPanel)jComponent).makePanel();
        jComponent2 = Box.createVerticalBox();
        jComponent2.add(jComponent);
        jComponent2.add(Box.createVerticalGlue());
        jTabbedPane.addTab("Multilign Parameters", jComponent2);
        this.options.add(filePanel);
        this.options.add(jTabbedPane);
    }

    @Override
    protected void deleteBackendTuple(int n) {
        this.backend.deleteMultilignTuple(n);
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        Box box = (Box)this.getInputControl(3);
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(box, 1);
        JTabbedPane jTabbedPane = (JTabbedPane)this.getInputControl(box, 2);
        Box box2 = (Box)this.getInputControl(jTabbedPane, 2);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(box2, 1);
        if (commandInfo.command.equals("ADD -->")) {
            boolean bl;
            super.processCommand(commandInfo);
            int n = this.backend.getMultilignMaxPairs();
            ((NumberField.IntegerField)fieldPanel.getField(2)).resetField(n);
            boolean bl2 = bl = filePanel.getFile(1).equals("") && this.getNumSequences() == 2;
            if (bl) {
                String string = System.getProperty("user.home") + System.getProperty("file.separator") + "multi.ali";
                filePanel.setFile(1, string);
            }
        } else if (commandInfo.command.equals("Alignment File")) {
            int n = 1;
            String string = StandardFileChooser.getSaveName(FileFilters.Alignment, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Delete Sequence")) {
            super.processCommand(commandInfo);
            int n = this.backend.getMultilignMaxPairs();
            ((NumberField.IntegerField)fieldPanel.getField(2)).resetField(n);
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected int getNumSequences() {
        return this.backend.getNumMultilignSequences();
    }

    @Override
    protected String getSequenceSetAsString() {
        return this.backend.getMultilignSequenceSetData();
    }

    @Override
    protected boolean runMainCalculationMultipleSequences() {
        this.showProgress();
        Box box = (Box)this.getInputControl(3);
        JTabbedPane jTabbedPane = (JTabbedPane)this.getInputControl(box, 2);
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(box, 1);
        filePanel.saveRecent();
        String string = filePanel.getFile(1);
        if (filePanel.isError()) {
            return false;
        }
        Box box2 = (Box)this.getInputControl(jTabbedPane, 1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(box2, 1);
        Integer n = ((NumberField.IntegerField)fieldPanel.getField(1)).getValue();
        Integer n2 = ((NumberField.IntegerField)fieldPanel.getField(2)).getValue();
        Integer n3 = ((NumberField.IntegerField)fieldPanel.getField(3)).getValue();
        Integer n4 = ((NumberField.IntegerField)fieldPanel.getField(4)).getValue();
        Double d = ((NumberField.DoubleField)fieldPanel.getField(5)).getValue();
        JPanel jPanel = (JPanel)this.getInputControl(box2, 2);
        boolean bl = ((HTMLCheckBox)this.getInputControl(jPanel, 1)).isSelected();
        boolean bl2 = ((HTMLCheckBox)this.getInputControl(jPanel, 2)).isSelected();
        Box box3 = (Box)this.getInputControl(jTabbedPane, 2);
        FieldPanel fieldPanel2 = (FieldPanel)this.getInputControl(box3, 1);
        Integer n5 = ((NumberField.IntegerField)fieldPanel2.getField(1)).getValue();
        Integer n6 = ((NumberField.IntegerField)fieldPanel2.getField(2)).getValue();
        Double d2 = ((NumberField.DoubleField)fieldPanel2.getField(3)).getValue();
        this.showProgress();
        String string2 = this.backend.runMultilign(n, n2, n3, n4, d, bl, d2, n6, n5, string, bl2, this.isRNA);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        if (!MultilignWindow.promptDraw()) {
            return true;
        }
        this.showDrawProgress();
        for (int i = 1; i <= this.getNumSequences(); ++i) {
            String string3 = this.backend.getMultilignCT(i);
            this.imageDialogs.add(new DrawingWindow(string3));
        }
        this.showImageDialogs();
        return true;
    }
}

