/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.HTMLCheckBox;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class Efn2Window
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public Efn2Window(String string) {
        super(string, string + " Efn2");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("CT File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.CT);
            if (string == null) {
                return;
            }
            String string2 = this.backend.buildEfn2DataStructure(string, this.isRNA);
            if (!this.verifyBackendResult(string2, "File: %s\nRNA: %s", string, this.isRNA)) {
                return;
            }
            String string3 = Efn2Window.getOutputFile(string, "out");
            filePanel.setFile(1, string);
            filePanel.setFile(2, string3);
            this.getCustomMenus().enableMenus();
        } else if (commandInfo.command.equals("Output File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.OUT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("CT File").inputFile(FileFilters.CT);
        FileField fileField2 = FileField.createEnabled("Output File").setFilters(FileFilters.OUT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        HTMLCheckBox hTMLCheckBox = HTMLCheckBox.createEmptyBox("Write Thermodynamic Details File");
        this.setGrid(1, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setGrid(2, 1);
        this.setFillCenter();
        this.placeComponent(0, 1, hTMLCheckBox);
        this.setAnchorNorth();
        this.setGrid(1, 1);
        this.makeStartButton(2, 0);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        HTMLCheckBox hTMLCheckBox = (HTMLCheckBox)this.getInputControl(2);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        boolean bl = hTMLCheckBox.isSelected();
        this.showProgress(false);
        String string2 = this.backend.runEfn2(string, bl);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        Dialogs.showMessage("Efn2 Complete.");
        return true;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        return new ConstraintsMenu[]{constraintsMenu};
    }
}

