/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.utilities;

import ur_rna.RNAstructure.backend.RNABackend;
import ur_rna.Utilities.PathTools;

public enum FileType {
    CT(RNABackend.FILE_CT),
    SEQ(RNABackend.FILE_SEQ),
    PFS(RNABackend.FILE_PFS),
    SAV(RNABackend.FILE_SAV),
    DBN(RNABackend.FILE_DBN),
    SHAPE(RNABackend.FILE_DBN + 1);

    private final int value;

    private FileType(int n2) {
        this.value = n2;
    }

    public int backendValue() {
        return this.value;
    }

    public boolean equals(int n) {
        return n == this.value;
    }

    public static FileType guessTypeFromFilePath(String string) {
        String string2 = PathTools.getExt(string, false, false);
        switch (string2 = string2.toUpperCase()) {
            case "CT": {
                return CT;
            }
            case "SEQ": 
            case "FA": 
            case "FASTA": {
                return SEQ;
            }
            case "PFS": {
                return PFS;
            }
            case "SAV": 
            case "FSV": {
                return SAV;
            }
            case "DBN": 
            case "DOT": 
            case "BRACKET": 
            case "BRK": {
                return DBN;
            }
        }
        return null;
    }
}

