/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.utilities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import ur_rna.Utilities.EventArgs;
import ur_rna.Utilities.EventSource;
import ur_rna.Utilities.Strings;

public abstract class BackgroundWorker
extends SwingWorker<Void, Void>
implements PropertyChangeListener {
    public static final int DEFAULT_UPDATE_INTERVAL = 250;
    protected String status = "";
    protected boolean progressIndeterminate;
    private final ArrayList<ErrorInfo> errors = new ArrayList();
    public final EventSource.TwoArgs<BackgroundWorker, Integer> ProgressChange = new EventSource.TwoArgs();
    public final EventSource.TwoArgs<BackgroundWorker, StateChangeEventArgs> StateChange = new EventSource.TwoArgs();
    public final EventSource.TwoArgs<BackgroundWorker, String> StatusChange = new EventSource.TwoArgs();
    public final EventSource.OneArg<BackgroundWorker> WorkDone = new EventSource.OneArg();

    public BackgroundWorker() {
        this.addPropertyChangeListener(this);
    }

    public void setStatus(String string) {
        String string2 = this.status;
        this.status = string;
        this.firePropertyChange("status", string2, string);
    }

    public void setProgressIndeterminate(boolean bl) {
        this.progressIndeterminate = bl;
        int n = this.getProgress();
        this.firePropertyChange("progress", n, -1);
    }

    public boolean isProgressIndeterminate() {
        return this.progressIndeterminate;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        switch (propertyChangeEvent.getPropertyName()) {
            case "state": {
                StateChangeEventArgs stateChangeEventArgs = new StateChangeEventArgs((SwingWorker.StateValue)((Object)propertyChangeEvent.getOldValue()), (SwingWorker.StateValue)((Object)propertyChangeEvent.getNewValue()));
                this.stateChanged(stateChangeEventArgs.old, stateChangeEventArgs.state);
                this.StateChange.invoke(this, stateChangeEventArgs);
                if (!SwingWorker.StateValue.DONE.equals((Object)stateChangeEventArgs.state)) break;
                this.WorkDone.invoke(this);
                break;
            }
            case "progress": {
                this.progressChanged((Integer)propertyChangeEvent.getNewValue());
                break;
            }
            case "status": {
                this.statusChanged((String)propertyChangeEvent.getNewValue());
            }
        }
    }

    protected void progressChanged(int n) {
        this.ProgressChange.invoke(this, n);
    }

    protected void stateChanged(SwingWorker.StateValue stateValue, SwingWorker.StateValue stateValue2) {
        this.StateChange.invoke(this, new StateChangeEventArgs(stateValue, stateValue2));
    }

    protected void statusChanged(String string) {
        this.StatusChange.invoke(this, string);
    }

    @Override
    protected void process(List<Void> list) {
        super.process(list);
        for (Void void_ : list) {
            this.processOutput(void_);
        }
    }

    protected void processOutput(Object object) {
    }

    public void setError(Exception exception) {
        this.setError(null, exception);
    }

    public void setError(String string) {
        this.setError(string, null);
    }

    public void setError(String string, Exception exception) {
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.message = string;
        errorInfo.ex = exception;
        this.errors.add(errorInfo);
    }

    public boolean hadErrors() {
        return this.errors.size() != 0;
    }

    public List<ErrorInfo> getErrors() {
        return this.errors;
    }

    public String getErrorMessages() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (ErrorInfo errorInfo : this.errors) {
            stringBuilder.append(String.format("%4d.", ++n));
            stringBuilder.append("  ");
            if (!Strings.isEmpty(errorInfo.message)) {
                stringBuilder.append(errorInfo.message);
            } else if (errorInfo.ex != null) {
                stringBuilder.append(errorInfo.ex.getMessage());
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    protected Void doInBackground() {
        try {
            this.work();
        }
        catch (Exception exception) {
            this.setError("Uncaught error while running background calculation.", exception);
        }
        return null;
    }

    public abstract void work();

    public static class ErrorInfo {
        public String message;
        public Exception ex;
    }

    public static class StateChangeEventArgs
    extends EventArgs {
        public final SwingWorker.StateValue old;
        public final SwingWorker.StateValue state;

        public StateChangeEventArgs(SwingWorker.StateValue stateValue, SwingWorker.StateValue stateValue2) {
            this.old = stateValue;
            this.state = stateValue2;
        }
    }
}

