/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.ui;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import ur_rna.RNAstructureUI.AppMainFrame;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;

public class StandardFileChooser
extends JFileChooser {
    private static final String DEFAULT_CONTEXT = "(default)";
    public static final String PREFS = "recent-file-locations";
    private boolean fileShouldExist;
    private boolean isCurDirSet;
    private String context;
    private static HashMap<String, File> recentDirs;
    private boolean modifyDir = true;
    private static Preferences recentPathPreferences;
    private static String preemptFileName;
    private static String preemptFiltersRequired;
    private static long preemptTimeout;

    public static void loadRecentPaths() {
        StandardFileChooser.loadRecentPaths(null);
    }

    public static void loadRecentPaths(Preferences preferences) {
        try {
            if (preferences == null) {
                preferences = StandardFileChooser.getDefaultPreferenceStorage();
            }
            Preferences preferences2 = recentPathPreferences = preferences;
            if (recentDirs == null) {
                recentDirs = new HashMap();
            } else {
                recentDirs.clear();
            }
            for (String string : preferences2.keys()) {
                StandardFileChooser.setRecentDir(string, preferences2.get(string, null));
            }
            if (StandardFileChooser.getRecentDir(null, true) == null) {
                StandardFileChooser.setRecentDir(null, PathTools.getHomeDir());
            }
        }
        catch (BackingStoreException backingStoreException) {
            AppLog.getDefault().error("Failed to load recent paths.", backingStoreException);
        }
    }

    public static void saveRecentPaths() {
        StandardFileChooser.saveRecentPaths(recentPathPreferences);
    }

    public static void saveRecentPaths(Preferences preferences) {
        try {
            if (preferences == null) {
                preferences = StandardFileChooser.getDefaultPreferenceStorage();
            }
            for (String string : recentDirs.keySet()) {
                File file = recentDirs.get(string);
                if (file == null) continue;
                preferences.put(string, file.toString());
            }
            preferences.flush();
        }
        catch (Exception exception) {
            AppLog.getDefault().error("Failed to save recent paths.", exception);
        }
    }

    private static Preferences getDefaultPreferenceStorage() {
        return Preferences.userNodeForPackage(StandardFileChooser.class).node(PREFS);
    }

    public static File getRecentDir(String string) {
        return StandardFileChooser.getRecentDir(string, false, null);
    }

    public static File getRecentDirOrDefault(String string, boolean bl) {
        return StandardFileChooser.getRecentDir(string, bl, recentDirs.get(DEFAULT_CONTEXT));
    }

    public static File getRecentDir(String string, boolean bl) {
        return StandardFileChooser.getRecentDir(string, bl, null);
    }

    public static File getRecentDir(String string, boolean bl, File file) {
        File file2;
        if (recentDirs == null) {
            StandardFileChooser.loadRecentPaths();
        }
        if (Strings.isEmpty(string)) {
            string = DEFAULT_CONTEXT;
        }
        if ((file2 = recentDirs.get(string)) == null || bl && !file2.exists()) {
            return file;
        }
        return file2;
    }

    public static void setRecentDir(String string, String string2) {
        StandardFileChooser.setRecentDir(string, PathTools.fileFromPath(string2));
    }

    public static void setRecentDir(String string, File file) {
        if (recentDirs == null) {
            StandardFileChooser.loadRecentPaths();
        }
        if (Strings.isEmpty(string)) {
            string = DEFAULT_CONTEXT;
        }
        if (file == null && !string.equals(DEFAULT_CONTEXT)) {
            recentDirs.remove(string);
        } else {
            recentDirs.put(string, file);
        }
        StandardFileChooser.saveRecentPaths();
    }

    public StandardFileChooser() {
        this(2, null, null);
    }

    public StandardFileChooser(boolean bl, String string, String string2) {
        this(bl ? 1 : 0, string, string2);
    }

    public StandardFileChooser(int n, String string, String string2) {
        super.setDialogType(n);
        super.setFileSelectionMode(0);
        if (string == null || string.trim().length() == 0) {
            super.setAcceptAllFileFilterUsed(true);
        } else {
            super.setAcceptAllFileFilterUsed(false);
            this.addFilters(string);
        }
        if (string2 != null && string2.length() != 0) {
            super.setDialogTitle(string2);
        }
        this.setFileShouldExist(n == 0);
    }

    public static File getDefaultDir() {
        return StandardFileChooser.getRecentDir(null, true, PathTools.getHomeDir());
    }

    public static void setDefaultDir(File file) {
        StandardFileChooser.setRecentDir(null, file);
    }

    public StandardFileChooser setDefaultFile(String string) {
        return this.setDefaultFile(PathTools.fileFromPath(string, false));
    }

    public StandardFileChooser setDefaultFile(File file) {
        if (file == null || file.isDirectory()) {
            this.setStartDir(file);
        } else {
            super.setSelectedFile(file);
            File file2 = file.getParentFile();
            if (file2 != null && file2.exists()) {
                this.setStartDir(file2);
            }
        }
        return this;
    }

    public StandardFileChooser setStartDir(String string) {
        return this.setStartDir(string == null ? null : new File(string));
    }

    public StandardFileChooser setStartDir(File file) {
        this.isCurDirSet = true;
        super.setCurrentDirectory(file);
        return this;
    }

    public boolean modifyDir() {
        return this.modifyDir;
    }

    public StandardFileChooser setModifyDir(boolean bl) {
        this.modifyDir = bl;
        return this;
    }

    public File showFileDialog(Component component) {
        int n;
        File file = StandardFileChooser.getRecentDir(this.context, true);
        if (file == null) {
            file = this.getDialogType() == 1 ? PathTools.getHomeDir() : StandardFileChooser.getDefaultDir();
        }
        if (!this.isCurDirSet && file != null) {
            this.setCurrentDirectory(file);
        }
        if ((n = super.showDialog(component, this.getApproveButtonText())) != 0) {
            return null;
        }
        if (this.modifyDir) {
            StandardFileChooser.setRecentDir(this.context, this.getCurrentDirectory());
        }
        return this.getSelectedFile();
    }

    public StandardFileChooser setContext(String string) {
        this.context = string;
        return this;
    }

    public String getContext() {
        return this.context;
    }

    public StandardFileChooser setButtonText(String string) {
        this.setApproveButtonText(string);
        return this;
    }

    public StandardFileChooser addFilters(String string) {
        String[] stringArray = string.split("\\|");
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = stringArray[i - 1].trim();
            if (string2.length() == 0) continue;
            if (string2.equals("*")) {
                super.setAcceptAllFileFilterUsed(true);
                if (!stringArray[i].equals("*")) continue;
                ++i;
                continue;
            }
            CharSequence[] charSequenceArray = stringArray[i].split(";");
            string2 = string2 + String.format(" Files (*.%s)", String.join((CharSequence)", *.", charSequenceArray));
            this.addChoosableFileFilter(new FileNameExtensionFilter(string2, (String[])charSequenceArray));
            ++i;
        }
        return this;
    }

    public StandardFileChooser clearFilters() {
        this.setAcceptAllFileFilterUsed(false);
        super.resetChoosableFileFilters();
        return this;
    }

    public static String getSaveName(String string, String string2, String string3, String string4, Component component) {
        return StandardFileChooser.getFileName(true, component, string3, string2, string, string4);
    }

    public static String getSaveName(String string) {
        return StandardFileChooser.getSaveName(string, null);
    }

    public static String getSaveName(String string, String string2) {
        return StandardFileChooser.getSaveName(string, string2, null, null, null);
    }

    public static String getOpenName(String string, String string2, String string3, String string4, Component component) {
        return StandardFileChooser.getFileName(false, component, string3, string2, string, string4);
    }

    public static String getOpenName(String string) {
        return StandardFileChooser.getOpenName(string, null);
    }

    public static String getOpenName(String string, String string2) {
        return StandardFileChooser.getOpenName(string, string2, null, null, null);
    }

    public static String getFileName(boolean bl, Component component, String string, String string2, String string3, String string4) {
        return StandardFileChooser.getFileName(bl, component, string, string2, string3, string4, false);
    }

    public static String getFileName(boolean bl, Component component, String string, String string2, String string3, String string4, boolean bl2) {
        File file;
        if (preemptTimeout != 0L && (preemptFiltersRequired == null || preemptFiltersRequired.equals(string3))) {
            long l = System.currentTimeMillis() - preemptTimeout;
            preemptTimeout = 0L;
            if (l <= 100L) {
                return preemptFileName;
            }
        }
        if (AppMainFrame.getUseSimpleFileChooser()) {
            if (Strings.isEmpty(string)) {
                string = String.format("RNAstructure - Get %s File Name", bl ? "Save" : "Open");
            }
            return Dialogs.getInput(string, "Enter a file path.", string2);
        }
        StandardFileChooser standardFileChooser = new StandardFileChooser(bl, string3, string);
        if (string4 == null) {
            string4 = string;
        }
        if (string4 != null) {
            standardFileChooser.setContext(string4);
        }
        if (string2 != null) {
            standardFileChooser.setDefaultFile(string2);
        }
        if (bl2) {
            standardFileChooser.setModifyDir(false);
        }
        if ((file = standardFileChooser.showFileDialog(component)) == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static void preemptNextFileNameRequest(String string, String string2) {
        preemptTimeout = System.currentTimeMillis();
        preemptFiltersRequired = string2;
        preemptFileName = string;
    }

    public boolean getFileShouldExist() {
        return this.fileShouldExist;
    }

    public void setFileShouldExist(boolean bl) {
        this.fileShouldExist = bl;
    }

    public String getDefaultExtension() {
        FileNameExtensionFilter fileNameExtensionFilter;
        String[] stringArray;
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter instanceof FileNameExtensionFilter && (stringArray = (fileNameExtensionFilter = (FileNameExtensionFilter)fileFilter).getExtensions()).length != 0) {
            return stringArray[0];
        }
        return "";
    }

    public boolean passesFilter(File file) {
        FileFilter fileFilter = this.getFileFilter();
        return fileFilter == null || fileFilter.accept(file);
    }

    @Override
    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (file == null || file.exists()) {
            return file;
        }
        if (!this.passesFilter(file)) {
            file = new File(file.getPath() + "." + this.getDefaultExtension());
        }
        return file;
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        if (file == null) {
            Dialogs.showMessage("Please select a file.");
            return;
        }
        if (!file.exists() && this.getFileShouldExist()) {
            Dialogs.showMessage("The specified file does not exist: \n" + file.getPath());
            return;
        }
        if (file.exists() && this.getDialogType() == 1) {
            int n = JOptionPane.showConfirmDialog(this, "The file exists, overwrite?\n\nDetails:\nFile: " + file.getPath(), "Existing file", 1);
            switch (n) {
                case 0: {
                    super.approveSelection();
                    return;
                }
                case 1: {
                    return;
                }
                case -1: {
                    return;
                }
                case 2: {
                    this.cancelSelection();
                    return;
                }
            }
        }
        super.approveSelection();
    }
}

