/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.menus;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenuItem;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.RNAstructureBackendCalculator;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.DynalignRefoldWindow;
import ur_rna.RNAstructureUI.windows.OligoScreenWindow;
import ur_rna.RNAstructureUI.windows.RefoldWindow;
import ur_rna.RNAstructureUI.windows.SequenceDisplayWindow;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.swing.MergeMenu;

public class FileMenu
extends MainMenu {
    private static final long serialVersionUID = 20120802L;
    private final MergeMenu drawOptionMenu;
    public static final int SequenceSection = -100;
    public static final int DrawSection = -80;
    public static final int RefoldSection = -60;

    public FileMenu() {
        super("File");
        this.setSubItemMergePos(-100);
        this.addItem("&New Sequence", "Create a new sequence.", 'N');
        this.addItem("&Open Sequence", "Open an existing sequence.", 'O');
        this.addSeparator();
        this.setSubItemMergePos(-80);
        this.addItem("O&ligoScreen", "Calculate thermodynamic parameters for a set of oligonucleotides.");
        this.addSeparator();
        this.addItem("&Draw", "Draw a secondary structure.");
        this.addItem("Do&t Plot", "Display the energy dot plot for a sequence that was previously folded.");
        this.addItem("Dot Plot Pa&rtition Function", "Display base pairing probabilities for a previously calculated sequence.");
        this.addItem("Dot Plot Dyn&align", "Generate a Dynalign dot plot for two sequences.");
        this.addItem("Dot Plot From T&ext File", "Draw a dot plot from a text file.");
        this.addSeparator();
        this.drawOptionMenu = this.createDrawStructuresMenu();
        this.add(this.drawOptionMenu);
        this.addSeparator();
        this.setSubItemMergePos(-60);
        this.addItem("&Refold From Save File", "Refold a sequence from its save file.");
        this.addItem("Refold From Dyn&align Save File", "Refold from a Dynalign calculation.");
        this.setSubItemMergePos(0);
        this.setSubItemMergePos(Integer.MAX_VALUE);
        this.addSeparator();
        if (AppLog.getDefault().isDebugEnabled()) {
            this.addItem("Test", "Create a new sequence.", 'T');
            this.addSeparator();
        }
        this.addItem("E&xit", "Exit the RNAstructure application.");
    }

    private MainMenu createDrawStructuresMenu() {
        MainMenu mainMenu = new MainMenu("Draw structures after calculations...");
        mainMenu.addCheckItem("Always Draw.", "After each calculation, structures will automatically be drawn without prompting.");
        mainMenu.addCheckItem("Never Draw.", "Structures will not be drawn after calculations (but output files will still be saved.");
        mainMenu.addCheckItem("Prompt to Draw after each Calculation.", "After each calculation, a prompt will be shown asking whether or not to draw structures.");
        this.writeDrawPref(mainMenu, null);
        return mainMenu;
    }

    @Override
    protected void onMenuAction(String string, ActionEvent actionEvent) {
        if (string.equals("Test")) {
            Dialogs.showMessage("DATAPATH=" + RNAstructureBackendCalculator.getEnvVar("DATAPATH"));
            return;
        }
        if (string.startsWith("D")) {
            DrawingWindow drawingWindow;
            String string2;
            if (string.equals("Dot Plot")) {
                DrawingWindow drawingWindow2;
                String string3 = StandardFileChooser.getOpenName(FileFilters.FoldingSav);
                if (string3 != null && !(drawingWindow2 = new DrawingWindow(string3)).isError()) {
                    drawingWindow2.showWindow();
                }
            } else if (string.equals("Dot Plot Dynalign")) {
                String string4 = StandardFileChooser.getOpenName(FileFilters.DynalignSav);
                if (string4 != null) {
                    boolean bl;
                    DrawingWindow drawingWindow3 = new DrawingWindow(string4, 1);
                    DrawingWindow drawingWindow4 = new DrawingWindow(string4, 2);
                    boolean bl2 = bl = !drawingWindow3.isError() && !drawingWindow4.isError();
                    if (bl) {
                        drawingWindow3.showWindow();
                        drawingWindow4.showWindow();
                    }
                }
            } else if (string.equals("Dot Plot From Text File")) {
                DrawingWindow drawingWindow5;
                String string5 = StandardFileChooser.getOpenName(FileFilters.DotPlot);
                if (string5 != null && !(drawingWindow5 = new DrawingWindow(string5)).isError()) {
                    drawingWindow5.showWindow();
                }
            } else if (string.equals("Dot Plot Partition Function")) {
                DrawingWindow drawingWindow6;
                String string6 = StandardFileChooser.getOpenName(FileFilters.PartitionSav);
                if (string6 != null && !(drawingWindow6 = new DrawingWindow(string6)).isError()) {
                    drawingWindow6.showWindow();
                }
            } else if (string.equals("Draw") && (string2 = StandardFileChooser.getOpenName(FileFilters.CT)) != null && !(drawingWindow = new DrawingWindow(string2)).isError()) {
                drawingWindow.showWindow();
            }
        } else if (string.equals("Always Draw.")) {
            this.writeDrawPref(null, "Y");
        } else if (string.equals("Never Draw.")) {
            this.writeDrawPref(null, "N");
        } else if (string.startsWith("Prompt to Draw")) {
            this.writeDrawPref(null, "P");
        } else if (string.equals("Exit")) {
            System.exit(0);
        } else if (string.equals("New Sequence")) {
            new SequenceDisplayWindow().showWindow();
        } else if (string.equals("OligoScreen")) {
            new OligoScreenWindow().showWindow();
        } else if (string.equals("Open Sequence")) {
            String string7 = StandardFileChooser.getOpenName(FileFilters.SequenceExtended);
            if (string7 != null) {
                new SequenceDisplayWindow(string7).showWindow();
            }
        } else if (string.equals("Refold From Dynalign Save File")) {
            new DynalignRefoldWindow().showWindow();
        } else if (string.equals("Refold From Save File")) {
            new RefoldWindow().showWindow();
        }
    }

    private void writeDrawPref(MergeMenu mergeMenu, String string) {
        if (string == null) {
            string = RNAstructure.options.drawStructures;
        } else {
            RNAstructure.options.drawStructures = string;
            RNAstructure.options.save();
        }
        if (mergeMenu == null) {
            mergeMenu = this.drawOptionMenu;
        }
        List<? extends JMenuItem> list = mergeMenu.getMenuItems();
        list.get(0).setSelected("Y".equals(string));
        list.get(1).setSelected("N".equals(string));
        list.get(2).setSelected("P".equals(string));
    }
}

