# This script is not intended to be executed directly.  It is sourced by test-runner.sh and most functions you see here are defined in test-tools.sh
# The variables EXENAME, EXEBASE, OKDIR, and EXEDIR are defined externally.

beginTestBlock  # Begin a group of tests.
runMake -r @EXE EnergyPlot # run `make` for the main exe and any other listed programs
EXT=.ct  # set extension for @OKFILE and @OUTFILE placeholders (defaults for runDiff)

SEQ_ALT1=testFiles/testFile_U1a.seq
SEQ_BONUS=testFiles/testFile_5SRNA_tail2.seq

# Test Fold_without_options.
runFullTest 'without_options'  $SINGLESEQ2 @OUT.ct

# Test Fold writing CT to STDOUT
runFullTest 'without_options_stdout'  $SINGLESEQ2 - \
	---stdout ---ref='without_options'

# Test Fold reading SEQ from STDIN
runFullTest 'without_options_stdin' - @OUT.ct < $SEQ_ALT1 \
	---ref='without_options_alternate'

# Test Fold_without_options_alternate.
# This alternate test will be used to test single and double stranded offsets later.
runFullTest 'without_options_alternate'  $SEQ_ALT1 @OUT.ct

# Test Fold_without_options_alternate_2.
# This second alternate test will be used to test experimental pair bonuses later.
runFullTest 'without_options_alternate_2'  $SEQ_BONUS @OUT.ct

# Test Fold_without_options_fasta_input.
runFullTest 'without_options_fasta_input'  $SINGLESEQ2_FASTA  @OUT.ct \
	---ref='without_options'

# Test Fold_constraint_file_option.
runFullTest 'constraint_file_option'  $SINGLESEQ2 @OUT.ct -c testFiles/testFile_folding2.con

# Test Fold_dna_option.
runFullTest 'dna_option'  $SINGLESEQ2 @OUT.ct -d

# Test Fold_dna_option_fasta_input.
runFullTest 'dna_option_fasta_input'  $SINGLESEQ2_FASTA  @OUT.ct  -d \
	---ref='dna_option'

# Test dms_option
# DMS folding using gamma distributions (Cordero et al., Biochemistry, 2012. http://dx.doi.org/10.1021/bi3008802)
runFullTest 'dms_option' testFiles/testFile_FNon_dGTPonly_sequence.seq @OUT.ct  -T 297.15 -dms testFiles/testFile_FNon_dGTPonly_mean_DMS.5.5.txt	

# Test dms_boot
# DMS with mock GIR1 data file generated by resamplig with replacement.
runFullTest 'dms_boot' testFiles/testFile_GIR1.seq @OUT.ct  -T 297.15 -dms testFiles/testFile_boot1_tmp193327_DMS.txt	

# Test Fold_double_stranded_offset_option.
runFullTest 'double_stranded_offset_option'  $SEQ_ALT1 @OUT.ct -dso testFiles/testFile_double_offset_dummy.txt

# Test Fold_experimental_pair_bonus_option.
runFullTest 'experimental_pair_bonus_option'  $SEQ_BONUS @OUT.ct -X testFiles/testFile_bonus_matrix.txt

# Test columnar format for experimental bonuses
runFullTest 'experimental_pair_bonus_option'  testFiles/testFile_5SRNA_tail2.seq @OUT.ct -X testFiles/testFile_bonus_columns.txt


# Test Fold_experimental_pair_bonus_offset_option.
runFullTest 'experimental_pair_bonus_offset_option'  $SEQ_BONUS @OUT.ct -X testFiles/testFile_bonus_matrix.txt -xo 10

# Test Fold_experimental_pair_bonus_scaling_option.
runFullTest 'experimental_pair_bonus_scaling_option'  $SEQ_BONUS @OUT.ct -X testFiles/testFile_bonus_matrix.txt -xs 10

# Test Fold_experimental_pair_bonus_scaling_option w/ columnar format
runFullTest 'experimental_pair_bonus_scaling_option'  testFiles/testFile_5SRNA_tail2.seq @OUT.ct -X testFiles/testFile_bonus_columns.txt -xs 10


# Test Fold_loop_option.
runFullTest 'loop_option'  $SINGLESEQ2 @OUT.ct -l 0

# Test Fold_max_distance_option.
runFullTest 'max_distance_option'  $SINGLESEQ2 @OUT.ct -md 25

# Test Fold_max_structures_option.
runFullTest 'max_structures_option'  $SINGLESEQ2 @OUT.ct -m 2

# Test Fold_gir1_m2seq_no_data
runFullTest 'gir1_m2seq_no_data' testFiles/testFile_GIR1.seq @OUT.ct -T 297.15

# Test Fold_gir1_m2seq_dms
runFullTest 'gir1_m2seq_dms' testFiles/testFile_GIR1.seq @OUT.ct -T 297.15 -dms testFiles/testFile_GIR1_M2seq_1D_DMS.txt

# Test Fold_gir1_m2seq_ex
runFullTest 'gir1_m2seq_ex' testFiles/testFile_GIR1.seq @OUT.ct -T 297.15 -x testFiles/testFile_GIR1_M2seq_EX.txt

# Test Fold_gir1_m2seq_ex_dms
runFullTest 'gir1_m2seq_ex_dms' testFiles/testFile_GIR1.seq @OUT.ct -T 297.15 -dms testFiles/testFile_GIR1_M2seq_1D_DMS.txt -x testFiles/testFile_GIR1_M2seq_EX.txt

# Test Fold_percent_difference_option.
runFullTest 'percent_difference_option'  $SINGLESEQ2 @OUT.ct -p 5

# Test Fold_minimum_free_energy_difference_option.
runFullTest 'minimum_free_energy_option'  $SINGLESEQ @OUT.ct -mfe

SAVEFILE=fold_save_file.sav
# Test Fold_save_file_option.
runFullTest 'save_file_option'  $SINGLESEQ2  @OUT.ct  -s $SAVEFILE \
	---ref='without_options'

# Test Fold_sav_plot (The save plot generated by the save file option).
initTest 'sav_plot' && {
  runTest EnergyPlot $SAVEFILE @OUT.ps
  addTestOuput $SAVEFILE # mark this file as test output (for proper cleanup)
  runDiff @OUT.ps @OK.ps
endTest; }

# Test Fold_shape_option.
runFullTest 'shape_option'  $SINGLESEQ2 @OUT.ct -sh testFiles/testFile_tRNA.shape

# Test Fold_shape_intercept_option.
runFullTest 'shape_intercept_option'  $SINGLESEQ2 @OUT.ct -sh testFiles/testFile_tRNA.shape -si 0.9

# Test Fold_shape_slope_option.
runFullTest 'shape_slope_option'  $SINGLESEQ2 @OUT.ct -sh testFiles/testFile_tRNA.shape -sm -0.2

# Test Fold_single_stranded_offset_option.
runFullTest 'single_stranded_offset_option'  $SEQ_ALT1 @OUT.ct -sso testFiles/testFile_single_offset.txt

# Test Fold_temperature_option.
runFullTest 'temperature_option'  $SINGLESEQ2 @OUT.ct -t 150

# Test Fold_unpaired_shape_intercept_option.
runFullTest 'unpaired_shape_intercept_option'  $SINGLESEQ2 @OUT.ct -sh testFiles/testFile_tRNA.shape -usi 0.9

# Test Fold_unpaired_shape_slope_option.
runFullTest 'unpaired_shape_slope_option'  $SINGLESEQ2 @OUT.ct -sh testFiles/testFile_tRNA.shape -usm -0.2

# Test Fold_window_size_option.
runFullTest 'window_size_option'  $SINGLESEQ2 @OUT.ct -w 15

# Test dmsnt_options
runFullTest 'dmsnt_option' testFiles/testFile_5Se.seq @OUT.ct -dmsnt testFiles/testFile_5S.dmsnt

# Test dmsnt_ex_options
runFullTest 'dmsnt_ex_option' testFiles/testFile_5Se.seq @OUT.ct -dmsnt testFiles/testFile_5S.dmsnt -x testFiles/testFile_5S_bonus.txt




endTestBlock # End a group of tests. Also cleans up orphaned files etc.
