# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_RNAstructure_wrap')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_RNAstructure_wrap')
    _RNAstructure_wrap = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_RNAstructure_wrap', [dirname(__file__)])
        except ImportError:
            import _RNAstructure_wrap
            return _RNAstructure_wrap
        try:
            _mod = imp.load_module('_RNAstructure_wrap', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _RNAstructure_wrap = swig_import_helper()
    del swig_import_helper
else:
    import _RNAstructure_wrap
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _RNAstructure_wrap.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _RNAstructure_wrap.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _RNAstructure_wrap.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _RNAstructure_wrap.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _RNAstructure_wrap.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _RNAstructure_wrap.SwigPyIterator_equal(self, x)

    def copy(self):
        return _RNAstructure_wrap.SwigPyIterator_copy(self)

    def next(self):
        return _RNAstructure_wrap.SwigPyIterator_next(self)

    def __next__(self):
        return _RNAstructure_wrap.SwigPyIterator___next__(self)

    def previous(self):
        return _RNAstructure_wrap.SwigPyIterator_previous(self)

    def advance(self, n):
        return _RNAstructure_wrap.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _RNAstructure_wrap.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _RNAstructure_wrap.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _RNAstructure_wrap.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _RNAstructure_wrap.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _RNAstructure_wrap.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _RNAstructure_wrap.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _RNAstructure_wrap.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class IntPair(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntPair, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IntPair, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _RNAstructure_wrap.new_IntPair(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_setmethods__["first"] = _RNAstructure_wrap.IntPair_first_set
    __swig_getmethods__["first"] = _RNAstructure_wrap.IntPair_first_get
    if _newclass:
        first = _swig_property(_RNAstructure_wrap.IntPair_first_get, _RNAstructure_wrap.IntPair_first_set)
    __swig_setmethods__["second"] = _RNAstructure_wrap.IntPair_second_set
    __swig_getmethods__["second"] = _RNAstructure_wrap.IntPair_second_get
    if _newclass:
        second = _swig_property(_RNAstructure_wrap.IntPair_second_get, _RNAstructure_wrap.IntPair_second_set)
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _RNAstructure_wrap.delete_IntPair
    __del__ = lambda self: None
IntPair_swigregister = _RNAstructure_wrap.IntPair_swigregister
IntPair_swigregister(IntPair)

class PairVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PairVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PairVector, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _RNAstructure_wrap.PairVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _RNAstructure_wrap.PairVector___nonzero__(self)

    def __bool__(self):
        return _RNAstructure_wrap.PairVector___bool__(self)

    def __len__(self):
        return _RNAstructure_wrap.PairVector___len__(self)

    def __getslice__(self, i, j):
        return _RNAstructure_wrap.PairVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _RNAstructure_wrap.PairVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _RNAstructure_wrap.PairVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _RNAstructure_wrap.PairVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _RNAstructure_wrap.PairVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _RNAstructure_wrap.PairVector___setitem__(self, *args)

    def pop(self):
        return _RNAstructure_wrap.PairVector_pop(self)

    def append(self, x):
        return _RNAstructure_wrap.PairVector_append(self, x)

    def empty(self):
        return _RNAstructure_wrap.PairVector_empty(self)

    def size(self):
        return _RNAstructure_wrap.PairVector_size(self)

    def swap(self, v):
        return _RNAstructure_wrap.PairVector_swap(self, v)

    def begin(self):
        return _RNAstructure_wrap.PairVector_begin(self)

    def end(self):
        return _RNAstructure_wrap.PairVector_end(self)

    def rbegin(self):
        return _RNAstructure_wrap.PairVector_rbegin(self)

    def rend(self):
        return _RNAstructure_wrap.PairVector_rend(self)

    def clear(self):
        return _RNAstructure_wrap.PairVector_clear(self)

    def get_allocator(self):
        return _RNAstructure_wrap.PairVector_get_allocator(self)

    def pop_back(self):
        return _RNAstructure_wrap.PairVector_pop_back(self)

    def erase(self, *args):
        return _RNAstructure_wrap.PairVector_erase(self, *args)

    def __init__(self, *args):
        this = _RNAstructure_wrap.new_PairVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _RNAstructure_wrap.PairVector_push_back(self, x)

    def front(self):
        return _RNAstructure_wrap.PairVector_front(self)

    def back(self):
        return _RNAstructure_wrap.PairVector_back(self)

    def assign(self, n, x):
        return _RNAstructure_wrap.PairVector_assign(self, n, x)

    def resize(self, *args):
        return _RNAstructure_wrap.PairVector_resize(self, *args)

    def insert(self, *args):
        return _RNAstructure_wrap.PairVector_insert(self, *args)

    def reserve(self, n):
        return _RNAstructure_wrap.PairVector_reserve(self, n)

    def capacity(self):
        return _RNAstructure_wrap.PairVector_capacity(self)
    __swig_destroy__ = _RNAstructure_wrap.delete_PairVector
    __del__ = lambda self: None
PairVector_swigregister = _RNAstructure_wrap.PairVector_swigregister
PairVector_swigregister(PairVector)

class StringVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringVector, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _RNAstructure_wrap.StringVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _RNAstructure_wrap.StringVector___nonzero__(self)

    def __bool__(self):
        return _RNAstructure_wrap.StringVector___bool__(self)

    def __len__(self):
        return _RNAstructure_wrap.StringVector___len__(self)

    def __getslice__(self, i, j):
        return _RNAstructure_wrap.StringVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _RNAstructure_wrap.StringVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _RNAstructure_wrap.StringVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _RNAstructure_wrap.StringVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _RNAstructure_wrap.StringVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _RNAstructure_wrap.StringVector___setitem__(self, *args)

    def pop(self):
        return _RNAstructure_wrap.StringVector_pop(self)

    def append(self, x):
        return _RNAstructure_wrap.StringVector_append(self, x)

    def empty(self):
        return _RNAstructure_wrap.StringVector_empty(self)

    def size(self):
        return _RNAstructure_wrap.StringVector_size(self)

    def swap(self, v):
        return _RNAstructure_wrap.StringVector_swap(self, v)

    def begin(self):
        return _RNAstructure_wrap.StringVector_begin(self)

    def end(self):
        return _RNAstructure_wrap.StringVector_end(self)

    def rbegin(self):
        return _RNAstructure_wrap.StringVector_rbegin(self)

    def rend(self):
        return _RNAstructure_wrap.StringVector_rend(self)

    def clear(self):
        return _RNAstructure_wrap.StringVector_clear(self)

    def get_allocator(self):
        return _RNAstructure_wrap.StringVector_get_allocator(self)

    def pop_back(self):
        return _RNAstructure_wrap.StringVector_pop_back(self)

    def erase(self, *args):
        return _RNAstructure_wrap.StringVector_erase(self, *args)

    def __init__(self, *args):
        this = _RNAstructure_wrap.new_StringVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _RNAstructure_wrap.StringVector_push_back(self, x)

    def front(self):
        return _RNAstructure_wrap.StringVector_front(self)

    def back(self):
        return _RNAstructure_wrap.StringVector_back(self)

    def assign(self, n, x):
        return _RNAstructure_wrap.StringVector_assign(self, n, x)

    def resize(self, *args):
        return _RNAstructure_wrap.StringVector_resize(self, *args)

    def insert(self, *args):
        return _RNAstructure_wrap.StringVector_insert(self, *args)

    def reserve(self, n):
        return _RNAstructure_wrap.StringVector_reserve(self, n)

    def capacity(self):
        return _RNAstructure_wrap.StringVector_capacity(self)
    __swig_destroy__ = _RNAstructure_wrap.delete_StringVector
    __del__ = lambda self: None
StringVector_swigregister = _RNAstructure_wrap.StringVector_swigregister
StringVector_swigregister(StringVector)

class StringVectorVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringVectorVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringVectorVector, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _RNAstructure_wrap.StringVectorVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _RNAstructure_wrap.StringVectorVector___nonzero__(self)

    def __bool__(self):
        return _RNAstructure_wrap.StringVectorVector___bool__(self)

    def __len__(self):
        return _RNAstructure_wrap.StringVectorVector___len__(self)

    def __getslice__(self, i, j):
        return _RNAstructure_wrap.StringVectorVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _RNAstructure_wrap.StringVectorVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _RNAstructure_wrap.StringVectorVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _RNAstructure_wrap.StringVectorVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _RNAstructure_wrap.StringVectorVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _RNAstructure_wrap.StringVectorVector___setitem__(self, *args)

    def pop(self):
        return _RNAstructure_wrap.StringVectorVector_pop(self)

    def append(self, x):
        return _RNAstructure_wrap.StringVectorVector_append(self, x)

    def empty(self):
        return _RNAstructure_wrap.StringVectorVector_empty(self)

    def size(self):
        return _RNAstructure_wrap.StringVectorVector_size(self)

    def swap(self, v):
        return _RNAstructure_wrap.StringVectorVector_swap(self, v)

    def begin(self):
        return _RNAstructure_wrap.StringVectorVector_begin(self)

    def end(self):
        return _RNAstructure_wrap.StringVectorVector_end(self)

    def rbegin(self):
        return _RNAstructure_wrap.StringVectorVector_rbegin(self)

    def rend(self):
        return _RNAstructure_wrap.StringVectorVector_rend(self)

    def clear(self):
        return _RNAstructure_wrap.StringVectorVector_clear(self)

    def get_allocator(self):
        return _RNAstructure_wrap.StringVectorVector_get_allocator(self)

    def pop_back(self):
        return _RNAstructure_wrap.StringVectorVector_pop_back(self)

    def erase(self, *args):
        return _RNAstructure_wrap.StringVectorVector_erase(self, *args)

    def __init__(self, *args):
        this = _RNAstructure_wrap.new_StringVectorVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _RNAstructure_wrap.StringVectorVector_push_back(self, x)

    def front(self):
        return _RNAstructure_wrap.StringVectorVector_front(self)

    def back(self):
        return _RNAstructure_wrap.StringVectorVector_back(self)

    def assign(self, n, x):
        return _RNAstructure_wrap.StringVectorVector_assign(self, n, x)

    def resize(self, *args):
        return _RNAstructure_wrap.StringVectorVector_resize(self, *args)

    def insert(self, *args):
        return _RNAstructure_wrap.StringVectorVector_insert(self, *args)

    def reserve(self, n):
        return _RNAstructure_wrap.StringVectorVector_reserve(self, n)

    def capacity(self):
        return _RNAstructure_wrap.StringVectorVector_capacity(self)
    __swig_destroy__ = _RNAstructure_wrap.delete_StringVectorVector
    __del__ = lambda self: None
StringVectorVector_swigregister = _RNAstructure_wrap.StringVectorVector_swigregister
StringVectorVector_swigregister(StringVectorVector)

TOLERANCE = _RNAstructure_wrap.TOLERANCE
class Thermodynamics(_object):
    """


    Thermodynamics Class.

    The RNA class provides an encapsulation of the functions and struct
    for reading and storing thermodynamic parameters. This includes
    methods for changing folding temperatures This class is intended for
    use in inheritance for classes that provide functionality.

    C++ includes: thermodynamics.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Thermodynamics, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Thermodynamics, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Thermodynamics::Thermodynamics(const bool ISRNA=true) """
        this = _RNAstructure_wrap.new_Thermodynamics(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def SetTemperature(self, temperature):
        """
        int
        Thermodynamics::SetTemperature(double temperature)

        Set the temperature of folding in K.

        This function allows the user to specify folding temperatures other
        than 310.15 K (37 degrees C). This changes folding free energy changes
        that would be returned for existing structures and would alter the set
        of structures predicted. When this function is called, the
        thermodynamic parameter files are immediately read from disk. These
        include both enthalpy parameters (.dh files) and free energy changes
        at 310.15 (.dat files). The files must either be at a location
        indicated by the $DATAPATH environment variable or in pwd. Changing
        the temperature only alters subsequent calculations. For example, if a
        structure prediction method has been called, the set of predicted
        structures are not changed at the time of a call to SetTemperature.
        Likewise, SetTemperature must be called before calling a structure
        prediction method if a temperature other than the 310.15 K default is
        desired. The function returns an error code where 0 is no error and
        non-zero errors can be parsed by by GetErrorMessage() or
        GetErrorMessageString() in an inheriting class. 
        """
        return _RNAstructure_wrap.Thermodynamics_SetTemperature(self, temperature)


    def GetTemperature(self):
        """
        double
        Thermodynamics::GetTemperature()

        Get the current folding temperature in K.

        Returns:
        --------

        A double that indicates the folding temperature in K. 
        """
        return _RNAstructure_wrap.Thermodynamics_GetTemperature(self)


    def GetAlphabetName(self):
        return _RNAstructure_wrap.Thermodynamics_GetAlphabetName(self)

    def ReadThermodynamic(self, directory=None, alphabet=None, temperature=-1.0):
        """
        int
        Thermodynamics::ReadThermodynamic(const char *pathname=NULL)

        Function to read the thermodynamic parameters.

        This function depends on temp, the current temperature, to determine
        in the folding free energies need to be set to other than those read
        in files for 310.15 K. Return of zero => no error and a return of non-
        zero indicates error. Public functions that need the thermodynamic
        parameters call this function automatically. By default, the path to
        the thermodynamic paramaters is fetched from the $DATAPATH environment
        variable. If a specific path is needed, $DATAPATH is overridden by
        specifying the pathname explicitly here as a parameter.

        Returns:
        --------

        An int that indicates whether an error occured.

        Parameters:
        -----------

        pathname:  is a pointer to cstring that indicates the pathname to the
        thermodynamnic parameters. By default, this is NULL and the
        environment variable $DATAPATH is consulted to get this path. 
        """
        return _RNAstructure_wrap.Thermodynamics_ReadThermodynamic(self, directory, alphabet, temperature)


    def ReloadDataTables(self, new_temperature=-1.0):
        return _RNAstructure_wrap.Thermodynamics_ReloadDataTables(self, new_temperature)

    def VerifyThermodynamic(self):
        return _RNAstructure_wrap.Thermodynamics_VerifyThermodynamic(self)

    def GetDatatable(self):
        """
        datatable *
        Thermodynamics::GetDatatable()

        This function is used during inheritance o provide access to the free
        energy change parameters. This function generates no error codes.
        (Error checking was done for this during construction).

        Returns:
        --------

        A pointer to datatable with free energy change parameters. 
        """
        return _RNAstructure_wrap.Thermodynamics_GetDatatable(self)


    def GetEnthalpyTable(self, alphabet=None):
        """
        datatable *
        Thermodynamics::GetEnthalpyTable()

        This function is used to provide an enthalpy table. This function will
        return a NULL pointer if there is an error reading the tables from
        disk. It is important that programs check the status of the pointer
        before using it, i.e. make sure it is not NULL.

        Returns:
        --------

        A pointer to datatable with the enthalpy change parameters. 
        """
        return _RNAstructure_wrap.Thermodynamics_GetEnthalpyTable(self, alphabet)


    def ClearEnergies(self):
        return _RNAstructure_wrap.Thermodynamics_ClearEnergies(self)

    def ClearEnthalpies(self):
        return _RNAstructure_wrap.Thermodynamics_ClearEnthalpies(self)

    def GetEnergyRead(self):
        """
        bool
        Thermodynamics::GetEnergyRead()

        Return whether this instance of Thermodynamics has the paremters
        populated (either from disk or from another Thermodynamics class).

        Returns:
        --------

        A bool yjay indicates whether the parameters are populated (true =
        yes). 
        """
        return _RNAstructure_wrap.Thermodynamics_GetEnergyRead(self)


    def IsAlphabetRead(self):
        return _RNAstructure_wrap.Thermodynamics_IsAlphabetRead(self)
    __swig_destroy__ = _RNAstructure_wrap.delete_Thermodynamics
    __del__ = lambda self: None
    __swig_setmethods__["isrna"] = _RNAstructure_wrap.Thermodynamics_isrna_set
    __swig_getmethods__["isrna"] = _RNAstructure_wrap.Thermodynamics_isrna_get
    if _newclass:
        isrna = _swig_property(_RNAstructure_wrap.Thermodynamics_isrna_get, _RNAstructure_wrap.Thermodynamics_isrna_set)
Thermodynamics_swigregister = _RNAstructure_wrap.Thermodynamics_swigregister
Thermodynamics_swigregister(Thermodynamics)

SEQUENCE_STRING = _RNAstructure_wrap.SEQUENCE_STRING
FILE_CT = _RNAstructure_wrap.FILE_CT
FILE_SEQ = _RNAstructure_wrap.FILE_SEQ
FILE_PFS = _RNAstructure_wrap.FILE_PFS
FILE_SAV = _RNAstructure_wrap.FILE_SAV
FILE_DBN = _RNAstructure_wrap.FILE_DBN
class RNA(Thermodynamics):
    """


    RNA Class.

    The RNA class provides an entry point for all the single sequence
    operations of RNAstructure.

    C++ includes: RNA.h 
    """

    __swig_setmethods__ = {}
    for _s in [Thermodynamics]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RNA, name, value)
    __swig_getmethods__ = {}
    for _s in [Thermodynamics]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RNA, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        RNA::RNA(const bool IsRNA=true)

        Default Constructor - user provides nothing. This basic constructor is
        provided for bimolecular folding and should not generally need to be
        accessed by end users of the RNA class.

        Parameters:
        -----------

        IsRNA:  is a bool that indicates whether this sequence is RNA or DNA.
        true= RNA. false=DNA. Default is true. 
        """
        this = _RNAstructure_wrap.new_RNA(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def GetErrorCode(self):
        """
        int RNA::GetErrorCode()

        Return an error code, where a return of zero is no error.

        This function returns and error flag that is generated during
        construction by RNA(const char &filename, const int type, const bool
        IsRNA=true) or from CalculateFreeEnergy(). An error of zero is always
        no error. Other codes are errors and a c-string can be fetched for the
        error with GetErrorMessage().

        Returns:
        --------

        An integer that provides the error code. 
        """
        return _RNAstructure_wrap.RNA_GetErrorCode(self)


    def GetErrorMessage(error):
        """
        char *
        RNA::GetErrorMessage(const int error)

        Return error messages based on code from GetErrorCode and other error
        codes.

        0 = no error 1 = input file not found 2 = error opening file 3 =
        structure number out of range 4 = nucleotide number out of range 5 =
        error reading thermodynamic parameters 6 = pseudoknot formation 7 =
        non-canonical pair 8 = too many restraints specified 9 = same
        nucleotide in conflicting restraint 10 = no structures to write 11 =
        nucleotide not a U (caused by ForceFMNCleavage() 12 = distance too
        short 13 = error reading constraint file 14 = traceback error 15 = no
        partition function data present 16 = incorrect save file version used
        17 = cannot be performed without having read a save file (.sav) 18 =
        threshold is too low to be valid 19 = drawing coordinates have not
        been determined 20 = no sequence has been read 21 = over 1 probability
        error on stochastic traceback 22 = programming error, unrecognized
        input to constructor 23 = no structures present 24 = too few
        iterations 25 = index (for drawing) is not a multiple of 10

        Parameters:
        -----------

        error:  is the integer error code provided by GetErrorCode() or from
        other functions that return integer error codes.

        Returns:
        --------

        A pointer to a c string that provides an error message. 
        """
        return _RNAstructure_wrap.RNA_GetErrorMessage(error)

    GetErrorMessage = staticmethod(GetErrorMessage)

    def GetFullErrorMessage(self):
        return _RNAstructure_wrap.RNA_GetFullErrorMessage(self)

    def GetErrorDetails(self):
        return _RNAstructure_wrap.RNA_GetErrorDetails(self)

    def SetErrorDetails(self, details):
        return _RNAstructure_wrap.RNA_SetErrorDetails(self, details)

    def SetSequenceLabel(self, label):
        return _RNAstructure_wrap.RNA_SetSequenceLabel(self, label)

    def GetErrorMessageString(self, error):
        """
        std::string
        RNA::GetErrorMessageString(const int error)

        Return error messages based on code from GetErrorCode and other error
        codes.

        Although RNA generally uses c strings, this member function returns a
        string that is suitable for interfacing with JAVA, etc. See the error
        list in the GetErrorMessage() entry.

        Parameters:
        -----------

        error:  is the integer error code provided by GetErrorCode() or from
        other functions that return integer error codes.

        Returns:
        --------

        A string that provides an error message. 
        """
        return _RNAstructure_wrap.RNA_GetErrorMessageString(self, error)


    def ResetError(self):
        return _RNAstructure_wrap.RNA_ResetError(self)

    def EnsureStructureCapcacity(self, minimumStructures):
        return _RNAstructure_wrap.RNA_EnsureStructureCapcacity(self, minimumStructures)

    def SpecifyPair(self, i, j, structurenumber=1):
        """
        int RNA::SpecifyPair(const
        int i, const int j, const int structurenumber=1)

        Specify a base pair between nucleotides i and j.

        The base pair is in structure number structurenumber, which is assumed
        to be structure 1. Return 0 if there is no problem, otherwise return
        an error code: error = 3 -> structurenumber out of range. error = 4 ->
        nucleotide number out of range. A c string or string description of
        the error are available using GetErrorMessage() or
        GetErrorMessageString(). Note!: Sequences with the 5' end = nucleotide
        1. Note!: Structures start at structure 1.

        Parameters:
        -----------

        i:  is an integer for the position of the first nucleotide in the
        pair.

        j:  in an integer for the position of the second nucleotide in the
        pair.

        structurenumber:  is the structure that has the pair. This defaults to
        1.

        Returns:
        --------

        An integer that indicates an error code that can be parsed by
        GetErrorMessage() or GetErrorMessageString(), 0 = no error. 
        """
        return _RNAstructure_wrap.RNA_SpecifyPair(self, i, j, structurenumber)


    def RemovePairs(self, structurenumber=1, removeIfLastStructure=True):
        """
        int RNA::RemovePairs(const
        int structurenumber=1)

        Remove all the current base pairs in a specified structure.

        Return 0 if there is no error. Return 5 if structurenumber never had
        pairs specified.

        Parameters:
        -----------

        structurenumber:  is an integer specifying the structure from which to
        remove the pairs.

        Returns:
        --------

        An integer that indicates an error code that can be parsed by
        GetErrorMessage() or GetErrorMessageString(), 0 = no error. 
        """
        return _RNAstructure_wrap.RNA_RemovePairs(self, structurenumber, removeIfLastStructure)


    def RemoveBasePair(self, i, structurenumber=1):
        """
        int
        RNA::RemoveBasePair(const int i, const int structurenumber=1)

        Remove a specified pair in a specified structure.

        Break the pair between i and i's pairing partner Return 0 if there is
        no error. Return 3 if structurenumber out of range. Return 4 if
        nucleotide number out of range.

        Parameters:
        -----------

        i:  is the index of a nucleotide in a pair that will be broken.

        structurenumber:  is an integer specifying the structure from which to
        remove the pairs.

        Returns:
        --------

        An integer that indicates an error code that can be parsed by
        GetErrorMessage() or GetErrorMessageString(), 0 = no error. 
        """
        return _RNAstructure_wrap.RNA_RemoveBasePair(self, i, structurenumber)


    def CalculateFreeEnergy(self, structurenumber=1, UseSimpleMBLoopRules=False):
        """
        double
        RNA::CalculateFreeEnergy(const int structurenumber=1, const bool
        UseSimpleMBLoopRules=false)

        Return the predicted Gibb's free energy change for structure #
        structurenumber, defaulted to 1.

        Free energies are in kcal/mol. The first time this is called, if no
        other free energy calculation has been performed and the folding
        temperature has not been specifed, thermodynamic parameter files
        (.dat) files will be read from disk. The parameter files should be
        located in the directory specified by environment variable $DATAPATH,
        or the pwd. In case of error, the function returns a free energy
        change of zero. Note!: That a free energy change of zero is also a
        valid folding free energy change. Errors will also generate an
        internal error code, accessible with GetErrorCode(). GetErrorCode()
        will return 0 when there is no error and other codes can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        structurenumber:  is an integer that refers to the index of the
        structure for which to calculate the folding free energy change. This
        defaults to 1.

        UseSimpleMBLoopRules:  is a bool that indicates what energy rules to
        use. The default, false, uses the complete nearest neighbor model for
        multibranch loops. When true is passed, the energy model is instead a
        simplified model that is the one used by the dynamic programming
        algorithms.

        Returns:
        --------

        A double which is the folding free energy change in kcal/mol. 
        """
        return _RNAstructure_wrap.RNA_CalculateFreeEnergy(self, structurenumber, UseSimpleMBLoopRules)


    def WriteThermodynamicDetails(self, filename, UseSimpleMBLoopRules=False):
        """
        int
        RNA::WriteThermodynamicDetails(const char filename[], const bool
        UseSimpleMBLoopRules=false)

        Calculate the folding free energy change for all structures and write
        the details of the calculation to a file.

        Free energies are in kcal/mol. The first time this is called, if no
        other free energy calculation has been performed and the folding
        temperature has not been specifed, thermodynamic parameter files
        (.dat) files will be read from disk. The parameter files should be
        located in the directory specified by environment variable $DATAPATH,
        or the pwd. In case of error, the function returns a non-zero.

        Parameters:
        -----------

        filename:  is a NULL terminated c string that provides the name of the
        output file to be written.

        UseSimpleMBLoopRules:  is a bool that indicates what energy rules to
        use. The default, false, uses the complete nearest neighbor model for
        multibranch loops. When true is passed, the energy model is instead a
        simplified model that is the one used by the dynamic programming
        algorithms.

        Returns:
        --------

        An int that indicates whether an error occurred (0 = no error; 5 =
        error reading parameter files). 
        """
        return _RNAstructure_wrap.RNA_WriteThermodynamicDetails(self, filename, UseSimpleMBLoopRules)


    def FoldSingleStrand(self, *args, **kwargs):
        """
        int
        RNA::FoldSingleStrand(const float percent=20, const int
        maximumstructures=20, const int window=5, const char savefile[]="",
        const int maxinternalloopsize=30, bool mfeonly=false)

        Predict the lowest free energy secondary structure and generate
        suboptimal structures using a heuristic.

        This function predicts the lowest free energy structure and suboptimal
        structures. If the temperature has not been specified using
        SetTemperature and no free energies have been calculated, the
        thermodynamic parameters have not been read and therefore they will be
        read by this function call. The parameter files should be located in
        the directory specified by the environment variable $DATAPATH of the
        pwd. In case of error, the function returns a non-zero that can be
        parsed by GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        percent:  is the maximum % difference in free energy in suboptimal
        structures from the lowest free energy structure. The default is 20.

        maximumstructures:  is the maximum number of suboptimal structures to
        generate. The default is 20.

        window:  is a parameter that specifies how different the suboptimal
        structures should be from each other (0=no restriction and larger
        integers require structures to be more different). The defaults is 5,
        but this should be customized based on sequence length.

        savefile:  is c string containing a file path and name for a savefile
        (.sav)that can be used to generate energy dot plots and to refold the
        secondary structure using different suboptimal structure parameters.
        The default is "", which results in no save file written.

        maxinternalloopsize:  is the maximum number of unpaired nucleotides in
        bulge and internal loops. This is used to accelerate the prediction
        speed. The default is 30.

        mfeonly:  is a bool that indicates whether only the minimum free
        energy structure will be generated. This saves half the calculation
        time, but no save file can be generated. Default is false.

        Returns:
        --------

        An int that indicates an error code (0 = no error, 5 = error reading
        thermodynamic parameter files, 14 = traceback error). 
        """
        return _RNAstructure_wrap.RNA_FoldSingleStrand(self, *args, **kwargs)


    def GenerateAllSuboptimalStructures(self, percent=5, deltaG=0.6):
        """
        int
        RNA::GenerateAllSuboptimalStructures(const float percent=5, const
        double deltaG=0.6)

        Predict the lowest free energy secondary structure and generate all
        suboptimal structures.

        This function predicts the lowest free energy structure and suboptimal
        structures. If the temperature has not been specified using
        SetTemperature and no free energies have been calculated, the
        thermodynamic parameters have not been read and therefore they will be
        read by this function call. The parameter files should be located in
        the directory specified by the environment variable $DATAPATH of the
        pwd. In case of error, the function returns a non-zero that can be
        parsed by GetErrorMessage() or GetErrorMessageString(). Two controls
        are available for limiting the number of structures, the maximum %
        difference in energy (percent) and the maximum absolute change in
        energy (deltaG). The smaller of the two will be used as the limit.

        Parameters:
        -----------

        percent:  is the maximum % difference in free energy in suboptimal
        structures from the lowest free energy structure. The default is 5.

        deltaG:  is the maximum difference in free energy change above the
        lowest free energy structure (in kcal/mol). The defaults is 0.6
        kcal/mol.

        Returns:
        --------

        An int that indicates an error code (0 = no error, non-zero = error).

        """
        return _RNAstructure_wrap.RNA_GenerateAllSuboptimalStructures(self, percent, deltaG)


    def MaximizeExpectedAccuracy(self, maxPercent=20, maxStructures=20, window=1, gamma=1.0):
        """
        int
        RNA::MaximizeExpectedAccuracy(const double maxPercent=20, const int
        maxStructures=20, const int window=1, const double gamma=1.0)

        Predict the structure with maximum expected accuracy and suboptimal
        structures.

        This function predicts structures composed of probable base pairs and
        single-srtranded nucleotide, weighted by gamma. The score for a
        structure is = gamma * 2 * (sum of pairing probabilities for pairs) +
        (sum of unpairing probabilities for single stranded nucleotides). This
        function requires partition function data from either a previous
        partition function calculations or from having read a partition
        function save file during construction of the class. In case of error,
        the function returns a non-zero that can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        maxPercent:  is the maximum percent difference is score in generating
        suboptimal structures. The default is 20.

        maxStructures:  is the maximum number of suboptimal structures to
        generate. The default is 20.

        window:  is the window parameter, where a higher value generates
        suboptimal structures that are more different from each other. The
        default is 1.

        gamma:  is the weight given to base pairs

        Returns:
        --------

        An int that indicates an error code (0 = no error, non-zero = error).

        """
        return _RNAstructure_wrap.RNA_MaximizeExpectedAccuracy(self, maxPercent, maxStructures, window, gamma)


    def PartitionFunction(self, *args, **kwargs):
        """
        int
        RNA::PartitionFunction(const char savefile[]="", double
        temperature=-10.0)

        Predict the partition function for a sequence.

        This function must be called to predict base pair probabilities,
        perform stochastic traceback, or for maximizing expected accuracy. If
        the temperature has not been specified using SetTemperature and no
        free energies have been calculated, the thermodynamic parameters have
        not been read and therefore they will be read by this function call.
        The parameter files should be located in the directory specified by
        the environment variable $DATAPATH of the pwd. In case of error, the
        function returns a non-zero that can be parsed by GetErrorMessage() or
        GetErrorMessageString(). Note that the parameter temperature is used
        when calculating equilibrium constants, but does not change the
        temperature at which the free energies are determined. SetTemperature,
        from the underlying base class Thermodynamics, should be used to
        change the temperature for most calculations. This parameter should
        generally not be used. The default is -10.0 and values below zero
        cause this parameter to be ignored (the correct default behavior).
        Note also that if SetTemperature is not used, the temperature defaults
        to 310.15 K (37 deg. C), which is the desired behavior for most
        purposes.

        Parameters:
        -----------

        savefile:  is a c string that contains the path and filename for
        creating a save file. This defaults to "", which indicates no file
        is to be written.

        temperature:  is a double that indicates a pseudo-temperature for
        calculating equilibrium constants from free energies at fixed
        temperature previously specified.

        Returns:
        --------

        An int that indicates an error code (0 = no error, 5 = error reading
        thermodynamic parameter files). 
        """
        return _RNAstructure_wrap.RNA_PartitionFunction(self, *args, **kwargs)


    def Rsample(self, *args, **kwargs):
        return _RNAstructure_wrap.RNA_Rsample(self, *args, **kwargs)

    def PredictProbablePairs(self, probability=0):
        """
        int
        RNA::PredictProbablePairs(const float probability=0)

        Predict structures containing highly probable pairs.

        This function predicts structures composed of probable base pairs.
        This function requires partition function data from either a previous
        partition function calculations or from having read a partition
        function save file during construction of the class. In case of error,
        the function returns a non-zero that can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        probability:  is the pairing probability threshold, where pairs will
        be predicted if they have a higher probability. Note that a value of
        less than 0.5 (50%), will cause an error. The default value of zero
        will trigger the creation of 8 structures, with thresholds of >=0.99,
        >=0.97, >=0.95, >=0.90, >=0.80, >=0.70, >=0.60, >0.50.

        Returns:
        --------

        An int that indicates an error code (0 = no error, non-zero = error).

        """
        return _RNAstructure_wrap.RNA_PredictProbablePairs(self, probability)


    def ProbKnot(self, iterations=1, MinHelixLength=1):
        """
        int RNA::ProbKnot(int
        iterations=1, int MinHelixLength=1)

        Predict maximum expected accuracy structures that contain pseudoknots
        from either a sequence or a partition function save file.

        This function uses base pair probabilities to predict structures that
        contains pseudoknots. This function requires partition function data
        from either a previous partition function calculations or from having
        read a partition function save file during construction of the class.
        In case of error, the function returns a non-zero that can be parsed
        by GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        iterations:  is the number of iterations of pair selection that are
        performed. The default and recommended value is 1.

        MinHelixLength:  is the shortest helix that is allowed. If this is set
        >1, a post- processing step is performed to remove short helices.
        Default = 1, i.e. no post-processing.

        Returns:
        --------

        An int that indicates an error code (0 = no error, non-zero = error).

        """
        return _RNAstructure_wrap.RNA_ProbKnot(self, iterations, MinHelixLength)


    def ProbKnotFromSample(self, iterations=1, MinHelixLength=1):
        """
        int
        RNA::ProbKnotFromSample(int iterations=1, int MinHelixLength=1)

        Predict maximum expected accuracy structures that contain pseudoknots
        from a file containing ensemble of structures.

        This function uses base pair probabilities to predict structures that
        contains pseudoknots. This function requires a file with ensemble of
        structures. This function processes the file to calculate pair
        probabilities. In case of error, the function returns a non-zero that
        can be parsed by GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        iterations:  is the number of iterations of pair selection that are
        performed. The default and recommended value is 1.

        MinHelixLength:  is the shortest helix that is allowed. If this is set
        >1, a post- processing step is performed to remove short helices.
        Default = 1, i.e. no post-processing.

        Returns:
        --------

        An int that indicates an error code (0 = no error, non-zero = error).

        """
        return _RNAstructure_wrap.RNA_ProbKnotFromSample(self, iterations, MinHelixLength)


    def ReFoldSingleStrand(self, percent=20, maximumstructures=20, window=5):
        """
        int
        RNA::ReFoldSingleStrand(const float percent=20, const int
        maximumstructures=20, const int window=5)

        Re-predict the lowest free energy secondary structure and generate
        suboptimal structures using a heuristic.

        This function predicts the lowest free energy structure and suboptimal
        structure after a save file (.sav) was specified to the constructor.
        The step of predicting structures from the save file is rapid, so this
        is laregely a method to quickly generate a different set of suboptimal
        structures. Refolding can only be performed if the RNA constructor was
        called with a save file name. (That is, you cannot call this after
        calling fold single strand, without loading the data from disk with a
        new instance of RNA. This is for historical reasons.) In case of
        error, the function returns a non-zero that can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        percent:  is the maximum % difference in free energy in suboptimal
        structures from the lowest free energy structure. The default is 20.

        maximumstructures:  is the maximum number of suboptimal structures to
        generate. The default is 20.

        window:  is a parameter that specifies how different the suboptimal
        structures should be from each other (0=no restriction and larger
        integers require structures to be more different). The default is 5.

        Returns:
        --------

        An int that indicates an error code (0 = no error, 5 = error reading
        thermodynamic parameter files, 14 = traceback error). 
        """
        return _RNAstructure_wrap.RNA_ReFoldSingleStrand(self, percent, maximumstructures, window)


    def Stochastic(self, structures=1000, seed=1):
        """
        int RNA::Stochastic(const int
        structures=1000, const int seed=1)

        Sample structures from the Boltzman ensemable.

        This function requires partition function data from either a previous
        partition function calculations or from having read a partition
        function save file during construction of the class. In case of error,
        the function returns a non-zero that can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        structures:  is the number of structures to be sampled. The default is
        1000.

        seed:  is an integer that seeds the random number generator that is
        required for sampling, which defaults to 1.

        Returns:
        --------

        An int that indicates an error code (0 = no error, non-zero = error).

        """
        return _RNAstructure_wrap.RNA_Stochastic(self, structures, seed)


    def ForceDoubleStranded(self, i):
        """
        int
        RNA::ForceDoubleStranded(const int i)

        Force a nucleotide to be double stranded (base paired).

        This function indicates a nucleotide that is double stranded (paired).
        In subsequent structure prediction, this nucleotide will be double
        stranded. The function returns 0 with no error and a non-zero
        otherwise that can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        i:  is the index of the paired nucleotide.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 4 = nucleotide
        out of range, 8 = too many restraints specified, 9 = same nucleotide
        in conflicting restraint). 
        """
        return _RNAstructure_wrap.RNA_ForceDoubleStranded(self, i)


    def ForceFMNCleavage(self, i):
        """
        int
        RNA::ForceFMNCleavage(const int i)

        Indicate a nucleotide that is accessible to FMN cleavage (a U in GU
        pair).

        In subsequent structure prediction, this nucleotide will be in a GU
        pair. The function returns 0 with no error and a non-zero otherwise
        that can be parsed by GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        i:  is the index of the FMN-cleaved nucleotide.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 4 = nucleotide
        out of range, 8 = too many restraints specified, 9 = same nucleotide
        in conflicting restraint, 11 = nucleotide not U). 
        """
        return _RNAstructure_wrap.RNA_ForceFMNCleavage(self, i)


    def ForceMaximumPairingDistance(self, distance):
        """
        int
        RNA::ForceMaximumPairingDistance(const int distance)

        Force a maximum distance between apired nucleotides.

        In a subsequent structure prediction, there will be no pairs allowed
        between nucleotides more distant than distance, i.e. |j-i| < distance
        for i to pair to j. The function returns and error code; 0==no error,
        12== too long or too short distance.

        Parameters:
        -----------

        distance:  is the maximum pairing distance.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 12 = too
        short). 
        """
        return _RNAstructure_wrap.RNA_ForceMaximumPairingDistance(self, distance)


    def ForceModification(self, i):
        """
        int
        RNA::ForceModification(const int i)

        Force modification for a nucleotide.

        This function indicates a nucleotide that is accessible to chemical
        modification. In subsequent structure prediction, this nucleotide will
        be single stranded, at the end of a helix, or in or adjacent to a GU
        pair. The function returns 0 with no error and a non-zero otherwise
        that can be parsed by GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        i:  is the index of the nucleotide accessible to chemical
        modification.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 4 = nucleotide
        out of range, 8 = too many restraints specified). 
        """
        return _RNAstructure_wrap.RNA_ForceModification(self, i)


    def ForcePair(self, i, j):
        """
        int RNA::ForcePair(const int
        i, const int j)

        Force a pair between two nucleotides.

        This function forces a pair between two nucleotides in subsequent
        structure predictions. When multiple pairs are specified, the pairs
        must not force a pseudoknot. The function returns 0 with no error and
        a non-zero otherwise that can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        i:  is the index of one nucleotide in the pair.

        j:  is the index of the second nucleotide in the pair.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 4 = nucleotide
        out of range, 6 = pseudoknot formation, 7 = non-canonical pair, 8 =
        too many restraints specified, 9 = same nucleotide in conflicting
        restraint). 
        """
        return _RNAstructure_wrap.RNA_ForcePair(self, i, j)


    def ForceProhibitPair(self, i, j):
        """
        int
        RNA::ForceProhibitPair(const int i, const int j)

        Prohibit a pair between two nucleotides.

        This function prevents a pair between two nucleotides in subsequent
        structure predictions. The function returns 0 with no error and a non-
        zero otherwise that can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        i:  is the index of one nucleotide in the pair.

        j:  is the index of the second nucleotide in the pair.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 4 = nucleotide
        out of range, 8 = too many restraints specified, 9 = nucleotide in
        conflicting restraint). 
        """
        return _RNAstructure_wrap.RNA_ForceProhibitPair(self, i, j)


    def ForceSingleStranded(self, i):
        """
        int
        RNA::ForceSingleStranded(const int i)

        Force a nucleotide to be single stranded.

        This function indicates a nucleotide that is single stranded. In
        subsequent structure prediction, this nucleotide will be single
        stranded. The function returns 0 with no error and a non-zero
        otherwise that can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        i:  is the index of the nucleotide that is single stranded.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 4 = nucleotide
        out of range, 8 = too many restraints specified, 9 = same nucleotide
        in conflicting restraint). 
        """
        return _RNAstructure_wrap.RNA_ForceSingleStranded(self, i)


    def GetForcedDoubleStranded(self, constraintnumber):
        """
        int
        RNA::GetForcedDoubleStranded(const int constraintnumber)

        Return a nucleotide that is forced double stranded.

        This function returns a nucleotide that is constrainted to be paired.
        Constraints are numbered from zero to
        GetNumberofForcedDoubleStranded()-1.

        Parameters:
        -----------

        constraintnumber:  is the index to the constraint number.

        Returns:
        --------

        An integer that is the nucleotide index. If the constraintnumber is
        for a constraint that does not exist, zero is returned. 
        """
        return _RNAstructure_wrap.RNA_GetForcedDoubleStranded(self, constraintnumber)


    def GetForcedFMNCleavage(self, constraintnumber):
        """
        int
        RNA::GetForcedFMNCleavage(const int constraintnumber)

        Return a nucleotide that is accessible to FMN cleavage.

        This function returns a nucleotide that is constrainted to be
        accessible to FMN cleavage (a U in a GU pair). Constraints are
        numbered from zero to GetNumberofForcedFMNCleavages()-1.

        Parameters:
        -----------

        constraintnumber:  is the index to the constraint number.

        Returns:
        --------

        An integer that is the nucleotide index. If the constraintnumber is
        for a constraint that does not exist, zero is returned. 
        """
        return _RNAstructure_wrap.RNA_GetForcedFMNCleavage(self, constraintnumber)


    def GetForcedModification(self, constraintnumber):
        """
        int
        RNA::GetForcedModification(const int constraintnumber)

        Return a nucleotide that is accessible to modification.

        This function returns a nucleotide that is constrainted to be
        accessible to chemical modification. Constraints are numbered from
        zero to GetNumberofModifications()-1.

        Parameters:
        -----------

        constraintnumber:  is the index to the constraint number.

        Returns:
        --------

        An integer that is the nucleotide index. If the constraintnumber is
        for a constraint that does not exist, zero is returned. 
        """
        return _RNAstructure_wrap.RNA_GetForcedModification(self, constraintnumber)


    def GetForcedPair(self, constraintnumber, fiveprime):
        """
        int
        RNA::GetForcedPair(const int constraintnumber, const bool fiveprime)

        Return a nucleotide in a forced pair.

        This function returns either the five prime or three prime nucleotide
        in a forced pair constraint, depending on the value of fiveprime.
        Constraints are numbered from zero to GetNumberofForcedPairs()-1.

        Parameters:
        -----------

        constraintnumber:  is the index to the constraint number.

        fiveprime:  determines if the nucleotide is the five prime or the
        three prime nucleotide in the constraint. true = five prime
        nucleotide.

        Returns:
        --------

        An integer that is the nucleotide index. If the constraintnumber is
        for a constraint that does not exist, zero is returned. 
        """
        return _RNAstructure_wrap.RNA_GetForcedPair(self, constraintnumber, fiveprime)


    def GetForcedProhibitedPair(self, constraintnumber, fiveprime):
        """
        int
        RNA::GetForcedProhibitedPair(const int constraintnumber, const bool
        fiveprime)

        Return a nucleotide in a prohibited pair.

        This function returns either the five prime or three prime nucleotide
        in a prohibited pair constraint, depending on the value of fiveprime.
        Constraints are numbered from zero to GetNumberofForcedProhibited()-1.

        Parameters:
        -----------

        constraintnumber:  is the index to the constraint number.

        fiveprime:  determines if the nucleotide is the five prime or the
        three prime nucleotide in the constraint. true = five prime
        nucleotide.

        Returns:
        --------

        An integer that is the nucleotide index. If the constraintnumber is
        for a constraint that does not exist, zero is returned. 
        """
        return _RNAstructure_wrap.RNA_GetForcedProhibitedPair(self, constraintnumber, fiveprime)


    def GetForcedSingleStranded(self, constraintnumber):
        """
        int
        RNA::GetForcedSingleStranded(const int constraintnumber)

        Return a nucleotide that is forced single stranded.

        This function returns a nucleotide that is constrainted to be single
        stranded. Constraints are numbered from zero to
        GetNumberofForcedSingleStranded()-1.

        Parameters:
        -----------

        constraintnumber:  is the index to the constraint number.

        Returns:
        --------

        An integer that is the nucleotide index. If the constraintnumber is
        for a constraint that does not exist, zero is returned. 
        """
        return _RNAstructure_wrap.RNA_GetForcedSingleStranded(self, constraintnumber)


    def GetMaximumPairingDistance(self):
        """
        int
        RNA::GetMaximumPairingDistance()

        Return the maximum pairing distance.

        return An integer that indicates the maximum distance allowed between
        paired nucleotides, where -1 indicates that the maximum distance is
        not set. 
        """
        return _RNAstructure_wrap.RNA_GetMaximumPairingDistance(self)


    def GetNumberOfForcedDoubleStranded(self):
        """
        int
        RNA::GetNumberOfForcedDoubleStranded()

        Return the number of nucletides forced to be paired.

        Returns:
        --------

        An integer that indicates the number of nucleotides that are forced
        pair. 
        """
        return _RNAstructure_wrap.RNA_GetNumberOfForcedDoubleStranded(self)


    def GetNumberOfForcedFMNCleavages(self):
        """
        int
        RNA::GetNumberOfForcedFMNCleavages()

        Return the number of nucleotides accessible to FMN cleavage.

        Returns:
        --------

        An integer that indicates the number of FMN cleavage nucleotides (Us
        in GU pairs). 
        """
        return _RNAstructure_wrap.RNA_GetNumberOfForcedFMNCleavages(self)


    def GetNumberOfForcedModifications(self):
        """
        int
        RNA::GetNumberOfForcedModifications()

        Return the number of nucleotides accessible to chemical modification.

        Returns:
        --------

        An integer that indicates the number of modified nucleotides. 
        """
        return _RNAstructure_wrap.RNA_GetNumberOfForcedModifications(self)


    def GetNumberOfForcedPairs(self):
        """
        int
        RNA::GetNumberOfForcedPairs()

        Return the number of forced base pairs.

        Returns:
        --------

        An integer that indicates the number of forced pairs. 
        """
        return _RNAstructure_wrap.RNA_GetNumberOfForcedPairs(self)


    def GetNumberOfForcedProhibitedPairs(self):
        """
        int
        RNA::GetNumberOfForcedProhibitedPairs()

        Return the number of prohibited base pairs.

        Returns:
        --------

        An integer that indicates the number of pairs that are prohibited. 
        """
        return _RNAstructure_wrap.RNA_GetNumberOfForcedProhibitedPairs(self)


    def GetNumberOfForcedSingleStranded(self):
        """
        int
        RNA::GetNumberOfForcedSingleStranded()

        Return the number of nucleotides that are not allowed to pair.

        Returns:
        --------

        An integer that indicates the number of nucleotides not allowed to
        pair. 
        """
        return _RNAstructure_wrap.RNA_GetNumberOfForcedSingleStranded(self)


    def ReadConstraints(self, filename):
        """
        int
        RNA::ReadConstraints(const char filename[])

        Read a set of folding constraints to disk in a plain text file.

        The file format for constraints is that generated by the
        WriteConstraints() function. The function returns 0 with no error and
        a non-zero otherwise that can be parsed by GetErrorMessage() or
        GetErrorMessageString(). Note that calling ReadConstraints() will
        erase previously defined constraints (except for SHAPE pseudoenergy
        restraints).

        Parameters:
        -----------

        filename:  is a c string that is the file name to be read.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 1 = file not
        found, 13 = error reading constraint file). 
        """
        return _RNAstructure_wrap.RNA_ReadConstraints(self, filename)


    def ReadSHAPE(self, *args):
        """
        int RNA::ReadSHAPE(const char
        filename[], const double parameter1, const double parameter2, const
        double ssm, const double ssb, std::string modifier="SHAPE")

        Read SHAPE data from disk including single-stranded SHAPE pseudo free
        energys.

        The SHAPE data is used to constrain structure prediction on subsequent
        structure predictions. This version of the overloaded function
        includes a single-stranded pseudo free energy change. The function
        returns 0 with no error and a non-zero otherwise that can be parsed by
        GetErrorMessage() or GetErrorMessageString(). Pseudo folding free
        energy change parameters should be in units of kcal/mol.

        Parameters:
        -----------

        filename:  is a c string that indicates a file that contains SHAPE
        data.

        parameter1:  is the double-stranded slope.

        parameter2:  is the double-stranded intercept.

        modifier:  is the type of chemical modification probe that was used
        (currently accepted values are SHAPE, DMS, and CMCT). Defaults to
        SHAPE.

        ssm:  is the single-stranded slope.

        ssb:  is the single-stranded intercept.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 1 = input file
        not found). 
        """
        return _RNAstructure_wrap.RNA_ReadSHAPE(self, *args)


    def ReadDMS(self, filename):
        return _RNAstructure_wrap.RNA_ReadDMS(self, filename)

    def ReadDSO(self, filename):
        """
        int RNA::ReadDSO(const char
        filename[])

        Read double strand offset data from disk.

        The double strand offset is data that is used to constrain structure
        prediction on subsequent structure predictions. This is a free energy
        in kcal/mol that is added to a specific nucleotide that is double
        stranded. The function returns 0 with no error and a non-zero
        otherwise that can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        filename:  is a c string that indicates a file that contains data, in
        a raw format with nucleotide index and offset (one set per line).

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 1 = input file
        not found). 
        """
        return _RNAstructure_wrap.RNA_ReadDSO(self, filename)


    def ReadSSO(self, filename):
        """
        int RNA::ReadSSO(const char
        filename[])

        Read single strand offset data from disk.

        The single strand offset is data that is used to constrain structure
        prediction on subsequent structure predictions. This is a free energy
        in kcal/mol that is added to a specific nucleotide that is single
        stranded. The function returns 0 with no error and a non-zero
        otherwise that can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        filename:  is a c string that indicates a file that contains data, in
        a raw format with nucleotide index and offset (one set per line).

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 1 = input file
        not found). 
        """
        return _RNAstructure_wrap.RNA_ReadSSO(self, filename)


    def ReadExperimentalPairBonus(self, filename, experimentalOffset, experimentalScaling):
        """
        int
        RNA::ReadExperimentalPairBonus(const char filename[], double const
        experimentalOffset, double const experimentalScaling)

        Read experimental pair bonuses from disk.

        This is a quantity that results in a bonus added to a specific pair,
        once per stack, so that pairs in the middle of a helix get the bonus
        twice and those at the end of a helix get the bonus once. The bonus is
        in the form of experimentalScaling*value + experimentalOffset. The
        data is formatted using a simple square matrix of values and no
        headers. The format requires that there be N^2 entries for a sequence
        of N nucleotides.

        Parameters:
        -----------

        filename:  is a c string that indicates a file that contains data.

        experimentalOffset:  is a double that is added to each value.

        experimentalScaling:  is a double by which each value is multiplied.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 1 = input file
        not found). 
        """
        return _RNAstructure_wrap.RNA_ReadExperimentalPairBonus(self, filename, experimentalOffset, experimentalScaling)


    def RemoveConstraints(self):
        """
        void
        RNA::RemoveConstraints()

        Remove all folding constraints.

        This function strips all previously assigned folding constraints. Note
        that this function does not delete SHAPE constraints or pseudo free
        energies. 
        """
        return _RNAstructure_wrap.RNA_RemoveConstraints(self)


    def SetExtrinsic(self, i, j, k):
        """
        int RNA::SetExtrinsic(int
        i, int j, double k)

        Add extrinsic restraints for partition function calculations.

        This function multiplies the equilibrium constant for structures
        including the i-j basepair by k. This applies only to partition
        functions and to stochastic traceback. If k>1, then the i-j pair is
        favored and if k<1, the i-j pair is disfavored. k should always be >=
        0. In case of error, the function returns a non-zero that can be
        parsed by GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        i:  is the index of a nucleotide in the i-j pair.

        j:  is the index of the other nucleotide in the i-j pair.

        k:  is an equilibrium constant that is >= 0.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, >0 indicates an
        error). 
        """
        return _RNAstructure_wrap.RNA_SetExtrinsic(self, i, j, k)


    def WriteConstraints(self, filename):
        """
        int
        RNA::WriteConstraints(const char filename[])

        Write the current set of folding constraints to disk in a plain text
        file.

        This function does not write SHAPE pseudo energies.

        Parameters:
        -----------

        filename:  is a c string that is the file name to be written.

        Returns:
        --------

        An integer that indicates an error code (0 = no error). Currently,
        this function does not generate errors, but the return is provided to
        add error handling in the future. 
        """
        return _RNAstructure_wrap.RNA_WriteConstraints(self, filename)


    def AddComment(self, comment, structurenumber=1):
        """
        int RNA::AddComment(const
        char comment[], const int structurenumber=1)

        Add a comment associated with a structure.

        This comment will appear in a written .ct file. The comment is
        appended to any existing comments, like titles read from .seq files.
        This function is especially useful if the constructor is used in which
        a character array is provided with the sequence. In that case, there
        is no sequence title read. The function returns 0 in the case of no
        errors, or 3 if the structurenumber is invalid. An error message can
        be retrieved using GetErrorMessage() called with the errorcode.

        Parameters:
        -----------

        comment:  is a character array that contains a null terminated
        c-string with the comment to be registered.

        structurenumber:  is an integer that specifies to which structure the
        comment should be added.

        Returns:
        --------

        An integer that contains an error code, where 0 is no error and non-
        zero is an error. 
        """
        return _RNAstructure_wrap.RNA_AddComment(self, comment, structurenumber)


    def WriteCt(self, *args, **kwargs):
        """
        int RNA::WriteCt(const char
        filename[], bool append=false)

        Write a ct file of the structures.

        Return 0 if no error and non-zero errors can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        filename:  is a NULL terminated c string that specifies the name of
        the ct file to be written.

        append:  is a bool that indiactes whether the ct data should be
        appended to an existing file. If true, data will be appended if the
        file exists, or a new file created if the file does not exist. If
        false, any esiting file is overwritten. This is false by default.

        Returns:
        --------

        An integer that provides an error code. 0 = no error, 10 = no
        structure to write. 
        """
        return _RNAstructure_wrap.RNA_WriteCt(self, *args, **kwargs)


    def WriteDotBracket(self, *args, **kwargs):
        """
        int
        RNA::WriteDotBracket(const char filename[])

        Write dot-bracket file of structures.

        Return 0 if no error and non-zero errors can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        filename:  is a NULL terminated c string that specified the name of
        the file to be written.

        Returns:
        --------

        An integer that provides an error code. 0 = no error. 
        """
        return _RNAstructure_wrap.RNA_WriteDotBracket(self, *args, **kwargs)


    def BreakPseudoknot(self, minimum_energy=True, structurenumber=0, useFastMethod=True):
        """
        int
        RNA::BreakPseudoknot(const bool minimum_energy=true, const int
        structurenumber=0)

        Break any pseudoknots that might be in a structure.

        This function uses the method of Smit et al. to break pseudoknots by
        running a dynamic programming algorithm that cannot predict
        pseudoknots while only allowing the pairs that already exist in the
        structure. When minimum_energy = true (the default), this function
        predicts the lowest free energy structure that has no pseudoknots.
        Note that when minimum_energy = true, this function might additionally
        break pairs that are not pseudoknotted if the pairs increase the
        folding free energy change or are forbidden (as in an isolated pair).
        Also note that when minum_energy=true, this function uses the
        GenerateAllSuboptimalStructures methodology behind the scenes, so
        large internal loops in the input would lead to a loss of pairs. When
        minumum_energy is set to false, this function maximizes the number of
        base pairs in the pseudoknot free structure. Return 0 if no error and
        non-zero errors can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        minimum_energy:  is a bool thgat indicates where the structure should
        be minimum in free energy (true) or maximize pairs (false).

        structurenumber:  is an int that indicates a specific structure for
        which to break pseudoknots (indexed from 1). The default value, 0,
        indicates that all structures should have pseudoknots broken.

        Returns:
        --------

        an int that provides an error code. 0 = no error. 
        """
        return _RNAstructure_wrap.RNA_BreakPseudoknot(self, minimum_energy, structurenumber, useFastMethod)


    def ContainsPseudoknot(self, structurenumber):
        """
        bool
        RNA::ContainsPseudoknot(const int structurenumber)

        Report if there are any pseudoknots in a structure.

        This method checks for any "crossing pairs," i.e. i-j and i'-j' s.t.
        i < i' < j < jp. If there is at least one crossing pair set, then
        there is a pseudoknot and the function returns true. This function
        generates internal error codes that can be accessed by GetErrorCode()
        after the constructor is called: 0 = no error, nonzero = error. The
        errorcode can be resolved to a c string using GetErrorMessage.

        Parameters:
        -----------

        structurenumber:  is an int that indicates the structure number to
        check. Note that indexing of structures starts with structure #1.

        Returns:
        --------

        A bool that indicates whether there is a pseudoknot. 
        """
        return _RNAstructure_wrap.RNA_ContainsPseudoknot(self, structurenumber)


    def GetEnsembleEnergy(self):
        """
        double
        RNA::GetEnsembleEnergy()

        Get the ensemble folding free energy change.

        Returns the ensemble folding free energy change as determined by the
        partition function. This is a handy way of getting the size of the
        partition function Q, which itself is too large to fit in a double for
        all but the shortest sequences. The ensemble folding free energy
        change = -RT ln (Q). Function requires that the partition function
        data be present either because PartitionFunction() has been called or
        the constructor that reads a partition function save was used. This
        function generates internal error codes that can be accessed by
        GetErrorCode() after the constructor is called: 0 = no error, nonzero
        = error. The errorcode can be resolved to a c string using
        GetErrorMessage.

        Returns:
        --------

        A double that is the ensemble folding free energy change in kcal/mol.

        """
        return _RNAstructure_wrap.RNA_GetEnsembleEnergy(self)


    def GetEnsembleDefect(self, structurenumber=1):
        return _RNAstructure_wrap.RNA_GetEnsembleDefect(self, structurenumber)

    def GetFreeEnergy(self, structurenumber):
        """
        double
        RNA::GetFreeEnergy(const int structurenumber)

        Get the folding free energy change for a predicted structure.

        Returns the folding free energy change of structure i as determined by
        a previous folding calculation. Function requires that the structure
        be predicted by a structure prediction method. This function generates
        internal error codes that can be accessed by GetErrorCode() after the
        constructor is called: 0 = no error, nonzero = error. The errorcode
        can be resolved to a c string using GetErrorMessage.

        Parameters:
        -----------

        structurenumber:  is an integer indicating the predicted structure
        number.

        Returns:
        --------

        A double that is the folding free energy change in kcal/mol. 
        """
        return _RNAstructure_wrap.RNA_GetFreeEnergy(self, structurenumber)


    def GetPair(self, i, structurenumber=1):
        """
        int RNA::GetPair(const int i,
        const int structurenumber=1)

        Get the nucleotide to which the specified nucleotide is paired.

        Returns the pairing partner of the ith nucleotide in structure number
        structurenumber. Zero means the nucleotide is unpaired. This function
        generates internal error codes that can be accessed by GetErrorCode()
        after the constructor is called: 0 = no error, nonzero = error. The
        errorcode can be resolved to a c string using GetErrorMessage.

        Parameters:
        -----------

        i:  is an int that indicates the nucleotide to which the pairing
        partner is being queried.

        structurenumber:  is an int that indicates the structure number, where
        the default is 1.

        Returns:
        --------

        An int that indicates the other nucleotide in pair, where 0 is no
        paired. 
        """
        return _RNAstructure_wrap.RNA_GetPair(self, i, structurenumber)


    def GetPairEnergy(self, i, j):
        """
        double
        RNA::GetPairEnergy(const int i, const int j)

        Get the lowest folding free energy possible for a structure containing
        pair i-j.

        Returns a folding free energy change in kcal/mol for use in energy dot
        plots. This function requires that the RNA constructor be called with
        a save file (.sav) name. (That is, for historical resaons, this cannot
        be called after FoldSingleStrand without writing the data to disk.)
        This function generates internal error codes that can be accessed by
        GetErrorCode() after the constructor is called: 0 = no error, nonzero
        = error. The errorcode can be resolved to a c string using
        GetErrorMessage. param i and j are ints that provide indexes the 5'
        and 3' nucleotides, respectively, in a pair. return A double that is
        the folding free energy change in kcal/mol. 
        """
        return _RNAstructure_wrap.RNA_GetPairEnergy(self, i, j)


    def GetPairProbability(self, i, j):
        """
        double
        RNA::GetPairProbability(const int i, const int j)

        Get a base pair probability.

        Returns the base pair probability for the pair between i and j.
        Function requires that the partition function data be present either
        because PartitionFunction() has been called or the constructor that
        reads a partition function save was used. This function generates
        internal error codes that can be accessed by GetErrorCode(): 0 = no
        error, nonzero = error. The errorcode can be resolved to a c string
        using GetErrorMessage.

        Parameters:
        -----------

        i:  provides the 5' nucleotide in a pair.

        j:  provides the 3' nucleotides in a pair.

        Returns:
        --------

        A double that is the base pair probability. If i and j cannot pair,
        0.0 is returned. If an error occurs, 0.0 is returned. 
        """
        return _RNAstructure_wrap.RNA_GetPairProbability(self, i, j)


    def GetPairProbabilities(self, arr, size):
        return _RNAstructure_wrap.RNA_GetPairProbabilities(self, arr, size)

    def GetStructureNumber(self):
        """
        int
        RNA::GetStructureNumber()

        Get the total number of specified or predicted structures.

        Returns:
        --------

        An integer specify the total number of structures. 
        """
        return _RNAstructure_wrap.RNA_GetStructureNumber(self)


    def DetermineDrawingCoordinates(self, height, width, structurenumber=1):
        """
        int
        RNA::DetermineDrawingCoordinates(const int height, const int width,
        const int structurenumber=1)

        Determine the coordinates for drawing a secondary structure.

        This function determines drawing coordinates for all nucleotides in
        structure number structurenumber. User must specify the height and
        width of a character (use the largest of nucleotides). The coordinates
        are in an abstract palette; the user must determine the minimum and
        maximum coordinate in both the x and y direction. The actual
        coordinates are fetched using GetNucleotideXCoordinate(int i) and
        GetNucleotideYCoordinate(int i). This function returns are error code,
        where 0=no error and other messages can be resolved to a c string
        using GetErrorMessage. The structure to be drawn must be free of
        pseudoknots.

        Parameters:
        -----------

        height:  is an integer that refers to the height of a nucleotide.

        width:  is an integer that refers to the width of a nucleotide, where
        the largest nucleotide should be provided or a non-proportional font
        should be used.

        structurenumber:  is an integer that refers to the structure to be
        drawn.

        Returns:
        --------

        An int that provides an error code, 0 = no error and other errors can
        be resolved to a c string using GetErrorMessage. 
        """
        return _RNAstructure_wrap.RNA_DetermineDrawingCoordinates(self, height, width, structurenumber)


    def GetCommentString(self, structurenumber=1):
        """
        std::string
        RNA::GetCommentString(const int structurenumber=1)

        Provide the comment from the ct file as a string.

        This function provides the comment from the CT file for a structure as
        a string. This function generates internal error codes that can be
        accessed by GetErrorCode() after the function is called: 0 = no error,
        nonzero = error. The errorcode can be resolved to a c string using
        GetErrorMessage.

        Parameters:
        -----------

        structurenumber:  is the structure for which the comment is to be
        provided.

        Returns:
        --------

        A string that provides the comment. 
        """
        return _RNAstructure_wrap.RNA_GetCommentString(self, structurenumber)


    def GetNucleotideXCoordinate(self, i):
        """
        int
        RNA::GetNucleotideXCoordinate(const int i)

        Get the X coordinate for nucleotide i for drawing a structure.

        This function gets the X coordinate for placing the nucleotide
        specified by i. The user needs to have determined the coordinates for
        a complete structure using DetermineDrawingCoordinates prior to making
        this call. This function generates internal error codes that can be
        accessed by GetErrorCode(): 0 = no error, nonzero = error. The
        errorcode can be resolved to a c string using GetErrorMessage. Zero is
        returned in case of error, but note that zero is also a valid
        coordinate.

        Parameters:
        -----------

        i:  is an integer refering to the nucleotide to be drawn.

        Returns:
        --------

        An int that gives the X coordinate. 
        """
        return _RNAstructure_wrap.RNA_GetNucleotideXCoordinate(self, i)


    def GetNucleotideYCoordinate(self, i):
        """
        int
        RNA::GetNucleotideYCoordinate(const int i)

        Get the Y coordinate for nucleotide i for drawing a structure.

        This function gets the Y coordinate for placing the nucleotide
        specified by i. The user needs to have determined the coordinates for
        a complete structure using DetermineDrawingCoordinates prior to making
        this call. This function generates internal error codes that can be
        accessed by GetErrorCode(): 0 = no error, nonzero = error. The
        errorcode can be resolved to a c string using GetErrorMessage. Zero is
        returned in case of error, but note that zero is also a valid
        coordinate.

        Parameters:
        -----------

        i:  is an integer refering to the nucleotide to be drawn.

        Returns:
        --------

        An int that gives the Y coordinate. 
        """
        return _RNAstructure_wrap.RNA_GetNucleotideYCoordinate(self, i)


    def GetLabelXCoordinate(self, i):
        """
        int
        RNA::GetLabelXCoordinate(const int i)

        Get the X coordinate for placing the nucleotide index label specified
        by i.

        This function gets the X coordinate for placing the nucleotide index
        label specified by i. The user needs to have determined the
        coordinates for a complete structure using DetermineDrawingCoordinates
        prior to making this call. This function generates internal error
        codes that can be accessed by GetErrorCode(): 0 = no error, nonzero =
        error. The errorcode can be resolved to a c string using
        GetErrorMessage. Zero is returned in case of error, but note that zero
        is also a valid coordinate. One additiona caveat: Labels that are
        placed at 0,0 are lables that would have overlapped nucleotides. These
        labels should not be drawn.

        Parameters:
        -----------

        i:  is an integer refering to the label to be drawn. This needs to be
        a multiple of 10.

        Returns:
        --------

        An int that gives the X coordinate. 
        """
        return _RNAstructure_wrap.RNA_GetLabelXCoordinate(self, i)


    def GetLabelYCoordinate(self, i):
        """
        int
        RNA::GetLabelYCoordinate(const int i)

        Get the Y coordinate for placing the nucleotide index label specified
        by i.

        This function gets the Y coordinate for placing the nucleotide index
        label specified by i. The user needs to have determined the
        coordinates for a complete structure using DetermineDrawingCoordinates
        prior to making this call. This function generates internal error
        codes that can be accessed by GetErrorCode(): 0 = no error, nonzero =
        error. The errorcode can be resolved to a c string using
        GetErrorMessage. Zero is returned in case of error, but note that zero
        is also a valid coordinate. One additiona caveat: Labels that are
        placed at 0,0 are lables that would have overlapped nucleotides. These
        labels should not be drawn.

        Parameters:
        -----------

        i:  is an integer refering to the label to be drawn. This needs to be
        a multiple of 10.

        Returns:
        --------

        An int that gives the Y coordinate. 
        """
        return _RNAstructure_wrap.RNA_GetLabelYCoordinate(self, i)


    def GetNucleotide(self, i):
        """
        char
        RNA::GetNucleotide(const int i)

        param An integer specifying the nucleotide index (starting at 1 and
        ending at GetSequenceLength()). This function generates internal error
        codes that can be accessed by GetErrorCode(): 0 = no error, nonzero =
        error. The errorcode can be resolved to a c string using
        GetErrorMessage. Note that nucleotides are numbered starting at an
        index of 1. return The char representing the nucleotide at index i or
        '-' if an error occured. 
        """
        return _RNAstructure_wrap.RNA_GetNucleotide(self, i)


    def GetSequenceLength(self):
        """
        int
        RNA::GetSequenceLength()

        Get the total length of the sequence.

        Returns:
        --------

        An integer that specifies the total length of the sequence. 
        """
        return _RNAstructure_wrap.RNA_GetSequenceLength(self)


    def GetSequence(self):
        return _RNAstructure_wrap.RNA_GetSequence(self)

    def GetBackboneType(self):
        """
        bool
        RNA::GetBackboneType()

        Get the backbone type.

        This function returns whether the backbone is RNA or DNA. Note that
        backbone type is set when calling the constructor.

        Returns:
        --------

        A bool that indicates the backbone (true = RNA, false = DNA). 
        """
        return _RNAstructure_wrap.RNA_GetBackboneType(self)


    def GetStructure(self):
        """
        structure *
        RNA::GetStructure()

        Access the underlying structure class. This is provided for use with
        two sequence methods. Generally, there is no need for end users to use
        this function because the RNA class provides an convenient wrapper for
        accessing the information in an RNA class.

        Returns:
        --------

        A pointer to structure. 
        """
        return _RNAstructure_wrap.RNA_GetStructure(self)


    def SetProgress(self, Progress):
        """
        void
        RNA::SetProgress(TProgressDialog &Progress)

        Provide a TProgressDialog for following calculation progress. A
        TProgressDialog class has a public function void update(int percent)
        that indicates the progress of a long calculation.

        Parameters:
        -----------

        Progress:  is a TProgressDialog class. 
        """
        return _RNAstructure_wrap.RNA_SetProgress(self, Progress)


    def StopProgress(self):
        """
        void RNA::StopProgress()

        Provide a means to stop using a TProgressDialog. StopProgress tells
        the RNA class to no longer follow progress. This should be called if
        the TProgressDialog is deleted, so that this class does not make
        reference to it. 
        """
        return _RNAstructure_wrap.RNA_StopProgress(self)


    def GetProgress(self):
        """
        TProgressDialog *
        RNA::GetProgress()

        Return the current pointer to TProgressDialog. This is used during
        inheritance to provide access to the underlying TProgressDialog. 
        """
        return _RNAstructure_wrap.RNA_GetProgress(self)

    __swig_destroy__ = _RNAstructure_wrap.delete_RNA
    __del__ = lambda self: None

    def CopyThermo(self, copy):
        return _RNAstructure_wrap.RNA_CopyThermo(self, copy)
RNA_swigregister = _RNAstructure_wrap.RNA_swigregister
RNA_swigregister(RNA)

def RNA_GetErrorMessage(error):
    """
    char *
    RNA::GetErrorMessage(const int error)

    Return error messages based on code from GetErrorCode and other error
    codes.

    0 = no error 1 = input file not found 2 = error opening file 3 =
    structure number out of range 4 = nucleotide number out of range 5 =
    error reading thermodynamic parameters 6 = pseudoknot formation 7 =
    non-canonical pair 8 = too many restraints specified 9 = same
    nucleotide in conflicting restraint 10 = no structures to write 11 =
    nucleotide not a U (caused by ForceFMNCleavage() 12 = distance too
    short 13 = error reading constraint file 14 = traceback error 15 = no
    partition function data present 16 = incorrect save file version used
    17 = cannot be performed without having read a save file (.sav) 18 =
    threshold is too low to be valid 19 = drawing coordinates have not
    been determined 20 = no sequence has been read 21 = over 1 probability
    error on stochastic traceback 22 = programming error, unrecognized
    input to constructor 23 = no structures present 24 = too few
    iterations 25 = index (for drawing) is not a multiple of 10

    Parameters:
    -----------

    error:  is the integer error code provided by GetErrorCode() or from
    other functions that return integer error codes.

    Returns:
    --------

    A pointer to a c string that provides an error message. 
    """
    return _RNAstructure_wrap.RNA_GetErrorMessage(error)

class HybridRNA(RNA):
    """


    HybridRNA Class.

    The HybridRNA class provides an entry point for all the bimolecular
    structure prediction routines of RNAstructure. The class is inherited
    from the RNA class and contains an instance of TwoRNA, which itself
    contains two instances to the class RNA.

    C++ includes: HybridRNA.h 
    """

    __swig_setmethods__ = {}
    for _s in [RNA]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HybridRNA, name, value)
    __swig_getmethods__ = {}
    for _s in [RNA]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HybridRNA, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        HybridRNA::HybridRNA(const char filename1[], const int type1, const
        char filename2[], const int type2, const bool IsRNA=true) 
        """
        this = _RNAstructure_wrap.new_HybridRNA(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def AccessFold(self, gamma=0.4, percent=50, maximumstructures=20, window=0, maxinternalloopsize=30):
        """
        int
        HybridRNA::AccessFold(const double gamma=0.4, const float percent=50,
        const int maximumstructures=20, const int window=0, const int
        maxinternalloopsize=30)

        Predict the lowest free energy secondary structure for two interacting
        strands and generate suboptimal structures. Thuis method does not
        allow intramolecular pairs. It considers accessibility with a
        heuristic that uses tge partition function. If the temperature has not
        been specified using the RNA base class SetTemperature and no free
        energies have been calculated, the thermodynamic parameters have not
        been read and therefore they will be read by this function call. The
        parameter files should be located in the directory specified by the
        environment variable $DATAPATH of the pwd. In case of error, the
        function returns a non- zero that can be parsed by GetErrorMessage()
        or GetErrorMessageString().

        Parameters:
        -----------

        gamma:  is a scaling factor that weights accessibility. The defaults
        is 0.4

        percent:  is the maximum % difference in free energy in suboptimal
        structures from the lowest free energy structure. The default is 50.

        maximumstructures:  is the maximum number of suboptimal structures to
        generate. The fefault is 20.

        window:  is a parameter that specifies how different the suboptimal
        structures should be from each other (0=no restriction and larger
        integers require structures to be more different). The default is 0.

        maxinternalloopsize:  is the maximum number of unpaired nucleotides in
        bulge and internal loops. This is used to accelerate the prediction
        speed. The default is 30.

        Returns:
        --------

        An int that indicates an error code (0 = no error, 5 = error reading
        thermodynamic parameter files, 14 = traceback error). 
        """
        return _RNAstructure_wrap.HybridRNA_AccessFold(self, gamma, percent, maximumstructures, window, maxinternalloopsize)


    def FoldBimolecular(self, *args, **kwargs):
        """
        int
        HybridRNA::FoldBimolecular(const float percent=10, const int
        maximumstructures=20, const int window=0, const char savefile[]="",
        const int maxinternalloopsize=30)

        Predict the lowest free energy secondary structure and generate
        suboptimal structures using a heuristic.

        This function predicts the lowest free energy structure and suboptimal
        structures. If the temperature has not been specified using the RNA
        base class SetTemperature and no free energies have been calculated,
        the thermodynamic parameters have not been read and therefore they
        will be read by this function call. The parameter files should be
        located in the directory specified by the environment variable
        $DATAPATH of the pwd. In case of error, the function returns a non-
        zero that can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        percent:  is the maximum % difference in free energy in suboptimal
        structures from the lowest free energy structure. The default is 10.

        maximumstructures:  is the maximum number of suboptimal structures to
        generate. The defaults is 20.

        window:  is a parameter that specifies how different the suboptimal
        structures should be from each other (0=no restriction and larger
        integers require structures to be more different). The default is 0.

        savefile:  is c string containing a file path and name for a savefile
        (.sav)that can be used to generate energy dot plots and to refold the
        secondary structure using different suboptimal structure parameters.
        The default is "", which results in no save file written.

        maxinternalloopsize:  is the maximum number of unpaired nucleotides in
        bulge and internal loops. This is used to accelerate the prediction
        speed. The default is 30.

        Returns:
        --------

        An int that indicates an error code (0 = no error, 5 = error reading
        thermodynamic parameter files, 14 = traceback error). 
        """
        return _RNAstructure_wrap.HybridRNA_FoldBimolecular(self, *args, **kwargs)


    def FoldDuplex(self, percent=40, maximumstructures=10, window=0, maxinternalloopsize=30):
        """
        int
        HybridRNA::FoldDuplex(const float percent=40, const int
        maximumstructures=10, const int window=0, const int
        maxinternalloopsize=30)

        Predict the lowest free energy secondary structure for two strands
        that cannot form intramolecular pairs and generate suboptimal
        structures using a heuristic.

        This function predicts the lowest free energy bimolecular structure
        and suboptimal structures. This function does not allow any folding
        constraints. If the temperature has not been specified using
        SetTemperature and no free energies have been calculated, the
        thermodynamic parameters have not been read and therefore they will be
        read by this function call. The parameter files should be located in
        the directory specified by the environment variable $DATAPATH of the
        pwd. In case of error, the function returns a non-zero that can be
        parsed by GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        percent:  is the maximum % difference in free energy in suboptimal
        structures from the lowest free energy structure. The default is 40.

        maximumstructures:  is the maximum number of suboptimal structures to
        generate. The default is 10.

        window:  is a parameter that specifies how different the suboptimal
        structures should be from each other (0=no restriction and larger
        integers require structures to be more different). The default is 0.

        maxinternalloopsize:  is the maximum number of unpaired nucleotides in
        bulge and internal loops. This is used to accelerate the prediction
        speed. The default is 30.

        Returns:
        --------

        An int that indicates an error code (0 = no error, 5 = error reading
        thermodynamic parameter files, 14 = traceback error). 
        """
        return _RNAstructure_wrap.HybridRNA_FoldDuplex(self, percent, maximumstructures, window, maxinternalloopsize)


    def PartitionFunctionBimolecular(self, *args, **kwargs):
        """
        int
        HybridRNA::PartitionFunctionBimolecular(const char savefile[]="")

        Predict the bimolecular partition function for a sequence (with no
        intramolecular pairs).

        This function must be called to predict base pair probabilities,
        perform stochastic traceback, or for maximizing expected accuracy.
        This predicts the partition function without intramolecular pairs. If
        the temperature has not been specified using SetTemperature and no
        free energies have been calculated, the thermodynamic parameters have
        not been read and therefore they will be read by this function call.
        The parameter files should be located in the directory specified by
        the environment variable $DATAPATH of the pwd. In case of error, the
        function returns a non-zero that can be parsed by GetErrorMessage() or
        GetErrorMessageString().

        Parameters:
        -----------

        savefile:  is a c string that contains the path and filename for
        creating a save file. This defaults to "", which indicates no file
        is to be written.

        Returns:
        --------

        An int that indicates an error code (0 = no error, 5 = error reading
        thermodynamic parameter files). 
        """
        return _RNAstructure_wrap.HybridRNA_PartitionFunctionBimolecular(self, *args, **kwargs)


    def GetRNA1(self):
        """
        RNA * HybridRNA::GetRNA1()

        Access the underlying RNA class from an instance of TwoRNA. This is
        provided for use with two sequence methods. Generally, there is no
        need for end users to use this function.

        Returns:
        --------

        A pointer to the underlying RNA class for sequence 1. 
        """
        return _RNAstructure_wrap.HybridRNA_GetRNA1(self)


    def GetRNA2(self):
        """
        RNA * HybridRNA::GetRNA2()

        Access the underlying RNA class from an instance of TwoRNA. This is
        provided for use with two sequence methods. Generally, there is no
        need for end users to use this function.

        Returns:
        --------

        A pointer to the underlying RNA class for sequence 2. 
        """
        return _RNAstructure_wrap.HybridRNA_GetRNA2(self)


    def GetErrorCode(self):
        """
        int
        HybridRNA::GetErrorCode()

        Return an error code, where a return of zero is no error.

        This function returns and error flag that is generated during
        construction by RNA(const char &filename, const int type, const bool
        IsRNA=true) or from CalculateFreeEnergy(). An error of zero is always
        no error. Other codes are errors and a c-string can be fetched for the
        error with GetErrorMessage().

        Returns:
        --------

        An integer that provides the error code. 
        """
        return _RNAstructure_wrap.HybridRNA_GetErrorCode(self)


    def GetErrorMessage(self, error):
        """
        char *
        HybridRNA::GetErrorMessage(const int error)

        Return error messages based on code from GetErrorCode and other error
        codes.

        0 = no error <100 = Error to be fetched from RNA base class. 100-999 =
        Error associated with bimolecular folding, to be handled here. >=1000
        = Errors for underlying sequence, get message from TwoRNA base class.

        Parameters:
        -----------

        error:  is the integer error code provided by GetErrorCode().

        Returns:
        --------

        A pointer to a c string that provides an error message or from other
        functions that return integer error codes. 
        """
        return _RNAstructure_wrap.HybridRNA_GetErrorMessage(self, error)


    def GetForbidIntramolecular(self):
        """
        bool
        HybridRNA::GetForbidIntramolecular()

        Get whether intramolecular pairs are allowed.

        Returns:
        --------

        A bool that indicates whether intramolecular pairs are forbidden (true
        = forbidden, false = not). 
        """
        return _RNAstructure_wrap.HybridRNA_GetForbidIntramolecular(self)


    def SetForbidIntramolecular(self, forbid):
        """
        void
        HybridRNA::SetForbidIntramolecular(const bool forbid)

        Set whether intramolecular pairs are allowed.

        If true is passed to this function, intramolecular pairs will be
        forbidden in FoldBimolecular.

        Parameters:
        -----------

        forbid:  is a bool that indicates whether intramolecular pairs are
        forbid. 
        """
        return _RNAstructure_wrap.HybridRNA_SetForbidIntramolecular(self, forbid)


    def SetProgress(self, Progress):
        """
        void
        HybridRNA::SetProgress(TProgressDialog &Progress)

        Provide a TProgressDialog for following calculation progress. A
        TProgressDialog class has a public function void update(int percent)
        that indicates the progress of a long calculation.

        Parameters:
        -----------

        Progress:  is a TProgressDialog class. 
        """
        return _RNAstructure_wrap.HybridRNA_SetProgress(self, Progress)


    def StopProgress(self):
        """
        void
        HybridRNA::StopProgress()

        Provide a means to stop using a TProgressDialog. StopProgress tells
        the RNA class to no longer follow progress. This should be called if
        the TProgressDialog is deleted, so that this class does not make
        reference to it. 
        """
        return _RNAstructure_wrap.HybridRNA_StopProgress(self)

    __swig_destroy__ = _RNAstructure_wrap.delete_HybridRNA
    __del__ = lambda self: None
HybridRNA_swigregister = _RNAstructure_wrap.HybridRNA_swigregister
HybridRNA_swigregister(HybridRNA)

COMPOUNDMESSAGELENGTH = _RNAstructure_wrap.COMPOUNDMESSAGELENGTH
class TwoRNA(_object):
    """


    TwoRNA Class.

    The TwoRNA class provides an entry point for all the two sequence
    prediction routines of RNAstructure. This contains two instances of
    the RNA class to provide the functionality of RNA.

    C++ includes: TwoRNA.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TwoRNA, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TwoRNA, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        TwoRNA::TwoRNA()

        Constructor Default constructor that requires no parameters. 
        """
        this = _RNAstructure_wrap.new_TwoRNA(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def SetTemperature(self, temperature):
        """
        int
        TwoRNA::SetTemperature(double temperature)

        Set the temperature at which the calculation will be performed in K.

        This function allows the user to specify folding temperatures other
        than 310.15 K (37 degrees C). This changes folding free energy changes
        that would be returned for existing structures and would alter the set
        of structures predicted. When this function is called, the
        thermodynamic parameter files are immediately read from disk. These
        include both enthalpy parameters (.dh files) and free energy changes
        at 310.15 (.dat files). The files must either be at a location
        indicated by the $DATAPATH environment variable or in pwd. Changing
        the temperature only alters subsequent calculations. For example, if a
        structure prediction method has been called, the set of predicted
        structures are not changed at the time of a call to SetTemperature.
        Likewise, SetTemperature must be called before calling a structure
        prediction method if a temperature other than the 310.15 K default is
        desired. The function returns an error code where 0 is no error and
        non-zero errors can be parsed by by GetErrorMessage() or
        GetErrorMessageString() in an inheriting class. 
        """
        return _RNAstructure_wrap.TwoRNA_SetTemperature(self, temperature)


    def GetTemperature(self):
        """
        double
        TwoRNA::GetTemperature()

        Get the current folding temperature in K.

        Returns:
        --------

        A double that indicates the folding temperature in K. 
        """
        return _RNAstructure_wrap.TwoRNA_GetTemperature(self)


    def GetErrorCode(self):
        """
        int
        TwoRNA::GetErrorCode()

        Return an error code, where a return of zero is no error.

        This function returns and error flag that is generated during
        construction by RNA(const char &filename, const int type, const bool
        IsRNA=true) or from CalculateFreeEnergy(). An error of zero is always
        no error. Other codes are errors and a c-string can be fetched for the
        error with GetErrorMessage().

        Returns:
        --------

        An integer that provides the error code. 
        """
        return _RNAstructure_wrap.TwoRNA_GetErrorCode(self)


    def GetErrorMessage(self, error):
        """
        char *
        TwoRNA::GetErrorMessage(const int error)

        Return error messages based on code from GetErrorCode and other error
        codes.

        0 = no error 1000 = Error associated with sequence 1 or with a
        procedure, function will get message from sequence 1 (the inherited
        RNA class). 2000 = Error associated with sequence 2, function will get
        message from sequence 2 (the RNA2 class). 3000 = Errors with each
        sequence, function will get messages from each.

        Parameters:
        -----------

        error:  is the integer error code provided by GetErrorCode().

        Returns:
        --------

        A pointer to a c string that provides an error message or from other
        functions that return integer error codes. 
        """
        return _RNAstructure_wrap.TwoRNA_GetErrorMessage(self, error)


    def GetErrorDetails(self):
        return _RNAstructure_wrap.TwoRNA_GetErrorDetails(self)

    def SetErrorDetails(self, details):
        return _RNAstructure_wrap.TwoRNA_SetErrorDetails(self, details)

    def GetErrorMessageString(self, error):
        """
        std::string
        TwoRNA::GetErrorMessageString(const int error)

        Return error messages based on code from GetErrorCode and other error
        codes.

        Although RNA generally uses c strings, this member function returns a
        string that is suitable for interfacing with JAVA, etc. See the error
        list in the GetErrorMessage() entry.

        Parameters:
        -----------

        error:  is the integer error code provided by GetErrorCode() or from
        other functions that return integer error codes.

        Returns:
        --------

        A string that provides an error message. 
        """
        return _RNAstructure_wrap.TwoRNA_GetErrorMessageString(self, error)


    def ResetError(self):
        return _RNAstructure_wrap.TwoRNA_ResetError(self)

    def GetRNA1(self):
        """
        RNA * TwoRNA::GetRNA1()

        return A pointer to the underlying structure class for sequence 1.

        Access the underlying RNA class. This is provided for use with two
        sequence methods. Generally, there is no need for end users to use
        this function.

        Returns:
        --------

        A pointer to the underlying RNA class for sequence 1. 
        """
        return _RNAstructure_wrap.TwoRNA_GetRNA1(self)


    def GetRNA2(self):
        """
        RNA * TwoRNA::GetRNA2()

        return A pointer to the underlying structure class for sequence 2.

        Access the underlying RNA class. This is provided for use with two
        sequence methods. Generally, there is no need for end users to use
        this function.

        Returns:
        --------

        A pointer to the underlying RNA class for sequence 2. 
        """
        return _RNAstructure_wrap.TwoRNA_GetRNA2(self)

    __swig_destroy__ = _RNAstructure_wrap.delete_TwoRNA
    __del__ = lambda self: None
    __swig_setmethods__["compoundmessage"] = _RNAstructure_wrap.TwoRNA_compoundmessage_set
    __swig_getmethods__["compoundmessage"] = _RNAstructure_wrap.TwoRNA_compoundmessage_get
    if _newclass:
        compoundmessage = _swig_property(_RNAstructure_wrap.TwoRNA_compoundmessage_get, _RNAstructure_wrap.TwoRNA_compoundmessage_set)
TwoRNA_swigregister = _RNAstructure_wrap.TwoRNA_swigregister
TwoRNA_swigregister(TwoRNA)

class Dynalign_object(TwoRNA):
    """


    Dynalign_object Class.

    The Dynalign_object class provides an entry point for the Dynalign
    algorithm. The class is inherited from the TwoRNA class, which itself
    contains two instances to the class RNA.

    C++ includes: Dynalign_object.h 
    """

    __swig_setmethods__ = {}
    for _s in [TwoRNA]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Dynalign_object, name, value)
    __swig_getmethods__ = {}
    for _s in [TwoRNA]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Dynalign_object, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        Dynalign_object::Dynalign_object(const char *filename, const short
        maxtrace, const short bpwin, const short awin, const short percent)

        Constructor This constructor is used to perform Dynaligh refolding.
        This does not allow any changes in constraints, but does allow the
        creation of different set of suboptimal structures. This constructor
        generates internal error codes that can be accessed by GetErrorCode()
        after the constructor is called. 0 = no error. The errorcode can be
        resolved to a c string using GetErrorMessage.

        Parameters:
        -----------

        filename:  is the name of a Dynalign save file name (.dsv).

        maxtrace:  is the maximum number of common structures to be
        determined. The recommended default is 20.

        bpwin:  the the base pair window parameter, where 0 allows the
        structures to have similar pairs and larger windows make the
        structures more diverse. The recommended default is 5.

        awin:  is the alignment window parameter, where 0 allows the
        alignments to be similar and larger values make the alignments more
        diverse. The recommended default is 1.

        percent:  is the maximum percent difference in total folding free
        energy change above the lowest for suboptimal common structures. The
        recommended default is 20. 
        """
        this = _RNAstructure_wrap.new_Dynalign_object(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Dynalign(self, maxtrace=20, bpwin=5, awin=1, percent=20, imaxseparation=-99, gap=0.4, singleinsert=True, savefile=0, optimalonly=False, singlefold_subopt_percent=30, local=False, numProcessors=1, maxpairs=-1):
        """
        int
        Dynalign_object::Dynalign(const short int maxtrace=20, const short int
        bpwin=5, const short int awin=1, const short int percent=20, const
        short int imaxseparation=-99, const float gap=0.4, const bool
        singleinsert=true, const char savefile[]=NULL, const bool
        optimalonly=false, const short int singlefold_subopt_percent=30, const
        bool local=false, const short int numProcessors=1, const int
        maxpairs=-1)

        Predict the lowest free energy structure common to two sequences and
        suboptimal solutions with the Dynalign algorithm.

        In case of error, the function returns a non-zero that can be parsed
        by GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        maxtrace:  is the maximum number of common structures to be
        determined. The defaults is 20.

        bpwin:  the the base pair window parameter, where 0 allows the
        structures to have similar pairs and larger windows make the
        structures more diverse. The default is 5.

        awin:  is the alignment window parameter, where 0 allows the
        alignments to be similar and larger values make the alignments more
        diverse. The default is 1.

        percent:  is the maximum percent difference in total folding free
        energy change above the lowest for suboptimal common structures. The
        defaults is 20.

        imaxseparation:  is the maximum separation between aligned
        nucleotides. Values >= 0 are the traditional parameter, those below
        zero trigger the HMM alignment method, which is now prefered.

        gap:  is the cost of adding gap nucleotides in the alignment in
        kcal/mol.

        singleinsert:  is whether single basepair inserts are allowed in one
        sequence vs the other.

        savefile:  is c-string with the name of a dynalign savefile (*.dsv) to
        be created.

        optimalonly:  can be used to turn on a calculation of only the energy
        (when true) and not the structures.

        singlefold_subopt_percent:  is the maximum % difference of folding
        energy above the lowest free energy structure for pairs in single
        sequence folding that will be allowed in the dynalign calculation.

        local:  is whether Dynalign is being run in local (true) or global
        mode (false).

        numProcessors:  is the number of processors to use for the
        calculation. This requires a compilation for SMP.

        maxpairs:  is under development for multiple sequence folding. Use -1
        (default) for now.

        Returns:
        --------

        An int that indicates an error code (0 = no error, non-zero = error
        occurred). 
        """
        return _RNAstructure_wrap.Dynalign_object_Dynalign(self, maxtrace, bpwin, awin, percent, imaxseparation, gap, singleinsert, savefile, optimalonly, singlefold_subopt_percent, local, numProcessors, maxpairs)


    def WriteAlignment(self, filename):
        """
        void
        Dynalign_object::WriteAlignment(const char filename[])

        Write the alignment to disk.

        This function should be called after loading a dynalign save file or
        after a dynalign calculation has been performed. This function
        generates no error flag. Nothing can go wrong...

        Parameters:
        -----------

        filename:  is the file to which the alignment should be written. 
        """
        return _RNAstructure_wrap.Dynalign_object_WriteAlignment(self, filename)


    def ForceAlignment(self, i, k):
        """
        int
        Dynalign_object::ForceAlignment(const int i, const int k)

        Force an alignment during a Dynalign calculation).

        Nucleotide i from sequence 1 will be aligned to nucleotide k in
        sequence 2 in subsequent Dynalign calculation. The function returns 0
        with no error and a non-zero otherwise that can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        i:  is the index of nucleotide from sequence 1.

        k:  is the index of nucleotide from sequence 2.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 100 =
        nucleotide i out of range, 101 = nucleotide k out of range). 
        """
        return _RNAstructure_wrap.Dynalign_object_ForceAlignment(self, i, k)


    def GetForcedAlignment(self, i, seq):
        """
        int
        Dynalign_object::GetForcedAlignment(const int i, const int seq)

        Get an alignment constraint.

        Parameters:
        -----------

        i:  is the nucleotide number.

        seq:  is the sequence (1 or 2) from which i is derived.

        Returns:
        --------

        An integer that indicates the nucleotide to which i is forced to be
        aligned, where 0 indicates no alignment. 
        """
        return _RNAstructure_wrap.Dynalign_object_GetForcedAlignment(self, i, seq)


    def ReadAlignmentConstraints(self, filename):
        """
        int
        Dynalign_object::ReadAlignmentConstraints(const char filename[])

        Read alignment constraints from disk.

        The file format is: i1 k1 i2 k2 -1 -1 Where each line gives a aligned
        pair (i from sequence 1 and k from sequence 2). The file terminates
        with -1 -1 to indicate the file end. The function returns 0 with no
        error and a non-zero otherwise that can be parsed by GetErrorMessage()
        or GetErrorMessageString().

        Parameters:
        -----------

        filename:  is a c string that is the file name to be read.

        Returns:
        --------

        An integer that indicates an error code (0 = no error, 102 = file not
        found, 103 = error reading constraint file). 
        """
        return _RNAstructure_wrap.Dynalign_object_ReadAlignmentConstraints(self, filename)


    def Templatefromct(self, ctfilename):
        """
        int
        Dynalign_object::Templatefromct(const char ctfilename[])

        Read a ct file to determine what pairs will be allowed for sequence 1
        in a subsequent dynalign calculation.

        This results in all pairs but those in the ct being disallowed.

        Parameters:
        -----------

        ctfilename:  is the name of the ct file to be read to provide the
        template.

        Returns:
        --------

        An integer that indicates an error code (0=no error, 104=file not
        found, 105=template is already specified) 
        """
        return _RNAstructure_wrap.Dynalign_object_Templatefromct(self, ctfilename)


    def Templatefromdsv(self, dsvfilename, maxdsvchange):
        """
        int
        Dynalign_object::Templatefromdsv(const char dsvfilename[], const float
        maxdsvchange)

        This reads a dsv file and only allows pairs with folding free energy
        change between the lowest and lowest + maxdsvchange in a subsequent
        dynalign calculation.

        Parameters:
        -----------

        dsvfilename:  is the name of the ct file to be read to provide the
        template.

        maxdsvchange:  in a float that gives a percent difference in free
        energy above the lowest free energy change.

        Returns:
        --------

        An integer that indicates an error code (0=no error, 106=file not
        found, 105=template is already specified) 
        """
        return _RNAstructure_wrap.Dynalign_object_Templatefromdsv(self, dsvfilename, maxdsvchange)


    def GetBestPairEnergy(self, sequence, i, j):
        """
        double
        Dynalign_object::GetBestPairEnergy(const int sequence, const int i,
        const int j)

        Report the best energy for pair i-j from sequence number sequence (1
        or 2).

        This function reports the lowest ffolding free energy for any pairs
        between i-j in sequence number sequence (1 or 2). This requires a
        search over all possible pairs in the second sequence. NOTE: This
        function ONLY works after reading a Dynalign save file (.dsv) using
        the constructor. This is because the Dynalign energies are not
        normally stored after calling Dynalign. This function generates
        internal error codes that can be accessed by GetErrorCode() after the
        constructor is called. 0 = no error, 107 = Data not available, 108 =
        nucleotide out of range. The errorcode can be resolved to a c string
        using GetErrorMessage.

        Parameters:
        -----------

        sequence:  is an integer indicating the sequence # (must be 1 or 2).

        i:  is the 5' nucleotide in a pair.

        j:  is the 3' nucleotide in a pair.

        Returns:
        --------

        A double that gives an energy in kcal/mol. 
        """
        return _RNAstructure_wrap.Dynalign_object_GetBestPairEnergy(self, sequence, i, j)


    def GetLowestEnergy(self):
        """
        double
        Dynalign_object::GetLowestEnergy()

        Report the lowest total free energy change from a Dynalign
        calculation.

        NOTE: This function ONLY works after reading a Dynalign save file
        (.dsv) using the constructor. This is because the Dynalign energies
        are not normally stored after calling Dynalign. This function
        generates internal error codes that can be accessed by GetErrorCode()
        after the constructor is called. 0 = no error, 107 = Data not
        available, 108 = nucleotide out of range. The errorcode can be
        resolved to a c string using GetErrorMessage.

        Returns:
        --------

        a double that gives an energy in kcal/mol. 
        """
        return _RNAstructure_wrap.Dynalign_object_GetLowestEnergy(self)


    def GetErrorMessage(self, error):
        """
        char *
        Dynalign_object::GetErrorMessage(const int error)

        Return error messages based on code from GetErrorCode and other error
        codes.

        0 = no error 100-999 = Error associated with Dynalign, to be handled
        here. >=1000 = Errors for underlying sequence, get message from TwoRNA
        base class. Current errors handled here are: 100 "Nucleotide from
        sequence 1 is out of range.\\n"; 101 "Nucleotide from sequence 2
        is out of range.\\n"; 102 "Alignment constraint file not
        found.\\n"; 103 "Error reading alignment constraint file.\\n";
        104 "CT file not found.\\n"; 105 "A template has already been
        specified; only one is allowed.\\n"; 106 "DSV file not
        found.\\n"; 107 "Data not available to calculate energy.\\n"
        108 "Nucleotide out of range.\\n"; 109 "Value of maxpairs is too
        large to be achievable.\\n" 110 "Error reading thermodynamic
        parameters."

        Parameters:
        -----------

        error:  is the integer error code provided by GetErrorCode() or by a
        call to a function that returns an error.

        Returns:
        --------

        A pointer to a c string that provides an error message or from other
        functions that return integer error codes. 
        """
        return _RNAstructure_wrap.Dynalign_object_GetErrorMessage(self, error)


    def SetProgress(self, Progress):
        """
        void
        Dynalign_object::SetProgress(TProgressDialog &Progress)

        Provide a TProgressDialog for following calculation progress. A
        TProgressDialog class has a public function void update(int percent)
        that indicates the progress of a long calculation.

        Parameters:
        -----------

        Progress:  is a TProgressDialog class. 
        """
        return _RNAstructure_wrap.Dynalign_object_SetProgress(self, Progress)


    def StopProgress(self):
        """
        void
        Dynalign_object::StopProgress()

        Provide a means to stop using a TProgressDialog. StopProgress tells
        the RNA class to no longer follow progress. This should be called if
        the TProgressDialog is deleted, so that this class does not make
        reference to it. 
        """
        return _RNAstructure_wrap.Dynalign_object_StopProgress(self)

    __swig_destroy__ = _RNAstructure_wrap.delete_Dynalign_object
    __del__ = lambda self: None
Dynalign_object_swigregister = _RNAstructure_wrap.Dynalign_object_swigregister
Dynalign_object_swigregister(Dynalign_object)

class Multilign_object(_object):
    """


    Multilign_object Class.

    The Multilign_object class provides an entry point for the Multilign
    algorithm.

    C++ includes: Multilign_object.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Multilign_object, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Multilign_object, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        Multilign_object::Multilign_object(const bool Multifind, const string
        &outputmultifind, const vector< string > &ctfiles, TProgressDialog
        *progress=NULL, const bool isrna=true) 
        """
        this = _RNAstructure_wrap.new_Multilign_object(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _RNAstructure_wrap.delete_Multilign_object
    __del__ = lambda self: None

    def CountBP(self, i=0, j=0, percent=0.8):
        """
        int
        Multilign_object::CountBP(const int i=0, const int j=0, const double
        percent=0.8) const

        count the number of basepairs with the lowest free energies below the
        percent of the miminal free energy. Dsv file is used for the counting.
        By default, the first dsv file in the progressive dynalign
        calculations is used, i.e. i = 0 and j = 0.

        Parameters:
        -----------

        i:  is an int value indicating which one in the iteration.

        j:  is an int value indicating which iteration.

        percent:  is threshold of double value in percentage.

        Returns:
        --------

        an int of the number of basepairs counted. 
        """
        return _RNAstructure_wrap.Multilign_object_CountBP(self, i, j, percent)


    def ProgressiveMultilign(self, numProcessors=1, Dsv=1, Ali=1, maxtrace=750, bpwin=2, awin=1, percent=20, imaxseparation=-99, gap=0.4, singleinsert=True, singlefold_subopt_percent=30, local=False):
        """
        int
        Multilign_object::ProgressiveMultilign(const short int
        numProcessors=1, const bool Dsv=1, const bool Ali=1, const short int
        maxtrace=750, const short int bpwin=2, const short int awin=1, const
        short int percent=20, const short int imaxseparation=-99, const float
        gap=0.4, const bool singleinsert=true, const short int
        singlefold_subopt_percent=30, const bool local=false)

        The core function doing dynalign calculation and templating In case of
        error, the function returns a non-zero that can be parsed by
        GetErrorMessage() or GetErrorMessageString().

        Parameters:
        -----------

        Dsv:  is a boolean value indicating to output pairwise dsv files or
        not. It has to be set to true currently.

        Ali:  is a boolean value indicating to output pairwise ali files or
        not. It has to be set to true currently.

        maxtrace:  is the maximum number of common structures to be
        determined.

        bpwin:  the the base pair window parameter, where 0 allows the
        structures to have similar pairs and larger windows make the
        structures more diverse.

        awin:  is the alignment window parameter, where 0 allows the
        alignments to be similar and larger values make the alignments more
        diverse.

        percent:  is the maximum percent difference in total folding free
        energy change above the lowest for suboptimal common structures.

        imaxseparation:  is the maximum separation between aligned
        nucleotides. Values >= 0 are the traditional parameter, those below
        zero trigger the HMM alignment method, which is now prefered.

        gap:  is the cost of adding gap nucleotides in the alignment in
        kcal/mol.

        singleinsert:  is whether single basepair inserts are allowed in one
        sequence vs the other.

        singlefold_subopt_percent:  is the maximum % difference of folding
        energy above the lowest free energy structure for pairs in single
        sequence folding that will be allowed in the dynalign calculation.

        local:  is whether Dynalign is being run in local (true) or global
        mode (false).

        numProcessors:  is the number of processors to use for the
        calculation. This requires a compilation for SMP.

        Returns:
        --------

        an int that indicates an error code (0 = no error, non-zero = error
        occurred). 
        """
        return _RNAstructure_wrap.Multilign_object_ProgressiveMultilign(self, numProcessors, Dsv, Ali, maxtrace, bpwin, awin, percent, imaxseparation, gap, singleinsert, singlefold_subopt_percent, local)


    def MultiTempMultilign(self):
        """
        int
        Multilign_object::MultiTempMultilign() 
        """
        return _RNAstructure_wrap.Multilign_object_MultiTempMultilign(self)


    def WriteAlignment(self, *args, **kwargs):
        """
        int
        Multilign_object::WriteAlignment(const string allali="all.ali")
        const

        calculate and output multiple alignment

        Parameters:
        -----------

        allali:  is the output filename of multiple alignment

        Returns:
        --------

        an int of error code. 
        """
        return _RNAstructure_wrap.Multilign_object_WriteAlignment(self, *args, **kwargs)


    def GetErrorCode(self):
        """
        int
        Multilign_object::GetErrorCode() const

        Return an error code, where a return of zero is no error.

        This function returns and error flag that is generated during
        construction by RNA(const char &filename, const int type, const bool
        IsRNA=true) or from CalculateFreeEnergy(). An error of zero is always
        no error. Other codes are errors and a c-string can be fetched for the
        error with GetErrorMessage().

        Returns:
        --------

        An integer that provides the error code. 
        """
        return _RNAstructure_wrap.Multilign_object_GetErrorCode(self)


    def GetErrorMessage(self, error):
        """
        string
        Multilign_object::GetErrorMessage(const int error) const

        Return error messages based on code from GetErrorCode and other error
        codes. 0 = no error 1000 = Error associated with sequence 1 or with a
        procedure, function will get message from sequence 1 (the inherited
        RNA class). 2000 = Error associated with sequence 2, function will get
        message from sequence 2 (the RNA2 class). 3000 = Errors with each
        sequence, function will get messages from each.

        Parameters:
        -----------

        error:  is the integer error code provided by GetErrorCode().

        Returns:
        --------

        A string that provides an error message or from other functions that
        return integer error codes. 
        """
        return _RNAstructure_wrap.Multilign_object_GetErrorMessage(self, error)


    def GetErrorDetails(self):
        return _RNAstructure_wrap.Multilign_object_GetErrorDetails(self)

    def ResetError(self):
        return _RNAstructure_wrap.Multilign_object_ResetError(self)

    def SetMaxPairs(self, maxpairs=-1):
        """
        int
        Multilign_object::SetMaxPairs(const int maxpairs=-1)

        Parameters:
        -----------

        maxpairs:  is int value defining how the MaxPairs will be set. By
        default it is set to be -1, meaning the average length of all the
        sequences.

        Returns:
        --------

        an errorcode. 
        """
        return _RNAstructure_wrap.Multilign_object_SetMaxPairs(self, maxpairs)


    def GetMaxPairs(self):
        """
        int
        Multilign_object::GetMaxPairs() const

        get the value of MaxPairs

        Returns:
        --------

        the value of MaxPairs 
        """
        return _RNAstructure_wrap.Multilign_object_GetMaxPairs(self)


    def AverageLength(self):
        """
        int
        Multilign_object::AverageLength() const

        get the average length of the input sequences

        Returns:
        --------

        the average length of the input sequences. 
        """
        return _RNAstructure_wrap.Multilign_object_AverageLength(self)


    def SetIterations(self, it=2):
        """
        int
        Multilign_object::SetIterations(const int it=2)

        set the value of iterations

        Parameters:
        -----------

        it:  is an value of int assigned to iterations. By default it is set
        to 2.

        Returns:
        --------

        an errorcode 
        """
        return _RNAstructure_wrap.Multilign_object_SetIterations(self, it)


    def GetIterations(self):
        """
        int
        Multilign_object::GetIterations() const

        get the value of iterations

        Returns:
        --------

        the value of iterations. 
        """
        return _RNAstructure_wrap.Multilign_object_GetIterations(self)


    def SetMaxDsv(self, maxdsvchange=1):
        """
        int
        Multilign_object::SetMaxDsv(const float maxdsvchange=1)

        set the value of MaxDsv/maxdsvchange

        Parameters:
        -----------

        maxdsvchange:  is a value of float assigned to MaxDsv. By default it
        is set to 1.

        Returns:
        --------

        an errorcode 
        """
        return _RNAstructure_wrap.Multilign_object_SetMaxDsv(self, maxdsvchange)


    def GetMaxDsv(self):
        """
        float
        Multilign_object::GetMaxDsv() const

        get the value of MaxDsv/maxdsvchange

        Returns:
        --------

        the value of MaxDsv/maxdsvchange. 
        """
        return _RNAstructure_wrap.Multilign_object_GetMaxDsv(self)


    def GetSequenceNumber(self):
        """
        int
        Multilign_object::GetSequenceNumber() const

        get the sequence number

        Returns:
        --------

        the number of input sequences 
        """
        return _RNAstructure_wrap.Multilign_object_GetSequenceNumber(self)


    def SetIndexSeq(self, *args):
        """
        int
        Multilign_object::SetIndexSeq(const string seqname)

        an overloaded function accepting a string as its parameter.

        Parameters:
        -----------

        seqname:  is the seq filename that will be set as the index sequence.

        Returns:
        --------

        an int value of ErrorCode 
        """
        return _RNAstructure_wrap.Multilign_object_SetIndexSeq(self, *args)


    def GetIndexSeq(self):
        """
        string
        Multilign_object::GetIndexSeq() const

        return the filename of the index seq.

        Returns:
        --------

        a string of index seq filename. 
        """
        return _RNAstructure_wrap.Multilign_object_GetIndexSeq(self)


    def Randomize(self):
        """
        void
        Multilign_object::Randomize()

        randomize the order of inputList. 
        """
        return _RNAstructure_wrap.Multilign_object_Randomize(self)


    def AddOneInput(self, *args, **kwargs):
        """
        int
        Multilign_object::AddOneInput(const string seq, const string ct, const
        string constraint="", const string shape="")

        add one entry into inputList.

        Parameters:
        -----------

        seq:  is a string value of sequence filename to be appended1

        ct:  is a string value of corresponding ct filename

        constraint:  is a string value of corresponding constraint filename.
        By default, it is empty, meaning no folding constraint exists

        shape:  is string value of corresponding SHAPE filename. By default,
        it is empty, meaning no SHAPE exists.

        Returns:
        --------

        a is int value of ErrorCode 
        """
        return _RNAstructure_wrap.Multilign_object_AddOneInput(self, *args, **kwargs)


    def RemoveOneInput(self, seq):
        """
        int
        Multilign_object::RemoveOneInput(const string seq)

        remove one entry from inputList.

        Parameters:
        -----------

        seq:  is a string value of sequence filename of which the entry in
        inputList will be removed

        Returns:
        --------

        a int value of ErrorCode 
        """
        return _RNAstructure_wrap.Multilign_object_RemoveOneInput(self, seq)


    def SetSHAPESlope(self, slope=1.8):
        """
        void
        Multilign_object::SetSHAPESlope(const double slope=1.8)

        set the slope parameter for SHAPE

        Parameters:
        -----------

        slope:  is a double value assigned to SHAPESlope. By default, it is
        set to 1.8. 
        """
        return _RNAstructure_wrap.Multilign_object_SetSHAPESlope(self, slope)


    def GetSHAPESlope(self):
        """
        double
        Multilign_object::GetSHAPESlope() const

        get the SHAPESlope

        Returns:
        --------

        a SHAPESlope of double value. 
        """
        return _RNAstructure_wrap.Multilign_object_GetSHAPESlope(self)


    def SetSHAPEIntercept(self, intercept=-0.6):
        """
        void
        Multilign_object::SetSHAPEIntercept(const double intercept=-0.6)

        set the intercept parameter for SHAPE.

        Parameters:
        -----------

        intercept:  is a double value assigned to SHAPEIntercept. By default,
        it is set to -0.6. 
        """
        return _RNAstructure_wrap.Multilign_object_SetSHAPEIntercept(self, intercept)


    def GetSHAPEIntercept(self):
        """
        double
        Multilign_object::GetSHAPEIntercept() const

        get the SHAPEIntercept.

        Returns:
        --------

        SHAPEIntercept of double value. 
        """
        return _RNAstructure_wrap.Multilign_object_GetSHAPEIntercept(self)


    def SetTemperature(self, temp=310.15):
        """
        void
        Multilign_object::SetTemperature(const double temp=310.15)

        set the temperature to fold the sequences.

        Parameters:
        -----------

        temp:  is a double value of temperature; by default it is set to
        310.15K 
        """
        return _RNAstructure_wrap.Multilign_object_SetTemperature(self, temp)


    def GetTemperature(self):
        """
        double
        Multilign_object::GetTemperature() const

        get the temperature to fold the sequences

        Returns:
        --------

        a double value of the set temperature. 
        """
        return _RNAstructure_wrap.Multilign_object_GetTemperature(self)


    def CleanupIntermediateFiles(self):
        """
        int Multilign_object::CleanupIntermediateFiles() const

        delete intermediate pairwise dsv and aout files

        Returns:
        --------

        an int value of error code. 
        """
        return _RNAstructure_wrap.Multilign_object_CleanupIntermediateFiles(self)


    def SetProgress(self, Progress=None):
        """
        void
        Multilign_object::SetProgress(TProgressDialog *Progress=NULL)

        Provide a TProgressDialog for following calculation progress.

        Parameters:
        -----------

        Progress:  is a pointer to TProgressDialog 
        """
        return _RNAstructure_wrap.Multilign_object_SetProgress(self, Progress)


    def StopProgress(self):
        """
        void
        Multilign_object::StopProgress()

        Provide a means to stop using a TProgressDialog by assigning NULL to
        progress pointer. 
        """
        return _RNAstructure_wrap.Multilign_object_StopProgress(self)


    def GetProgress(self):
        """
        TProgressDialog
        * Multilign_object::GetProgress() const

        get the progress

        Returns:
        --------

        the pointer to TProgressDialog 
        """
        return _RNAstructure_wrap.Multilign_object_GetProgress(self)


    def GetInputFilenames(self):
        """
        void
        Multilign_object::GetInputFilenames()

        For diagnostic purpose only. Output the input sequence, ct,
        constraints, and SHAPE filenames to stdout.

        The following functions are used for Diagnostic purpose only
        //////////// Generally not needed, but for debugging input. 
        """
        return _RNAstructure_wrap.Multilign_object_GetInputFilenames(self)


    def GetPairs(self):
        """
        void
        Multilign_object::GetPairs()

        For diagnostic purpose only. Output the paired sequence filenames to
        stdout. 
        """
        return _RNAstructure_wrap.Multilign_object_GetPairs(self)


    def get_energies(self):
        """
        vector<float>
        Multilign_object::get_energies() 
        """
        return _RNAstructure_wrap.Multilign_object_get_energies(self)


    def get_dGIndex(self):
        """
        vector<float>
        Multilign_object::get_dGIndex() 
        """
        return _RNAstructure_wrap.Multilign_object_get_dGIndex(self)


    def get_pair_alignments(self):
        """vector<vector<string> > Multilign_object::get_pair_alignments() """
        return _RNAstructure_wrap.Multilign_object_get_pair_alignments(self)

Multilign_object_swigregister = _RNAstructure_wrap.Multilign_object_swigregister
Multilign_object_swigregister(Multilign_object)

class Oligowalk_object(RNA):
    """


    Oligowalk_object Class.

    The Oligowalk_class inhereits from RNA and provides the OligoWalk
    functionality. Additionally, it provides OligoScreen.

    C++ includes: Oligowalk_object.h 
    """

    __swig_setmethods__ = {}
    for _s in [RNA]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Oligowalk_object, name, value)
    __swig_getmethods__ = {}
    for _s in [RNA]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Oligowalk_object, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        Oligowalk_object::Oligowalk_object(const bool IsRNA=true)

        Default Constructor - user provides nothing.

        This constructor calls the underlying RNA(IsRNA=true) constructor.
        This basic constructor is provided for performing OligoScreen
        calculations, which do not need an input sequence. This constructor
        needs to be called with RNA=true for Oligos to be RNA and RNA=false
        for Oligos to be DNA.

        Parameters:
        -----------

        IsRNA:  is a bool where true= RNA and false=DNA. 
        """
        this = _RNAstructure_wrap.new_Oligowalk_object(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Oligowalk(self, oligo_length, isDNA, option, oligo_concentration, usesub, start, stop):
        """
        int
        Oligowalk_object::Oligowalk(const int oligo_length, const bool isDNA,
        const int option, const double oligo_concentration, const int usesub,
        const int start, const int stop)

        Perform an OligoWalk calculation. Note that this can only be performed
        once.

        Parameters:
        -----------

        oligo_length:  is an int that gives the length of the
        oligonucleotides.

        isDNA:  is a bool that indicates the oligonucleotide chemistry, where
        true = DNA and false = RNA.

        option:  is an int that gives the calculation type, where option 1 =
        break local target structure to bind oligo, option 2 = refold target
        RNA after oligo binding, and option 3 = no target structure
        considered.

        oligo_concentration:  is a double that indicates the oligonucleotide
        concentration in M.

        usesub:  is an int that indicates whether suboptimal structures are to
        be used, where 0 = none and 3 = use heuristic method.

        start:  is an int that indicates the starting location of the walk.

        stop:  is an int that indicates the ending location of the walk.

        Returns:
        --------

        An integer that indicates an error code that can be parsed by
        GetErrorMessage() or GetErrorMessageString(), 0 = no error. 
        """
        return _RNAstructure_wrap.Oligowalk_object_Oligowalk(self, oligo_length, isDNA, option, oligo_concentration, usesub, start, stop)


    def GetBreakTargetDG(self, index):
        """
        double
        Oligowalk_object::GetBreakTargetDG(const int index)

        Get the breaking target DG for a given nucleotide. This can only be
        called after performing a valid OligoWalk calculation. In case of
        error, the function returns a free energy change of zero. Note!: That
        a free energy change of zero is also a valid folding free energy
        change. Errors will also generate an internal error code, accessible
        with GetErrorCode().

        Parameters:
        -----------

        index:  is an int that specifies the 5' end of an oligonucleotide
        binding site on the target.

        Returns:
        --------

        A double that is the free energy change in kcal/mol. 
        """
        return _RNAstructure_wrap.Oligowalk_object_GetBreakTargetDG(self, index)


    def GetDuplexDG(self, index):
        """
        double
        Oligowalk_object::GetDuplexDG(const int index)

        Get the duplex DG for a given nucleotide. This can only be called
        after performing a valid OligoWalk calculation. In case of error, the
        function returns a free energy change of zero. Note!: That a free
        energy change of zero is also a valid folding free energy change.
        Errors will also generate an internal error code, accessible with
        GetErrorCode().

        Parameters:
        -----------

        index:  is an int that specifies the 5' end of an oligonucleotide
        binding site on the target.

        Returns:
        --------

        A double that is the free energy change in kcal/mol. 
        """
        return _RNAstructure_wrap.Oligowalk_object_GetDuplexDG(self, index)


    def GetOligoOligoDG(self, index):
        """
        double
        Oligowalk_object::GetOligoOligoDG(const int index)

        Get the bimolecular oligo-oligo DG for a given nucleotide. This can
        only be called after performing a valid OligoWalk calculation. In case
        of error, the function returns a free energy change of zero. Note!:
        That a free energy change of zero is also a valid folding free energy
        change. Errors will also generate an internal error code, accessible
        with GetErrorCode().

        Parameters:
        -----------

        index:  is an int that specifies the 5' end of an oligonucleotide
        binding site on the target.

        Returns:
        --------

        A double that is the free energy change in kcal/mol. 
        """
        return _RNAstructure_wrap.Oligowalk_object_GetOligoOligoDG(self, index)


    def GetOligoSelfDG(self, index):
        """
        double
        Oligowalk_object::GetOligoSelfDG(const int index)

        Get the oligo-self DG for a given nucleotide. This can only be called
        after performing a valid OligoWalk calculation. In case of error, the
        function returns a free energy change of zero. Note!: That a free
        energy change of zero is also a valid folding free energy change.
        Errors will also generate an internal error code, accessible with
        GetErrorCode().

        Parameters:
        -----------

        index:  is an int that specifies the 5' end of an oligonucleotide
        binding site on the target.

        Returns:
        --------

        A double that is the free energy change in kcal/mol. 
        """
        return _RNAstructure_wrap.Oligowalk_object_GetOligoSelfDG(self, index)


    def GetOverallDG(self, index):
        """
        double
        Oligowalk_object::GetOverallDG(const int index)

        Get the overall DG for a given nucleotide. This can only be called
        after performing a valid OligoWalk calculation. In case of error, the
        function returns a free energy change of zero. Note!: That a free
        energy change of zero is also a valid folding free energy change.
        Errors will also generate an internal error code, accessible with
        GetErrorCode().

        Parameters:
        -----------

        index:  is an int that specifies the 5' end of an oligonucleotide
        binding site on the target.

        Returns:
        --------

        A double that is the free energy change in kcal/mol. 
        """
        return _RNAstructure_wrap.Oligowalk_object_GetOverallDG(self, index)


    def GetTm(self, index):
        """
        double
        Oligowalk_object::GetTm(const int index)

        Get the Tm for a given nucleotide. This can only be called after
        performing a valid OligoWalk calculation. In case of error, the
        function returns a free energy change of zero. Note!: That a free
        energy change of zero is also a valid folding free energy change.
        Errors will also generate an internal error code, accessible with
        GetErrorCode().

        Parameters:
        -----------

        index:  is an int that specifies the 5' end of an oligonucleotide
        binding site on the target.

        Returns:
        --------

        A double that is the Tm in degrees C. 
        """
        return _RNAstructure_wrap.Oligowalk_object_GetTm(self, index)


    def WriteReport(self, outputfilename, oligo_length, isDNA, option, oligo_concentration, usesub, start, stop):
        """
        int
        Oligowalk_object::WriteReport(const char outputfilename[], const int
        oligo_length, const bool isDNA, const int option, const double
        oligo_concentration, const int usesub, const int start, const int
        stop)

        Write a report for an OligoWalk calculation. This must be called after
        performing a valid OligoWalk calculation.

        Parameters:
        -----------

        outputfilename:  is a c-string that provides a filename to which the
        report will be written.

        oligo_length:  is an int that gives the length of the
        oligonucleotides.

        isDNA:  is a bool that indicates the oligonucleotide chemistry, where
        true = DNA and false = RNA.

        option:  is an int that gives the calculation type, where option 1 =
        break local target structure to bind oligo, option 2 = refold target
        RNA after oligo binding, and option 3 = no target structure
        considered.

        oligo_concentration:  is a double that indicates the oligonucleotide
        concentration in M.

        usesub:  is an int that indicates whether suboptimal structures are to
        be used, where 0 = none and 3 = use heuristic method.

        start:  is an int that indicates the starting location of the walk.

        stop:  is an int that indicates the ending location of the walk.

        Returns:
        --------

        An integer that indicates an error code that can be parsed by
        GetErrorMessage() or GetErrorMessageString(), 0 = no error. 
        """
        return _RNAstructure_wrap.Oligowalk_object_WriteReport(self, outputfilename, oligo_length, isDNA, option, oligo_concentration, usesub, start, stop)


    def OligoScreen(self, infilename, outfilename):
        """
        int
        Oligowalk_object::OligoScreen(const char infilename[], const char
        outfilename[])

        This function runs OligoScreen.

        Read a list of oligonucleotides in infilename and output thermodynamic
        characteristics in outfilename. The backbone type is set when the
        constructor is called. Note that oligoscreen has no target sequence,
        so the default constructor OligoWalk(bool IsRNA) should be used.

        Parameters:
        -----------

        infilename:  is a c-string that indicates the filename to be read.

        outfilename:  is a c-string that indicates the name of an output file
        to be written with report.

        Returns:
        --------

        An int that indicates an error code that can be parsed by
        GetErrorMessage() or GetErrorMessageString(), 0 = no error. 
        """
        return _RNAstructure_wrap.Oligowalk_object_OligoScreen(self, infilename, outfilename)


    def GetErrorMessage(self, error):
        """
        char *
        Oligowalk_object::GetErrorMessage(const int error)

        Return error messages based on code from GetErrorCode and other error
        codes. 100 = no OligoWalk data present 101 = OligoWalk has already
        been performed other codes are handled by the RNA base class function
        GetErrorMessage.

        Parameters:
        -----------

        error:  is the integer error code provided by GetErrorCode()/

        Returns:
        --------

        A pointer to a c string that provides an error message or from other
        functions that return integer error codes. 
        """
        return _RNAstructure_wrap.Oligowalk_object_GetErrorMessage(self, error)

    __swig_destroy__ = _RNAstructure_wrap.delete_Oligowalk_object
    __del__ = lambda self: None
Oligowalk_object_swigregister = _RNAstructure_wrap.Oligowalk_object_swigregister
Oligowalk_object_swigregister(Oligowalk_object)

class hairpin_t(_object):
    """C++ includes: ProbScan.h """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, hairpin_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, hairpin_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["probability"] = _RNAstructure_wrap.hairpin_t_probability_set
    __swig_getmethods__["probability"] = _RNAstructure_wrap.hairpin_t_probability_get
    if _newclass:
        probability = _swig_property(_RNAstructure_wrap.hairpin_t_probability_get, _RNAstructure_wrap.hairpin_t_probability_set)
    __swig_setmethods__["i"] = _RNAstructure_wrap.hairpin_t_i_set
    __swig_getmethods__["i"] = _RNAstructure_wrap.hairpin_t_i_get
    if _newclass:
        i = _swig_property(_RNAstructure_wrap.hairpin_t_i_get, _RNAstructure_wrap.hairpin_t_i_set)
    __swig_setmethods__["j"] = _RNAstructure_wrap.hairpin_t_j_set
    __swig_getmethods__["j"] = _RNAstructure_wrap.hairpin_t_j_get
    if _newclass:
        j = _swig_property(_RNAstructure_wrap.hairpin_t_j_get, _RNAstructure_wrap.hairpin_t_j_set)

    def __init__(self):
        """C++ includes: ProbScan.h """
        this = _RNAstructure_wrap.new_hairpin_t()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _RNAstructure_wrap.delete_hairpin_t
    __del__ = lambda self: None
hairpin_t_swigregister = _RNAstructure_wrap.hairpin_t_swigregister
hairpin_t_swigregister(hairpin_t)

class internal_loop_t(_object):
    """C++ includes: ProbScan.h """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, internal_loop_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, internal_loop_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["probability"] = _RNAstructure_wrap.internal_loop_t_probability_set
    __swig_getmethods__["probability"] = _RNAstructure_wrap.internal_loop_t_probability_get
    if _newclass:
        probability = _swig_property(_RNAstructure_wrap.internal_loop_t_probability_get, _RNAstructure_wrap.internal_loop_t_probability_set)
    __swig_setmethods__["i"] = _RNAstructure_wrap.internal_loop_t_i_set
    __swig_getmethods__["i"] = _RNAstructure_wrap.internal_loop_t_i_get
    if _newclass:
        i = _swig_property(_RNAstructure_wrap.internal_loop_t_i_get, _RNAstructure_wrap.internal_loop_t_i_set)
    __swig_setmethods__["j"] = _RNAstructure_wrap.internal_loop_t_j_set
    __swig_getmethods__["j"] = _RNAstructure_wrap.internal_loop_t_j_get
    if _newclass:
        j = _swig_property(_RNAstructure_wrap.internal_loop_t_j_get, _RNAstructure_wrap.internal_loop_t_j_set)
    __swig_setmethods__["k"] = _RNAstructure_wrap.internal_loop_t_k_set
    __swig_getmethods__["k"] = _RNAstructure_wrap.internal_loop_t_k_get
    if _newclass:
        k = _swig_property(_RNAstructure_wrap.internal_loop_t_k_get, _RNAstructure_wrap.internal_loop_t_k_set)
    __swig_setmethods__["l"] = _RNAstructure_wrap.internal_loop_t_l_set
    __swig_getmethods__["l"] = _RNAstructure_wrap.internal_loop_t_l_get
    if _newclass:
        l = _swig_property(_RNAstructure_wrap.internal_loop_t_l_get, _RNAstructure_wrap.internal_loop_t_l_set)

    def __init__(self):
        """C++ includes: ProbScan.h """
        this = _RNAstructure_wrap.new_internal_loop_t()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _RNAstructure_wrap.delete_internal_loop_t
    __del__ = lambda self: None
internal_loop_t_swigregister = _RNAstructure_wrap.internal_loop_t_swigregister
internal_loop_t_swigregister(internal_loop_t)

class basestack_t(_object):
    """C++ includes: ProbScan.h """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, basestack_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, basestack_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["probability"] = _RNAstructure_wrap.basestack_t_probability_set
    __swig_getmethods__["probability"] = _RNAstructure_wrap.basestack_t_probability_get
    if _newclass:
        probability = _swig_property(_RNAstructure_wrap.basestack_t_probability_get, _RNAstructure_wrap.basestack_t_probability_set)
    __swig_setmethods__["i"] = _RNAstructure_wrap.basestack_t_i_set
    __swig_getmethods__["i"] = _RNAstructure_wrap.basestack_t_i_get
    if _newclass:
        i = _swig_property(_RNAstructure_wrap.basestack_t_i_get, _RNAstructure_wrap.basestack_t_i_set)
    __swig_setmethods__["j"] = _RNAstructure_wrap.basestack_t_j_set
    __swig_getmethods__["j"] = _RNAstructure_wrap.basestack_t_j_get
    if _newclass:
        j = _swig_property(_RNAstructure_wrap.basestack_t_j_get, _RNAstructure_wrap.basestack_t_j_set)
    __swig_setmethods__["k"] = _RNAstructure_wrap.basestack_t_k_set
    __swig_getmethods__["k"] = _RNAstructure_wrap.basestack_t_k_get
    if _newclass:
        k = _swig_property(_RNAstructure_wrap.basestack_t_k_get, _RNAstructure_wrap.basestack_t_k_set)
    __swig_setmethods__["l"] = _RNAstructure_wrap.basestack_t_l_set
    __swig_getmethods__["l"] = _RNAstructure_wrap.basestack_t_l_get
    if _newclass:
        l = _swig_property(_RNAstructure_wrap.basestack_t_l_get, _RNAstructure_wrap.basestack_t_l_set)

    def __init__(self):
        """C++ includes: ProbScan.h """
        this = _RNAstructure_wrap.new_basestack_t()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _RNAstructure_wrap.delete_basestack_t
    __del__ = lambda self: None
basestack_t_swigregister = _RNAstructure_wrap.basestack_t_swigregister
basestack_t_swigregister(basestack_t)

class multibranch_loop_t(_object):
    """C++ includes: ProbScan.h """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, multibranch_loop_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, multibranch_loop_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["probability"] = _RNAstructure_wrap.multibranch_loop_t_probability_set
    __swig_getmethods__["probability"] = _RNAstructure_wrap.multibranch_loop_t_probability_get
    if _newclass:
        probability = _swig_property(_RNAstructure_wrap.multibranch_loop_t_probability_get, _RNAstructure_wrap.multibranch_loop_t_probability_set)
    __swig_setmethods__["branches"] = _RNAstructure_wrap.multibranch_loop_t_branches_set
    __swig_getmethods__["branches"] = _RNAstructure_wrap.multibranch_loop_t_branches_get
    if _newclass:
        branches = _swig_property(_RNAstructure_wrap.multibranch_loop_t_branches_get, _RNAstructure_wrap.multibranch_loop_t_branches_set)

    def __init__(self):
        """C++ includes: ProbScan.h """
        this = _RNAstructure_wrap.new_multibranch_loop_t()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _RNAstructure_wrap.delete_multibranch_loop_t
    __del__ = lambda self: None
multibranch_loop_t_swigregister = _RNAstructure_wrap.multibranch_loop_t_swigregister
multibranch_loop_t_swigregister(multibranch_loop_t)


def hairpin(p, i, j):
    """
    hairpin_t hairpin(double p, int i,
    int j) 
    """
    return _RNAstructure_wrap.hairpin(p, i, j)

def internal_loop(p, i, j, k, l):
    """
    internal_loop_t
    internal_loop(double p, int i, int j, int k, int l) 
    """
    return _RNAstructure_wrap.internal_loop(p, i, j, k, l)

def basestack(p, i, j, k, l):
    """
    basestack_t basestack(double p, int
    i, int j, int k, int l) 
    """
    return _RNAstructure_wrap.basestack(p, i, j, k, l)

def multibranch_loop(i, j):
    """
    multibranch_loop_t
    multibranch_loop(int i, int j) 
    """
    return _RNAstructure_wrap.multibranch_loop(i, j)

def add_branch(mb, k, l):
    """
    void add_branch(multibranch_loop_t
    &mb, int k, int l) 
    """
    return _RNAstructure_wrap.add_branch(mb, k, l)

def show_hairpins(arg1):
    """
    void show_hairpins(vector<
    hairpin_t >) 
    """
    return _RNAstructure_wrap.show_hairpins(arg1)

def show_stacks(arg1):
    """
    void show_stacks(vector<
    basestack_t >) 
    """
    return _RNAstructure_wrap.show_stacks(arg1)

def show_internal_loops(arg1):
    """
    void
    show_internal_loops(vector< internal_loop_t >) 
    """
    return _RNAstructure_wrap.show_internal_loops(arg1)

def show_bulge_loops(arg1):
    """
    void
    show_bulge_loops(vector< internal_loop_t >) 
    """
    return _RNAstructure_wrap.show_bulge_loops(arg1)

def show_mbl(mbl):
    """
    void show_mbl(multibranch_loop_t
    mbl) 
    """
    return _RNAstructure_wrap.show_mbl(mbl)
class mb_element(_object):
    """C++ includes: ProbScan.h """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, mb_element, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, mb_element, name)
    __repr__ = _swig_repr
    __swig_setmethods__["i"] = _RNAstructure_wrap.mb_element_i_set
    __swig_getmethods__["i"] = _RNAstructure_wrap.mb_element_i_get
    if _newclass:
        i = _swig_property(_RNAstructure_wrap.mb_element_i_get, _RNAstructure_wrap.mb_element_i_set)
    __swig_setmethods__["j"] = _RNAstructure_wrap.mb_element_j_set
    __swig_getmethods__["j"] = _RNAstructure_wrap.mb_element_j_get
    if _newclass:
        j = _swig_property(_RNAstructure_wrap.mb_element_j_get, _RNAstructure_wrap.mb_element_j_set)
    __swig_setmethods__["is_a_pair"] = _RNAstructure_wrap.mb_element_is_a_pair_set
    __swig_getmethods__["is_a_pair"] = _RNAstructure_wrap.mb_element_is_a_pair_get
    if _newclass:
        is_a_pair = _swig_property(_RNAstructure_wrap.mb_element_is_a_pair_get, _RNAstructure_wrap.mb_element_is_a_pair_set)

    def __init__(self, *args):
        """mb_element::mb_element(int nuc) """
        this = _RNAstructure_wrap.new_mb_element(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _RNAstructure_wrap.delete_mb_element
    __del__ = lambda self: None
mb_element_swigregister = _RNAstructure_wrap.mb_element_swigregister
mb_element_swigregister(mb_element)

class ProbScan(RNA):
    """C++ includes: ProbScan.h """

    __swig_setmethods__ = {}
    for _s in [RNA]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProbScan, name, value)
    __swig_getmethods__ = {}
    for _s in [RNA]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProbScan, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        ProbScan::ProbScan(const
        char filename[], bool from_sequence_file, bool isRNA=true)

        Constructor - user provides a filename for existing file as a c
        string.

        The existing file, specified by filename, can either be a ct file, a
        sequence, or an RNAstructure save file. Therefore, the user provides a
        flag for the file: type = 1 => .ct file, type = 2 => .seq file, type =
        3 => partition function save (.pfs) file, type = 4 => folding save
        file (.sav). If the input file is ont a partition function save file,
        the partition function will be calculated. If the sequence is long,
        this may take some time. This constructor generates internal error
        codes that can be accessed by GetErrorCode() after the constructor is
        called. 0 = no error. The errorcode can be resolved to a c string
        using GetErrorMessage. Note that the contructor needs to be explicitly
        told, via IsRNA, what the backbone is because files do not store this
        information. Note also that save files explicitly store the
        thermodynamic parameters, therefore changing the backbone type as
        compaared to the original calculation will not change structure
        predictions.

        Parameters:
        -----------

        filename:  is null terminated c string containing the path to the
        input file.

        from_sequence_file:  is a bool which tells the constructor whether we
        are initializing from a sequence file, in which case the partition
        function must be calculated

        isRNA:  is a bool that indicates whether this sequence is RNA or DNA.
        true= RNA. false=DNA. Default is true. 
        """
        this = _RNAstructure_wrap.new_ProbScan(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def probability_of_hairpin(self, i, j):
        """
        double
        ProbScan::probability_of_hairpin(int i, int j)

        Returns probability of a hairpin closed at a specific position.

        Parameters:
        -----------

        i:  The 5' nucleotide closing the hairpin

        j:  The 3' nucleotide closing the hairpin

        Returns:
        --------

        A double containing the probability of the hairpin 
        """
        return _RNAstructure_wrap.ProbScan_probability_of_hairpin(self, i, j)


    def probability_of_all_hairpins(self, min, max, threshold):
        """
        vector<
        hairpin_t > ProbScan::probability_of_all_hairpins(int min, int max,
        double threshold)

        Calculates the probabilities of all possible hairpins in this
        sequence.

        Parameters:
        -----------

        min:  The minimum size of a hairpin

        max:  The maximum size of a hairpin

        threshold:  The minimum probability for candidate hairpins

        Returns:
        --------

        A vector of hairpin objects, containing the positions of the hairpins
        and their probabilities 
        """
        return _RNAstructure_wrap.ProbScan_probability_of_all_hairpins(self, min, max, threshold)


    def probability_of_internal_loop(self, i, j, k, l):
        """
        double
        ProbScan::probability_of_internal_loop(int i, int j, int k, int l)

        Returns probability of an internal loop or bulge loop closed at a
        specific position.

        Parameters:
        -----------

        i:  The 5' nucleotide closing the loop on the exterior

        j:  The 3' nucleotide closing the loop on the exterior

        k:  The 5' nucleotide closing the loop on the interior

        l:  The 3' nucleotide closing the loop on the interior

        Returns:
        --------

        A double containing the probability of the internal loop 
        """
        return _RNAstructure_wrap.ProbScan_probability_of_internal_loop(self, i, j, k, l)


    def probability_of_all_internal_loops(self, *args, **kwargs):
        """
        vector< internal_loop_t >
        ProbScan::probability_of_all_internal_loops(double threshold,
        std::string mode=std::string("both"))

        Calculates the probabilities of all possible internal loops and/or
        bulge loops in this sequence.

        Parameters:
        -----------

        threshold:  the minimum probability of candidate loops

        mode:  a string which indicates what type of loops should be searched
        for. Allowed values are "internal", "bulge", and "both"

        Returns:
        --------

        A vector of internal loop objects, containing the positions of the
        loops and their probabilities 
        """
        return _RNAstructure_wrap.ProbScan_probability_of_all_internal_loops(self, *args, **kwargs)


    def probability_of_stack(self, i, j):
        """
        double
        ProbScan::probability_of_stack(int i, int j)

        Calculates probability of a base pair stack closed at a specific
        position Note that this is a special case of probability_of_helix
        where the size is set to 1

        Parameters:
        -----------

        i:  The 5' nucleotide closing the stack

        j:  The 3' nucleotide closing the stack

        Returns:
        --------

        A double containing the probability of the stack 
        """
        return _RNAstructure_wrap.ProbScan_probability_of_stack(self, i, j)


    def probability_of_helix(self, i, j, how_many_stacks):
        """
        double
        ProbScan::probability_of_helix(const int i, const int j, const int
        how_many_stacks)

        Calculates probability of an helix at a specific position.

        Parameters:
        -----------

        i:  The 5' nucleotide closing the helix on the exterior

        j:  The 3' nucleotide closing the helix on the exterior

        how_many_stacks:  The number of base pair STACKS in the helix (this is
        the number of pairs minus 1)

        Returns:
        --------

        A double containing the probability of the helix 
        """
        return _RNAstructure_wrap.ProbScan_probability_of_helix(self, i, j, how_many_stacks)


    def probability_of_all_helices(self, threshold, length):
        """
        std::vector< basestack_t > ProbScan::probability_of_all_helices(double
        threshold, int length)

        Calculates the probabilities of all possible helices in this sequence
        of a specific length.

        Parameters:
        -----------

        threshold:  the minimum probability of candidate helices

        length:  the number of base pair stacks to search for

        Returns:
        --------

        A vector of helix objects, containing the positions of the helices and
        their probabilities 
        """
        return _RNAstructure_wrap.ProbScan_probability_of_all_helices(self, threshold, length)


    def probability_of_multibranch_loop(self, mb):
        """
        double ProbScan::probability_of_multibranch_loop(const
        multibranch_loop_t &mb)

        Calculates probability of a multibranch loop at a specific position.

        Parameters:
        -----------

        mb:  A multibranch loop object, containing a vector of pairs
        describing the multibranch loop. These can be created with the
        multibranch_loop function. See the text interface for the ProbScan
        program for an example of usage.

        Returns:
        --------

        A double containing the probability of the multibranch loop 
        """
        return _RNAstructure_wrap.ProbScan_probability_of_multibranch_loop(self, mb)

    __swig_destroy__ = _RNAstructure_wrap.delete_ProbScan
    __del__ = lambda self: None
ProbScan_swigregister = _RNAstructure_wrap.ProbScan_swigregister
ProbScan_swigregister(ProbScan)


def show_mb_element_array(arg1):
    """
    void
    show_mb_element_array(vector< mb_element >) 
    """
    return _RNAstructure_wrap.show_mb_element_array(arg1)
class HairpinLoopVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HairpinLoopVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HairpinLoopVector, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _RNAstructure_wrap.HairpinLoopVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _RNAstructure_wrap.HairpinLoopVector___nonzero__(self)

    def __bool__(self):
        return _RNAstructure_wrap.HairpinLoopVector___bool__(self)

    def __len__(self):
        return _RNAstructure_wrap.HairpinLoopVector___len__(self)

    def __getslice__(self, i, j):
        return _RNAstructure_wrap.HairpinLoopVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _RNAstructure_wrap.HairpinLoopVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _RNAstructure_wrap.HairpinLoopVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _RNAstructure_wrap.HairpinLoopVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _RNAstructure_wrap.HairpinLoopVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _RNAstructure_wrap.HairpinLoopVector___setitem__(self, *args)

    def pop(self):
        return _RNAstructure_wrap.HairpinLoopVector_pop(self)

    def append(self, x):
        return _RNAstructure_wrap.HairpinLoopVector_append(self, x)

    def empty(self):
        return _RNAstructure_wrap.HairpinLoopVector_empty(self)

    def size(self):
        return _RNAstructure_wrap.HairpinLoopVector_size(self)

    def swap(self, v):
        return _RNAstructure_wrap.HairpinLoopVector_swap(self, v)

    def begin(self):
        return _RNAstructure_wrap.HairpinLoopVector_begin(self)

    def end(self):
        return _RNAstructure_wrap.HairpinLoopVector_end(self)

    def rbegin(self):
        return _RNAstructure_wrap.HairpinLoopVector_rbegin(self)

    def rend(self):
        return _RNAstructure_wrap.HairpinLoopVector_rend(self)

    def clear(self):
        return _RNAstructure_wrap.HairpinLoopVector_clear(self)

    def get_allocator(self):
        return _RNAstructure_wrap.HairpinLoopVector_get_allocator(self)

    def pop_back(self):
        return _RNAstructure_wrap.HairpinLoopVector_pop_back(self)

    def erase(self, *args):
        return _RNAstructure_wrap.HairpinLoopVector_erase(self, *args)

    def __init__(self, *args):
        this = _RNAstructure_wrap.new_HairpinLoopVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _RNAstructure_wrap.HairpinLoopVector_push_back(self, x)

    def front(self):
        return _RNAstructure_wrap.HairpinLoopVector_front(self)

    def back(self):
        return _RNAstructure_wrap.HairpinLoopVector_back(self)

    def assign(self, n, x):
        return _RNAstructure_wrap.HairpinLoopVector_assign(self, n, x)

    def resize(self, *args):
        return _RNAstructure_wrap.HairpinLoopVector_resize(self, *args)

    def insert(self, *args):
        return _RNAstructure_wrap.HairpinLoopVector_insert(self, *args)

    def reserve(self, n):
        return _RNAstructure_wrap.HairpinLoopVector_reserve(self, n)

    def capacity(self):
        return _RNAstructure_wrap.HairpinLoopVector_capacity(self)
    __swig_destroy__ = _RNAstructure_wrap.delete_HairpinLoopVector
    __del__ = lambda self: None
HairpinLoopVector_swigregister = _RNAstructure_wrap.HairpinLoopVector_swigregister
HairpinLoopVector_swigregister(HairpinLoopVector)

class InternalLoopVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, InternalLoopVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, InternalLoopVector, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _RNAstructure_wrap.InternalLoopVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _RNAstructure_wrap.InternalLoopVector___nonzero__(self)

    def __bool__(self):
        return _RNAstructure_wrap.InternalLoopVector___bool__(self)

    def __len__(self):
        return _RNAstructure_wrap.InternalLoopVector___len__(self)

    def __getslice__(self, i, j):
        return _RNAstructure_wrap.InternalLoopVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _RNAstructure_wrap.InternalLoopVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _RNAstructure_wrap.InternalLoopVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _RNAstructure_wrap.InternalLoopVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _RNAstructure_wrap.InternalLoopVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _RNAstructure_wrap.InternalLoopVector___setitem__(self, *args)

    def pop(self):
        return _RNAstructure_wrap.InternalLoopVector_pop(self)

    def append(self, x):
        return _RNAstructure_wrap.InternalLoopVector_append(self, x)

    def empty(self):
        return _RNAstructure_wrap.InternalLoopVector_empty(self)

    def size(self):
        return _RNAstructure_wrap.InternalLoopVector_size(self)

    def swap(self, v):
        return _RNAstructure_wrap.InternalLoopVector_swap(self, v)

    def begin(self):
        return _RNAstructure_wrap.InternalLoopVector_begin(self)

    def end(self):
        return _RNAstructure_wrap.InternalLoopVector_end(self)

    def rbegin(self):
        return _RNAstructure_wrap.InternalLoopVector_rbegin(self)

    def rend(self):
        return _RNAstructure_wrap.InternalLoopVector_rend(self)

    def clear(self):
        return _RNAstructure_wrap.InternalLoopVector_clear(self)

    def get_allocator(self):
        return _RNAstructure_wrap.InternalLoopVector_get_allocator(self)

    def pop_back(self):
        return _RNAstructure_wrap.InternalLoopVector_pop_back(self)

    def erase(self, *args):
        return _RNAstructure_wrap.InternalLoopVector_erase(self, *args)

    def __init__(self, *args):
        this = _RNAstructure_wrap.new_InternalLoopVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _RNAstructure_wrap.InternalLoopVector_push_back(self, x)

    def front(self):
        return _RNAstructure_wrap.InternalLoopVector_front(self)

    def back(self):
        return _RNAstructure_wrap.InternalLoopVector_back(self)

    def assign(self, n, x):
        return _RNAstructure_wrap.InternalLoopVector_assign(self, n, x)

    def resize(self, *args):
        return _RNAstructure_wrap.InternalLoopVector_resize(self, *args)

    def insert(self, *args):
        return _RNAstructure_wrap.InternalLoopVector_insert(self, *args)

    def reserve(self, n):
        return _RNAstructure_wrap.InternalLoopVector_reserve(self, n)

    def capacity(self):
        return _RNAstructure_wrap.InternalLoopVector_capacity(self)
    __swig_destroy__ = _RNAstructure_wrap.delete_InternalLoopVector
    __del__ = lambda self: None
InternalLoopVector_swigregister = _RNAstructure_wrap.InternalLoopVector_swigregister
InternalLoopVector_swigregister(InternalLoopVector)

class MultibranchLoopVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultibranchLoopVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultibranchLoopVector, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _RNAstructure_wrap.MultibranchLoopVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _RNAstructure_wrap.MultibranchLoopVector___nonzero__(self)

    def __bool__(self):
        return _RNAstructure_wrap.MultibranchLoopVector___bool__(self)

    def __len__(self):
        return _RNAstructure_wrap.MultibranchLoopVector___len__(self)

    def __getslice__(self, i, j):
        return _RNAstructure_wrap.MultibranchLoopVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _RNAstructure_wrap.MultibranchLoopVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _RNAstructure_wrap.MultibranchLoopVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _RNAstructure_wrap.MultibranchLoopVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _RNAstructure_wrap.MultibranchLoopVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _RNAstructure_wrap.MultibranchLoopVector___setitem__(self, *args)

    def pop(self):
        return _RNAstructure_wrap.MultibranchLoopVector_pop(self)

    def append(self, x):
        return _RNAstructure_wrap.MultibranchLoopVector_append(self, x)

    def empty(self):
        return _RNAstructure_wrap.MultibranchLoopVector_empty(self)

    def size(self):
        return _RNAstructure_wrap.MultibranchLoopVector_size(self)

    def swap(self, v):
        return _RNAstructure_wrap.MultibranchLoopVector_swap(self, v)

    def begin(self):
        return _RNAstructure_wrap.MultibranchLoopVector_begin(self)

    def end(self):
        return _RNAstructure_wrap.MultibranchLoopVector_end(self)

    def rbegin(self):
        return _RNAstructure_wrap.MultibranchLoopVector_rbegin(self)

    def rend(self):
        return _RNAstructure_wrap.MultibranchLoopVector_rend(self)

    def clear(self):
        return _RNAstructure_wrap.MultibranchLoopVector_clear(self)

    def get_allocator(self):
        return _RNAstructure_wrap.MultibranchLoopVector_get_allocator(self)

    def pop_back(self):
        return _RNAstructure_wrap.MultibranchLoopVector_pop_back(self)

    def erase(self, *args):
        return _RNAstructure_wrap.MultibranchLoopVector_erase(self, *args)

    def __init__(self, *args):
        this = _RNAstructure_wrap.new_MultibranchLoopVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _RNAstructure_wrap.MultibranchLoopVector_push_back(self, x)

    def front(self):
        return _RNAstructure_wrap.MultibranchLoopVector_front(self)

    def back(self):
        return _RNAstructure_wrap.MultibranchLoopVector_back(self)

    def assign(self, n, x):
        return _RNAstructure_wrap.MultibranchLoopVector_assign(self, n, x)

    def resize(self, *args):
        return _RNAstructure_wrap.MultibranchLoopVector_resize(self, *args)

    def insert(self, *args):
        return _RNAstructure_wrap.MultibranchLoopVector_insert(self, *args)

    def reserve(self, n):
        return _RNAstructure_wrap.MultibranchLoopVector_reserve(self, n)

    def capacity(self):
        return _RNAstructure_wrap.MultibranchLoopVector_capacity(self)
    __swig_destroy__ = _RNAstructure_wrap.delete_MultibranchLoopVector
    __del__ = lambda self: None
MultibranchLoopVector_swigregister = _RNAstructure_wrap.MultibranchLoopVector_swigregister
MultibranchLoopVector_swigregister(MultibranchLoopVector)

class BaseStackVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BaseStackVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BaseStackVector, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _RNAstructure_wrap.BaseStackVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _RNAstructure_wrap.BaseStackVector___nonzero__(self)

    def __bool__(self):
        return _RNAstructure_wrap.BaseStackVector___bool__(self)

    def __len__(self):
        return _RNAstructure_wrap.BaseStackVector___len__(self)

    def __getslice__(self, i, j):
        return _RNAstructure_wrap.BaseStackVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _RNAstructure_wrap.BaseStackVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _RNAstructure_wrap.BaseStackVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _RNAstructure_wrap.BaseStackVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _RNAstructure_wrap.BaseStackVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _RNAstructure_wrap.BaseStackVector___setitem__(self, *args)

    def pop(self):
        return _RNAstructure_wrap.BaseStackVector_pop(self)

    def append(self, x):
        return _RNAstructure_wrap.BaseStackVector_append(self, x)

    def empty(self):
        return _RNAstructure_wrap.BaseStackVector_empty(self)

    def size(self):
        return _RNAstructure_wrap.BaseStackVector_size(self)

    def swap(self, v):
        return _RNAstructure_wrap.BaseStackVector_swap(self, v)

    def begin(self):
        return _RNAstructure_wrap.BaseStackVector_begin(self)

    def end(self):
        return _RNAstructure_wrap.BaseStackVector_end(self)

    def rbegin(self):
        return _RNAstructure_wrap.BaseStackVector_rbegin(self)

    def rend(self):
        return _RNAstructure_wrap.BaseStackVector_rend(self)

    def clear(self):
        return _RNAstructure_wrap.BaseStackVector_clear(self)

    def get_allocator(self):
        return _RNAstructure_wrap.BaseStackVector_get_allocator(self)

    def pop_back(self):
        return _RNAstructure_wrap.BaseStackVector_pop_back(self)

    def erase(self, *args):
        return _RNAstructure_wrap.BaseStackVector_erase(self, *args)

    def __init__(self, *args):
        this = _RNAstructure_wrap.new_BaseStackVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _RNAstructure_wrap.BaseStackVector_push_back(self, x)

    def front(self):
        return _RNAstructure_wrap.BaseStackVector_front(self)

    def back(self):
        return _RNAstructure_wrap.BaseStackVector_back(self)

    def assign(self, n, x):
        return _RNAstructure_wrap.BaseStackVector_assign(self, n, x)

    def resize(self, *args):
        return _RNAstructure_wrap.BaseStackVector_resize(self, *args)

    def insert(self, *args):
        return _RNAstructure_wrap.BaseStackVector_insert(self, *args)

    def reserve(self, n):
        return _RNAstructure_wrap.BaseStackVector_reserve(self, n)

    def capacity(self):
        return _RNAstructure_wrap.BaseStackVector_capacity(self)
    __swig_destroy__ = _RNAstructure_wrap.delete_BaseStackVector
    __del__ = lambda self: None
BaseStackVector_swigregister = _RNAstructure_wrap.BaseStackVector_swigregister
BaseStackVector_swigregister(BaseStackVector)

# This file is compatible with both classic and new-style classes.


