package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.menus.HelpMenu;

import javax.swing.*;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyVetoException;

/**
 * @author Richard M. Watson
 */
public class AboutWindow extends JInternalFrame implements ActionListener {
    private JButton btnExtract;
    private JPanel mainPanel;
    private JButton btnClose;
    private JLabel lblWebsite;
    private JLabel lblHelp;
    private JLabel lblLogo;
//    private JLabel lblVersion;
//    private JLabel lblCopyright;

    private void createUIComponents() {
        // TODO: place custom component creation code here
    }

    public AboutWindow() {
        // UI is already setup
        super("Notification", false, true, false, false);
        KeyAdapter ka = new KeyAdapter() {
            @Override
            public void keyTyped(final KeyEvent e) {
                super.keyTyped(e);
                if ((int) e.getKeyChar() == KeyEvent.VK_ESCAPE)
                    close();
            }
        };
        addKeyListener(ka);
        btnExtract.addKeyListener(ka);
        btnClose.addKeyListener(ka);

        BasicInternalFrameUI ui = ((BasicInternalFrameUI) this.getUI());
        ui.setNorthPane(null);
//        ui.setEastPane(null);
//        ui.setWestPane(null);
//        ui.setSouthPane(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        btnClose.addActionListener(this);
        btnExtract.addActionListener(this);
        //lblVersion.setText(lblVersion.getText().replace("[VERSION]", RNAstructure.VERSION));
        //lblCopyright.setText(lblCopyright.getText().replace("[YEAR]", RNAstructure.YEAR));
        setSize(new Dimension(600, 200));
        setVisible(true);

        MouseAdapter ma = new MouseAdapter() {
            @Override
            public void mouseClicked(final MouseEvent e) {
                Component c = e.getComponent();
                if (c == lblWebsite)
                    HelpMenu.browseWebsite();
                else if (c == lblHelp)
                    HelpMenu.browseHelp();
            }
        };
        lblWebsite.addMouseListener(ma);
        lblHelp.addMouseListener(ma);
        lblWebsite.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        lblHelp.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        add(mainPanel, gbc);

        pack();
    }

    public void initFocus() {
        btnClose.requestFocus();
    }

    private void close() {
        try {
            this.setClosed(true);
        } catch (PropertyVetoException ex) {
            //
        }
    }
    /**
     * Invoked when an action occurs.
     *
     * @param e
     */
    @Override
    public void actionPerformed(final ActionEvent e) {
        switch (e.getActionCommand()) {
            case "extract-examples":
                RNAstructure.ExtractExamples();
                break;
            case "close":
                close();
                break;
        }
    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setFont(new Font(mainPanel.getFont().getName(), mainPanel.getFont().getStyle(), 12));
        btnExtract = new JButton();
        btnExtract.setActionCommand("extract-examples");
        btnExtract.setFont(new Font("Arial", btnExtract.getFont().getStyle(), 14));
        btnExtract.setText("Extract Example Files");
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 10, 0);
        mainPanel.add(btnExtract, gbc);
        btnClose = new JButton();
        btnClose.setActionCommand("close");
        btnClose.setFont(new Font("Arial", btnClose.getFont().getStyle(), 14));
        btnClose.setText("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        mainPanel.add(btnClose, gbc);
        final JLabel label1 = new JLabel();
        label1.setFont(new Font("Arial", label1.getFont().getStyle(), 14));
        label1.setPreferredSize(new Dimension(500, 80));
        label1.setText("<html><span style=\"font-size:5pt\"><br></span>This application comes with a set of <b>example files</b> that are useful when getting started with the program. If you are using the program for the first time, it is recommended that you click the button below to extract the example files to a location of your choosing.");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = GridBagConstraints.SOUTH;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        mainPanel.add(label1, gbc);
        lblWebsite = new JLabel();
        lblWebsite.setFont(new Font("Arial", lblWebsite.getFont().getStyle(), 14));
        lblWebsite.setText("<html>Lab Website <a href=\"\">rna.urmc.rochester.edu</a>");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.4;
        mainPanel.add(lblWebsite, gbc);
        lblHelp = new JLabel();
        lblHelp.setFont(new Font("Arial", lblHelp.getFont().getStyle(), 14));
        lblHelp.setText("<html>RNAstructure <a href=\"\">Online Help</a>");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.6;
        mainPanel.add(lblHelp, gbc);
        final JLabel label2 = new JLabel();
        label2.setFont(new Font("Arial", label2.getFont().getStyle(), 14));
        label2.setText("RNAstucture is developed by the David H. Mathews Lab at the University of Rochester.");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = GridBagConstraints.NORTH;
        gbc.insets = new Insets(10, 0, 10, 0);
        mainPanel.add(label2, gbc);
        lblLogo = new JLabel();
        lblLogo.setIcon(new ImageIcon(getClass().getResource("/ur_rna/RNAstructureUI/resources/images/logo.png")));
        lblLogo.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        mainPanel.add(lblLogo, gbc);
    }
    /** @noinspection ALL */
    public JComponent $$$getRootComponent$$$() { return mainPanel; }
}
