package ur_rna.StructureEditor.windows;

import javax.swing.*;
import java.awt.*;

/**
 * A dialog for the user to enter bases to insert into a drawing.
 */
public class InsertBasesDialog extends JPanel {
    private JTextArea txtBases;
    private JComboBox cmbRelative;
    private JPanel pnlMain;

    public boolean isInsertAfter() { return cmbRelative.getSelectedIndex() == 1; }
    public String getSequence() { return txtBases.getText().trim(); }

    public InsertBasesDialog() {

    }

    public int showDialog(final Component owner, final String title) {
        JOptionPane pane = new JOptionPane(pnlMain, JOptionPane.QUESTION_MESSAGE, JOptionPane.OK_CANCEL_OPTION) {
            @Override
            public void selectInitialValue() {
                super.selectInitialValue();
                txtBases.requestFocusInWindow();
            }
        };
        pane.createDialog(owner, title).setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) return JOptionPane.CANCEL_OPTION;
        return ((Number) selectedValue).intValue();
    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        pnlMain = new JPanel();
        pnlMain.setLayout(new GridBagLayout());
        final JLabel label1 = new JLabel();
        label1.setText("Enter the base (or bases) to insert:");
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        pnlMain.add(label1, gbc);
        final JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setPreferredSize(new Dimension(200, 80));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = GridBagConstraints.BOTH;
        pnlMain.add(scrollPane1, gbc);
        txtBases = new JTextArea();
        scrollPane1.setViewportView(txtBases);
        final JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = GridBagConstraints.BOTH;
        pnlMain.add(panel1, gbc);
        final JLabel label2 = new JLabel();
        label2.setText("Insert the new bases");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        panel1.add(label2, gbc);
        cmbRelative = new JComboBox();
        final DefaultComboBoxModel defaultComboBoxModel1 = new DefaultComboBoxModel();
        defaultComboBoxModel1.addElement("before");
        defaultComboBoxModel1.addElement("after");
        cmbRelative.setModel(defaultComboBoxModel1);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.insets = new Insets(0, 2, 0, 2);
        panel1.add(cmbRelative, gbc);
        final JLabel label3 = new JLabel();
        label3.setText("the selected base.");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        panel1.add(label3, gbc);
    }
    /** @noinspection ALL */
    public JComponent $$$getRootComponent$$$() { return pnlMain; }
}
