package ur_rna.StructureEditor.ui;

import ur_rna.Utilities.Convert;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import java.awt.*;

/**
 *
 */
public class SliderToolWindow extends ToolWindow {
    private JSlider slider;
    private JLabel lblValue;
    private JButton btnCancel;
    private JButton btnAccept;
    private JTextField txtValue;
    private JLabel lblPrompt;

    public SliderToolWindow() {
        slider.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(final ChangeEvent e) {
                txtValue.setText("" + slider.getValue());
            }
        });
        txtValue.getDocument().addDocumentListener(new DocumentListener() {
            @Override
            public void insertUpdate(final DocumentEvent e) {
                docChanged();
            }
            @Override
            public void removeUpdate(final DocumentEvent e) {
                docChanged();
            }
            @Override
            public void changedUpdate(final DocumentEvent e) {
                docChanged();
            }
        });

        setPreferredSize(new Dimension(300, 200));
        pack();
        setVisible(true);
    }
    void docChanged() {
        int val = Convert.toInt(txtValue.getText(), -1);
        if (val != -1 && val != slider.getValue() && val >= slider.getMinimum() && val <= slider.getMaximum())
            slider.setValue(val);
    }

    private void createUIComponents() {
        // TODO: place custom component creation code here
    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        final JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        slider = new JSlider();
        slider.setMajorTickSpacing(5);
        slider.setMinorTickSpacing(1);
        slider.setPaintLabels(false);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setPreferredSize(new Dimension(300, 32));
        slider.putClientProperty("Slider.paintThumbArrowShape", Boolean.TRUE);
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.insets = new Insets(5, 0, 5, 0);
        panel1.add(slider, gbc);
        btnAccept = new JButton();
        btnAccept.setActionCommand("accept");
        btnAccept.setText("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.insets = new Insets(0, 3, 0, 0);
        panel1.add(btnAccept, gbc);
        btnCancel = new JButton();
        btnCancel.setActionCommand("cancel");
        btnCancel.setText("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(btnCancel, gbc);
        lblPrompt = new JLabel();
        lblPrompt.setPreferredSize(new Dimension(300, 32));
        lblPrompt.setText("<html>Enter a numeric value below or use the slider <br>\nto select one within the valid range.");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(3, 5, 3, 5);
        panel1.add(lblPrompt, gbc);
        txtValue = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.insets = new Insets(3, 0, 3, 5);
        panel1.add(txtValue, gbc);
        lblValue = new JLabel();
        lblValue.setText("Value:");
        lblValue.setVerticalAlignment(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = GridBagConstraints.EAST;
        gbc.insets = new Insets(0, 0, 0, 5);
        panel1.add(lblValue, gbc);
        lblValue.setLabelFor(txtValue);
    }
}
