/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import ur_rna.Utilities.swing.AcceleratorKey;
import ur_rna.Utilities.swing.IMergeItem;
import ur_rna.Utilities.swing.Menus;
import ur_rna.Utilities.swing.UiAction;

public class MergeItem
extends JMenuItem
implements IMergeItem {
    private int pos = -2147483647;
    public Object tag;

    public JMenuItem getMenuItem() {
        return this;
    }

    public MergeItem() {
    }

    public MergeItem(int n) {
        this.setMergePos(n);
    }

    public MergeItem(Action action) {
        this(action, -2147483647);
    }

    public MergeItem(Action action, int n) {
        super(action);
        this.setMergePos(n);
    }

    public MergeItem(Action action, String string, int n) {
        super(action);
        this.setMergePos(n);
        this.setText(string);
    }

    public MergeItem(String string) {
        this.setText(string);
    }

    public MergeItem(String string, int n) {
        this(n);
        this.setText(string);
    }

    public MergeItem(String string, ActionListener actionListener, String string2, int n, KeyStroke keyStroke) {
        super(new UiAction(string, actionListener).setMnemonic(n).setKeyStroke(keyStroke).setCommand(string2));
    }

    @Override
    public void setText(String string2) {
        Menus.setTextWithMnemonic(this, string2, string -> super.setText((String)string));
    }

    @Override
    public int getMergePos() {
        return this.pos;
    }

    @Override
    public MergeItem setMergePos(int n) {
        if (n != -2147483647) {
            this.pos = n;
        }
        return this;
    }

    public MergeItem setKeyStroke(char c) {
        this.setKeyStroke(AcceleratorKey.getKey(c));
        return this;
    }

    public MergeItem setKeyStroke(String string) {
        this.setKeyStroke(AcceleratorKey.getKey(string));
        return this;
    }

    public MergeItem setKeyStroke(KeyStroke keyStroke) {
        this.getMenuItem().setAccelerator(keyStroke);
        return this;
    }

    public KeyStroke getKeyStroke() {
        return this.getMenuItem().getAccelerator();
    }

    @Override
    public String toString() {
        String string = this.getClass().getSimpleName();
        return String.format("%s [ Name: \"%s\"  Text: \"%s\" Pos: %d ]", string, this.getName(), this.getText(), this.getMergePos());
    }

    public static class Separator
    extends JPopupMenu.Separator
    implements IMergeItem {
        private int pos = -2147483647;

        public Separator() {
        }

        public Separator(int n) {
            this.pos = n;
        }

        @Override
        public int getMergePos() {
            return this.pos;
        }

        @Override
        public Separator setMergePos(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }
}

