/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import ur_rna.Utilities.swing.Components;
import ur_rna.Utilities.swing.IMenuItem;
import ur_rna.Utilities.swing.KeyMnemonic;

public class Menus {
    public static boolean hasSubItems(Component component) {
        JComponent jComponent = Menus.getSubItemContainer(component);
        return jComponent != null && jComponent.getComponentCount() != 0;
    }

    public static JComponent getSubItemContainer(Component component) {
        if (component instanceof JMenu) {
            return ((JMenu)component).getPopupMenu();
        }
        if (component instanceof JComponent) {
            return (JComponent)component;
        }
        return null;
    }

    public static List<JMenu> getMenus(Component component) {
        JComponent jComponent = Menus.getSubItemContainer(component);
        if (jComponent == null) {
            return Collections.emptyList();
        }
        int n = jComponent.getComponentCount();
        ArrayList<JMenu> arrayList = new ArrayList<JMenu>(n);
        for (int i = 0; i < n; ++i) {
            Component component2 = jComponent.getComponent(i);
            if (!(component2 instanceof JMenu)) continue;
            arrayList.add((JMenu)component2);
        }
        return arrayList;
    }

    public static List<JMenuItem> getMenuItems(Component component) {
        JComponent jComponent = Menus.getSubItemContainer(component);
        if (jComponent == null) {
            return Collections.emptyList();
        }
        int n = jComponent.getComponentCount();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(n);
        for (int i = 0; i < n; ++i) {
            Component component2 = jComponent.getComponent(i);
            if (!(component2 instanceof JMenuItem)) continue;
            arrayList.add((JMenuItem)component2);
        }
        return arrayList;
    }

    public static JMenuItem findByTreePath(Component component, String string) {
        return Menus.findByTreePath(IMenuItem.from(component), string);
    }

    public static JMenuItem findByTreePath(IMenuItem iMenuItem, String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("->");
        int n = 0;
        while (true) {
            JMenuItem jMenuItem = Menus.findByName(iMenuItem, stringArray[n]);
            if (++n == stringArray.length) {
                return jMenuItem;
            }
            if (!(jMenuItem instanceof JMenu)) {
                return null;
            }
            iMenuItem = IMenuItem.from(jMenuItem);
        }
    }

    public static JMenuItem findByName(Component component, String string) {
        return Menus.findByName(IMenuItem.from(component), string);
    }

    public static JMenuItem findByName(IMenuItem iMenuItem, String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("->")) {
            return Menus.findByTreePath(iMenuItem, string);
        }
        List<? extends JMenuItem> list = iMenuItem.getMenuItems();
        int n = 0;
        for (JMenuItem jMenuItem : list) {
            if (string.equals(Components.getNameOrText(jMenuItem))) {
                return jMenuItem;
            }
            if (string.equals("[" + n + "]")) {
                return jMenuItem;
            }
            ++n;
        }
        for (JMenuItem jMenuItem : list) {
            JMenuItem jMenuItem2;
            if (!(jMenuItem instanceof JMenu) || (jMenuItem2 = Menus.findByName(IMenuItem.from(jMenuItem), string)) == null) continue;
            return jMenuItem2;
        }
        return null;
    }

    public static void setTextWithMnemonic(AbstractButton abstractButton, String string, Consumer<String> consumer) {
        int n = KeyMnemonic.getMnemonic(string);
        if (n == 0) {
            consumer.accept(string);
        } else {
            abstractButton.setMnemonic(n);
            int n2 = KeyMnemonic.getMnemonicIndex(string);
            consumer.accept(KeyMnemonic.stripMnemonics(string));
            if (n2 != abstractButton.getDisplayedMnemonicIndex()) {
                abstractButton.setDisplayedMnemonicIndex(n2);
            }
        }
    }

    public static JMenuItem findByAction(Component component, Action action) {
        return Menus.findByAction(IMenuItem.from(component), action);
    }

    public static JMenuItem findByAction(IMenuItem iMenuItem, Action action) {
        if (action == null) {
            return null;
        }
        for (JMenuItem jMenuItem : iMenuItem.getMenuItems()) {
            if (!action.equals(jMenuItem.getAction())) continue;
            return jMenuItem;
        }
        for (JMenu jMenu : iMenuItem.getMenus()) {
            JMenuItem jMenuItem = Menus.findByAction(IMenuItem.from(jMenu), action);
            if (jMenuItem == null) continue;
            return jMenuItem;
        }
        return null;
    }

    public static void setEnabled(IMenuItem iMenuItem, boolean bl) {
        for (JMenu jMenuItem : iMenuItem.getMenus()) {
            Menus.setEnabled(IMenuItem.from(jMenuItem), bl);
        }
        for (JMenuItem jMenuItem : iMenuItem.getMenuItems()) {
            jMenuItem.setEnabled(bl);
        }
    }
}

